######################################################################
#
# 1108_utf8jp_by_jipsj.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x80"],
        ["\x01",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x81"],
        ["\x02",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x82"],
        ["\x03",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x83"],
        ["\x04",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x84"],
        ["\x05",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x85"],
        ["\x06",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x86"],
        ["\x07",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x87"],
        ["\x08",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x88"],
        ["\x09",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x89"],
        ["\x0A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8A"],
        ["\x0B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8B"],
        ["\x0C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8C"],
        ["\x0D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8D"],
        ["\x0E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8E"],
        ["\x0F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8F"],
        ["\x10",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x90"],
        ["\x11",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x91"],
        ["\x12",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x92"],
        ["\x13",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x93"],
        ["\x14",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x94"],
        ["\x15",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x95"],
        ["\x16",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x96"],
        ["\x17",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x97"],
        ["\x18",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x98"],
        ["\x19",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x99"],
        ["\x1A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9A"],
        ["\x1B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9B"],
        ["\x1C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9C"],
        ["\x1D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9D"],
        ["\x1E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9E"],
        ["\x1F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9F"],
        ["\x20",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA0"],
        ["\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA1"],
        ["\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA2"],
        ["\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA3"],
        ["\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA4"],
        ["\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA5"],
        ["\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA6"],
        ["\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA7"],
        ["\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA8"],
        ["\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA9"],
        ["\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAA"],
        ["\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAB"],
        ["\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAC"],
        ["\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAD"],
        ["\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAE"],
        ["\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAF"],
        ["\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB0"],
        ["\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB1"],
        ["\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB2"],
        ["\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB3"],
        ["\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB4"],
        ["\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB5"],
        ["\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB6"],
        ["\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB7"],
        ["\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB8"],
        ["\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB9"],
        ["\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBA"],
        ["\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBB"],
        ["\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBC"],
        ["\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBD"],
        ["\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBE"],
        ["\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBF"],
        ["\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x80"],
        ["\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x81"],
        ["\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x82"],
        ["\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x83"],
        ["\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x84"],
        ["\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x85"],
        ["\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x86"],
        ["\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x87"],
        ["\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x88"],
        ["\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x89"],
        ["\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8A"],
        ["\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8B"],
        ["\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8C"],
        ["\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8D"],
        ["\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8E"],
        ["\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8F"],
        ["\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x90"],
        ["\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x91"],
        ["\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x92"],
        ["\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x93"],
        ["\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x94"],
        ["\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x95"],
        ["\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x96"],
        ["\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x97"],
        ["\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x98"],
        ["\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x99"],
        ["\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9A"],
        ["\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9B"],
        ["\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9C"],
        ["\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9D"],
        ["\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9E"],
        ["\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9F"],
        ["\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA0"],
        ["\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA1"],
        ["\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA2"],
        ["\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA3"],
        ["\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA4"],
        ["\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA5"],
        ["\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA6"],
        ["\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA7"],
        ["\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA8"],
        ["\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA9"],
        ["\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAA"],
        ["\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAB"],
        ["\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAC"],
        ["\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAD"],
        ["\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAE"],
        ["\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAF"],
        ["\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB0"],
        ["\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB1"],
        ["\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB2"],
        ["\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB3"],
        ["\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB4"],
        ["\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB5"],
        ["\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB6"],
        ["\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB7"],
        ["\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB8"],
        ["\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB9"],
        ["\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBA"],
        ["\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBB"],
        ["\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBC"],
        ["\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBD"],
        ["\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBE"],
        ["\x7F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBF"],
        ["\x80",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x80"],
        ["\x81",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x81"],
        ["\x82",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x82"],
        ["\x83",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x83"],
        ["\x84",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x84"],
        ["\x85",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x85"],
        ["\x86",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x86"],
        ["\x87",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x87"],
        ["\x88",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x88"],
        ["\x89",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x89"],
        ["\x8A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8A"],
        ["\x8B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8B"],
        ["\x8C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8C"],
        ["\x8D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8D"],
        ["\x8E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8E"],
        ["\x8F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8F"],
        ["\x90",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x90"],
        ["\x91",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x91"],
        ["\x92",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x92"],
        ["\x93",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x93"],
        ["\x94",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x94"],
        ["\x95",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x95"],
        ["\x96",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x96"],
        ["\x97",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x97"],
        ["\x98",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x98"],
        ["\x99",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x99"],
        ["\x9A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9A"],
        ["\x9B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9B"],
        ["\x9C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9C"],
        ["\x9D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9D"],
        ["\x9E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9E"],
        ["\x9F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9F"],
        ["\xA0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA0"],
        ["\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA1"],
        ["\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA2"],
        ["\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA3"],
        ["\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA4"],
        ["\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA5"],
        ["\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA6"],
        ["\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA7"],
        ["\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA8"],
        ["\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA9"],
        ["\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAA"],
        ["\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAB"],
        ["\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAC"],
        ["\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAD"],
        ["\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAE"],
        ["\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAF"],
        ["\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB0"],
        ["\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB1"],
        ["\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB2"],
        ["\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB3"],
        ["\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB4"],
        ["\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB5"],
        ["\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB6"],
        ["\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB7"],
        ["\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB8"],
        ["\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB9"],
        ["\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBA"],
        ["\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBB"],
        ["\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBC"],
        ["\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBD"],
        ["\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBE"],
        ["\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBF"],
        ["\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x80"],
        ["\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x81"],
        ["\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x82"],
        ["\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x83"],
        ["\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x84"],
        ["\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x85"],
        ["\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x86"],
        ["\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x87"],
        ["\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x88"],
        ["\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x89"],
        ["\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8A"],
        ["\xCB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8B"],
        ["\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8C"],
        ["\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8D"],
        ["\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8E"],
        ["\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8F"],
        ["\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x90"],
        ["\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x91"],
        ["\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x92"],
        ["\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x93"],
        ["\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x94"],
        ["\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x95"],
        ["\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x96"],
        ["\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x97"],
        ["\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x98"],
        ["\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x99"],
        ["\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9A"],
        ["\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9B"],
        ["\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9C"],
        ["\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9D"],
        ["\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9E"],
        ["\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9F"],
        ["\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA0"],
        ["\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA1"],
        ["\xE2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA2"],
        ["\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA3"],
        ["\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA4"],
        ["\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA5"],
        ["\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA6"],
        ["\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA7"],
        ["\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA8"],
        ["\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA9"],
        ["\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAA"],
        ["\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAB"],
        ["\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAC"],
        ["\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAD"],
        ["\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAE"],
        ["\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAF"],
        ["\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB0"],
        ["\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB1"],
        ["\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB2"],
        ["\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB3"],
        ["\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB4"],
        ["\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB5"],
        ["\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB6"],
        ["\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB7"],
        ["\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB8"],
        ["\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB9"],
        ["\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBA"],
        ["\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBB"],
        ["\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBC"],
        ["\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBD"],
        ["\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBE"],
        ["\xFF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBF"],
        ["\x21\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x80"],
        ["\x21\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x81"],
        ["\x21\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x82"],
        ["\x21\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x83"],
        ["\x21\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x84"],
        ["\x21\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x85"],
        ["\x21\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x86"],
        ["\x21\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x87"],
        ["\x21\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x88"],
        ["\x21\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x89"],
        ["\x21\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8A"],
        ["\x21\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8B"],
        ["\x21\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8C"],
        ["\x21\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8D"],
        ["\x21\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8E"],
        ["\x21\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8F"],
        ["\x21\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x90"],
        ["\x21\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x91"],
        ["\x21\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x92"],
        ["\x21\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x93"],
        ["\x21\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x94"],
        ["\x21\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x95"],
        ["\x21\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x96"],
        ["\x21\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x97"],
        ["\x21\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x98"],
        ["\x21\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x99"],
        ["\x21\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9A"],
        ["\x21\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9B"],
        ["\x21\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9C"],
        ["\x21\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9D"],
        ["\x21\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9E"],
        ["\x21\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9F"],
        ["\x21\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA0"],
        ["\x21\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA1"],
        ["\x21\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA2"],
        ["\x21\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA3"],
        ["\x21\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA4"],
        ["\x21\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA5"],
        ["\x21\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA6"],
        ["\x21\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA7"],
        ["\x21\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA8"],
        ["\x21\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA9"],
        ["\x21\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAA"],
        ["\x21\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAB"],
        ["\x21\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAC"],
        ["\x21\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAD"],
        ["\x21\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAE"],
        ["\x21\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAF"],
        ["\x21\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB0"],
        ["\x21\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB1"],
        ["\x21\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB2"],
        ["\x21\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB3"],
        ["\x21\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB4"],
        ["\x21\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB5"],
        ["\x21\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB6"],
        ["\x21\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB7"],
        ["\x21\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB8"],
        ["\x21\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB9"],
        ["\x21\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBA"],
        ["\x21\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBB"],
        ["\x21\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBC"],
        ["\x21\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBD"],
        ["\x21\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBE"],
        ["\x21\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBF"],
        ["\x21\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x80"],
        ["\x21\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x81"],
        ["\x21\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x82"],
        ["\x21\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x83"],
        ["\x21\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x84"],
        ["\x21\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x85"],
        ["\x21\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x86"],
        ["\x21\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x87"],
        ["\x21\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x88"],
        ["\x21\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x89"],
        ["\x21\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8A"],
        ["\x21\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8B"],
        ["\x21\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8C"],
        ["\x21\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8D"],
        ["\x21\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8E"],
        ["\x21\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8F"],
        ["\x21\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x90"],
        ["\x21\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x91"],
        ["\x21\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x92"],
        ["\x21\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x93"],
        ["\x21\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x94"],
        ["\x21\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x95"],
        ["\x21\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x96"],
        ["\x21\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x97"],
        ["\x21\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x98"],
        ["\x21\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x99"],
        ["\x21\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9A"],
        ["\x21\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9B"],
        ["\x21\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9C"],
        ["\x21\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9D"],
        ["\x22\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9E"],
        ["\x22\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9F"],
        ["\x22\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA0"],
        ["\x22\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA1"],
        ["\x22\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA2"],
        ["\x22\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA3"],
        ["\x22\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA4"],
        ["\x22\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA5"],
        ["\x22\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA6"],
        ["\x22\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA7"],
        ["\x22\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA8"],
        ["\x22\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA9"],
        ["\x22\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAA"],
        ["\x22\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAB"],
        ["\xA5\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB7"],
        ["\xA5\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB8"],
        ["\xA6\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB9"],
        ["\xA6\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBA"],
        ["\xA5\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBB"],
        ["\xA5\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBC"],
        ["\x2D\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBD"],
        ["\x2D\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBE"],
        ["\xA5\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x87"],
        ["\xA5\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x88"],
        ["\xA6\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8A"],
        ["\xA6\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8B"],
        ["\xA5\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8C"],
        ["\xA5\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8D"],
        ["\x2D\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x99"],
        ["\x2D\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9A"],
        ["\xA6\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9B"],
        ["\xA5\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9C"],
        ["\xA6\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9D"],
        ["\x2D\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9E"],
        ["\x2D\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9F"],
        ["\xA5\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA0"],
        ["\xA5\xE2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA1"],
        ["\x2D\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA2"],
        ["\xA5\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA3"],
        ["\xA5\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA4"],
        ["\x2D\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA5"],
        ["\x2D\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA6"],
        ["\xA6\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA7"],
        ["\xA4\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xAF"],
        ["\xA4\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB0"],
        ["\xA6\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB1"],
        ["\xA6\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB2"],
        ["\xA6\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB3"],
        ["\xA5\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB4"],
        ["\xA5\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB5"],
        ["\xA5\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB6"],
        ["\xA6\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xBB"],
        ["\x23\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8B"],
        ["\x23\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8C"],
        ["\x23\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8D"],
        ["\x23\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8E"],
        ["\x23\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8F"],
        ["\x23\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x90"],
        ["\x23\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x91"],
        ["\x23\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x92"],
        ["\x23\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x93"],
        ["\x23\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x94"],
        ["\x23\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9C"],
        ["\x23\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9D"],
        ["\x23\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9E"],
        ["\x23\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9F"],
        ["\x23\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA0"],
        ["\x23\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA1"],
        ["\x23\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA2"],
        ["\x23\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA3"],
        ["\x23\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA4"],
        ["\x23\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA5"],
        ["\x23\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA6"],
        ["\x23\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA7"],
        ["\x23\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA8"],
        ["\x23\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA9"],
        ["\x23\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAA"],
        ["\x23\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAB"],
        ["\x23\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAC"],
        ["\x23\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAD"],
        ["\x23\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAE"],
        ["\x23\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAF"],
        ["\x23\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB0"],
        ["\x23\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB1"],
        ["\x23\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB2"],
        ["\x23\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB3"],
        ["\x23\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB4"],
        ["\x23\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB5"],
        ["\x23\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBC"],
        ["\x23\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBD"],
        ["\x23\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBE"],
        ["\x23\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBF"],
        ["\x23\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x80"],
        ["\x23\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x81"],
        ["\x23\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x82"],
        ["\x23\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x83"],
        ["\x23\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x84"],
        ["\x23\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x85"],
        ["\x23\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x86"],
        ["\x23\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x87"],
        ["\x23\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x88"],
        ["\x23\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x89"],
        ["\x23\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8A"],
        ["\x23\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8B"],
        ["\x23\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8C"],
        ["\x23\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8D"],
        ["\x23\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8E"],
        ["\x23\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8F"],
        ["\x23\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x90"],
        ["\x23\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x91"],
        ["\x23\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x92"],
        ["\x23\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x93"],
        ["\x23\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x94"],
        ["\x23\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x95"],
        ["\x24\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9A"],
        ["\x24\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9B"],
        ["\x24\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9C"],
        ["\x24\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9D"],
        ["\x24\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9E"],
        ["\x24\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9F"],
        ["\x24\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA0"],
        ["\x24\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA1"],
        ["\x24\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA2"],
        ["\x24\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA3"],
        ["\x24\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA4"],
        ["\x24\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA5"],
        ["\x24\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA6"],
        ["\x24\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA7"],
        ["\x24\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA8"],
        ["\x24\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA9"],
        ["\x24\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAA"],
        ["\x24\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAB"],
        ["\x24\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAC"],
        ["\x24\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAD"],
        ["\x24\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAE"],
        ["\x24\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAF"],
        ["\x24\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB0"],
        ["\x24\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB1"],
        ["\x24\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB2"],
        ["\x24\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB3"],
        ["\x24\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB4"],
        ["\x24\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB5"],
        ["\x24\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB6"],
        ["\x24\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB7"],
        ["\x24\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB8"],
        ["\x24\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB9"],
        ["\x24\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBA"],
        ["\x24\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBB"],
        ["\x24\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBC"],
        ["\x24\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBD"],
        ["\x24\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBE"],
        ["\x24\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBF"],
        ["\x24\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x80"],
        ["\x24\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x81"],
        ["\x24\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x82"],
        ["\x24\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x83"],
        ["\x24\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x84"],
        ["\x24\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x85"],
        ["\x24\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x86"],
        ["\x24\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x87"],
        ["\x24\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x88"],
        ["\x24\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x89"],
        ["\x24\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8A"],
        ["\x24\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8B"],
        ["\x24\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8C"],
        ["\x24\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8D"],
        ["\x24\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8E"],
        ["\x24\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8F"],
        ["\x24\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x90"],
        ["\x24\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x91"],
        ["\x24\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x92"],
        ["\x24\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x93"],
        ["\x24\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x94"],
        ["\x24\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x95"],
        ["\x24\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x96"],
        ["\x24\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x97"],
        ["\x24\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x98"],
        ["\x24\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x99"],
        ["\x24\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9A"],
        ["\x24\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9B"],
        ["\x24\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9C"],
        ["\x24\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9D"],
        ["\x24\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9E"],
        ["\x24\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9F"],
        ["\x24\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA0"],
        ["\x24\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA1"],
        ["\x24\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA2"],
        ["\x24\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA3"],
        ["\x24\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA4"],
        ["\x24\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA5"],
        ["\x24\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA6"],
        ["\x24\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA7"],
        ["\x24\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA8"],
        ["\x24\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA9"],
        ["\x24\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAA"],
        ["\x24\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAB"],
        ["\x24\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAC"],
        ["\x25\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB8"],
        ["\x25\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB9"],
        ["\x25\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBA"],
        ["\x25\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBB"],
        ["\x25\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBC"],
        ["\x25\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBD"],
        ["\x25\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBE"],
        ["\x25\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBF"],
        ["\x25\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x80"],
        ["\x25\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x81"],
        ["\x25\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x82"],
        ["\x25\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x83"],
        ["\x25\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x84"],
        ["\x25\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x85"],
        ["\x25\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x86"],
        ["\x25\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x87"],
        ["\x25\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x88"],
        ["\x25\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x89"],
        ["\x25\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8A"],
        ["\x25\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8B"],
        ["\x25\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8C"],
        ["\x25\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8D"],
        ["\x25\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8E"],
        ["\x25\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8F"],
        ["\x25\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x90"],
        ["\x25\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x91"],
        ["\x25\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x92"],
        ["\x25\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x93"],
        ["\x25\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x94"],
        ["\x25\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x95"],
        ["\x25\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x96"],
        ["\x25\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x97"],
        ["\x25\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x98"],
        ["\x25\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x99"],
        ["\x25\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9A"],
        ["\x25\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9B"],
        ["\x25\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9C"],
        ["\x25\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9D"],
        ["\x25\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9E"],
        ["\x25\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9F"],
        ["\x25\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA0"],
        ["\x25\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA1"],
        ["\x25\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA2"],
        ["\x25\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA3"],
        ["\x25\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA4"],
        ["\x25\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA5"],
        ["\x25\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA6"],
        ["\x25\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA7"],
        ["\x25\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA8"],
        ["\x25\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA9"],
        ["\x25\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAA"],
        ["\x25\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAB"],
        ["\x25\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAC"],
        ["\x25\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAD"],
        ["\x25\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAE"],
        ["\x25\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAF"],
        ["\x25\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB0"],
        ["\x25\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB1"],
        ["\x25\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB2"],
        ["\x25\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB3"],
        ["\x25\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB4"],
        ["\x25\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB5"],
        ["\x25\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB6"],
        ["\x25\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB7"],
        ["\x25\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB8"],
        ["\x25\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB9"],
        ["\x25\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBA"],
        ["\x25\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBB"],
        ["\x25\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBC"],
        ["\x25\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBD"],
        ["\x25\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBE"],
        ["\x25\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBF"],
        ["\x25\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x80"],
        ["\x25\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x81"],
        ["\x25\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x82"],
        ["\x25\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x83"],
        ["\x25\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x84"],
        ["\x25\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x85"],
        ["\x25\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x86"],
        ["\x25\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x87"],
        ["\x25\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x88"],
        ["\x25\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x89"],
        ["\x25\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8A"],
        ["\x25\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8B"],
        ["\x25\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8C"],
        ["\x25\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8D"],
        ["\x26\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x96"],
        ["\x26\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x97"],
        ["\x26\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x98"],
        ["\x26\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x99"],
        ["\x26\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9A"],
        ["\x26\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9B"],
        ["\x26\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9C"],
        ["\x26\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9D"],
        ["\x26\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9E"],
        ["\x26\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9F"],
        ["\x26\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA0"],
        ["\x26\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA1"],
        ["\x26\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA2"],
        ["\x26\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA3"],
        ["\x26\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA4"],
        ["\x26\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA5"],
        ["\x26\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA6"],
        ["\x26\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA7"],
        ["\x26\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA8"],
        ["\x26\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA9"],
        ["\x26\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAA"],
        ["\x26\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAB"],
        ["\x26\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAC"],
        ["\x26\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAD"],
        ["\x26\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB6"],
        ["\x26\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB7"],
        ["\x26\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB8"],
        ["\x26\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB9"],
        ["\x26\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBA"],
        ["\x26\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBB"],
        ["\x26\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBC"],
        ["\x26\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBD"],
        ["\x26\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBE"],
        ["\x26\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBF"],
        ["\x26\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x80"],
        ["\x26\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x81"],
        ["\x26\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x82"],
        ["\x26\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x83"],
        ["\x26\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x84"],
        ["\x26\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x85"],
        ["\x26\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x86"],
        ["\x26\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x87"],
        ["\x26\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x88"],
        ["\x26\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x89"],
        ["\x26\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8A"],
        ["\x26\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8B"],
        ["\x26\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8C"],
        ["\x26\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8D"],
        ["\x27\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB4"],
        ["\x27\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB5"],
        ["\x27\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB6"],
        ["\x27\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB7"],
        ["\x27\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB8"],
        ["\x27\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB9"],
        ["\x27\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBA"],
        ["\x27\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBB"],
        ["\x27\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBC"],
        ["\x27\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBD"],
        ["\x27\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBE"],
        ["\x27\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBF"],
        ["\x27\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x80"],
        ["\x27\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x81"],
        ["\x27\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x82"],
        ["\x27\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x83"],
        ["\x27\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x84"],
        ["\x27\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x85"],
        ["\x27\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x86"],
        ["\x27\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x87"],
        ["\x27\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x88"],
        ["\x27\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x89"],
        ["\x27\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8A"],
        ["\x27\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8B"],
        ["\x27\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8C"],
        ["\x27\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8D"],
        ["\x27\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8E"],
        ["\x27\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8F"],
        ["\x27\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x90"],
        ["\x27\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x91"],
        ["\x27\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x92"],
        ["\x27\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x93"],
        ["\x27\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x94"],
        ["\x27\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA4"],
        ["\x27\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA5"],
        ["\x27\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA6"],
        ["\x27\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA7"],
        ["\x27\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA8"],
        ["\x27\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA9"],
        ["\x27\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAA"],
        ["\x27\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAB"],
        ["\x27\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAC"],
        ["\x27\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAD"],
        ["\x27\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAE"],
        ["\x27\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAF"],
        ["\x27\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB0"],
        ["\x27\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB1"],
        ["\x27\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB2"],
        ["\x27\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB3"],
        ["\x27\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB4"],
        ["\x27\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB5"],
        ["\x27\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB6"],
        ["\x27\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB7"],
        ["\x27\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB8"],
        ["\x27\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB9"],
        ["\x27\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBA"],
        ["\x27\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBB"],
        ["\x27\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBC"],
        ["\x27\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBD"],
        ["\x27\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBE"],
        ["\x27\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBF"],
        ["\x27\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x80"],
        ["\x27\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x81"],
        ["\x27\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x82"],
        ["\x27\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x83"],
        ["\x27\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x84"],
        ["\x2D\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA8"],
        ["\x2D\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xA9"],
        ["\x2D\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAA"],
        ["\x2D\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAB"],
        ["\x2D\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAC"],
        ["\x2D\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAD"],
        ["\x2D\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAE"],
        ["\x2D\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xAF"],
        ["\x2D\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB0"],
        ["\x2D\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB1"],
        ["\x2D\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB2"],
        ["\x2D\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB3"],
        ["\x2D\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB4"],
        ["\x2D\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB5"],
        ["\x2D\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB6"],
        ["\x2D\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB7"],
        ["\x2D\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB8"],
        ["\x2D\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xB9"],
        ["\x2D\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBA"],
        ["\x2D\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBB"],
        ["\x2D\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBC"],
        ["\x2D\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBD"],
        ["\x2D\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBE"],
        ["\x2D\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x95\xBF"],
        ["\x2D\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x80"],
        ["\x2D\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x81"],
        ["\x2D\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x82"],
        ["\x2D\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x83"],
        ["\x2D\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x84"],
        ["\x2D\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x85"],
        ["\x2D\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x87"],
        ["\x2D\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x88"],
        ["\x2D\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x89"],
        ["\x2D\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8A"],
        ["\x2D\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8B"],
        ["\x2D\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8C"],
        ["\x2D\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8D"],
        ["\x2D\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8E"],
        ["\x2D\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x8F"],
        ["\x2D\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x90"],
        ["\x2D\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x91"],
        ["\x2D\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x92"],
        ["\x2D\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x93"],
        ["\x2D\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x94"],
        ["\x2D\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x95"],
        ["\x2D\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x96"],
        ["\x2D\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x97"],
        ["\x2D\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x98"],
        ["\x2D\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x99"],
        ["\x2D\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9A"],
        ["\x2D\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9B"],
        ["\x2D\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9C"],
        ["\x2D\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\x9D"],
        ["\x2D\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA6"],
        ["\x2D\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA7"],
        ["\x2D\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA8"],
        ["\x2D\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA9"],
        ["\x2D\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAA"],
        ["\x2D\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAC"],
        ["\x2D\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAD"],
        ["\x2D\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAE"],
        ["\x2D\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xAF"],
        ["\x2D\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB0"],
        ["\x2D\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB1"],
        ["\x2D\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB2"],
        ["\x2D\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB3"],
        ["\x2D\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB4"],
        ["\x2D\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB5"],
        ["\x2D\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xB6"],
        ["\x2D\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBA"],
        ["\x2D\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBB"],
        ["\x2D\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xBF"],
        ["\x2D\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x97\x80"],
        ["\x30\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x82"],
        ["\x30\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x83"],
        ["\x30\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x84"],
        ["\x30\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x85"],
        ["\x30\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x86"],
        ["\x30\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x87"],
        ["\x30\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x88"],
        ["\x30\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x89"],
        ["\x30\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8A"],
        ["\x30\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8B"],
        ["\x30\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8C"],
        ["\x30\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8D"],
        ["\x30\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8E"],
        ["\x30\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8F"],
        ["\x30\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x90"],
        ["\x30\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x91"],
        ["\x30\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x92"],
        ["\x30\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x93"],
        ["\x72\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x94"],
        ["\x30\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x95"],
        ["\x30\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x96"],
        ["\x30\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x97"],
        ["\x30\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x98"],
        ["\x30\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x99"],
        ["\x30\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9A"],
        ["\x30\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9B"],
        ["\x30\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9C"],
        ["\x30\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9D"],
        ["\x30\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9E"],
        ["\x30\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9F"],
        ["\x30\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA0"],
        ["\x30\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA1"],
        ["\x30\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA2"],
        ["\x30\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA3"],
        ["\x30\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA4"],
        ["\x30\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA5"],
        ["\x30\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA6"],
        ["\x30\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA7"],
        ["\x30\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA8"],
        ["\x30\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA9"],
        ["\x30\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAA"],
        ["\x30\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAB"],
        ["\x30\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAC"],
        ["\x30\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAD"],
        ["\x30\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAE"],
        ["\x30\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAF"],
        ["\x30\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB0"],
        ["\x30\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB1"],
        ["\x30\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB2"],
        ["\x30\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB3"],
        ["\x30\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB4"],
        ["\x30\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB5"],
        ["\x30\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB6"],
        ["\x30\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB7"],
        ["\x30\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB8"],
        ["\x30\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB9"],
        ["\x30\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBA"],
        ["\x30\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBB"],
        ["\x30\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBC"],
        ["\x30\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBD"],
        ["\x30\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBE"],
        ["\x30\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBF"],
        ["\x30\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x80"],
        ["\x30\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x81"],
        ["\x30\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x82"],
        ["\x30\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x83"],
        ["\x30\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x84"],
        ["\x30\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x85"],
        ["\x30\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x86"],
        ["\x30\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x87"],
        ["\x30\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x88"],
        ["\x30\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x89"],
        ["\x30\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8A"],
        ["\x30\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8B"],
        ["\x30\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8C"],
        ["\x30\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8D"],
        ["\x30\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8E"],
        ["\x30\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8F"],
        ["\x30\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x90"],
        ["\x30\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x91"],
        ["\x30\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x92"],
        ["\x30\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x93"],
        ["\x30\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x94"],
        ["\x30\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x95"],
        ["\x30\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x96"],
        ["\x30\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x97"],
        ["\x30\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x98"],
        ["\x30\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x99"],
        ["\x30\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9A"],
        ["\x30\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9B"],
        ["\x30\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9C"],
        ["\x30\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9D"],
        ["\x30\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9E"],
        ["\x30\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9F"],
        ["\x31\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA0"],
        ["\x31\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA1"],
        ["\x31\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA2"],
        ["\x31\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA3"],
        ["\x31\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA4"],
        ["\x31\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA5"],
        ["\x31\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA6"],
        ["\x31\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA7"],
        ["\x31\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA8"],
        ["\x31\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA9"],
        ["\x31\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAA"],
        ["\x31\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAB"],
        ["\x31\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAC"],
        ["\x31\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAD"],
        ["\x31\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAE"],
        ["\x31\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAF"],
        ["\x31\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB0"],
        ["\x31\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB1"],
        ["\x31\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB2"],
        ["\x31\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB3"],
        ["\x31\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB4"],
        ["\x31\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB5"],
        ["\x31\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB6"],
        ["\x31\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB7"],
        ["\x31\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB8"],
        ["\x31\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB9"],
        ["\x31\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBA"],
        ["\x31\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBB"],
        ["\x31\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBC"],
        ["\x31\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBD"],
        ["\x31\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBE"],
        ["\x31\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBF"],
        ["\x31\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x80"],
        ["\x31\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x81"],
        ["\x31\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x82"],
        ["\x31\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x83"],
        ["\x31\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x84"],
        ["\x31\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x85"],
        ["\x31\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x86"],
        ["\x31\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x87"],
        ["\x31\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x88"],
        ["\x31\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x89"],
        ["\x31\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8A"],
        ["\x31\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8B"],
        ["\x31\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8C"],
        ["\x31\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8D"],
        ["\x31\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8E"],
        ["\x31\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8F"],
        ["\x31\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x90"],
        ["\x31\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x91"],
        ["\x31\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x92"],
        ["\x31\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x93"],
        ["\x31\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x94"],
        ["\x31\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x95"],
        ["\x31\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x96"],
        ["\x31\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x97"],
        ["\x31\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x98"],
        ["\x31\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x99"],
        ["\x31\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9A"],
        ["\x31\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9B"],
        ["\x31\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9C"],
        ["\x31\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9D"],
        ["\x31\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9E"],
        ["\x31\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9F"],
        ["\x31\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA0"],
        ["\x31\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA1"],
        ["\x31\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA2"],
        ["\x31\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA3"],
        ["\x31\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA4"],
        ["\x31\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA5"],
        ["\x31\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA6"],
        ["\x31\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA7"],
        ["\x31\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA8"],
        ["\x31\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA9"],
        ["\x31\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAA"],
        ["\x31\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAB"],
        ["\x31\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAC"],
        ["\x31\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAD"],
        ["\x31\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAE"],
        ["\x31\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAF"],
        ["\x31\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB0"],
        ["\x31\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB1"],
        ["\x31\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB2"],
        ["\x31\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB3"],
        ["\x31\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB4"],
        ["\x31\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB5"],
        ["\x31\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB6"],
        ["\x31\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB7"],
        ["\x31\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB8"],
        ["\x31\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB9"],
        ["\x31\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBA"],
        ["\x31\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBB"],
        ["\x31\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBC"],
        ["\x31\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBD"],
        ["\x32\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBE"],
        ["\x32\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBF"],
        ["\x32\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x80"],
        ["\x32\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x81"],
        ["\x32\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x82"],
        ["\x32\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x83"],
        ["\x32\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x84"],
        ["\x32\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x85"],
        ["\x72\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x86"],
        ["\x32\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x87"],
        ["\x32\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x88"],
        ["\x32\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x89"],
        ["\x32\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8A"],
        ["\x32\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8B"],
        ["\x32\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8C"],
        ["\x32\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8D"],
        ["\x32\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8E"],
        ["\x32\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8F"],
        ["\x32\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x90"],
        ["\x32\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x91"],
        ["\x32\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x92"],
        ["\x32\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x93"],
        ["\x32\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x94"],
        ["\x32\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x95"],
        ["\x32\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x96"],
        ["\x32\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x97"],
        ["\x32\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x98"],
        ["\x32\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x99"],
        ["\x32\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9A"],
        ["\x32\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9B"],
        ["\x32\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9C"],
        ["\x32\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9D"],
        ["\x32\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9E"],
        ["\x32\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9F"],
        ["\x32\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA0"],
        ["\x32\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA1"],
        ["\x32\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA2"],
        ["\x32\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA3"],
        ["\x32\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA4"],
        ["\x32\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA5"],
        ["\x32\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA6"],
        ["\x32\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA7"],
        ["\x32\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA8"],
        ["\x32\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA9"],
        ["\x32\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAA"],
        ["\x32\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAB"],
        ["\x32\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAC"],
        ["\x32\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAD"],
        ["\x32\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAE"],
        ["\x32\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAF"],
        ["\x32\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB0"],
        ["\x32\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB1"],
        ["\x32\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB2"],
        ["\x32\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB3"],
        ["\x32\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB4"],
        ["\x32\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB5"],
        ["\x32\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB6"],
        ["\x32\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB7"],
        ["\x32\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB8"],
        ["\x32\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB9"],
        ["\x32\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBA"],
        ["\x32\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBB"],
        ["\x32\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBC"],
        ["\x32\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBD"],
        ["\x32\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBE"],
        ["\x32\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBF"],
        ["\x32\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x80"],
        ["\x32\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x81"],
        ["\x32\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x82"],
        ["\x32\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x83"],
        ["\x32\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x84"],
        ["\x32\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x85"],
        ["\x32\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x86"],
        ["\x32\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x87"],
        ["\x32\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x88"],
        ["\x32\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x89"],
        ["\x32\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8A"],
        ["\x32\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8B"],
        ["\x32\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8C"],
        ["\x32\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8D"],
        ["\x32\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8E"],
        ["\x32\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8F"],
        ["\x32\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x90"],
        ["\x32\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x91"],
        ["\x32\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x92"],
        ["\x32\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x93"],
        ["\x32\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x94"],
        ["\x32\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x95"],
        ["\x32\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x96"],
        ["\x32\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x97"],
        ["\x32\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x98"],
        ["\x32\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x99"],
        ["\x32\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9A"],
        ["\x32\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9B"],
        ["\x33\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9C"],
        ["\x33\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9D"],
        ["\x33\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9E"],
        ["\x33\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9F"],
        ["\x33\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA0"],
        ["\x33\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA1"],
        ["\x33\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA2"],
        ["\x33\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA3"],
        ["\x33\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA4"],
        ["\x33\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA5"],
        ["\x33\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA6"],
        ["\x33\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA7"],
        ["\x33\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA8"],
        ["\x33\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA9"],
        ["\x33\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAA"],
        ["\x33\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAB"],
        ["\x33\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAC"],
        ["\x33\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAD"],
        ["\x33\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAE"],
        ["\x33\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAF"],
        ["\x33\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB0"],
        ["\x33\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB1"],
        ["\x33\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB2"],
        ["\x33\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB3"],
        ["\x33\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB4"],
        ["\x33\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB5"],
        ["\x33\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB6"],
        ["\x33\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB7"],
        ["\x33\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB8"],
        ["\x33\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB9"],
        ["\x33\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBA"],
        ["\x33\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBB"],
        ["\x33\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBC"],
        ["\x69\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBD"],
        ["\x33\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBE"],
        ["\x33\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBF"],
        ["\x33\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x80"],
        ["\x33\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x81"],
        ["\x33\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x82"],
        ["\x33\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x83"],
        ["\x59\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x84"],
        ["\x33\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x85"],
        ["\x33\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x86"],
        ["\x33\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x87"],
        ["\x33\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x88"],
        ["\x33\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x89"],
        ["\x33\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8A"],
        ["\x33\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8B"],
        ["\x33\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8C"],
        ["\x33\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8D"],
        ["\x33\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8E"],
        ["\x33\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8F"],
        ["\x33\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x90"],
        ["\x33\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x91"],
        ["\x33\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x92"],
        ["\x33\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x93"],
        ["\x33\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x94"],
        ["\x33\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x95"],
        ["\x33\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x96"],
        ["\x33\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x97"],
        ["\x33\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x98"],
        ["\x33\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x99"],
        ["\x33\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9A"],
        ["\x33\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9B"],
        ["\x33\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9C"],
        ["\x33\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9D"],
        ["\x33\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9E"],
        ["\x33\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9F"],
        ["\x33\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA0"],
        ["\x33\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA1"],
        ["\x33\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA2"],
        ["\x33\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA3"],
        ["\x33\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA4"],
        ["\x33\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA5"],
        ["\x33\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA6"],
        ["\x33\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA7"],
        ["\x33\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA8"],
        ["\x33\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA9"],
        ["\x33\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAA"],
        ["\x33\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAB"],
        ["\x33\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAC"],
        ["\x33\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAD"],
        ["\x33\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAE"],
        ["\x33\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAF"],
        ["\x33\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB0"],
        ["\x63\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB1"],
        ["\x33\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB2"],
        ["\x33\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB3"],
        ["\x33\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB4"],
        ["\x33\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB5"],
        ["\x33\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB6"],
        ["\x33\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB7"],
        ["\x33\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB8"],
        ["\x33\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB9"],
        ["\x34\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBA"],
        ["\x34\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBB"],
        ["\x34\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBC"],
        ["\x34\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBD"],
        ["\x34\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBE"],
        ["\x34\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBF"],
        ["\x34\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x80"],
        ["\x34\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x81"],
        ["\x34\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x82"],
        ["\x34\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x83"],
        ["\x34\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x84"],
        ["\x34\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x85"],
        ["\x34\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x86"],
        ["\x34\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x87"],
        ["\x34\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x88"],
        ["\x34\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x89"],
        ["\x34\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8A"],
        ["\x34\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8B"],
        ["\x34\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8C"],
        ["\x34\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8D"],
        ["\x34\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8E"],
        ["\x34\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8F"],
        ["\x34\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x90"],
        ["\x34\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x91"],
        ["\x34\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x92"],
        ["\x34\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x93"],
        ["\x34\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x94"],
        ["\x34\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x95"],
        ["\x34\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x96"],
        ["\x34\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x97"],
        ["\x34\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x98"],
        ["\x34\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x99"],
        ["\x34\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9A"],
        ["\x34\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9B"],
        ["\x5E\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9C"],
        ["\x34\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9D"],
        ["\x34\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9E"],
        ["\x34\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9F"],
        ["\x34\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA0"],
        ["\x34\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA1"],
        ["\x34\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA2"],
        ["\x34\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA3"],
        ["\x34\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA4"],
        ["\x34\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA5"],
        ["\x34\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA6"],
        ["\x34\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA7"],
        ["\x34\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA8"],
        ["\x34\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA9"],
        ["\x34\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAA"],
        ["\x6B\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAB"],
        ["\x34\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAC"],
        ["\x34\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAD"],
        ["\x34\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAE"],
        ["\x34\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAF"],
        ["\x34\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB0"],
        ["\x34\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB1"],
        ["\x34\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB2"],
        ["\x34\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB3"],
        ["\x34\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB4"],
        ["\x34\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB5"],
        ["\x34\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB6"],
        ["\x34\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB7"],
        ["\x34\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB8"],
        ["\x34\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB9"],
        ["\x34\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBA"],
        ["\x34\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBB"],
        ["\x34\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBC"],
        ["\x34\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBD"],
        ["\x34\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBE"],
        ["\x34\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBF"],
        ["\x34\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x80"],
        ["\x34\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x81"],
        ["\x34\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x82"],
        ["\x34\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x83"],
        ["\x34\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x84"],
        ["\x34\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x85"],
        ["\x34\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x86"],
        ["\x34\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x87"],
        ["\x34\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x88"],
        ["\x34\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x89"],
        ["\x34\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8A"],
        ["\x34\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8B"],
        ["\x34\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8C"],
        ["\x34\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8D"],
        ["\x34\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8E"],
        ["\x34\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8F"],
        ["\x34\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x90"],
        ["\x34\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x91"],
        ["\x34\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x92"],
        ["\x34\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x93"],
        ["\x34\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x94"],
        ["\x34\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x95"],
        ["\x34\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x96"],
        ["\x34\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x97"],
        ["\x35\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x98"],
        ["\x35\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x99"],
        ["\x35\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9A"],
        ["\x35\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9B"],
        ["\x35\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9C"],
        ["\x35\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9D"],
        ["\x35\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9E"],
        ["\x35\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9F"],
        ["\x35\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA0"],
        ["\x35\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA1"],
        ["\x35\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA2"],
        ["\x35\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA3"],
        ["\x35\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA4"],
        ["\x35\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA5"],
        ["\x35\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA6"],
        ["\x35\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA7"],
        ["\x35\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA8"],
        ["\x35\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA9"],
        ["\x35\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAA"],
        ["\x35\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAB"],
        ["\x35\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAC"],
        ["\x35\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAD"],
        ["\x35\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAE"],
        ["\x35\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAF"],
        ["\x35\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB0"],
        ["\x35\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB1"],
        ["\x35\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB2"],
        ["\x35\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB3"],
        ["\x35\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB4"],
        ["\x35\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB5"],
        ["\x35\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB6"],
        ["\x35\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB7"],
        ["\x35\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB8"],
        ["\x35\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB9"],
        ["\x35\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBA"],
        ["\x35\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBB"],
        ["\x35\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBC"],
        ["\x35\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBD"],
        ["\x35\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBE"],
        ["\x35\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBF"],
        ["\x35\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x80"],
        ["\x35\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x81"],
        ["\x35\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x82"],
        ["\x35\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x83"],
        ["\x35\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x84"],
        ["\x35\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x85"],
        ["\x35\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x86"],
        ["\x35\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x87"],
        ["\x35\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x88"],
        ["\x35\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x89"],
        ["\x35\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8A"],
        ["\x35\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8B"],
        ["\x35\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8C"],
        ["\x35\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8D"],
        ["\x35\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8E"],
        ["\x35\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8F"],
        ["\x35\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x90"],
        ["\x35\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x91"],
        ["\x35\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x92"],
        ["\x35\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x93"],
        ["\x35\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x94"],
        ["\x35\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x95"],
        ["\x35\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x96"],
        ["\x35\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x97"],
        ["\x35\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x98"],
        ["\x35\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x99"],
        ["\x35\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9A"],
        ["\x35\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9B"],
        ["\x35\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9C"],
        ["\x35\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9D"],
        ["\x35\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9E"],
        ["\x35\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9F"],
        ["\x35\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA0"],
        ["\x35\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA1"],
        ["\x35\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA2"],
        ["\x35\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA3"],
        ["\x35\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA4"],
        ["\x35\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA5"],
        ["\x35\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA6"],
        ["\x35\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA7"],
        ["\x35\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA8"],
        ["\x35\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA9"],
        ["\x35\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAA"],
        ["\x35\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAB"],
        ["\x35\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAC"],
        ["\x35\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAD"],
        ["\x35\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAE"],
        ["\x35\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAF"],
        ["\x35\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB0"],
        ["\x35\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB1"],
        ["\x35\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB2"],
        ["\x35\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB3"],
        ["\x35\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB4"],
        ["\x35\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB5"],
        ["\x36\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB6"],
        ["\x36\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB7"],
        ["\x36\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB8"],
        ["\x36\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB9"],
        ["\x36\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBA"],
        ["\x36\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBB"],
        ["\x36\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBC"],
        ["\x36\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBD"],
        ["\x36\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBE"],
        ["\x36\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBF"],
        ["\x36\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x80"],
        ["\x36\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x81"],
        ["\x36\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x82"],
        ["\x36\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x83"],
        ["\x36\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x84"],
        ["\x36\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x85"],
        ["\x36\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x86"],
        ["\x36\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x87"],
        ["\x36\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x88"],
        ["\x36\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x89"],
        ["\x36\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8A"],
        ["\x36\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8B"],
        ["\x36\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8C"],
        ["\x36\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8D"],
        ["\x36\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8E"],
        ["\x36\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8F"],
        ["\x36\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x90"],
        ["\x36\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x91"],
        ["\x36\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x92"],
        ["\x36\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x93"],
        ["\x36\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x94"],
        ["\x36\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x95"],
        ["\x36\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x96"],
        ["\x36\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x97"],
        ["\x36\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x98"],
        ["\x36\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x99"],
        ["\x36\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9A"],
        ["\xB6\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9B"],
        ["\x36\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9C"],
        ["\x36\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9D"],
        ["\x36\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9E"],
        ["\x36\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9F"],
        ["\x36\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA0"],
        ["\x36\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA1"],
        ["\x36\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA2"],
        ["\x36\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA3"],
        ["\x36\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA4"],
        ["\x36\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA5"],
        ["\x36\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA6"],
        ["\x36\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA7"],
        ["\x36\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA8"],
        ["\x36\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA9"],
        ["\x36\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAA"],
        ["\x36\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAB"],
        ["\x36\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAC"],
        ["\x36\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAD"],
        ["\x36\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAE"],
        ["\x36\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAF"],
        ["\x36\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB0"],
        ["\x36\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB1"],
        ["\x36\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB2"],
        ["\x36\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB3"],
        ["\x36\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB4"],
        ["\x36\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB5"],
        ["\x36\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB6"],
        ["\x36\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB7"],
        ["\x36\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB8"],
        ["\x36\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB9"],
        ["\x36\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBA"],
        ["\x36\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBB"],
        ["\x36\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBC"],
        ["\x36\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBD"],
        ["\x36\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBE"],
        ["\x36\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBF"],
        ["\x36\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x80"],
        ["\x36\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x81"],
        ["\x36\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x82"],
        ["\x36\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x83"],
        ["\x36\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x84"],
        ["\x36\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x85"],
        ["\x36\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x86"],
        ["\x36\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x87"],
        ["\x36\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x88"],
        ["\x36\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x89"],
        ["\x36\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8A"],
        ["\x36\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8B"],
        ["\x36\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8C"],
        ["\x36\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8D"],
        ["\x36\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8E"],
        ["\x36\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8F"],
        ["\x36\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x90"],
        ["\x36\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x91"],
        ["\x36\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x92"],
        ["\x36\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x93"],
        ["\x37\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x94"],
        ["\x37\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x95"],
        ["\x37\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x96"],
        ["\x37\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x97"],
        ["\x37\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x98"],
        ["\x37\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x99"],
        ["\x37\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9A"],
        ["\x37\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9B"],
        ["\x37\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9C"],
        ["\x37\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9D"],
        ["\x37\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9E"],
        ["\x37\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9F"],
        ["\x37\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA0"],
        ["\x37\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA1"],
        ["\x37\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA2"],
        ["\x37\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA3"],
        ["\x37\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA4"],
        ["\x37\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA5"],
        ["\x37\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA6"],
        ["\x37\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA7"],
        ["\x37\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA8"],
        ["\x37\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA9"],
        ["\x37\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAA"],
        ["\x37\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAB"],
        ["\x37\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAC"],
        ["\x37\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAD"],
        ["\x37\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAE"],
        ["\x37\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAF"],
        ["\x37\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB0"],
        ["\x37\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB1"],
        ["\x37\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB2"],
        ["\x37\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB3"],
        ["\x37\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB4"],
        ["\x37\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB5"],
        ["\x37\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB6"],
        ["\x37\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB7"],
        ["\x37\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB8"],
        ["\x37\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB9"],
        ["\x37\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBA"],
        ["\x37\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBB"],
        ["\x37\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBC"],
        ["\x37\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBD"],
        ["\x37\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBE"],
        ["\x37\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBF"],
        ["\x37\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x80"],
        ["\x37\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x81"],
        ["\x37\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x82"],
        ["\x37\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x83"],
        ["\x37\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x84"],
        ["\x37\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x85"],
        ["\x37\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x86"],
        ["\x37\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x87"],
        ["\x37\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x88"],
        ["\x37\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x89"],
        ["\x37\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8A"],
        ["\x37\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8B"],
        ["\x37\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8C"],
        ["\x37\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8D"],
        ["\x70\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8E"],
        ["\x37\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8F"],
        ["\x37\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x90"],
        ["\x37\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x91"],
        ["\x37\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x92"],
        ["\x37\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x93"],
        ["\x37\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x94"],
        ["\x37\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x95"],
        ["\x37\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x96"],
        ["\x37\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x97"],
        ["\x37\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x98"],
        ["\x37\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x99"],
        ["\x37\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9A"],
        ["\x37\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9B"],
        ["\x37\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9C"],
        ["\x37\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9D"],
        ["\x37\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9E"],
        ["\x37\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9F"],
        ["\x37\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA0"],
        ["\x37\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA1"],
        ["\x37\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA2"],
        ["\x37\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA3"],
        ["\x37\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA4"],
        ["\x37\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA5"],
        ["\x37\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA6"],
        ["\x37\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA7"],
        ["\x37\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA8"],
        ["\x37\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA9"],
        ["\x37\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAA"],
        ["\x37\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAB"],
        ["\x37\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAC"],
        ["\x37\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAD"],
        ["\x37\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAE"],
        ["\x37\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAF"],
        ["\x37\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB0"],
        ["\x37\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB1"],
        ["\x38\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB2"],
        ["\x38\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB3"],
        ["\x38\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB4"],
        ["\x38\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB5"],
        ["\x38\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB6"],
        ["\x38\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB7"],
        ["\x38\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB8"],
        ["\x38\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB9"],
        ["\x38\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBA"],
        ["\x38\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBB"],
        ["\x38\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBC"],
        ["\x38\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBD"],
        ["\x38\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBE"],
        ["\x38\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBF"],
        ["\x38\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x80"],
        ["\x38\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x81"],
        ["\x38\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x82"],
        ["\x38\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x83"],
        ["\x38\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x84"],
        ["\x38\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x85"],
        ["\x38\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x86"],
        ["\x38\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x87"],
        ["\x38\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x88"],
        ["\x38\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x89"],
        ["\x38\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8A"],
        ["\x38\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8B"],
        ["\x38\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8C"],
        ["\x38\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8D"],
        ["\x38\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8E"],
        ["\x38\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8F"],
        ["\x38\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x90"],
        ["\x38\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x91"],
        ["\x38\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x92"],
        ["\x38\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x93"],
        ["\x38\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x94"],
        ["\x38\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x95"],
        ["\x38\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x96"],
        ["\x38\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x97"],
        ["\x38\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x98"],
        ["\x38\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x99"],
        ["\x38\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9A"],
        ["\x38\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9B"],
        ["\x38\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9C"],
        ["\x38\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9D"],
        ["\x38\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9E"],
        ["\x38\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9F"],
        ["\x38\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA0"],
        ["\x38\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA1"],
        ["\x38\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA2"],
        ["\x38\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA3"],
        ["\x38\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA4"],
        ["\x38\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA5"],
        ["\x38\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA6"],
        ["\x38\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA7"],
        ["\x38\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA8"],
        ["\x38\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA9"],
        ["\x38\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAA"],
        ["\x38\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAB"],
        ["\x38\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAC"],
        ["\x38\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAD"],
        ["\x38\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAE"],
        ["\x38\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAF"],
        ["\x38\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB0"],
        ["\x38\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB1"],
        ["\x38\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB2"],
        ["\x38\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB3"],
        ["\x38\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB4"],
        ["\x38\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB5"],
        ["\x38\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB6"],
        ["\x38\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB7"],
        ["\x38\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB8"],
        ["\x38\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB9"],
        ["\x38\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBA"],
        ["\x38\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBB"],
        ["\x38\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBC"],
        ["\x38\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBD"],
        ["\x38\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBE"],
        ["\x38\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBF"],
        ["\x38\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x80"],
        ["\x38\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x81"],
        ["\x38\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x82"],
        ["\x38\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x83"],
        ["\x38\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x84"],
        ["\x38\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x85"],
        ["\x38\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x86"],
        ["\x38\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x87"],
        ["\x38\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x88"],
        ["\x38\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x89"],
        ["\x38\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8A"],
        ["\x38\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8B"],
        ["\x38\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8C"],
        ["\x38\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8D"],
        ["\x38\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8E"],
        ["\x38\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8F"],
        ["\x39\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x90"],
        ["\x39\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x91"],
        ["\x39\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x92"],
        ["\x39\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x93"],
        ["\x39\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x94"],
        ["\x39\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x95"],
        ["\x39\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x96"],
        ["\x39\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x97"],
        ["\x39\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x98"],
        ["\x39\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x99"],
        ["\x39\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9A"],
        ["\x39\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9B"],
        ["\x39\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9C"],
        ["\x39\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9D"],
        ["\x39\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9E"],
        ["\x39\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9F"],
        ["\x39\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA0"],
        ["\x39\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA1"],
        ["\x39\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA2"],
        ["\x39\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA3"],
        ["\x39\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA4"],
        ["\x39\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA5"],
        ["\x39\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA6"],
        ["\x39\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA7"],
        ["\x39\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA8"],
        ["\x39\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA9"],
        ["\x39\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAA"],
        ["\x39\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAB"],
        ["\x39\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAC"],
        ["\x39\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAD"],
        ["\x39\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAE"],
        ["\x39\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAF"],
        ["\x39\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB0"],
        ["\x39\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB1"],
        ["\x39\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB2"],
        ["\x39\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB3"],
        ["\x39\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB4"],
        ["\x39\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB5"],
        ["\x39\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB6"],
        ["\x39\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB7"],
        ["\x39\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB8"],
        ["\x39\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB9"],
        ["\x39\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBA"],
        ["\x39\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBB"],
        ["\x39\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBC"],
        ["\x39\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBD"],
        ["\x39\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBE"],
        ["\x39\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBF"],
        ["\x39\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x80"],
        ["\x39\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x81"],
        ["\x39\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x82"],
        ["\x39\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x83"],
        ["\x39\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x84"],
        ["\x39\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x85"],
        ["\x39\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x86"],
        ["\x39\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x87"],
        ["\x39\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x88"],
        ["\x39\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x89"],
        ["\x39\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8A"],
        ["\x62\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8B"],
        ["\x39\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8C"],
        ["\x39\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8D"],
        ["\x39\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8E"],
        ["\x39\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8F"],
        ["\x39\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x90"],
        ["\x39\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x91"],
        ["\x39\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x92"],
        ["\x39\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x93"],
        ["\x39\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x94"],
        ["\x39\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x95"],
        ["\x39\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x96"],
        ["\x39\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x97"],
        ["\x39\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x98"],
        ["\x39\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x99"],
        ["\x39\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9A"],
        ["\x39\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9B"],
        ["\xD6\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9C"],
        ["\x39\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9D"],
        ["\x39\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9E"],
        ["\x39\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9F"],
        ["\x39\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA0"],
        ["\x39\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA1"],
        ["\x39\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA2"],
        ["\x39\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA3"],
        ["\x39\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA4"],
        ["\x39\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA5"],
        ["\x39\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA6"],
        ["\x39\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA7"],
        ["\x39\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA8"],
        ["\x39\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA9"],
        ["\x39\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAA"],
        ["\x39\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAB"],
        ["\x39\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAC"],
        ["\x39\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAD"],
        ["\x3A\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAE"],
        ["\x3A\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAF"],
        ["\x3A\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB0"],
        ["\x3A\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB1"],
        ["\x3A\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB2"],
        ["\x3A\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB3"],
        ["\x3A\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB4"],
        ["\x3A\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB5"],
        ["\x3A\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB6"],
        ["\x3A\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB7"],
        ["\x3A\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB8"],
        ["\x3A\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB9"],
        ["\x3A\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBA"],
        ["\x3A\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBB"],
        ["\x3A\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBC"],
        ["\x3A\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBD"],
        ["\x3A\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBE"],
        ["\x3A\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBF"],
        ["\x3A\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x80"],
        ["\x3A\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x81"],
        ["\x3A\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x82"],
        ["\x3A\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x83"],
        ["\x3A\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x84"],
        ["\x3A\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x85"],
        ["\x3A\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x86"],
        ["\x3A\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x87"],
        ["\x3A\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x88"],
        ["\x3A\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x89"],
        ["\x3A\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8A"],
        ["\x3A\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8B"],
        ["\x3A\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8C"],
        ["\x3A\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8D"],
        ["\x3A\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8E"],
        ["\x3A\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8F"],
        ["\x3A\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x90"],
        ["\x3A\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x91"],
        ["\x3A\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x92"],
        ["\x3A\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x93"],
        ["\x3A\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x94"],
        ["\x3A\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x95"],
        ["\x3A\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x96"],
        ["\x3A\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x97"],
        ["\x3A\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x98"],
        ["\x3A\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x99"],
        ["\x3A\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9A"],
        ["\x3A\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9B"],
        ["\x3A\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9C"],
        ["\x3A\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9D"],
        ["\x3A\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9E"],
        ["\x3A\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9F"],
        ["\x3A\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA0"],
        ["\x3A\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA1"],
        ["\x3A\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA2"],
        ["\x3A\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA3"],
        ["\x3A\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA4"],
        ["\x3A\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA5"],
        ["\x3A\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA6"],
        ["\x3A\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA7"],
        ["\x3A\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA8"],
        ["\x3A\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA9"],
        ["\x3A\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAA"],
        ["\x3A\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAB"],
        ["\x3A\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAC"],
        ["\x3A\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAD"],
        ["\x3A\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAE"],
        ["\x3A\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAF"],
        ["\x3A\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB0"],
        ["\x3A\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB1"],
        ["\x3A\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB2"],
        ["\x3A\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB3"],
        ["\x3A\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB4"],
        ["\x3A\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB5"],
        ["\x3A\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB6"],
        ["\x3A\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB7"],
        ["\x3A\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB8"],
        ["\x3A\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB9"],
        ["\x3A\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBA"],
        ["\x3A\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBB"],
        ["\x3A\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBC"],
        ["\x3A\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBD"],
        ["\x3A\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBE"],
        ["\x3A\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBF"],
        ["\x3A\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x80"],
        ["\x3A\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x81"],
        ["\x3A\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x82"],
        ["\x3A\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x83"],
        ["\x3A\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x84"],
        ["\x3A\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x85"],
        ["\x3A\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x86"],
        ["\x3A\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x87"],
        ["\x3A\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x88"],
        ["\x3A\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x89"],
        ["\x3A\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8A"],
        ["\x3A\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8B"],
        ["\x3B\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8C"],
        ["\x3B\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8D"],
        ["\x3B\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8E"],
        ["\x3B\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8F"],
        ["\x3B\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x90"],
        ["\x3B\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x91"],
        ["\x3B\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x92"],
        ["\x3B\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x93"],
        ["\x3B\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x94"],
        ["\x3B\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x95"],
        ["\x3B\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x96"],
        ["\x3B\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x97"],
        ["\x3B\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x98"],
        ["\x3B\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x99"],
        ["\x3B\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9A"],
        ["\x3B\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9B"],
        ["\x3B\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9C"],
        ["\x3B\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9D"],
        ["\x3B\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9E"],
        ["\x3B\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9F"],
        ["\x3B\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA0"],
        ["\x3B\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA1"],
        ["\x3B\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA2"],
        ["\x3B\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA3"],
        ["\x3B\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA4"],
        ["\x3B\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA5"],
        ["\x3B\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA6"],
        ["\x3B\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA7"],
        ["\x3B\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA8"],
        ["\x3B\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA9"],
        ["\x3B\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAA"],
        ["\x3B\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAB"],
        ["\x3B\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAC"],
        ["\x3B\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAD"],
        ["\x3B\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAE"],
        ["\x3B\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAF"],
        ["\x3B\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB0"],
        ["\x3B\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB1"],
        ["\x3B\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB2"],
        ["\x3B\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB3"],
        ["\x3B\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB4"],
        ["\x3B\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB5"],
        ["\x3B\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB6"],
        ["\x3B\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB7"],
        ["\x3B\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB8"],
        ["\x3B\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB9"],
        ["\x3B\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBA"],
        ["\x3B\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBB"],
        ["\x3B\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBC"],
        ["\x3B\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBD"],
        ["\x3B\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBE"],
        ["\x3B\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBF"],
        ["\x3B\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x80"],
        ["\x3B\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x81"],
        ["\x3B\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x82"],
        ["\x3B\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x83"],
        ["\x3B\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x84"],
        ["\x3B\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x85"],
        ["\x3B\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x86"],
        ["\x3B\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x87"],
        ["\x3B\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x88"],
        ["\x3B\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x89"],
        ["\x3B\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8A"],
        ["\x3B\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8B"],
        ["\x3B\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8C"],
        ["\x3B\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8D"],
        ["\x3B\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8E"],
        ["\x3B\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8F"],
        ["\x3B\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x90"],
        ["\x3B\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x91"],
        ["\x3B\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x92"],
        ["\x3B\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x93"],
        ["\x3B\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x94"],
        ["\x3B\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x95"],
        ["\x3B\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x96"],
        ["\x3B\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x97"],
        ["\x3B\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x98"],
        ["\x3B\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x99"],
        ["\x3B\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9A"],
        ["\x3B\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9B"],
        ["\x3B\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9C"],
        ["\x3B\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9D"],
        ["\x3B\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9E"],
        ["\x3B\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9F"],
        ["\x3B\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA0"],
        ["\x3B\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA1"],
        ["\x3B\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA2"],
        ["\x3B\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA3"],
        ["\x3B\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA4"],
        ["\x3B\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA5"],
        ["\x3B\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA6"],
        ["\x3B\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA7"],
        ["\x3B\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA8"],
        ["\x3B\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA9"],
        ["\x3C\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAA"],
        ["\x3C\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAB"],
        ["\x3C\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAC"],
        ["\x3C\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAD"],
        ["\x3C\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAE"],
        ["\x3C\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAF"],
        ["\x3C\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB0"],
        ["\x3C\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB1"],
        ["\x3C\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB2"],
        ["\x3C\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB3"],
        ["\x3C\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB4"],
        ["\x3C\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB5"],
        ["\x3C\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB6"],
        ["\x3C\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB7"],
        ["\x3C\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB8"],
        ["\x3C\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB9"],
        ["\x3C\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBA"],
        ["\x3C\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBB"],
        ["\x3C\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBC"],
        ["\x3C\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBD"],
        ["\x3C\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBE"],
        ["\x3C\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBF"],
        ["\x3C\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x80"],
        ["\x3C\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x81"],
        ["\x3C\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x82"],
        ["\x3C\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x83"],
        ["\x3C\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x84"],
        ["\x3C\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x85"],
        ["\x3C\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x86"],
        ["\x3C\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x87"],
        ["\x3C\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x88"],
        ["\x3C\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x89"],
        ["\x3C\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8A"],
        ["\x3C\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8B"],
        ["\x3C\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8C"],
        ["\x3C\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8D"],
        ["\x3C\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8E"],
        ["\x3C\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8F"],
        ["\x3C\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x90"],
        ["\x3C\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x91"],
        ["\x69\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x92"],
        ["\x3C\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x93"],
        ["\x3C\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x94"],
        ["\x3C\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x95"],
        ["\x3C\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x96"],
        ["\x3C\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x97"],
        ["\x3C\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x98"],
        ["\x3C\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x99"],
        ["\x3C\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9A"],
        ["\x3C\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9B"],
        ["\x3C\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9C"],
        ["\x3C\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9D"],
        ["\x3C\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9E"],
        ["\x3C\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9F"],
        ["\x3C\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA0"],
        ["\x3C\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA1"],
        ["\x3C\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA2"],
        ["\x3C\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA3"],
        ["\x3C\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA4"],
        ["\x3C\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA5"],
        ["\x3C\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA6"],
        ["\x3C\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA7"],
        ["\x3C\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA8"],
        ["\x3C\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA9"],
        ["\x3C\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAA"],
        ["\x3C\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAB"],
        ["\x3C\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAC"],
        ["\x3C\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAD"],
        ["\x3C\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAE"],
        ["\x3C\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAF"],
        ["\x3C\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB0"],
        ["\x3C\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB1"],
        ["\x3C\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB2"],
        ["\x3C\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB3"],
        ["\x3C\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB4"],
        ["\x3C\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB5"],
        ["\x3C\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB6"],
        ["\x3C\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB7"],
        ["\x3C\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB8"],
        ["\x3C\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB9"],
        ["\x3C\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBA"],
        ["\x3C\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBB"],
        ["\x3C\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBC"],
        ["\x3C\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBD"],
        ["\x3C\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBE"],
        ["\x3C\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBF"],
        ["\x3C\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x80"],
        ["\x3C\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x81"],
        ["\x3C\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x82"],
        ["\x3C\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x83"],
        ["\x3C\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x84"],
        ["\x3C\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x85"],
        ["\x3C\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x86"],
        ["\x3C\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x87"],
        ["\x3D\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x88"],
        ["\x3D\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x89"],
        ["\x3D\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8A"],
        ["\x3D\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8B"],
        ["\x3D\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8C"],
        ["\x3D\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8D"],
        ["\x3D\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8E"],
        ["\x3D\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8F"],
        ["\x3D\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x90"],
        ["\x3D\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x91"],
        ["\x3D\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x92"],
        ["\x3D\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x93"],
        ["\x3D\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x94"],
        ["\x3D\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x95"],
        ["\x3D\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x96"],
        ["\x3D\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x97"],
        ["\x3D\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x98"],
        ["\x3D\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x99"],
        ["\x3D\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9A"],
        ["\x3D\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9B"],
        ["\x3D\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9C"],
        ["\x3D\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9D"],
        ["\x3D\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9E"],
        ["\x3D\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9F"],
        ["\x3D\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA0"],
        ["\x3D\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA1"],
        ["\x3D\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA2"],
        ["\x3D\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA3"],
        ["\x3D\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA4"],
        ["\x3D\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA5"],
        ["\x3D\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA6"],
        ["\x3D\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA7"],
        ["\x3D\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA8"],
        ["\x3D\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA9"],
        ["\x3D\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAA"],
        ["\x3D\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAB"],
        ["\x3D\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAC"],
        ["\x3D\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAD"],
        ["\x3D\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAE"],
        ["\x3D\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAF"],
        ["\x3D\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB0"],
        ["\x3D\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB1"],
        ["\x3D\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB2"],
        ["\x3D\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB3"],
        ["\x3D\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB4"],
        ["\x3D\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB5"],
        ["\x3D\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB6"],
        ["\x3D\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB7"],
        ["\x3D\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB8"],
        ["\x3D\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB9"],
        ["\x3D\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBA"],
        ["\x3D\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBB"],
        ["\x3D\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBC"],
        ["\x3D\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBD"],
        ["\x3D\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBE"],
        ["\x3D\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBF"],
        ["\x3D\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x80"],
        ["\x3D\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x81"],
        ["\x3D\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x82"],
        ["\x3D\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x83"],
        ["\x3D\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x84"],
        ["\x3D\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x85"],
        ["\x3D\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x86"],
        ["\x3D\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x87"],
        ["\x3D\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x88"],
        ["\x3D\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x89"],
        ["\x3D\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8A"],
        ["\x3D\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8B"],
        ["\x3D\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8C"],
        ["\x3D\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8D"],
        ["\x3D\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8E"],
        ["\x3D\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8F"],
        ["\x3D\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x90"],
        ["\x3D\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x91"],
        ["\x3D\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x92"],
        ["\x3D\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x93"],
        ["\x3D\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x94"],
        ["\x3D\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x95"],
        ["\x3D\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x96"],
        ["\x3D\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x97"],
        ["\x3D\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x98"],
        ["\x3D\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x99"],
        ["\x3D\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9A"],
        ["\x3D\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9B"],
        ["\x3D\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9C"],
        ["\x3D\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9D"],
        ["\x3D\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9E"],
        ["\x3D\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9F"],
        ["\x3D\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA0"],
        ["\x3D\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA1"],
        ["\x3D\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA2"],
        ["\x3D\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA3"],
        ["\x3D\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA4"],
        ["\x3D\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA5"],
        ["\x3E\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA6"],
        ["\x3E\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA7"],
        ["\x3E\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA8"],
        ["\x3E\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA9"],
        ["\x3E\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAA"],
        ["\x3E\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAB"],
        ["\x3E\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAC"],
        ["\x3E\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAD"],
        ["\x3E\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAE"],
        ["\x3E\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAF"],
        ["\x3E\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB0"],
        ["\x3E\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB1"],
        ["\x3E\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB2"],
        ["\x3E\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB3"],
        ["\x3E\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB4"],
        ["\x3E\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB5"],
        ["\x3E\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB6"],
        ["\x3E\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB7"],
        ["\x3E\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB8"],
        ["\x3E\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB9"],
        ["\x3E\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBA"],
        ["\x3E\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBB"],
        ["\x3E\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBC"],
        ["\x3E\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBD"],
        ["\x3E\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBE"],
        ["\x3E\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBF"],
        ["\x3E\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x80"],
        ["\x3E\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x81"],
        ["\x3E\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x82"],
        ["\x3E\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x83"],
        ["\x3E\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x84"],
        ["\x3E\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x85"],
        ["\x3E\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x86"],
        ["\x3E\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x87"],
        ["\x3E\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x88"],
        ["\x3E\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x89"],
        ["\x3E\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8A"],
        ["\x3E\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8B"],
        ["\x3E\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8C"],
        ["\x3E\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8D"],
        ["\x3E\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8E"],
        ["\x3E\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8F"],
        ["\x3E\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x90"],
        ["\x3E\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x91"],
        ["\x3E\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x92"],
        ["\x3E\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x93"],
        ["\x3E\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x94"],
        ["\x3E\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x95"],
        ["\x3E\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x96"],
        ["\x3E\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x97"],
        ["\x3E\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x98"],
        ["\x3E\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x99"],
        ["\x3E\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9A"],
        ["\x3E\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9B"],
        ["\x3E\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9C"],
        ["\x3E\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9D"],
        ["\x3E\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9E"],
        ["\x3E\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9F"],
        ["\x3E\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA0"],
        ["\x3E\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA1"],
        ["\x3E\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA2"],
        ["\x3E\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA3"],
        ["\x3E\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA4"],
        ["\x3E\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA5"],
        ["\x3E\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA6"],
        ["\x3E\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA7"],
        ["\x3E\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA8"],
        ["\x3E\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA9"],
        ["\x3E\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAA"],
        ["\x3E\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAB"],
        ["\x3E\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAC"],
        ["\x3E\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAD"],
        ["\x3E\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAE"],
        ["\x3E\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAF"],
        ["\x3E\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB0"],
        ["\x3E\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB1"],
        ["\x3E\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB2"],
        ["\x3E\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB3"],
        ["\x3E\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB4"],
        ["\x3E\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB5"],
        ["\x3E\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB6"],
        ["\x3E\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB7"],
        ["\x3E\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB8"],
        ["\x3E\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB9"],
        ["\x3E\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBA"],
        ["\x3E\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBB"],
        ["\x3E\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBC"],
        ["\x3E\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBD"],
        ["\x3E\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBE"],
        ["\x3E\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBF"],
        ["\x3E\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x80"],
        ["\x3E\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x81"],
        ["\x3E\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x82"],
        ["\x3E\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x83"],
        ["\x3F\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x84"],
        ["\x3F\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x85"],
        ["\x3F\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x86"],
        ["\x3F\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x87"],
        ["\x3F\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x88"],
        ["\x3F\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x89"],
        ["\x3F\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8A"],
        ["\x3F\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8B"],
        ["\x3F\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8C"],
        ["\x3F\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8D"],
        ["\x3F\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8E"],
        ["\x3F\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8F"],
        ["\x3F\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x90"],
        ["\x3F\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x91"],
        ["\x3F\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x92"],
        ["\x3F\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x93"],
        ["\x3F\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x94"],
        ["\x3F\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x95"],
        ["\x3F\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x96"],
        ["\x3F\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x97"],
        ["\x3F\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x98"],
        ["\x3F\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x99"],
        ["\x3F\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9A"],
        ["\x3F\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9B"],
        ["\x3F\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9C"],
        ["\x3F\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9D"],
        ["\x3F\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9E"],
        ["\x3F\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9F"],
        ["\x3F\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA0"],
        ["\x3F\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA1"],
        ["\x3F\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA2"],
        ["\x3F\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA3"],
        ["\x3F\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA4"],
        ["\x3F\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA5"],
        ["\x3F\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA6"],
        ["\x3F\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA7"],
        ["\x3F\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA8"],
        ["\x3F\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA9"],
        ["\x3F\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAA"],
        ["\x3F\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAB"],
        ["\x3F\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAC"],
        ["\x3F\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAD"],
        ["\x3F\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAE"],
        ["\x3F\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAF"],
        ["\x3F\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB0"],
        ["\x3F\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB1"],
        ["\x3F\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB2"],
        ["\x3F\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB3"],
        ["\x3F\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB4"],
        ["\x3F\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB5"],
        ["\x3F\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB6"],
        ["\x3F\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB7"],
        ["\x3F\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB8"],
        ["\x3F\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB9"],
        ["\x3F\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBA"],
        ["\x3F\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBB"],
        ["\x70\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBC"],
        ["\x3F\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBD"],
        ["\x3F\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBE"],
        ["\x3F\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBF"],
        ["\x3F\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x80"],
        ["\x3F\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x81"],
        ["\x3F\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x82"],
        ["\x3F\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x83"],
        ["\x3F\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x84"],
        ["\x3F\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x85"],
        ["\x3F\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x86"],
        ["\x3F\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x87"],
        ["\x3F\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x88"],
        ["\x3F\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x89"],
        ["\x3F\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8A"],
        ["\x3F\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8B"],
        ["\x3F\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8C"],
        ["\x3F\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8D"],
        ["\x3F\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8E"],
        ["\x3F\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8F"],
        ["\x3F\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x90"],
        ["\x3F\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x91"],
        ["\x3F\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x92"],
        ["\x3F\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x93"],
        ["\x3F\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x94"],
        ["\x3F\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x95"],
        ["\x3F\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x96"],
        ["\x3F\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x97"],
        ["\x3F\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x98"],
        ["\x3F\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x99"],
        ["\x3F\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9A"],
        ["\x3F\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9B"],
        ["\x3F\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9C"],
        ["\x3F\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9D"],
        ["\x3F\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9E"],
        ["\x3F\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9F"],
        ["\x3F\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA0"],
        ["\x3F\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA1"],
        ["\x40\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA2"],
        ["\x40\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA3"],
        ["\x40\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA4"],
        ["\x40\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA5"],
        ["\x40\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA6"],
        ["\x40\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA7"],
        ["\x40\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA8"],
        ["\x40\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA9"],
        ["\x40\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAA"],
        ["\x40\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAB"],
        ["\x40\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAC"],
        ["\x40\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAD"],
        ["\x40\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAE"],
        ["\x40\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAF"],
        ["\x40\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB0"],
        ["\x40\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB1"],
        ["\x40\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB2"],
        ["\x40\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB3"],
        ["\x40\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB4"],
        ["\x40\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB5"],
        ["\x40\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB6"],
        ["\x40\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB7"],
        ["\x40\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB8"],
        ["\x40\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB9"],
        ["\x40\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBA"],
        ["\x40\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBB"],
        ["\x40\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBC"],
        ["\x40\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBD"],
        ["\x40\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBE"],
        ["\x40\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBF"],
        ["\x40\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x80"],
        ["\x40\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x81"],
        ["\x40\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x82"],
        ["\x40\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x83"],
        ["\x40\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x84"],
        ["\x40\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x85"],
        ["\x40\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x86"],
        ["\x40\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x87"],
        ["\x40\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x88"],
        ["\x40\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x89"],
        ["\x40\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8A"],
        ["\x40\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8B"],
        ["\x40\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8C"],
        ["\x40\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8D"],
        ["\x40\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8E"],
        ["\x40\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8F"],
        ["\x40\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x90"],
        ["\x40\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x91"],
        ["\x40\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x92"],
        ["\x40\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x93"],
        ["\x40\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x94"],
        ["\x40\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x95"],
        ["\x40\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x96"],
        ["\x40\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x97"],
        ["\x40\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x98"],
        ["\x40\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x99"],
        ["\x40\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9A"],
        ["\x40\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9B"],
        ["\x40\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9C"],
        ["\x40\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9D"],
        ["\x40\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9E"],
        ["\x40\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9F"],
        ["\x40\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA0"],
        ["\x40\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA1"],
        ["\x40\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA2"],
        ["\x40\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA3"],
        ["\x40\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA4"],
        ["\x40\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA5"],
        ["\x40\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA6"],
        ["\x40\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA7"],
        ["\x40\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA8"],
        ["\x40\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA9"],
        ["\x40\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAA"],
        ["\x40\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAB"],
        ["\x40\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAC"],
        ["\x40\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAD"],
        ["\x40\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAE"],
        ["\x40\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAF"],
        ["\x40\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB0"],
        ["\x40\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB1"],
        ["\x40\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB2"],
        ["\x40\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB3"],
        ["\x40\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB4"],
        ["\x40\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB5"],
        ["\x40\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB6"],
        ["\x40\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB7"],
        ["\x40\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB8"],
        ["\x40\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB9"],
        ["\x40\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBA"],
        ["\x40\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBB"],
        ["\x40\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBC"],
        ["\x40\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBD"],
        ["\x40\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBE"],
        ["\x40\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBF"],
        ["\x41\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x80"],
        ["\x41\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x81"],
        ["\x41\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x82"],
        ["\x41\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x83"],
        ["\x41\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x84"],
        ["\x41\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x85"],
        ["\x41\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x86"],
        ["\x6C\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x87"],
        ["\x41\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x88"],
        ["\x41\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x89"],
        ["\x41\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8A"],
        ["\x41\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8B"],
        ["\x41\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8C"],
        ["\x41\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8D"],
        ["\x41\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8E"],
        ["\x41\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8F"],
        ["\x41\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x90"],
        ["\x41\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x91"],
        ["\x41\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x92"],
        ["\x41\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x93"],
        ["\x41\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x94"],
        ["\x41\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x95"],
        ["\x41\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x96"],
        ["\x41\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x97"],
        ["\x41\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x98"],
        ["\x41\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x99"],
        ["\x41\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9A"],
        ["\x41\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9B"],
        ["\x41\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9C"],
        ["\x41\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9D"],
        ["\x41\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9E"],
        ["\x41\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9F"],
        ["\x41\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA0"],
        ["\x41\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA1"],
        ["\x41\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA2"],
        ["\x41\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA3"],
        ["\x41\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA4"],
        ["\x41\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA5"],
        ["\x41\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA6"],
        ["\x41\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA7"],
        ["\x41\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA8"],
        ["\x41\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA9"],
        ["\x41\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAA"],
        ["\x41\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAB"],
        ["\x41\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAC"],
        ["\x41\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAD"],
        ["\x41\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAE"],
        ["\x41\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAF"],
        ["\x41\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB0"],
        ["\x41\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB1"],
        ["\x41\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB2"],
        ["\x41\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB3"],
        ["\x41\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB4"],
        ["\x41\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB5"],
        ["\x41\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB6"],
        ["\x41\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB7"],
        ["\x41\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB8"],
        ["\x41\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB9"],
        ["\x41\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBA"],
        ["\x41\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBB"],
        ["\x41\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBC"],
        ["\x41\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBD"],
        ["\x41\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBE"],
        ["\x41\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBF"],
        ["\x41\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x80"],
        ["\x41\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x81"],
        ["\x41\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x82"],
        ["\x41\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x83"],
        ["\x41\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x84"],
        ["\x41\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x85"],
        ["\x41\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x86"],
        ["\x41\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x87"],
        ["\x41\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x88"],
        ["\x41\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x89"],
        ["\x41\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8A"],
        ["\x41\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8B"],
        ["\x41\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8C"],
        ["\x41\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8D"],
        ["\x41\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8E"],
        ["\x41\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8F"],
        ["\x41\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x90"],
        ["\x41\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x91"],
        ["\x41\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x92"],
        ["\x41\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x93"],
        ["\x41\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x94"],
        ["\x41\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x95"],
        ["\x41\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x96"],
        ["\x41\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x97"],
        ["\x41\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x98"],
        ["\x41\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x99"],
        ["\x41\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9A"],
        ["\x41\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9B"],
        ["\x41\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9C"],
        ["\x41\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9D"],
        ["\x42\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9E"],
        ["\x42\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9F"],
        ["\x42\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA0"],
        ["\x42\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA1"],
        ["\x42\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA2"],
        ["\x42\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA3"],
        ["\x42\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA4"],
        ["\x42\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA5"],
        ["\x42\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA6"],
        ["\x42\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA7"],
        ["\x42\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA8"],
        ["\x42\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA9"],
        ["\x42\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAA"],
        ["\x42\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAB"],
        ["\x42\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAC"],
        ["\x42\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAD"],
        ["\x42\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAE"],
        ["\x42\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAF"],
        ["\x42\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB0"],
        ["\x42\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB1"],
        ["\x42\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB2"],
        ["\x42\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB3"],
        ["\x42\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB4"],
        ["\x42\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB5"],
        ["\x42\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB6"],
        ["\x42\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB7"],
        ["\x42\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB8"],
        ["\x42\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB9"],
        ["\x42\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBA"],
        ["\x42\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBB"],
        ["\x42\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBC"],
        ["\x42\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBD"],
        ["\x42\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBE"],
        ["\x42\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBF"],
        ["\x42\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x80"],
        ["\x42\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x81"],
        ["\x42\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x82"],
        ["\x42\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x83"],
        ["\x42\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x84"],
        ["\x42\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x85"],
        ["\x42\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x86"],
        ["\x42\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x87"],
        ["\x42\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x88"],
        ["\x42\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x89"],
        ["\x42\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8A"],
        ["\x42\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8B"],
        ["\x42\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8C"],
        ["\x42\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8D"],
        ["\x42\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8E"],
        ["\x42\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8F"],
        ["\x42\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x90"],
        ["\x42\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x91"],
        ["\x42\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x92"],
        ["\x42\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x93"],
        ["\x42\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x94"],
        ["\x42\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x95"],
        ["\x42\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x96"],
        ["\x42\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x97"],
        ["\x42\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x98"],
        ["\x42\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x99"],
        ["\x42\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9A"],
        ["\x42\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9B"],
        ["\x42\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9C"],
        ["\x42\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9D"],
        ["\x42\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9E"],
        ["\x42\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9F"],
        ["\x42\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA0"],
        ["\x42\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA1"],
        ["\x42\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA2"],
        ["\x42\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA3"],
        ["\x42\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA4"],
        ["\x42\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA5"],
        ["\x42\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA6"],
        ["\x42\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA7"],
        ["\x42\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA8"],
        ["\x42\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA9"],
        ["\x42\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAA"],
        ["\x42\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAB"],
        ["\x42\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAC"],
        ["\x42\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAD"],
        ["\x42\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAE"],
        ["\x42\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAF"],
        ["\x42\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB0"],
        ["\x42\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB1"],
        ["\x42\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB2"],
        ["\x42\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB3"],
        ["\x42\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB4"],
        ["\x42\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB5"],
        ["\x42\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB6"],
        ["\x42\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB7"],
        ["\x42\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB8"],
        ["\x42\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB9"],
        ["\x42\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBA"],
        ["\x42\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBB"],
        ["\x43\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBC"],
        ["\x43\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBD"],
        ["\x43\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBE"],
        ["\x43\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBF"],
        ["\x43\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x80"],
        ["\x43\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x81"],
        ["\x43\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x82"],
        ["\x43\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x83"],
        ["\x43\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x84"],
        ["\x43\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x85"],
        ["\x43\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x86"],
        ["\x43\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x87"],
        ["\x43\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x88"],
        ["\x43\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x89"],
        ["\x43\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8A"],
        ["\x43\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8B"],
        ["\x43\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8C"],
        ["\x43\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8D"],
        ["\x43\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8E"],
        ["\x43\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8F"],
        ["\x43\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x90"],
        ["\x43\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x91"],
        ["\x43\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x92"],
        ["\x43\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x93"],
        ["\x43\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x94"],
        ["\x43\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x95"],
        ["\x43\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x96"],
        ["\x43\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x97"],
        ["\x43\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x98"],
        ["\x43\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x99"],
        ["\x43\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9A"],
        ["\x43\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9B"],
        ["\x43\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9C"],
        ["\x43\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9D"],
        ["\x43\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9E"],
        ["\x43\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9F"],
        ["\x43\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA0"],
        ["\x43\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA1"],
        ["\x43\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA2"],
        ["\x43\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA3"],
        ["\x43\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA4"],
        ["\x43\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA5"],
        ["\x43\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA6"],
        ["\x43\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA7"],
        ["\x43\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA8"],
        ["\x43\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA9"],
        ["\x43\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAA"],
        ["\x43\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAB"],
        ["\x43\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAC"],
        ["\x43\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAD"],
        ["\x43\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAE"],
        ["\x43\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAF"],
        ["\x43\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB0"],
        ["\x43\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB1"],
        ["\x43\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB2"],
        ["\x43\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB3"],
        ["\x43\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB4"],
        ["\x43\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB5"],
        ["\x43\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB6"],
        ["\x43\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB7"],
        ["\x43\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB8"],
        ["\x43\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB9"],
        ["\x43\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBA"],
        ["\x43\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBB"],
        ["\x43\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBC"],
        ["\x43\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBD"],
        ["\x43\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBE"],
        ["\x43\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBF"],
        ["\x43\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x80"],
        ["\x43\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x81"],
        ["\x43\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x82"],
        ["\x43\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x83"],
        ["\x43\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x84"],
        ["\x43\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x85"],
        ["\x43\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x86"],
        ["\x43\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x87"],
        ["\x43\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x88"],
        ["\x43\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x89"],
        ["\x43\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8A"],
        ["\x43\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8B"],
        ["\x43\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8C"],
        ["\x43\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8D"],
        ["\x43\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8E"],
        ["\x43\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8F"],
        ["\x43\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x90"],
        ["\x43\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x91"],
        ["\x43\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x92"],
        ["\x43\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x93"],
        ["\x43\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x94"],
        ["\x43\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x95"],
        ["\x43\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x96"],
        ["\x43\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x97"],
        ["\x43\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x98"],
        ["\x43\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x99"],
        ["\x44\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9A"],
        ["\x44\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9B"],
        ["\x44\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9C"],
        ["\x44\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9D"],
        ["\x44\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9E"],
        ["\x44\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9F"],
        ["\x44\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA0"],
        ["\x44\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA1"],
        ["\x44\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA2"],
        ["\x44\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA3"],
        ["\x44\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA4"],
        ["\x44\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA5"],
        ["\x44\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA6"],
        ["\x44\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA7"],
        ["\x44\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA8"],
        ["\x44\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA9"],
        ["\x44\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAA"],
        ["\x44\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAB"],
        ["\x44\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAC"],
        ["\x44\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAD"],
        ["\x44\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAE"],
        ["\x44\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAF"],
        ["\x44\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB0"],
        ["\x44\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB1"],
        ["\x44\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB2"],
        ["\x44\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB3"],
        ["\x44\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB4"],
        ["\x44\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB5"],
        ["\x44\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB6"],
        ["\x44\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB7"],
        ["\x44\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB8"],
        ["\x44\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB9"],
        ["\x44\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBA"],
        ["\x44\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBB"],
        ["\x44\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBC"],
        ["\x44\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBD"],
        ["\x44\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBE"],
        ["\x44\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBF"],
        ["\x44\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x80"],
        ["\x44\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x81"],
        ["\x44\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x82"],
        ["\x44\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x83"],
        ["\x44\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x84"],
        ["\x44\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x85"],
        ["\x44\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x86"],
        ["\x44\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x87"],
        ["\x44\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x88"],
        ["\x44\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x89"],
        ["\x44\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8A"],
        ["\x44\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8B"],
        ["\x44\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8C"],
        ["\x44\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8D"],
        ["\x44\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8E"],
        ["\x44\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8F"],
        ["\x44\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x90"],
        ["\x44\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x91"],
        ["\x44\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x92"],
        ["\x44\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x93"],
        ["\x54\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x94"],
        ["\x44\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x95"],
        ["\x44\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x96"],
        ["\x44\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x97"],
        ["\x44\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x98"],
        ["\x44\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x99"],
        ["\x44\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9A"],
        ["\x44\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9B"],
        ["\x44\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9C"],
        ["\x44\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9D"],
        ["\x44\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9E"],
        ["\x44\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9F"],
        ["\x44\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA0"],
        ["\x44\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA1"],
        ["\x44\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA2"],
        ["\x44\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA3"],
        ["\x44\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA4"],
        ["\x44\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA5"],
        ["\x44\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA6"],
        ["\x44\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA7"],
        ["\x44\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA8"],
        ["\x44\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA9"],
        ["\x44\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAA"],
        ["\x44\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAB"],
        ["\x44\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAC"],
        ["\x44\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAD"],
        ["\x44\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAE"],
        ["\x44\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAF"],
        ["\x44\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB0"],
        ["\x44\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB1"],
        ["\x44\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB2"],
        ["\x44\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB3"],
        ["\x44\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB4"],
        ["\x44\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB5"],
        ["\x44\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB6"],
        ["\x44\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB7"],
        ["\x45\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB8"],
        ["\x45\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB9"],
        ["\x45\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBA"],
        ["\x45\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBB"],
        ["\x45\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBC"],
        ["\x45\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBD"],
        ["\x45\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBE"],
        ["\x45\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBF"],
        ["\x45\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x80"],
        ["\x45\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x81"],
        ["\x45\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x82"],
        ["\x45\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x83"],
        ["\x45\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x84"],
        ["\x45\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x85"],
        ["\x45\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x86"],
        ["\x45\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x87"],
        ["\x45\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x88"],
        ["\x45\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x89"],
        ["\x45\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8A"],
        ["\x45\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8B"],
        ["\x45\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8C"],
        ["\xD6\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8D"],
        ["\x45\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8E"],
        ["\x45\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8F"],
        ["\x45\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x90"],
        ["\x45\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x91"],
        ["\x45\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x92"],
        ["\x45\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x93"],
        ["\x45\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x94"],
        ["\x45\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x95"],
        ["\xD4\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x96"],
        ["\x45\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x97"],
        ["\x45\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x98"],
        ["\x45\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x99"],
        ["\x45\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9A"],
        ["\x45\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9B"],
        ["\x45\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9C"],
        ["\x45\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9D"],
        ["\x45\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9E"],
        ["\x45\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9F"],
        ["\x45\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA0"],
        ["\x45\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA1"],
        ["\x45\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA2"],
        ["\x45\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA3"],
        ["\x45\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA4"],
        ["\x45\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA5"],
        ["\x45\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA6"],
        ["\x45\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA7"],
        ["\x45\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA8"],
        ["\x45\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA9"],
        ["\x45\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAA"],
        ["\x45\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAB"],
        ["\x45\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAC"],
        ["\x45\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAD"],
        ["\x62\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAE"],
        ["\x45\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAF"],
        ["\x45\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB0"],
        ["\x45\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB1"],
        ["\x45\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB2"],
        ["\x45\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB3"],
        ["\x45\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB4"],
        ["\x45\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB5"],
        ["\x45\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB6"],
        ["\x45\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB7"],
        ["\x45\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB8"],
        ["\x45\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB9"],
        ["\x45\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBA"],
        ["\x45\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBB"],
        ["\x45\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBC"],
        ["\x45\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBD"],
        ["\x45\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBE"],
        ["\x45\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBF"],
        ["\x45\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x80"],
        ["\x45\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x81"],
        ["\x45\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x82"],
        ["\x45\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x83"],
        ["\x45\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x84"],
        ["\x5B\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x85"],
        ["\x45\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x86"],
        ["\x45\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x87"],
        ["\x45\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x88"],
        ["\x45\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x89"],
        ["\x5E\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8A"],
        ["\x45\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8B"],
        ["\x45\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8C"],
        ["\x45\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8D"],
        ["\x45\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8E"],
        ["\x45\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8F"],
        ["\x45\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x90"],
        ["\x45\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x91"],
        ["\x45\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x92"],
        ["\x45\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x93"],
        ["\x45\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x94"],
        ["\x45\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x95"],
        ["\x46\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x96"],
        ["\x46\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x97"],
        ["\x46\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x98"],
        ["\x46\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x99"],
        ["\x46\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9A"],
        ["\x46\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9B"],
        ["\x46\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9C"],
        ["\x46\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9D"],
        ["\x46\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9E"],
        ["\x46\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9F"],
        ["\x46\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA0"],
        ["\x46\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA1"],
        ["\x46\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA2"],
        ["\x46\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA3"],
        ["\x46\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA4"],
        ["\x46\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA5"],
        ["\x46\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA6"],
        ["\x46\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA7"],
        ["\x46\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA8"],
        ["\x46\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA9"],
        ["\x46\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAA"],
        ["\x46\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAB"],
        ["\x46\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAC"],
        ["\x46\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAD"],
        ["\x46\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAE"],
        ["\x46\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAF"],
        ["\x46\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB0"],
        ["\x46\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB1"],
        ["\x46\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB2"],
        ["\x46\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB3"],
        ["\x46\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB4"],
        ["\x46\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB5"],
        ["\x46\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB6"],
        ["\x46\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB7"],
        ["\x46\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB8"],
        ["\x46\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB9"],
        ["\x46\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBA"],
        ["\x46\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBB"],
        ["\x46\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBC"],
        ["\x46\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBD"],
        ["\x46\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBE"],
        ["\x46\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBF"],
        ["\x46\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x80"],
        ["\x46\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x81"],
        ["\x46\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x82"],
        ["\x46\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x83"],
        ["\x46\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x84"],
        ["\x46\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x85"],
        ["\x46\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x86"],
        ["\x46\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x87"],
        ["\x46\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x88"],
        ["\x46\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x89"],
        ["\x46\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8A"],
        ["\x46\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8B"],
        ["\x46\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8C"],
        ["\x46\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8D"],
        ["\x46\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8E"],
        ["\x46\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8F"],
        ["\x46\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x90"],
        ["\x46\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x91"],
        ["\x46\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x92"],
        ["\x46\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x93"],
        ["\x46\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x94"],
        ["\x46\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x95"],
        ["\x46\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x96"],
        ["\x46\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x97"],
        ["\x46\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x98"],
        ["\x46\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x99"],
        ["\x46\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9A"],
        ["\x46\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9B"],
        ["\x46\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9C"],
        ["\x46\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9D"],
        ["\x46\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9E"],
        ["\x46\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9F"],
        ["\x46\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA0"],
        ["\x46\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA1"],
        ["\x46\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA2"],
        ["\x46\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA3"],
        ["\x46\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA4"],
        ["\x46\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA5"],
        ["\x46\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA6"],
        ["\x46\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA7"],
        ["\x46\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA8"],
        ["\x46\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA9"],
        ["\x46\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAA"],
        ["\x6D\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAB"],
        ["\x46\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAC"],
        ["\x46\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAD"],
        ["\x46\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAE"],
        ["\x46\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAF"],
        ["\x46\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB0"],
        ["\x46\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB1"],
        ["\x46\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB2"],
        ["\x46\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB3"],
        ["\x47\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB4"],
        ["\x47\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB5"],
        ["\x47\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB6"],
        ["\x47\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB7"],
        ["\x47\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB8"],
        ["\x47\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB9"],
        ["\x47\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBA"],
        ["\x47\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBB"],
        ["\x47\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBC"],
        ["\x47\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBD"],
        ["\x47\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBE"],
        ["\x47\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBF"],
        ["\x47\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x80"],
        ["\x47\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x81"],
        ["\x47\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x82"],
        ["\x47\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x83"],
        ["\x47\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x84"],
        ["\x47\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x85"],
        ["\x47\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x86"],
        ["\x47\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x87"],
        ["\x47\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x88"],
        ["\x47\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x89"],
        ["\x47\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8A"],
        ["\x47\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8B"],
        ["\x47\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8C"],
        ["\x47\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8D"],
        ["\x47\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8E"],
        ["\x47\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8F"],
        ["\x47\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x90"],
        ["\x47\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x91"],
        ["\x47\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x92"],
        ["\x47\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x93"],
        ["\x47\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x94"],
        ["\x47\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x95"],
        ["\x47\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x96"],
        ["\x47\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x97"],
        ["\x47\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x98"],
        ["\x47\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x99"],
        ["\x47\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9A"],
        ["\x47\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9B"],
        ["\x47\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9C"],
        ["\x47\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9D"],
        ["\x47\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9E"],
        ["\x47\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9F"],
        ["\x47\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA0"],
        ["\x47\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA1"],
        ["\x47\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA2"],
        ["\x47\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA3"],
        ["\x47\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA4"],
        ["\x47\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA5"],
        ["\x47\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA6"],
        ["\x47\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA7"],
        ["\x47\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA8"],
        ["\x47\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA9"],
        ["\x47\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAA"],
        ["\x47\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAB"],
        ["\x47\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAC"],
        ["\x47\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAD"],
        ["\x47\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAE"],
        ["\x47\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAF"],
        ["\x47\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB0"],
        ["\x47\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB1"],
        ["\x47\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB2"],
        ["\x47\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB3"],
        ["\x47\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB4"],
        ["\x47\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB5"],
        ["\x47\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB6"],
        ["\x47\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB7"],
        ["\x47\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB8"],
        ["\x47\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB9"],
        ["\x47\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBA"],
        ["\x6A\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBB"],
        ["\x47\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBC"],
        ["\x47\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBD"],
        ["\x47\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBE"],
        ["\x47\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBF"],
        ["\x47\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x80"],
        ["\x47\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x81"],
        ["\x47\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x82"],
        ["\x47\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x83"],
        ["\x47\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x84"],
        ["\x47\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x85"],
        ["\x47\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x86"],
        ["\x47\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x87"],
        ["\x47\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x88"],
        ["\x47\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x89"],
        ["\x47\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8A"],
        ["\x47\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8B"],
        ["\x47\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8C"],
        ["\x47\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8D"],
        ["\x47\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8E"],
        ["\x47\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8F"],
        ["\x47\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x90"],
        ["\x47\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x91"],
        ["\x48\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x92"],
        ["\x48\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x93"],
        ["\x48\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x94"],
        ["\x48\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x95"],
        ["\x48\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x96"],
        ["\x48\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x97"],
        ["\x48\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x98"],
        ["\x48\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x99"],
        ["\x48\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9A"],
        ["\x48\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9B"],
        ["\x48\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9C"],
        ["\x48\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9D"],
        ["\x48\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9E"],
        ["\x48\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9F"],
        ["\x48\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA0"],
        ["\x48\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA1"],
        ["\x48\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA2"],
        ["\x48\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA3"],
        ["\x48\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA4"],
        ["\x48\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA5"],
        ["\x48\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA6"],
        ["\x48\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA7"],
        ["\x48\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA8"],
        ["\x48\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA9"],
        ["\x48\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAA"],
        ["\x48\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAB"],
        ["\x48\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAC"],
        ["\x48\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAD"],
        ["\x48\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAE"],
        ["\x48\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAF"],
        ["\x48\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB0"],
        ["\x48\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB1"],
        ["\x48\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB2"],
        ["\x48\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB3"],
        ["\x48\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB4"],
        ["\x48\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB5"],
        ["\x48\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB6"],
        ["\x48\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB7"],
        ["\x48\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB8"],
        ["\x48\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB9"],
        ["\x48\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBA"],
        ["\x48\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBB"],
        ["\x48\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBC"],
        ["\x48\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBD"],
        ["\x48\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBE"],
        ["\x48\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBF"],
        ["\x48\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x80"],
        ["\x48\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x81"],
        ["\x48\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x82"],
        ["\x48\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x83"],
        ["\x48\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x84"],
        ["\x48\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x85"],
        ["\x48\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x86"],
        ["\x48\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x87"],
        ["\x48\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x88"],
        ["\x48\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x89"],
        ["\x48\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8A"],
        ["\x48\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8B"],
        ["\x48\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8C"],
        ["\x48\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8D"],
        ["\x48\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8E"],
        ["\x48\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8F"],
        ["\x48\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x90"],
        ["\x48\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x91"],
        ["\x48\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x92"],
        ["\x48\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x93"],
        ["\x48\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x94"],
        ["\x48\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x95"],
        ["\x48\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x96"],
        ["\x48\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x97"],
        ["\x48\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x98"],
        ["\x48\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x99"],
        ["\x48\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9A"],
        ["\x48\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9B"],
        ["\x48\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9C"],
        ["\x48\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9D"],
        ["\x48\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9E"],
        ["\x48\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9F"],
        ["\x48\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA0"],
        ["\x48\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA1"],
        ["\x48\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA2"],
        ["\x48\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA3"],
        ["\x48\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA4"],
        ["\x48\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA5"],
        ["\x48\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA6"],
        ["\x48\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA7"],
        ["\x48\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA8"],
        ["\x48\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA9"],
        ["\x48\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAA"],
        ["\x48\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAB"],
        ["\x48\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAC"],
        ["\x48\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAD"],
        ["\x48\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAE"],
        ["\x48\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAF"],
        ["\x49\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB0"],
        ["\x49\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB1"],
        ["\x49\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB2"],
        ["\x49\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB3"],
        ["\x49\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB4"],
        ["\x49\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB5"],
        ["\x49\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB6"],
        ["\x49\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB7"],
        ["\x49\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB8"],
        ["\x49\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB9"],
        ["\x49\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBA"],
        ["\x49\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBB"],
        ["\x49\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBC"],
        ["\x49\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBD"],
        ["\x49\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBE"],
        ["\x5B\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBF"],
        ["\x49\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x80"],
        ["\x49\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x81"],
        ["\x49\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x82"],
        ["\x49\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x83"],
        ["\x49\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x84"],
        ["\x49\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x85"],
        ["\x49\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x86"],
        ["\x49\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x87"],
        ["\x49\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x88"],
        ["\x49\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x89"],
        ["\x49\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8A"],
        ["\x49\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8B"],
        ["\x49\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8C"],
        ["\x49\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8D"],
        ["\x49\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8E"],
        ["\x49\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8F"],
        ["\x49\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x90"],
        ["\x49\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x91"],
        ["\x49\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x92"],
        ["\x49\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x93"],
        ["\x49\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x94"],
        ["\x49\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x95"],
        ["\x49\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x96"],
        ["\x49\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x97"],
        ["\x49\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x98"],
        ["\x49\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x99"],
        ["\x49\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9A"],
        ["\x49\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9B"],
        ["\x49\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9C"],
        ["\x49\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9D"],
        ["\x49\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9E"],
        ["\x49\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9F"],
        ["\x49\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA0"],
        ["\x49\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA1"],
        ["\x49\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA2"],
        ["\x49\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA3"],
        ["\x49\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA4"],
        ["\x49\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA5"],
        ["\x49\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA6"],
        ["\x49\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA7"],
        ["\x49\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA8"],
        ["\x49\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA9"],
        ["\x49\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAA"],
        ["\x49\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAB"],
        ["\x49\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAC"],
        ["\x49\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAD"],
        ["\x49\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAE"],
        ["\x49\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAF"],
        ["\x49\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB0"],
        ["\x49\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB1"],
        ["\x49\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB2"],
        ["\x49\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB3"],
        ["\x49\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB4"],
        ["\x49\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB5"],
        ["\x49\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB6"],
        ["\x49\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB7"],
        ["\x49\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB8"],
        ["\x49\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB9"],
        ["\x49\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBA"],
        ["\x49\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBB"],
        ["\x49\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBC"],
        ["\x49\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBD"],
        ["\x49\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBE"],
        ["\x49\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBF"],
        ["\x49\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x80"],
        ["\x49\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x81"],
        ["\x49\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x82"],
        ["\x49\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x83"],
        ["\x49\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x84"],
        ["\x49\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x85"],
        ["\x49\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x86"],
        ["\x49\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x87"],
        ["\x49\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x88"],
        ["\x49\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x89"],
        ["\x49\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8A"],
        ["\x49\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8B"],
        ["\x49\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8C"],
        ["\x49\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8D"],
        ["\x4A\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8E"],
        ["\x4A\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8F"],
        ["\x4A\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x90"],
        ["\x4A\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x91"],
        ["\x4A\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x92"],
        ["\x4A\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x93"],
        ["\x4A\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x94"],
        ["\x4A\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x95"],
        ["\x4A\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x96"],
        ["\x4A\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x97"],
        ["\x4A\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x98"],
        ["\x4A\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x99"],
        ["\x4A\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9A"],
        ["\x4A\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9B"],
        ["\x4A\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9C"],
        ["\x4A\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9D"],
        ["\x4A\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9E"],
        ["\x4A\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9F"],
        ["\x4A\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA0"],
        ["\x4A\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA1"],
        ["\x4A\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA2"],
        ["\x4A\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA3"],
        ["\x4A\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA4"],
        ["\x4A\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA5"],
        ["\x4A\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA6"],
        ["\x4A\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA7"],
        ["\x4A\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA8"],
        ["\x4A\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA9"],
        ["\x4A\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAA"],
        ["\x4A\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAB"],
        ["\x4A\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAC"],
        ["\x4A\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAD"],
        ["\x4A\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAE"],
        ["\x4A\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAF"],
        ["\x4A\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB0"],
        ["\x4A\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB1"],
        ["\x4A\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB2"],
        ["\x4A\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB3"],
        ["\x4A\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB4"],
        ["\x4A\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB5"],
        ["\x4A\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB6"],
        ["\x4A\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB7"],
        ["\x4A\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB8"],
        ["\x4A\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB9"],
        ["\x4A\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBA"],
        ["\x4A\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBB"],
        ["\x4A\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBC"],
        ["\x4A\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBD"],
        ["\x4A\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBE"],
        ["\x4A\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBF"],
        ["\x4A\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x80"],
        ["\x4A\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x81"],
        ["\x4A\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x82"],
        ["\x4A\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x83"],
        ["\x4A\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x84"],
        ["\x4A\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x85"],
        ["\x4A\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x86"],
        ["\x4A\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x87"],
        ["\x4A\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x88"],
        ["\x4A\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x89"],
        ["\x4A\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8A"],
        ["\x4A\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8B"],
        ["\x4A\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8C"],
        ["\x4A\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8D"],
        ["\x4A\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8E"],
        ["\x4A\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8F"],
        ["\x4A\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x90"],
        ["\x4A\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x91"],
        ["\x4A\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x92"],
        ["\x4A\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x93"],
        ["\x4A\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x94"],
        ["\x4A\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x95"],
        ["\x4A\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x96"],
        ["\x4A\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x97"],
        ["\x4A\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x98"],
        ["\x4A\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x99"],
        ["\x4A\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9A"],
        ["\x4A\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9B"],
        ["\x4A\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9C"],
        ["\x4A\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9D"],
        ["\x4A\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9E"],
        ["\x4A\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9F"],
        ["\x4A\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA0"],
        ["\x4A\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA1"],
        ["\x4A\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA2"],
        ["\x4A\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA3"],
        ["\x4A\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA4"],
        ["\x4A\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA5"],
        ["\x4A\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA6"],
        ["\x4A\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA7"],
        ["\x4A\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA8"],
        ["\x4A\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA9"],
        ["\x4A\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAA"],
        ["\x4A\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAB"],
        ["\x4B\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAC"],
        ["\x4B\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAD"],
        ["\x4B\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAE"],
        ["\x4B\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAF"],
        ["\x4B\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB0"],
        ["\x4B\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB1"],
        ["\x4B\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB2"],
        ["\x4B\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB3"],
        ["\x4B\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB4"],
        ["\x4B\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB5"],
        ["\x4B\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB6"],
        ["\x4B\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB7"],
        ["\x4B\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB8"],
        ["\x4B\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB9"],
        ["\x4B\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBA"],
        ["\x4B\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBB"],
        ["\x4B\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBC"],
        ["\x4B\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBD"],
        ["\x4B\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBE"],
        ["\x4B\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBF"],
        ["\x4B\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x80"],
        ["\x4B\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x81"],
        ["\x4B\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x82"],
        ["\x4B\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x83"],
        ["\x4B\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x84"],
        ["\x4B\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x85"],
        ["\x4B\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x86"],
        ["\x4B\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x87"],
        ["\x4B\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x88"],
        ["\x4B\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x89"],
        ["\x4B\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8A"],
        ["\x4B\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8B"],
        ["\x4B\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8C"],
        ["\x4B\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8D"],
        ["\x4B\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8E"],
        ["\x4B\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8F"],
        ["\x4B\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x90"],
        ["\x4B\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x91"],
        ["\x4B\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x92"],
        ["\x4B\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x93"],
        ["\x4B\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x94"],
        ["\x4B\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x95"],
        ["\x4B\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x96"],
        ["\x4B\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x97"],
        ["\x4B\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x98"],
        ["\x4B\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x99"],
        ["\x4B\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9A"],
        ["\x4B\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9B"],
        ["\x4B\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9C"],
        ["\x4B\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9D"],
        ["\x4B\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9E"],
        ["\x4B\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9F"],
        ["\x4B\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA0"],
        ["\x4B\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA1"],
        ["\x4B\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA2"],
        ["\x4B\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA3"],
        ["\x4B\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA4"],
        ["\x4B\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA5"],
        ["\x4B\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA6"],
        ["\x4B\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA7"],
        ["\x4B\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA8"],
        ["\x4B\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA9"],
        ["\x4B\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAA"],
        ["\x4B\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAB"],
        ["\x4B\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAC"],
        ["\x4B\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAD"],
        ["\x4B\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAE"],
        ["\x4B\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAF"],
        ["\x4B\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB0"],
        ["\x4B\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB1"],
        ["\x4B\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB2"],
        ["\x4B\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB3"],
        ["\x4B\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB4"],
        ["\xBF\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB5"],
        ["\x4B\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB6"],
        ["\x4B\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB7"],
        ["\x4B\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB8"],
        ["\x4B\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB9"],
        ["\x4B\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBA"],
        ["\x4B\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBB"],
        ["\x4B\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBC"],
        ["\x4B\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBD"],
        ["\x4B\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBE"],
        ["\x4B\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBF"],
        ["\x4B\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x80"],
        ["\x4B\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x81"],
        ["\x4B\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x82"],
        ["\x4B\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x83"],
        ["\x50\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x84"],
        ["\x4B\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x85"],
        ["\x4B\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x86"],
        ["\x4B\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x87"],
        ["\x4B\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x88"],
        ["\x4B\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x89"],
        ["\x4C\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8A"],
        ["\x4C\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8B"],
        ["\x4C\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8C"],
        ["\x4C\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8D"],
        ["\x4C\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8E"],
        ["\x4C\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8F"],
        ["\x4C\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x90"],
        ["\x4C\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x91"],
        ["\x4C\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x92"],
        ["\x4C\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x93"],
        ["\x4C\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x94"],
        ["\x4C\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x95"],
        ["\x4C\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x96"],
        ["\x4C\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x97"],
        ["\x4C\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x98"],
        ["\x4C\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x99"],
        ["\x4C\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9A"],
        ["\x4C\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9B"],
        ["\x4C\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9C"],
        ["\x4C\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9D"],
        ["\x4C\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9E"],
        ["\x4C\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9F"],
        ["\x4C\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA0"],
        ["\x4C\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA1"],
        ["\x4C\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA2"],
        ["\x4C\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA3"],
        ["\x4C\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA4"],
        ["\x4C\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA5"],
        ["\x4C\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA6"],
        ["\x4C\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA7"],
        ["\x4C\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA8"],
        ["\x4C\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA9"],
        ["\x4C\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAA"],
        ["\x4C\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAB"],
        ["\x4C\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAC"],
        ["\x4C\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAD"],
        ["\x4C\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAE"],
        ["\x4C\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAF"],
        ["\x4C\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB0"],
        ["\x4C\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB1"],
        ["\x4C\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB2"],
        ["\x4C\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB3"],
        ["\x4C\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB4"],
        ["\x4C\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB5"],
        ["\x4C\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB6"],
        ["\x4C\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB7"],
        ["\x4C\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB8"],
        ["\x4C\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB9"],
        ["\x4C\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBA"],
        ["\x4C\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBB"],
        ["\x4C\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBC"],
        ["\x4C\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBD"],
        ["\x4C\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBE"],
        ["\x4C\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBF"],
        ["\x4C\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x80"],
        ["\x4C\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x81"],
        ["\x4C\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x82"],
        ["\x4C\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x83"],
        ["\x4C\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x84"],
        ["\x4C\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x85"],
        ["\x4C\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x86"],
        ["\x4C\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x87"],
        ["\x4C\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x88"],
        ["\x4C\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x89"],
        ["\x4C\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8A"],
        ["\x4C\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8B"],
        ["\x4C\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8C"],
        ["\x4C\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8D"],
        ["\x4C\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8E"],
        ["\x4C\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8F"],
        ["\x4C\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x90"],
        ["\x4C\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x91"],
        ["\x4C\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x92"],
        ["\x4C\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x93"],
        ["\x4C\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x94"],
        ["\x4C\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x95"],
        ["\x4C\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x96"],
        ["\x4C\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x97"],
        ["\x4C\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x98"],
        ["\x4C\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x99"],
        ["\x4C\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9A"],
        ["\x4C\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9B"],
        ["\x4C\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9C"],
        ["\x4C\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9D"],
        ["\x4C\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9E"],
        ["\x4C\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9F"],
        ["\x4C\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA0"],
        ["\x4C\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA1"],
        ["\x69\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA2"],
        ["\x4C\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA3"],
        ["\x4C\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA4"],
        ["\x4C\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA5"],
        ["\x4C\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA6"],
        ["\x4C\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA7"],
        ["\x4D\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA8"],
        ["\x4D\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA9"],
        ["\x4D\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAA"],
        ["\x4D\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAB"],
        ["\x4D\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAC"],
        ["\x4D\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAD"],
        ["\x4D\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAE"],
        ["\x4D\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAF"],
        ["\x4D\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB0"],
        ["\x4D\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB1"],
        ["\x4D\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB2"],
        ["\x4D\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB3"],
        ["\x4D\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB4"],
        ["\x4D\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB5"],
        ["\x4D\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB6"],
        ["\x4D\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB7"],
        ["\x4D\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB8"],
        ["\x4D\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB9"],
        ["\x4D\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBA"],
        ["\x4D\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBB"],
        ["\x4D\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBC"],
        ["\x4D\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBD"],
        ["\x4D\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBE"],
        ["\x4D\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBF"],
        ["\x4D\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x80"],
        ["\x4D\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x81"],
        ["\x4D\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x82"],
        ["\x4D\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x83"],
        ["\x4D\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x84"],
        ["\x4D\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x85"],
        ["\x4D\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x86"],
        ["\x4D\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x87"],
        ["\x4D\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x88"],
        ["\x4D\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x89"],
        ["\x4D\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8A"],
        ["\x4D\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8B"],
        ["\x4D\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8C"],
        ["\x4D\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8D"],
        ["\x4D\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8E"],
        ["\x4D\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8F"],
        ["\x4D\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x90"],
        ["\x4D\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x91"],
        ["\x4D\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x92"],
        ["\x4D\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x93"],
        ["\x4D\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x94"],
        ["\x4D\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x95"],
        ["\x4D\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x96"],
        ["\x4D\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x97"],
        ["\x4D\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x98"],
        ["\x4D\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x99"],
        ["\x4D\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9A"],
        ["\x4D\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9B"],
        ["\x4D\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9C"],
        ["\x4D\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9D"],
        ["\x4D\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9E"],
        ["\x4D\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9F"],
        ["\x4D\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA0"],
        ["\xD0\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA1"],
        ["\x4D\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA2"],
        ["\x4D\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA3"],
        ["\x4D\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA4"],
        ["\x4D\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA5"],
        ["\x4D\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA6"],
        ["\x4D\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA7"],
        ["\x4D\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA8"],
        ["\x4D\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA9"],
        ["\x4D\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAA"],
        ["\x4D\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAB"],
        ["\x4D\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAC"],
        ["\x4D\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAD"],
        ["\x4D\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAE"],
        ["\x4D\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAF"],
        ["\x4D\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB0"],
        ["\x4D\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB1"],
        ["\x4D\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB2"],
        ["\x4D\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB3"],
        ["\x4D\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB4"],
        ["\x4D\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB5"],
        ["\x4D\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB6"],
        ["\x4D\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB7"],
        ["\x4D\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB8"],
        ["\x4D\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB9"],
        ["\x4D\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBA"],
        ["\x4D\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBB"],
        ["\x4D\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBC"],
        ["\x4D\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBD"],
        ["\x4D\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBE"],
        ["\x4D\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBF"],
        ["\x4D\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x80"],
        ["\x4D\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x81"],
        ["\x4D\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x82"],
        ["\x4D\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x83"],
        ["\x4D\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x84"],
        ["\x4D\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x85"],
        ["\x4E\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x86"],
        ["\x4E\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x87"],
        ["\x4E\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x88"],
        ["\x4E\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x89"],
        ["\x4E\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8A"],
        ["\x4E\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8B"],
        ["\x4E\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8C"],
        ["\x4E\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8D"],
        ["\x4E\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8E"],
        ["\x4E\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8F"],
        ["\x4E\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x90"],
        ["\x4E\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x91"],
        ["\x4E\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x92"],
        ["\x4E\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x93"],
        ["\x4E\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x94"],
        ["\x4E\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x95"],
        ["\x4E\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x96"],
        ["\x4E\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x97"],
        ["\x4E\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x98"],
        ["\x4E\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x99"],
        ["\x4E\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9A"],
        ["\x4E\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9B"],
        ["\x4E\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9C"],
        ["\x4E\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9D"],
        ["\x4E\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9E"],
        ["\x4E\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9F"],
        ["\x4E\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA0"],
        ["\x4E\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA1"],
        ["\x4E\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA2"],
        ["\x4E\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA3"],
        ["\x4E\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA4"],
        ["\x4E\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA5"],
        ["\x4E\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA6"],
        ["\x4E\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA7"],
        ["\x4E\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA8"],
        ["\x4E\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA9"],
        ["\x4E\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAA"],
        ["\x4E\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAB"],
        ["\x4E\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAC"],
        ["\x4E\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAD"],
        ["\x4E\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAE"],
        ["\x4E\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAF"],
        ["\x4E\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB0"],
        ["\x4E\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB1"],
        ["\x4E\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB2"],
        ["\x4E\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB3"],
        ["\x4E\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB4"],
        ["\x4E\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB5"],
        ["\x4E\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB6"],
        ["\x4E\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB7"],
        ["\x4E\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB8"],
        ["\x4E\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB9"],
        ["\x4E\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBA"],
        ["\x4E\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBB"],
        ["\x4E\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBC"],
        ["\x4E\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBD"],
        ["\x4E\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBE"],
        ["\x4E\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBF"],
        ["\x4E\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x80"],
        ["\x4E\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x81"],
        ["\x4E\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x82"],
        ["\x4E\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x83"],
        ["\x4E\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x84"],
        ["\x4E\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x85"],
        ["\x4E\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x86"],
        ["\x4E\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x87"],
        ["\x4E\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x88"],
        ["\x4E\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x89"],
        ["\x4E\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8A"],
        ["\x4E\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8B"],
        ["\x4E\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8C"],
        ["\x4E\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8D"],
        ["\x4E\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8E"],
        ["\x4E\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8F"],
        ["\x4E\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x90"],
        ["\x4E\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x91"],
        ["\x4E\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x92"],
        ["\x4E\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x93"],
        ["\x4E\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x94"],
        ["\x4E\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x95"],
        ["\x4E\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x96"],
        ["\x4E\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x97"],
        ["\x4E\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x98"],
        ["\x4E\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x99"],
        ["\x4E\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9A"],
        ["\x4E\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9B"],
        ["\x4E\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9C"],
        ["\x4E\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9D"],
        ["\x4E\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9E"],
        ["\x4E\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9F"],
        ["\x4E\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA0"],
        ["\x4E\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA1"],
        ["\x4E\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA2"],
        ["\x4E\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA3"],
        ["\x4F\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA4"],
        ["\x4F\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA5"],
        ["\x4F\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA6"],
        ["\x4F\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA7"],
        ["\x4F\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA8"],
        ["\x4F\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA9"],
        ["\x4F\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAA"],
        ["\x4F\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAB"],
        ["\x4F\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAC"],
        ["\x4F\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAD"],
        ["\x4F\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAE"],
        ["\x4F\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAF"],
        ["\x4F\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB0"],
        ["\x4F\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB1"],
        ["\x4F\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB2"],
        ["\x4F\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB3"],
        ["\x4F\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB4"],
        ["\x4F\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB5"],
        ["\x4F\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB6"],
        ["\x4F\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB7"],
        ["\x4F\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB8"],
        ["\x64\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB9"],
        ["\x4F\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBA"],
        ["\x4F\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBB"],
        ["\x4F\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBC"],
        ["\x4F\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBD"],
        ["\x4F\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBE"],
        ["\x4F\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBF"],
        ["\x4F\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x80"],
        ["\x4F\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x81"],
        ["\x4F\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x82"],
        ["\x4F\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x83"],
        ["\x4F\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x84"],
        ["\x4F\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x85"],
        ["\x4F\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x86"],
        ["\x4F\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x87"],
        ["\x4F\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x88"],
        ["\x4F\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x89"],
        ["\x4F\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8A"],
        ["\x4F\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8B"],
        ["\x4F\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8C"],
        ["\x4F\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8D"],
        ["\x4F\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8E"],
        ["\x4F\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8F"],
        ["\x4F\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x90"],
        ["\x4F\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x91"],
        ["\x4F\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x92"],
        ["\x4F\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x93"],
        ["\x4F\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x94"],
        ["\x4F\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x95"],
        ["\x4F\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x96"],
        ["\x50\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x82"],
        ["\x50\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x83"],
        ["\x50\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x84"],
        ["\x50\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x85"],
        ["\x50\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x86"],
        ["\x50\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x87"],
        ["\x50\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x88"],
        ["\x50\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x89"],
        ["\x50\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8A"],
        ["\x50\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8B"],
        ["\x50\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8C"],
        ["\x50\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8D"],
        ["\x50\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8E"],
        ["\x50\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8F"],
        ["\x50\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x90"],
        ["\x50\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x91"],
        ["\x50\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x92"],
        ["\x50\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x93"],
        ["\x50\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x94"],
        ["\x50\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x95"],
        ["\x50\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x96"],
        ["\x50\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x97"],
        ["\x50\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x98"],
        ["\x50\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x99"],
        ["\x50\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9A"],
        ["\x50\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9B"],
        ["\x50\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9C"],
        ["\x50\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9D"],
        ["\x50\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9E"],
        ["\x50\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9F"],
        ["\x50\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA0"],
        ["\x50\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA1"],
        ["\x50\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA2"],
        ["\x50\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA3"],
        ["\x50\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA4"],
        ["\x50\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA5"],
        ["\x50\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA6"],
        ["\x50\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA7"],
        ["\x50\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA8"],
        ["\x50\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA9"],
        ["\x50\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAA"],
        ["\x50\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAB"],
        ["\x50\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAC"],
        ["\x50\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAD"],
        ["\x50\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAE"],
        ["\x50\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAF"],
        ["\x50\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB0"],
        ["\x50\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB1"],
        ["\x50\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB2"],
        ["\x50\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB3"],
        ["\x50\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB4"],
        ["\x50\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB5"],
        ["\x50\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB6"],
        ["\x4B\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB7"],
        ["\x50\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB8"],
        ["\x50\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB9"],
        ["\x50\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBA"],
        ["\x50\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBB"],
        ["\x50\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBC"],
        ["\x50\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBD"],
        ["\x50\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBE"],
        ["\x50\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBF"],
        ["\x50\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x80"],
        ["\x50\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x81"],
        ["\x50\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x82"],
        ["\x50\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x83"],
        ["\x50\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x84"],
        ["\x50\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x85"],
        ["\x50\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x86"],
        ["\x50\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x87"],
        ["\x50\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x88"],
        ["\x50\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x89"],
        ["\x50\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8A"],
        ["\x50\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8B"],
        ["\x50\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8C"],
        ["\x50\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8D"],
        ["\x50\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8E"],
        ["\x50\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8F"],
        ["\x50\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x90"],
        ["\x50\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x91"],
        ["\x50\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x92"],
        ["\x50\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x93"],
        ["\x50\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x94"],
        ["\x50\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x95"],
        ["\x50\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x96"],
        ["\x50\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x97"],
        ["\x50\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x98"],
        ["\x50\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x99"],
        ["\x50\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9A"],
        ["\x50\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9B"],
        ["\x50\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9C"],
        ["\x50\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9D"],
        ["\x50\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9E"],
        ["\x50\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9F"],
        ["\x51\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA0"],
        ["\x51\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA1"],
        ["\x51\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA2"],
        ["\x51\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA3"],
        ["\x51\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA4"],
        ["\x51\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA5"],
        ["\x51\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA6"],
        ["\x51\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA7"],
        ["\x51\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA8"],
        ["\x51\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA9"],
        ["\x51\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAA"],
        ["\x51\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAB"],
        ["\x51\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAC"],
        ["\x51\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAD"],
        ["\x51\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAE"],
        ["\x51\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAF"],
        ["\x51\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB0"],
        ["\x51\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB1"],
        ["\x51\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB2"],
        ["\x51\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB3"],
        ["\x51\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB4"],
        ["\x51\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB5"],
        ["\x51\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB6"],
        ["\x51\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB7"],
        ["\x51\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB8"],
        ["\x51\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB9"],
        ["\x51\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBA"],
        ["\x51\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBB"],
        ["\x51\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBC"],
        ["\x51\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBD"],
        ["\x51\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBE"],
        ["\x51\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBF"],
        ["\x51\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x80"],
        ["\x51\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x81"],
        ["\x51\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x82"],
        ["\x51\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x83"],
        ["\x51\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x84"],
        ["\x51\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x85"],
        ["\x51\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x86"],
        ["\x51\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x87"],
        ["\x51\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x88"],
        ["\x51\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x89"],
        ["\x51\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8A"],
        ["\x51\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8B"],
        ["\x51\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8C"],
        ["\x51\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8D"],
        ["\x51\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8E"],
        ["\x51\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8F"],
        ["\x51\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x90"],
        ["\x51\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x91"],
        ["\x51\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x92"],
        ["\x51\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x93"],
        ["\x51\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x94"],
        ["\x51\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x95"],
        ["\x51\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x96"],
        ["\x51\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x97"],
        ["\x51\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x98"],
        ["\x51\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x99"],
        ["\x51\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9A"],
        ["\x51\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9B"],
        ["\x51\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9C"],
        ["\x51\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9D"],
        ["\x51\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9E"],
        ["\x51\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9F"],
        ["\x51\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA0"],
        ["\x51\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA1"],
        ["\x51\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA2"],
        ["\x51\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA3"],
        ["\x51\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA4"],
        ["\x51\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA5"],
        ["\x51\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA6"],
        ["\x51\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA7"],
        ["\x51\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA8"],
        ["\x51\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA9"],
        ["\x51\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAA"],
        ["\x51\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAB"],
        ["\x51\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAC"],
        ["\x51\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAD"],
        ["\x51\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAE"],
        ["\x51\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAF"],
        ["\x51\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB0"],
        ["\x51\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB1"],
        ["\x51\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB2"],
        ["\x51\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB3"],
        ["\x51\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB4"],
        ["\x51\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB5"],
        ["\x51\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB6"],
        ["\x51\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB7"],
        ["\x51\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB8"],
        ["\x51\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB9"],
        ["\x51\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBA"],
        ["\x51\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBB"],
        ["\x51\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBC"],
        ["\x51\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBD"],
        ["\x52\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBE"],
        ["\x52\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBF"],
        ["\x52\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x80"],
        ["\x52\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x81"],
        ["\x52\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x82"],
        ["\x52\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x83"],
        ["\x52\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x84"],
        ["\x52\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x85"],
        ["\x52\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x86"],
        ["\x52\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x87"],
        ["\x52\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x88"],
        ["\x52\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x89"],
        ["\x52\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8A"],
        ["\x52\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8B"],
        ["\x52\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8C"],
        ["\x52\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8D"],
        ["\x52\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8E"],
        ["\x52\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8F"],
        ["\x52\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x90"],
        ["\x52\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x91"],
        ["\x52\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x92"],
        ["\x52\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x93"],
        ["\x52\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x94"],
        ["\x52\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x95"],
        ["\x52\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x96"],
        ["\x52\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x97"],
        ["\x52\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x98"],
        ["\x52\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x99"],
        ["\x52\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9A"],
        ["\x52\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9B"],
        ["\x52\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9C"],
        ["\x52\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9D"],
        ["\x52\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9E"],
        ["\x52\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9F"],
        ["\x52\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA0"],
        ["\x52\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA1"],
        ["\x52\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA2"],
        ["\x52\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA3"],
        ["\x52\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA4"],
        ["\x52\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA5"],
        ["\x52\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA6"],
        ["\x52\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA7"],
        ["\x52\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA8"],
        ["\x52\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA9"],
        ["\x52\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAA"],
        ["\x52\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAB"],
        ["\x52\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAC"],
        ["\x52\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAD"],
        ["\x52\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAE"],
        ["\x52\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAF"],
        ["\x52\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB0"],
        ["\x52\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB1"],
        ["\x52\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB2"],
        ["\x52\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB3"],
        ["\x52\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB4"],
        ["\x52\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB5"],
        ["\x52\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB6"],
        ["\x52\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB7"],
        ["\x52\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB8"],
        ["\x52\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB9"],
        ["\x52\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBA"],
        ["\x52\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBB"],
        ["\x52\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBC"],
        ["\x52\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBD"],
        ["\x52\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBE"],
        ["\x52\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBF"],
        ["\x52\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x80"],
        ["\x52\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x81"],
        ["\x52\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x82"],
        ["\x52\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x83"],
        ["\x52\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x84"],
        ["\x52\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x85"],
        ["\x52\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x86"],
        ["\x52\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x87"],
        ["\x52\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x88"],
        ["\x52\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x89"],
        ["\x52\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8A"],
        ["\x52\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8B"],
        ["\x52\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8C"],
        ["\x52\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8D"],
        ["\x52\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8E"],
        ["\x52\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8F"],
        ["\x52\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x90"],
        ["\x52\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x91"],
        ["\x52\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x92"],
        ["\x52\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x93"],
        ["\x52\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x94"],
        ["\x52\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x95"],
        ["\x52\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x96"],
        ["\x52\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x97"],
        ["\x52\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x98"],
        ["\x52\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x99"],
        ["\x52\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9A"],
        ["\x52\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9B"],
        ["\x53\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9C"],
        ["\x53\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9D"],
        ["\x53\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9E"],
        ["\x53\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9F"],
        ["\x53\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA0"],
        ["\x53\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA1"],
        ["\x53\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA2"],
        ["\x53\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA3"],
        ["\x53\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA4"],
        ["\x53\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA5"],
        ["\x53\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA6"],
        ["\x53\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA7"],
        ["\x53\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA8"],
        ["\x53\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA9"],
        ["\x53\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAA"],
        ["\x53\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAB"],
        ["\x53\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAC"],
        ["\x53\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAD"],
        ["\x53\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAE"],
        ["\x53\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAF"],
        ["\x53\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB0"],
        ["\x53\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB1"],
        ["\x53\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB2"],
        ["\x53\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB3"],
        ["\x53\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB4"],
        ["\x53\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB5"],
        ["\x53\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB6"],
        ["\x53\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB7"],
        ["\x53\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB8"],
        ["\x53\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB9"],
        ["\x53\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBA"],
        ["\x53\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBB"],
        ["\x53\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBC"],
        ["\x53\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBD"],
        ["\x53\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBE"],
        ["\x53\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBF"],
        ["\x53\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x80"],
        ["\x53\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x81"],
        ["\x53\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x82"],
        ["\x53\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x83"],
        ["\x53\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x84"],
        ["\x53\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x85"],
        ["\x53\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x86"],
        ["\x53\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x87"],
        ["\x53\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x88"],
        ["\x53\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x89"],
        ["\x53\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8A"],
        ["\x53\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8B"],
        ["\x53\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8C"],
        ["\x53\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8D"],
        ["\x53\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8E"],
        ["\x53\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8F"],
        ["\x53\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x90"],
        ["\x53\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x91"],
        ["\x53\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x92"],
        ["\x53\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x93"],
        ["\x53\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x94"],
        ["\x53\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x95"],
        ["\x53\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x96"],
        ["\x53\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x97"],
        ["\x53\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x98"],
        ["\x53\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x99"],
        ["\x53\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9A"],
        ["\x53\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9B"],
        ["\x53\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9C"],
        ["\x53\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9D"],
        ["\x53\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9E"],
        ["\x53\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9F"],
        ["\x53\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA0"],
        ["\x53\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA1"],
        ["\x53\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA2"],
        ["\x53\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA3"],
        ["\x53\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA4"],
        ["\x53\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA5"],
        ["\x53\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA6"],
        ["\x53\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA7"],
        ["\x53\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA8"],
        ["\x53\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA9"],
        ["\x53\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAA"],
        ["\x53\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAB"],
        ["\x53\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAC"],
        ["\x53\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAD"],
        ["\x53\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAE"],
        ["\x53\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAF"],
        ["\x53\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB0"],
        ["\x53\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB1"],
        ["\x53\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB2"],
        ["\x53\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB3"],
        ["\x53\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB4"],
        ["\x53\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB5"],
        ["\x53\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB6"],
        ["\x53\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB7"],
        ["\x53\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB8"],
        ["\x53\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB9"],
        ["\x54\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBA"],
        ["\x54\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBB"],
        ["\x54\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBC"],
        ["\x54\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBD"],
        ["\x54\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBE"],
        ["\x54\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBF"],
        ["\x54\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x80"],
        ["\x54\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x81"],
        ["\x54\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x82"],
        ["\x54\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x83"],
        ["\x54\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x84"],
        ["\x54\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x85"],
        ["\x54\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x86"],
        ["\x54\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x87"],
        ["\x54\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x88"],
        ["\x54\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x89"],
        ["\x54\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8A"],
        ["\x54\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8B"],
        ["\x54\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8C"],
        ["\x54\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8D"],
        ["\x54\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8E"],
        ["\x54\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8F"],
        ["\x54\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x90"],
        ["\x54\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x91"],
        ["\x54\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x92"],
        ["\x54\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x93"],
        ["\x54\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x94"],
        ["\x54\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x95"],
        ["\x54\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x96"],
        ["\x54\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x97"],
        ["\x54\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x98"],
        ["\x54\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x99"],
        ["\x54\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9A"],
        ["\x54\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9B"],
        ["\x54\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9C"],
        ["\x54\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9D"],
        ["\x54\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9E"],
        ["\x54\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9F"],
        ["\x54\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA0"],
        ["\x54\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA1"],
        ["\x54\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA2"],
        ["\x54\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA3"],
        ["\x54\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA4"],
        ["\x54\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA5"],
        ["\x54\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA6"],
        ["\x54\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA7"],
        ["\x54\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA8"],
        ["\x54\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA9"],
        ["\x54\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAA"],
        ["\x54\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAB"],
        ["\x54\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAC"],
        ["\x54\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAD"],
        ["\x54\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAE"],
        ["\x54\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAF"],
        ["\x54\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB0"],
        ["\x54\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB1"],
        ["\x54\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB2"],
        ["\x54\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB3"],
        ["\x54\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB4"],
        ["\x54\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB5"],
        ["\x54\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB6"],
        ["\x54\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB7"],
        ["\x54\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB8"],
        ["\x54\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB9"],
        ["\x54\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBA"],
        ["\x54\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBB"],
        ["\x54\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBC"],
        ["\x44\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBD"],
        ["\x54\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBE"],
        ["\x54\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBF"],
        ["\x54\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x80"],
        ["\x54\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x81"],
        ["\x54\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x82"],
        ["\x54\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x83"],
        ["\x54\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x84"],
        ["\x54\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x85"],
        ["\x54\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x86"],
        ["\x54\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x87"],
        ["\x54\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x88"],
        ["\x54\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x89"],
        ["\x54\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8A"],
        ["\x54\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8B"],
        ["\x54\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8C"],
        ["\x54\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8D"],
        ["\x54\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8E"],
        ["\x54\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8F"],
        ["\x54\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x90"],
        ["\x54\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x91"],
        ["\x54\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x92"],
        ["\x54\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x93"],
        ["\x54\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x94"],
        ["\x54\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x95"],
        ["\x54\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x96"],
        ["\x54\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x97"],
        ["\x55\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x98"],
        ["\x55\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x99"],
        ["\x55\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9A"],
        ["\x55\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9B"],
        ["\x55\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9C"],
        ["\x55\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9D"],
        ["\x55\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9E"],
        ["\x55\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9F"],
        ["\x55\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA0"],
        ["\x55\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA1"],
        ["\x55\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA2"],
        ["\x55\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA3"],
        ["\x55\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA4"],
        ["\x55\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA5"],
        ["\x55\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA6"],
        ["\x55\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA7"],
        ["\x55\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA8"],
        ["\x55\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA9"],
        ["\x55\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAA"],
        ["\x55\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAB"],
        ["\x55\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAC"],
        ["\x55\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAD"],
        ["\x55\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAE"],
        ["\x55\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAF"],
        ["\x55\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB0"],
        ["\x55\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB1"],
        ["\x55\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB2"],
        ["\x55\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB3"],
        ["\x55\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB4"],
        ["\x55\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB5"],
        ["\x55\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB6"],
        ["\x55\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB7"],
        ["\x55\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB8"],
        ["\x55\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB9"],
        ["\x55\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBA"],
        ["\x55\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBB"],
        ["\x55\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBC"],
        ["\x55\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBD"],
        ["\x55\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBE"],
        ["\x55\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBF"],
        ["\x55\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x80"],
        ["\x55\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x81"],
        ["\x55\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x82"],
        ["\x55\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x83"],
        ["\x55\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x84"],
        ["\x55\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x85"],
        ["\x55\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x86"],
        ["\x55\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x87"],
        ["\x55\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x88"],
        ["\x55\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x89"],
        ["\x55\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8A"],
        ["\x55\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8B"],
        ["\x55\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8C"],
        ["\x55\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8D"],
        ["\x55\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8E"],
        ["\x55\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8F"],
        ["\x55\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x90"],
        ["\x55\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x91"],
        ["\x55\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x92"],
        ["\x55\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x93"],
        ["\x55\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x94"],
        ["\x55\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x95"],
        ["\x55\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x96"],
        ["\x55\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x97"],
        ["\x55\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x98"],
        ["\x55\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x99"],
        ["\x55\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9A"],
        ["\x55\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9B"],
        ["\x55\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9C"],
        ["\x55\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9D"],
        ["\x55\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9E"],
        ["\x55\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9F"],
        ["\x55\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA0"],
        ["\x55\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA1"],
        ["\x55\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA2"],
        ["\x55\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA3"],
        ["\x55\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA4"],
        ["\x55\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA5"],
        ["\x55\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA6"],
        ["\x55\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA7"],
        ["\x55\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA8"],
        ["\x55\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA9"],
        ["\x55\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAA"],
        ["\x55\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAB"],
        ["\x55\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAC"],
        ["\x55\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAD"],
        ["\x55\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAE"],
        ["\x55\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAF"],
        ["\x55\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB0"],
        ["\x55\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB1"],
        ["\x55\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB2"],
        ["\x55\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB3"],
        ["\x55\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB4"],
        ["\x55\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB5"],
        ["\x56\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB6"],
        ["\x56\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB7"],
        ["\x56\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB8"],
        ["\x56\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB9"],
        ["\x56\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBA"],
        ["\x56\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBB"],
        ["\x56\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBC"],
        ["\x56\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBD"],
        ["\x56\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBE"],
        ["\x56\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBF"],
        ["\x56\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x80"],
        ["\x56\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x81"],
        ["\x56\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x82"],
        ["\x56\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x83"],
        ["\x56\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x84"],
        ["\x56\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x85"],
        ["\x56\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x86"],
        ["\x56\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x87"],
        ["\x56\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x88"],
        ["\x56\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x89"],
        ["\x56\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8A"],
        ["\x56\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8B"],
        ["\x56\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8C"],
        ["\x56\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8D"],
        ["\x56\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8E"],
        ["\x56\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8F"],
        ["\x56\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x90"],
        ["\x56\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x91"],
        ["\x56\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x92"],
        ["\x56\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x93"],
        ["\x56\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x94"],
        ["\x56\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x95"],
        ["\x56\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x96"],
        ["\x56\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x97"],
        ["\x56\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x98"],
        ["\x56\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x99"],
        ["\x56\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9A"],
        ["\x56\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9B"],
        ["\x56\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9C"],
        ["\x56\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9D"],
        ["\x56\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9E"],
        ["\x56\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9F"],
        ["\x56\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA0"],
        ["\x56\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA1"],
        ["\x56\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA2"],
        ["\x56\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA3"],
        ["\x56\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA4"],
        ["\x56\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA5"],
        ["\x56\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA6"],
        ["\x56\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA7"],
        ["\x56\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA8"],
        ["\x56\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA9"],
        ["\x56\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAA"],
        ["\x56\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAB"],
        ["\x56\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAC"],
        ["\x56\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAD"],
        ["\x56\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAE"],
        ["\x56\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAF"],
        ["\x56\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB0"],
        ["\x56\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB1"],
        ["\x56\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB2"],
        ["\x56\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB3"],
        ["\x56\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB4"],
        ["\x56\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB5"],
        ["\x56\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB6"],
        ["\x56\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB7"],
        ["\x56\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB8"],
        ["\x56\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB9"],
        ["\x56\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBA"],
        ["\x56\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBB"],
        ["\x56\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBC"],
        ["\x56\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBD"],
        ["\x56\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBE"],
        ["\x56\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBF"],
        ["\x56\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x80"],
        ["\x56\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x81"],
        ["\x56\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x82"],
        ["\x56\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x83"],
        ["\x56\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x84"],
        ["\x56\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x85"],
        ["\x56\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x86"],
        ["\x56\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x87"],
        ["\x56\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x88"],
        ["\x56\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x89"],
        ["\x56\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8A"],
        ["\x56\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8B"],
        ["\x56\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8C"],
        ["\x56\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8D"],
        ["\x56\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8E"],
        ["\x56\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8F"],
        ["\x56\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x90"],
        ["\x56\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x91"],
        ["\x56\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x92"],
        ["\x56\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x93"],
        ["\x57\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x94"],
        ["\x57\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x95"],
        ["\x57\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x96"],
        ["\x57\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x97"],
        ["\x57\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x98"],
        ["\x57\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x99"],
        ["\x57\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9A"],
        ["\x57\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9B"],
        ["\x57\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9C"],
        ["\x57\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9D"],
        ["\x57\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9E"],
        ["\x57\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9F"],
        ["\x57\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA0"],
        ["\x57\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA1"],
        ["\x57\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA2"],
        ["\x57\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA3"],
        ["\x57\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA4"],
        ["\x57\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA5"],
        ["\x57\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA6"],
        ["\x57\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA7"],
        ["\x57\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA8"],
        ["\x57\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA9"],
        ["\x57\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAA"],
        ["\x57\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAB"],
        ["\x57\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAC"],
        ["\x57\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAD"],
        ["\x57\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAF"],
        ["\x57\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB0"],
        ["\x57\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB1"],
        ["\x57\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB2"],
        ["\x57\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB3"],
        ["\x57\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB4"],
        ["\x57\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB5"],
        ["\x57\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB6"],
        ["\x57\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB7"],
        ["\x57\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB8"],
        ["\x57\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB9"],
        ["\x57\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBA"],
        ["\x57\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBB"],
        ["\x57\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBC"],
        ["\x57\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBD"],
        ["\x57\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBE"],
        ["\x57\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBF"],
        ["\x57\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x80"],
        ["\x57\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x81"],
        ["\x57\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x82"],
        ["\x57\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x83"],
        ["\x57\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x84"],
        ["\x57\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x85"],
        ["\x57\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x86"],
        ["\x57\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x87"],
        ["\x57\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x88"],
        ["\x57\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x89"],
        ["\x57\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8A"],
        ["\x57\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8B"],
        ["\x57\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8C"],
        ["\x57\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8D"],
        ["\x57\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8E"],
        ["\x57\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8F"],
        ["\x57\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x90"],
        ["\x57\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x91"],
        ["\x57\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x92"],
        ["\x57\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x93"],
        ["\x57\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x94"],
        ["\x57\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x95"],
        ["\x57\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x96"],
        ["\x57\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x97"],
        ["\x57\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x98"],
        ["\x57\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x99"],
        ["\x57\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9A"],
        ["\x57\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9B"],
        ["\x57\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9C"],
        ["\x57\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9D"],
        ["\x57\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9E"],
        ["\x57\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9F"],
        ["\x57\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA0"],
        ["\x57\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA1"],
        ["\x57\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA2"],
        ["\x57\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA3"],
        ["\x57\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA4"],
        ["\x57\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA5"],
        ["\x57\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA6"],
        ["\x57\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA7"],
        ["\x57\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA8"],
        ["\x57\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA9"],
        ["\x57\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAA"],
        ["\x57\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAB"],
        ["\x57\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAC"],
        ["\x57\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAD"],
        ["\x57\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAE"],
        ["\x57\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAF"],
        ["\x57\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB0"],
        ["\x57\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB1"],
        ["\x58\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB2"],
        ["\x58\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB3"],
        ["\x58\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB4"],
        ["\x58\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB5"],
        ["\x58\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB6"],
        ["\x58\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB7"],
        ["\x58\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB8"],
        ["\x58\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB9"],
        ["\x58\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBA"],
        ["\x58\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBB"],
        ["\x58\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBC"],
        ["\x58\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBD"],
        ["\x58\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBE"],
        ["\x58\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBF"],
        ["\x58\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x80"],
        ["\x58\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x81"],
        ["\x58\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x82"],
        ["\x58\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x83"],
        ["\x58\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x84"],
        ["\x58\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x85"],
        ["\x58\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x86"],
        ["\x58\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x87"],
        ["\x58\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x88"],
        ["\x58\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x89"],
        ["\x58\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8A"],
        ["\x58\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8B"],
        ["\x58\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8C"],
        ["\x58\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8D"],
        ["\x58\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8E"],
        ["\x58\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8F"],
        ["\x58\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x90"],
        ["\x58\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x91"],
        ["\x58\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x92"],
        ["\x58\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x93"],
        ["\x58\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x94"],
        ["\x58\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x95"],
        ["\x58\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x96"],
        ["\x58\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x97"],
        ["\x58\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x98"],
        ["\x58\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x99"],
        ["\x58\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9A"],
        ["\x58\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9B"],
        ["\x58\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9C"],
        ["\x58\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9D"],
        ["\x58\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9E"],
        ["\x58\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9F"],
        ["\x58\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA0"],
        ["\x58\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA1"],
        ["\x58\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA2"],
        ["\x58\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA3"],
        ["\x58\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA4"],
        ["\x58\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA5"],
        ["\x58\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA6"],
        ["\x58\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA7"],
        ["\x58\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA8"],
        ["\x58\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA9"],
        ["\x58\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAA"],
        ["\x58\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAB"],
        ["\x58\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAC"],
        ["\x58\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAD"],
        ["\x58\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAE"],
        ["\x58\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAF"],
        ["\x58\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB0"],
        ["\x58\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB1"],
        ["\x58\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB2"],
        ["\x58\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB3"],
        ["\x58\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB4"],
        ["\x58\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB5"],
        ["\x58\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB6"],
        ["\x58\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB7"],
        ["\x58\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB8"],
        ["\x58\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB9"],
        ["\x58\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBA"],
        ["\x58\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBB"],
        ["\x58\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBC"],
        ["\x58\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBD"],
        ["\x58\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBE"],
        ["\x58\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBF"],
        ["\x58\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x80"],
        ["\x58\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x81"],
        ["\x58\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x82"],
        ["\x58\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x83"],
        ["\x58\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x84"],
        ["\x58\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x85"],
        ["\x58\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x86"],
        ["\x58\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x87"],
        ["\x58\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x88"],
        ["\x58\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x89"],
        ["\x58\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8A"],
        ["\x58\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8B"],
        ["\x58\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8C"],
        ["\x58\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8D"],
        ["\x58\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8E"],
        ["\x58\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8F"],
        ["\x59\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x90"],
        ["\x59\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x91"],
        ["\x59\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x92"],
        ["\x59\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x93"],
        ["\x59\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x94"],
        ["\x59\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x95"],
        ["\x59\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x96"],
        ["\x59\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x97"],
        ["\x59\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x98"],
        ["\x59\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x99"],
        ["\x59\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9A"],
        ["\x59\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9B"],
        ["\x59\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9C"],
        ["\x59\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9D"],
        ["\x59\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9E"],
        ["\x59\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9F"],
        ["\x59\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA0"],
        ["\x59\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA1"],
        ["\x59\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA2"],
        ["\x59\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA3"],
        ["\x59\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA4"],
        ["\x59\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA5"],
        ["\x59\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA6"],
        ["\x59\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA7"],
        ["\x59\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA8"],
        ["\x59\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA9"],
        ["\x59\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAA"],
        ["\x59\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAB"],
        ["\x59\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAC"],
        ["\x59\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAD"],
        ["\x59\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAE"],
        ["\x59\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAF"],
        ["\x59\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB0"],
        ["\x59\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB1"],
        ["\x59\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB2"],
        ["\x59\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB3"],
        ["\x59\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB4"],
        ["\x59\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB5"],
        ["\x59\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB6"],
        ["\x59\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB7"],
        ["\x59\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB8"],
        ["\x59\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB9"],
        ["\x59\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBA"],
        ["\x59\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBB"],
        ["\x59\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBC"],
        ["\x59\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBD"],
        ["\x59\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBE"],
        ["\x59\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBF"],
        ["\x59\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x80"],
        ["\x59\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x81"],
        ["\x59\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x82"],
        ["\x59\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x83"],
        ["\x59\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x84"],
        ["\x59\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x85"],
        ["\x59\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x86"],
        ["\x59\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x87"],
        ["\x59\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x88"],
        ["\x59\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x89"],
        ["\x59\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8A"],
        ["\x59\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8B"],
        ["\x59\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8C"],
        ["\x59\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8D"],
        ["\x59\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8E"],
        ["\x59\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8F"],
        ["\x59\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x90"],
        ["\x59\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x91"],
        ["\x59\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x92"],
        ["\x59\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x93"],
        ["\x59\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x94"],
        ["\x59\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x95"],
        ["\x59\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x96"],
        ["\x59\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x97"],
        ["\x59\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x98"],
        ["\x59\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x99"],
        ["\x59\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9A"],
        ["\x59\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9B"],
        ["\x59\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9C"],
        ["\x59\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9D"],
        ["\x59\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9E"],
        ["\x59\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9F"],
        ["\x59\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA0"],
        ["\x59\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA1"],
        ["\x59\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA2"],
        ["\x59\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA3"],
        ["\x59\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA4"],
        ["\x59\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA5"],
        ["\x59\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA6"],
        ["\x33\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA7"],
        ["\x59\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA8"],
        ["\x59\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA9"],
        ["\x59\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAA"],
        ["\x59\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAB"],
        ["\x59\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAC"],
        ["\x59\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAD"],
        ["\x5A\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAE"],
        ["\x5A\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAF"],
        ["\x5A\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB0"],
        ["\x5A\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB1"],
        ["\x5A\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB2"],
        ["\x5A\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB3"],
        ["\x5A\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB4"],
        ["\x5A\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB5"],
        ["\x5A\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB6"],
        ["\x5A\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB7"],
        ["\x5A\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB8"],
        ["\x5A\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB9"],
        ["\x5A\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBA"],
        ["\x5A\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBB"],
        ["\x5A\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBC"],
        ["\x5A\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBD"],
        ["\x5A\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBE"],
        ["\x5A\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBF"],
        ["\x5A\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x80"],
        ["\x5A\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x81"],
        ["\x5A\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x82"],
        ["\x5A\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x83"],
        ["\x5A\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x84"],
        ["\x5A\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x85"],
        ["\x5A\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x86"],
        ["\x5A\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x87"],
        ["\x5A\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x88"],
        ["\x5A\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x89"],
        ["\x5A\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8A"],
        ["\x5A\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8B"],
        ["\x5A\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8C"],
        ["\x5A\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8D"],
        ["\x5A\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8E"],
        ["\x5A\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8F"],
        ["\x5A\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x90"],
        ["\x5A\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x91"],
        ["\x5A\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x92"],
        ["\x5A\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x93"],
        ["\x5A\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x94"],
        ["\x5A\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x95"],
        ["\x5A\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x96"],
        ["\x5A\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x97"],
        ["\x5A\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x98"],
        ["\x5A\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x99"],
        ["\x5A\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9A"],
        ["\x5A\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9B"],
        ["\x5A\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9C"],
        ["\x5A\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9D"],
        ["\x5A\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9E"],
        ["\x5A\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9F"],
        ["\x5A\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA0"],
        ["\x5A\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA1"],
        ["\x5A\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA2"],
        ["\x5A\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA3"],
        ["\x5A\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA4"],
        ["\x5A\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA5"],
        ["\x5A\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA6"],
        ["\x5A\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA7"],
        ["\x5A\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA8"],
        ["\x5A\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA9"],
        ["\x5A\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAA"],
        ["\x5A\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAB"],
        ["\x5A\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAC"],
        ["\x5A\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAD"],
        ["\x5A\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAE"],
        ["\x5A\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAF"],
        ["\x5A\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB0"],
        ["\x5A\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB1"],
        ["\x5A\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB2"],
        ["\x5A\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB3"],
        ["\x5A\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB4"],
        ["\x5A\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB5"],
        ["\x5A\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB6"],
        ["\x5A\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB7"],
        ["\x5A\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB8"],
        ["\x5A\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB9"],
        ["\x5A\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBA"],
        ["\x5A\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBB"],
        ["\x5A\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBC"],
        ["\x5A\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBD"],
        ["\x5A\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBE"],
        ["\x5A\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBF"],
        ["\x5A\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x80"],
        ["\x5A\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x81"],
        ["\x5A\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x82"],
        ["\x5A\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x83"],
        ["\x5A\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x84"],
        ["\x5A\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x85"],
        ["\x5A\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x86"],
        ["\x5A\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x87"],
        ["\x5A\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x88"],
        ["\x5A\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x89"],
        ["\x5A\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8A"],
        ["\x5A\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8B"],
        ["\x5B\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8C"],
        ["\x5B\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8D"],
        ["\x5B\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8E"],
        ["\x5B\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8F"],
        ["\x5B\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x90"],
        ["\x5B\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x91"],
        ["\x5B\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x92"],
        ["\x5B\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x93"],
        ["\x5B\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x94"],
        ["\x5B\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x95"],
        ["\x5B\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x96"],
        ["\x5B\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x97"],
        ["\x5B\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x98"],
        ["\x5B\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x99"],
        ["\x5B\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9A"],
        ["\x5B\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9B"],
        ["\x5B\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9C"],
        ["\x5B\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9D"],
        ["\x5B\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9E"],
        ["\x5B\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9F"],
        ["\x5B\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA0"],
        ["\x5B\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA1"],
        ["\x5B\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA2"],
        ["\x5B\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA3"],
        ["\x5B\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA4"],
        ["\x5B\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA5"],
        ["\x5B\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA6"],
        ["\x5B\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA7"],
        ["\x5B\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA8"],
        ["\x5B\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA9"],
        ["\x5B\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAA"],
        ["\x5B\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAB"],
        ["\x5B\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAC"],
        ["\x5B\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAD"],
        ["\x5B\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAE"],
        ["\x5B\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAF"],
        ["\x5B\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB0"],
        ["\x5B\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB1"],
        ["\x5B\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB2"],
        ["\x5B\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB3"],
        ["\x5B\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB4"],
        ["\x5B\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB5"],
        ["\x5B\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB6"],
        ["\x5B\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB7"],
        ["\x5B\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB8"],
        ["\x5B\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB9"],
        ["\x5B\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBA"],
        ["\x5B\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBB"],
        ["\x5B\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBC"],
        ["\x5B\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBD"],
        ["\x5B\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBE"],
        ["\x5B\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBF"],
        ["\x5B\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x80"],
        ["\x5B\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x81"],
        ["\x5B\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x82"],
        ["\x49\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x83"],
        ["\x5B\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x84"],
        ["\x5B\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x85"],
        ["\x5B\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x86"],
        ["\x5B\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x87"],
        ["\x5B\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x88"],
        ["\x5B\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x89"],
        ["\x5B\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8A"],
        ["\x5B\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8B"],
        ["\x5B\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8C"],
        ["\x5B\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8D"],
        ["\x5B\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8E"],
        ["\x5B\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8F"],
        ["\x5B\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x90"],
        ["\x5B\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x91"],
        ["\x5B\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x92"],
        ["\x5B\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x93"],
        ["\x5B\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x94"],
        ["\x5B\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x95"],
        ["\x5B\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x96"],
        ["\x5B\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x97"],
        ["\x45\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x98"],
        ["\x5B\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x99"],
        ["\x5B\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9A"],
        ["\x5B\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9B"],
        ["\x5B\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9C"],
        ["\x5B\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9D"],
        ["\x5B\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9E"],
        ["\x5B\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9F"],
        ["\x5B\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA0"],
        ["\x5B\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA1"],
        ["\x5B\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA2"],
        ["\x5B\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA3"],
        ["\x5B\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA4"],
        ["\x5B\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA5"],
        ["\x5B\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA6"],
        ["\x5B\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA7"],
        ["\x5B\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA8"],
        ["\x5B\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA9"],
        ["\x5C\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAA"],
        ["\x5C\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAB"],
        ["\x5C\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAC"],
        ["\x5C\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAD"],
        ["\x5C\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAE"],
        ["\x5C\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAF"],
        ["\x5C\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB0"],
        ["\x5C\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB1"],
        ["\x5C\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB2"],
        ["\x5C\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB3"],
        ["\x5C\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB4"],
        ["\x5C\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB5"],
        ["\x5C\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB6"],
        ["\x5C\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB7"],
        ["\x5C\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB8"],
        ["\x5C\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB9"],
        ["\x5C\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBA"],
        ["\x5C\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBB"],
        ["\x5C\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBC"],
        ["\x5C\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBD"],
        ["\x5C\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBE"],
        ["\x5C\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBF"],
        ["\x5C\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x80"],
        ["\x5C\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x81"],
        ["\x5C\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x82"],
        ["\x5C\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x83"],
        ["\x5C\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x84"],
        ["\x5C\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x85"],
        ["\x5C\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x86"],
        ["\x5C\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x87"],
        ["\x5C\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x88"],
        ["\x5C\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x89"],
        ["\x5C\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8A"],
        ["\x5C\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8B"],
        ["\x5C\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8C"],
        ["\x5C\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8D"],
        ["\x5C\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8E"],
        ["\x5C\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8F"],
        ["\x5C\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x90"],
        ["\x5C\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x91"],
        ["\x5C\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x92"],
        ["\x5C\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x93"],
        ["\x5C\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x94"],
        ["\x5C\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x95"],
        ["\x5C\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x96"],
        ["\x5C\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x97"],
        ["\x5C\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x98"],
        ["\x5C\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x99"],
        ["\x5C\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9A"],
        ["\x5C\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9B"],
        ["\x5C\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9C"],
        ["\x5C\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9D"],
        ["\x5C\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9E"],
        ["\x5C\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9F"],
        ["\x5C\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA0"],
        ["\x5C\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA1"],
        ["\x5C\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA2"],
        ["\x5C\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA3"],
        ["\x5C\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA4"],
        ["\x5C\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA5"],
        ["\x5C\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA6"],
        ["\x5C\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA7"],
        ["\x5C\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA8"],
        ["\x5C\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA9"],
        ["\x5C\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAA"],
        ["\x5C\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAB"],
        ["\x5C\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAC"],
        ["\x5C\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAD"],
        ["\x5C\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAE"],
        ["\x5C\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAF"],
        ["\x5C\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB0"],
        ["\x5C\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB1"],
        ["\x5C\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB2"],
        ["\x5C\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB3"],
        ["\x5C\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB4"],
        ["\x5C\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB5"],
        ["\x5C\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB6"],
        ["\x5C\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB7"],
        ["\x5C\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB8"],
        ["\x5C\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB9"],
        ["\x5C\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBA"],
        ["\x5C\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBB"],
        ["\x5C\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBC"],
        ["\x5C\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBD"],
        ["\x5C\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBE"],
        ["\x5C\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBF"],
        ["\x5C\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x80"],
        ["\x5C\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x81"],
        ["\x5C\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x82"],
        ["\x5C\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x83"],
        ["\x5C\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x84"],
        ["\x5C\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x85"],
        ["\x5C\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x86"],
        ["\x5C\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x87"],
        ["\x5D\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x88"],
        ["\x5D\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x89"],
        ["\x5D\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8A"],
        ["\x5D\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8B"],
        ["\x5D\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8C"],
        ["\x5D\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8D"],
        ["\x5D\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8E"],
        ["\x5D\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8F"],
        ["\x5D\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x90"],
        ["\x5D\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x91"],
        ["\x5D\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x92"],
        ["\x5D\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x93"],
        ["\x5D\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x94"],
        ["\x5D\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x95"],
        ["\x5D\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x96"],
        ["\x5D\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x97"],
        ["\x5D\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x98"],
        ["\x5D\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x99"],
        ["\x5D\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9A"],
        ["\x5D\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9B"],
        ["\x5D\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9C"],
        ["\x5D\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9D"],
        ["\x5D\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9E"],
        ["\x5D\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9F"],
        ["\x5D\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA0"],
        ["\x5D\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA1"],
        ["\x5D\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA2"],
        ["\x5D\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA3"],
        ["\x5D\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA4"],
        ["\x5D\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA5"],
        ["\x5D\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA6"],
        ["\x5D\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA7"],
        ["\x5D\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA8"],
        ["\x5D\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA9"],
        ["\x5D\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAA"],
        ["\x5D\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAB"],
        ["\x5D\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAC"],
        ["\x5D\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAD"],
        ["\x5D\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAE"],
        ["\x5D\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAF"],
        ["\x5D\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB0"],
        ["\x5D\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB1"],
        ["\x5D\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB2"],
        ["\x5D\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB3"],
        ["\x5D\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB4"],
        ["\x5D\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB5"],
        ["\x5D\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB6"],
        ["\x5D\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB7"],
        ["\x5D\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB8"],
        ["\x5D\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB9"],
        ["\x5D\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBA"],
        ["\x5D\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBB"],
        ["\x5D\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBC"],
        ["\x5D\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBD"],
        ["\x5D\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBE"],
        ["\x5D\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBF"],
        ["\x5D\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x80"],
        ["\x5D\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x81"],
        ["\x5D\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x82"],
        ["\x5D\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x83"],
        ["\x5D\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x84"],
        ["\x5D\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x85"],
        ["\x5D\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x86"],
        ["\x5D\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x87"],
        ["\x5D\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x88"],
        ["\x5D\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x89"],
        ["\x5D\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8A"],
        ["\x5D\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8B"],
        ["\x5D\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8C"],
        ["\x5D\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8D"],
        ["\x5D\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8E"],
        ["\x5D\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8F"],
        ["\x5D\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x90"],
        ["\x5D\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x91"],
        ["\x5D\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x92"],
        ["\x5D\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x93"],
        ["\x5D\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x94"],
        ["\x5D\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x95"],
        ["\x5D\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x96"],
        ["\x5D\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x97"],
        ["\x5D\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x98"],
        ["\x5D\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x99"],
        ["\x5D\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9A"],
        ["\x5D\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9B"],
        ["\x5D\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9C"],
        ["\x5D\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9D"],
        ["\x5D\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9E"],
        ["\x5D\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9F"],
        ["\x5D\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA0"],
        ["\x5D\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA1"],
        ["\x5D\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA2"],
        ["\x5D\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA3"],
        ["\x5D\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA4"],
        ["\x5D\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA5"],
        ["\x5E\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA6"],
        ["\x5E\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA7"],
        ["\x5E\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA8"],
        ["\x5E\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA9"],
        ["\x5E\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAA"],
        ["\x5E\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAB"],
        ["\x5E\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAC"],
        ["\x5E\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAD"],
        ["\x5E\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAE"],
        ["\x5E\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAF"],
        ["\x5E\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB0"],
        ["\x5E\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB1"],
        ["\x5E\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB2"],
        ["\x5E\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB3"],
        ["\x5E\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB4"],
        ["\x5E\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB5"],
        ["\x5E\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB6"],
        ["\x5E\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB7"],
        ["\x5E\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB8"],
        ["\x5E\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB9"],
        ["\x5E\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBA"],
        ["\x5E\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBB"],
        ["\x5E\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBC"],
        ["\x5E\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBD"],
        ["\x45\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBE"],
        ["\x5E\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBF"],
        ["\x5E\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x80"],
        ["\x5E\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x81"],
        ["\x5E\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x82"],
        ["\x5E\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x83"],
        ["\x5E\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x84"],
        ["\x5E\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x85"],
        ["\x5E\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x86"],
        ["\x5E\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x87"],
        ["\x5E\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x88"],
        ["\x5E\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x89"],
        ["\x5E\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8A"],
        ["\x5E\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8B"],
        ["\x5E\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8C"],
        ["\x5E\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8D"],
        ["\x5E\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8E"],
        ["\x5E\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8F"],
        ["\x5E\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x90"],
        ["\x5E\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x91"],
        ["\x5E\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x92"],
        ["\x5E\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x93"],
        ["\x5E\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x94"],
        ["\x5E\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x95"],
        ["\x5E\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x96"],
        ["\x5E\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x97"],
        ["\x5E\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x98"],
        ["\x5E\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x99"],
        ["\x5E\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9A"],
        ["\x5E\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9B"],
        ["\x5E\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9C"],
        ["\x5E\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9D"],
        ["\x5E\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9E"],
        ["\x5E\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9F"],
        ["\x5E\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA0"],
        ["\x5E\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA1"],
        ["\x5E\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA2"],
        ["\x5E\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA3"],
        ["\x5E\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA4"],
        ["\x5E\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA5"],
        ["\x5E\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA6"],
        ["\x5E\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA7"],
        ["\x5E\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA8"],
        ["\x5E\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA9"],
        ["\x5E\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAA"],
        ["\x5E\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAB"],
        ["\x5E\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAC"],
        ["\x5E\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAD"],
        ["\x5E\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAE"],
        ["\x5E\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAF"],
        ["\x5E\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB0"],
        ["\x5E\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB1"],
        ["\x5E\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB2"],
        ["\x5E\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB3"],
        ["\x5E\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB4"],
        ["\x5E\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB5"],
        ["\x5E\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB6"],
        ["\x5E\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB7"],
        ["\x5E\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB8"],
        ["\x5E\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB9"],
        ["\x34\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBA"],
        ["\x5E\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBB"],
        ["\x5E\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBC"],
        ["\x5E\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBD"],
        ["\x5E\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBE"],
        ["\x5E\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBF"],
        ["\x5E\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x80"],
        ["\x5E\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x81"],
        ["\x5E\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x82"],
        ["\x5E\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x83"],
        ["\x5F\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x84"],
        ["\x5F\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x85"],
        ["\x5F\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x86"],
        ["\x5F\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x87"],
        ["\x5F\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x88"],
        ["\x5F\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x89"],
        ["\x5F\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8A"],
        ["\x5F\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8B"],
        ["\x5F\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8C"],
        ["\x5F\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8D"],
        ["\x5F\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8E"],
        ["\x5F\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8F"],
        ["\x5F\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x90"],
        ["\x5F\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x91"],
        ["\x5F\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x92"],
        ["\x5F\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x93"],
        ["\x5F\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x94"],
        ["\x5F\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x95"],
        ["\x5F\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x96"],
        ["\x5F\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x97"],
        ["\x5F\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x98"],
        ["\x5F\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x99"],
        ["\x5F\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9A"],
        ["\x5F\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9B"],
        ["\x5F\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9C"],
        ["\x5F\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9D"],
        ["\x5F\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9E"],
        ["\x5F\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9F"],
        ["\x5F\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA0"],
        ["\x5F\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA1"],
        ["\x5F\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA2"],
        ["\x5F\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA3"],
        ["\x5F\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA4"],
        ["\x5F\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA5"],
        ["\x5F\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA6"],
        ["\x5F\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA7"],
        ["\x5F\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA8"],
        ["\x5F\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA9"],
        ["\x5F\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAA"],
        ["\x5F\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAB"],
        ["\x5F\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAC"],
        ["\x5F\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAD"],
        ["\x5F\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAE"],
        ["\x5F\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAF"],
        ["\x5F\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB0"],
        ["\x5F\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB1"],
        ["\x5F\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB2"],
        ["\x5F\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB3"],
        ["\x5F\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB4"],
        ["\x5F\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB5"],
        ["\x5F\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB6"],
        ["\x5F\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB7"],
        ["\x5F\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB8"],
        ["\x5F\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB9"],
        ["\x5F\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBA"],
        ["\x5F\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBB"],
        ["\x5F\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBC"],
        ["\x5F\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBD"],
        ["\x5F\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBE"],
        ["\x5F\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBF"],
        ["\x5F\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x80"],
        ["\x5F\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x81"],
        ["\x5F\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x82"],
        ["\x5F\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x83"],
        ["\x5F\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x84"],
        ["\x5F\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x85"],
        ["\x5F\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x86"],
        ["\x5F\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x87"],
        ["\x5F\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x88"],
        ["\x5F\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x89"],
        ["\x5F\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8A"],
        ["\x5F\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8B"],
        ["\x5F\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8C"],
        ["\x5F\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8D"],
        ["\x5F\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8E"],
        ["\x5F\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8F"],
        ["\x5F\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x90"],
        ["\x5F\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x91"],
        ["\x5F\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x92"],
        ["\x5F\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x93"],
        ["\x5F\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x94"],
        ["\x5F\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x95"],
        ["\x5F\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x96"],
        ["\x5F\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x97"],
        ["\x5F\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x98"],
        ["\x5F\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x99"],
        ["\x5F\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9A"],
        ["\x5F\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9B"],
        ["\x5F\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9C"],
        ["\x5F\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9D"],
        ["\x5F\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9E"],
        ["\x5F\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9F"],
        ["\x5F\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA0"],
        ["\x5F\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA1"],
        ["\x60\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA2"],
        ["\x60\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA3"],
        ["\x60\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA4"],
        ["\x60\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA5"],
        ["\x60\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA6"],
        ["\x60\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA7"],
        ["\x60\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA8"],
        ["\x60\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA9"],
        ["\x60\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAA"],
        ["\x60\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAB"],
        ["\x60\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAC"],
        ["\x60\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAD"],
        ["\x60\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAE"],
        ["\x60\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAF"],
        ["\x60\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB0"],
        ["\x60\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB1"],
        ["\x60\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB2"],
        ["\x60\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB3"],
        ["\x60\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB4"],
        ["\x60\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB5"],
        ["\x60\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB6"],
        ["\x60\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB7"],
        ["\x60\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB8"],
        ["\x60\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB9"],
        ["\x60\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBA"],
        ["\x60\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBB"],
        ["\x60\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBC"],
        ["\x60\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBD"],
        ["\x60\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBE"],
        ["\x60\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBF"],
        ["\x60\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x80"],
        ["\x60\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x81"],
        ["\x60\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x82"],
        ["\x60\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x83"],
        ["\x60\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x84"],
        ["\x60\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x85"],
        ["\x60\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x86"],
        ["\x60\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x87"],
        ["\x60\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x88"],
        ["\x60\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x89"],
        ["\x60\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8A"],
        ["\x60\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8B"],
        ["\x60\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8C"],
        ["\x60\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8D"],
        ["\x60\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8E"],
        ["\x60\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8F"],
        ["\x60\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x90"],
        ["\x60\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x91"],
        ["\x60\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x92"],
        ["\x60\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x93"],
        ["\x60\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x94"],
        ["\x60\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x95"],
        ["\x60\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x96"],
        ["\x60\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x97"],
        ["\x60\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x98"],
        ["\x60\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x99"],
        ["\x60\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9A"],
        ["\x60\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9B"],
        ["\x60\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9C"],
        ["\x60\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9D"],
        ["\x60\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9E"],
        ["\x60\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9F"],
        ["\x60\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA0"],
        ["\x60\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA1"],
        ["\x60\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA2"],
        ["\x60\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA3"],
        ["\x60\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA4"],
        ["\x60\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA5"],
        ["\x60\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA6"],
        ["\x60\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA7"],
        ["\x60\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA8"],
        ["\x60\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA9"],
        ["\x60\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAA"],
        ["\x60\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAB"],
        ["\x60\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAC"],
        ["\x60\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAD"],
        ["\x60\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAE"],
        ["\x60\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAF"],
        ["\x60\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB0"],
        ["\x60\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB1"],
        ["\x60\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB2"],
        ["\x60\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB3"],
        ["\x60\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB4"],
        ["\x60\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB5"],
        ["\x60\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB6"],
        ["\xC4\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB7"],
        ["\x60\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB8"],
        ["\x60\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB9"],
        ["\x60\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBA"],
        ["\x60\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBB"],
        ["\x60\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBC"],
        ["\x60\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBD"],
        ["\x60\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBE"],
        ["\x60\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBF"],
        ["\x61\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x80"],
        ["\x61\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x81"],
        ["\x61\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x82"],
        ["\x61\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x83"],
        ["\x61\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x84"],
        ["\x61\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x85"],
        ["\x61\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x86"],
        ["\x61\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x87"],
        ["\x61\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x88"],
        ["\x61\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x89"],
        ["\x61\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8A"],
        ["\x61\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8B"],
        ["\x61\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8C"],
        ["\x61\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8D"],
        ["\x61\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8E"],
        ["\x61\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8F"],
        ["\x61\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x90"],
        ["\x61\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x91"],
        ["\x61\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x92"],
        ["\x61\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x93"],
        ["\x61\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x94"],
        ["\x61\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x95"],
        ["\x61\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x96"],
        ["\x61\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x97"],
        ["\x61\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x98"],
        ["\x61\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x99"],
        ["\x61\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9A"],
        ["\x61\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9B"],
        ["\x61\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9C"],
        ["\x61\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9D"],
        ["\x61\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9E"],
        ["\x61\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9F"],
        ["\x61\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA0"],
        ["\x61\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA1"],
        ["\x61\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA2"],
        ["\x61\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA3"],
        ["\x61\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA4"],
        ["\x61\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA5"],
        ["\x61\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA6"],
        ["\x61\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA7"],
        ["\x61\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA8"],
        ["\x61\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA9"],
        ["\x61\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAA"],
        ["\x61\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAB"],
        ["\x61\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAC"],
        ["\x61\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAD"],
        ["\x61\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAE"],
        ["\x61\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAF"],
        ["\x61\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB0"],
        ["\x61\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB1"],
        ["\x61\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB2"],
        ["\x61\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB3"],
        ["\x61\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB4"],
        ["\x61\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB5"],
        ["\x61\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB6"],
        ["\x61\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB7"],
        ["\x61\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB8"],
        ["\x61\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB9"],
        ["\x61\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBA"],
        ["\x61\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBB"],
        ["\x61\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBC"],
        ["\x61\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBD"],
        ["\x61\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBE"],
        ["\x61\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBF"],
        ["\x61\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x80"],
        ["\x61\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x81"],
        ["\x61\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x82"],
        ["\x61\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x83"],
        ["\x61\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x84"],
        ["\x61\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x85"],
        ["\x61\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x86"],
        ["\x61\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x87"],
        ["\x61\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x88"],
        ["\x61\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x89"],
        ["\x61\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8A"],
        ["\x61\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8B"],
        ["\x61\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8C"],
        ["\x61\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8D"],
        ["\x61\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8E"],
        ["\x61\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8F"],
        ["\x61\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x90"],
        ["\x61\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x91"],
        ["\x61\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x92"],
        ["\x61\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x93"],
        ["\x61\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x94"],
        ["\x61\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x95"],
        ["\x61\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x96"],
        ["\x61\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x97"],
        ["\x61\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x98"],
        ["\x61\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x99"],
        ["\x61\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9A"],
        ["\x61\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9B"],
        ["\x61\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9C"],
        ["\x61\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9D"],
        ["\x62\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9E"],
        ["\x62\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9F"],
        ["\x62\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA0"],
        ["\x62\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA1"],
        ["\x62\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA2"],
        ["\x62\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA3"],
        ["\x62\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA4"],
        ["\x62\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA5"],
        ["\x62\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA6"],
        ["\x62\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA7"],
        ["\x62\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA8"],
        ["\x62\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA9"],
        ["\x62\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAA"],
        ["\x62\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAB"],
        ["\x62\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAC"],
        ["\x62\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAD"],
        ["\x62\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAE"],
        ["\x62\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAF"],
        ["\x62\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB0"],
        ["\x62\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB1"],
        ["\x62\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB2"],
        ["\x62\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB3"],
        ["\x62\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB4"],
        ["\x62\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB5"],
        ["\x62\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB6"],
        ["\x62\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB7"],
        ["\x62\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB8"],
        ["\x62\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB9"],
        ["\x62\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBA"],
        ["\x62\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBB"],
        ["\x62\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBC"],
        ["\x62\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBD"],
        ["\x62\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBE"],
        ["\x62\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBF"],
        ["\x62\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x80"],
        ["\x62\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x81"],
        ["\x62\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x82"],
        ["\x62\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x83"],
        ["\x62\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x84"],
        ["\x62\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x85"],
        ["\x62\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x86"],
        ["\x62\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x87"],
        ["\x62\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x88"],
        ["\x62\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x89"],
        ["\x62\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8A"],
        ["\x62\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8B"],
        ["\x62\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8C"],
        ["\x62\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8D"],
        ["\x62\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8E"],
        ["\x62\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8F"],
        ["\x62\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x90"],
        ["\x62\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x91"],
        ["\x62\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x92"],
        ["\x62\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x93"],
        ["\x62\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x94"],
        ["\x62\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x95"],
        ["\x62\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x96"],
        ["\x62\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x97"],
        ["\x62\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x98"],
        ["\x62\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x99"],
        ["\x62\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9A"],
        ["\x62\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9B"],
        ["\x62\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9C"],
        ["\x62\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9D"],
        ["\x62\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9E"],
        ["\x62\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9F"],
        ["\x62\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA0"],
        ["\x62\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA1"],
        ["\x62\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA2"],
        ["\x62\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA3"],
        ["\x62\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA4"],
        ["\x39\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA5"],
        ["\x62\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA6"],
        ["\x45\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA7"],
        ["\x62\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA8"],
        ["\x62\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA9"],
        ["\x62\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAA"],
        ["\x62\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAB"],
        ["\x62\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAC"],
        ["\x62\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAD"],
        ["\x62\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAE"],
        ["\x62\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAF"],
        ["\x62\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB0"],
        ["\x62\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB1"],
        ["\x62\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB2"],
        ["\x62\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB3"],
        ["\x62\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB4"],
        ["\x62\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB5"],
        ["\x62\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB6"],
        ["\x62\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB7"],
        ["\x62\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB8"],
        ["\x62\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB9"],
        ["\x62\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBA"],
        ["\x62\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBB"],
        ["\x63\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBC"],
        ["\x63\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBD"],
        ["\x63\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBE"],
        ["\x63\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBF"],
        ["\x63\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x80"],
        ["\x63\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x81"],
        ["\x63\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x82"],
        ["\x63\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x83"],
        ["\x63\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x84"],
        ["\x63\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x85"],
        ["\x63\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x86"],
        ["\x63\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x87"],
        ["\x63\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x88"],
        ["\x63\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x89"],
        ["\x63\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8A"],
        ["\x63\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8B"],
        ["\x63\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8C"],
        ["\x63\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8D"],
        ["\x63\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8E"],
        ["\x63\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8F"],
        ["\x63\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x90"],
        ["\x63\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x91"],
        ["\x63\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x92"],
        ["\x63\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x93"],
        ["\x63\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x94"],
        ["\x63\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x95"],
        ["\x63\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x96"],
        ["\x63\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x97"],
        ["\x63\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x98"],
        ["\x63\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x99"],
        ["\x63\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9A"],
        ["\x63\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9B"],
        ["\x63\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9C"],
        ["\x63\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9D"],
        ["\x63\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9E"],
        ["\x63\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9F"],
        ["\x63\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA0"],
        ["\x63\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA1"],
        ["\x63\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA2"],
        ["\x63\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA3"],
        ["\x63\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA4"],
        ["\x63\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA5"],
        ["\x63\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA6"],
        ["\x63\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA7"],
        ["\x63\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA8"],
        ["\x63\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA9"],
        ["\x63\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAA"],
        ["\x63\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAB"],
        ["\x63\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAC"],
        ["\x63\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAD"],
        ["\x63\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAE"],
        ["\x63\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAF"],
        ["\x63\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB0"],
        ["\x63\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB1"],
        ["\x63\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB2"],
        ["\x63\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB3"],
        ["\x63\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB4"],
        ["\x63\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB5"],
        ["\x63\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB6"],
        ["\x63\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB7"],
        ["\x63\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB8"],
        ["\x33\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB9"],
        ["\x63\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBA"],
        ["\x63\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBB"],
        ["\x63\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBC"],
        ["\x63\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBD"],
        ["\x63\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBE"],
        ["\x63\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBF"],
        ["\x63\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x80"],
        ["\x63\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x81"],
        ["\x63\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x82"],
        ["\x63\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x83"],
        ["\x63\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x84"],
        ["\x63\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x85"],
        ["\x63\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x86"],
        ["\x63\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x87"],
        ["\x63\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x88"],
        ["\x63\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x89"],
        ["\x63\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8A"],
        ["\x63\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8B"],
        ["\x63\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8C"],
        ["\x63\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8D"],
        ["\x63\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8E"],
        ["\x63\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8F"],
        ["\x63\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x90"],
        ["\x63\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x91"],
        ["\x63\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x92"],
        ["\x63\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x93"],
        ["\x63\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x94"],
        ["\x63\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x95"],
        ["\x63\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x96"],
        ["\x63\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x97"],
        ["\x63\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x98"],
        ["\x63\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x99"],
        ["\x64\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9A"],
        ["\x64\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9B"],
        ["\x64\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9C"],
        ["\x64\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9D"],
        ["\x64\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9E"],
        ["\x64\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9F"],
        ["\x64\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA0"],
        ["\x64\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA1"],
        ["\x64\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA2"],
        ["\x64\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA3"],
        ["\x64\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA4"],
        ["\x64\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA5"],
        ["\x64\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA6"],
        ["\x64\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA7"],
        ["\x64\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA8"],
        ["\x64\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA9"],
        ["\x64\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAA"],
        ["\x64\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAB"],
        ["\x64\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAC"],
        ["\x64\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAD"],
        ["\x64\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAE"],
        ["\x64\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAF"],
        ["\x64\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB0"],
        ["\x64\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB1"],
        ["\x64\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB2"],
        ["\x64\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB3"],
        ["\x64\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB4"],
        ["\x64\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB5"],
        ["\x64\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB6"],
        ["\x64\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB7"],
        ["\x64\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB8"],
        ["\x64\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB9"],
        ["\x64\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBA"],
        ["\x64\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBB"],
        ["\x64\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBC"],
        ["\x64\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBD"],
        ["\x64\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBE"],
        ["\x4F\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBF"],
        ["\x64\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x80"],
        ["\x64\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x81"],
        ["\x64\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x82"],
        ["\x64\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x83"],
        ["\x64\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x84"],
        ["\x64\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x85"],
        ["\x64\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x86"],
        ["\x64\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x87"],
        ["\x64\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x88"],
        ["\x64\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x89"],
        ["\x64\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8A"],
        ["\x64\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8B"],
        ["\x64\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8C"],
        ["\x64\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8D"],
        ["\x64\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8E"],
        ["\x64\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8F"],
        ["\x64\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x90"],
        ["\x64\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x91"],
        ["\x64\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x92"],
        ["\x64\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x93"],
        ["\x64\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x94"],
        ["\x64\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x95"],
        ["\x64\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x96"],
        ["\x64\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x97"],
        ["\x64\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x98"],
        ["\x64\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x99"],
        ["\x64\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9A"],
        ["\x64\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9B"],
        ["\x64\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9C"],
        ["\x64\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9D"],
        ["\x64\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9E"],
        ["\x64\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9F"],
        ["\x64\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA0"],
        ["\x64\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA1"],
        ["\x64\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA2"],
        ["\x64\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA3"],
        ["\x64\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA4"],
        ["\x64\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA5"],
        ["\x64\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA6"],
        ["\x64\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA7"],
        ["\x64\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA8"],
        ["\x64\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA9"],
        ["\x64\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAA"],
        ["\x64\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAB"],
        ["\x64\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAC"],
        ["\x64\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAD"],
        ["\x64\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAE"],
        ["\x64\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAF"],
        ["\x64\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB0"],
        ["\x64\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB1"],
        ["\x64\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB2"],
        ["\x64\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB3"],
        ["\x64\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB4"],
        ["\x64\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB5"],
        ["\x64\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB6"],
        ["\x64\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB7"],
        ["\x65\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB8"],
        ["\x65\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB9"],
        ["\x65\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBA"],
        ["\x65\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBB"],
        ["\x65\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBC"],
        ["\x65\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBD"],
        ["\x65\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBE"],
        ["\x65\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBF"],
        ["\x65\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x80"],
        ["\x65\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x81"],
        ["\x65\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x82"],
        ["\x65\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x83"],
        ["\x65\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x84"],
        ["\x65\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x85"],
        ["\x65\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x86"],
        ["\x65\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x87"],
        ["\x65\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x88"],
        ["\x65\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x89"],
        ["\x65\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8A"],
        ["\x65\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8B"],
        ["\x65\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8C"],
        ["\x65\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8D"],
        ["\x65\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8E"],
        ["\x65\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8F"],
        ["\x65\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x90"],
        ["\x65\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x91"],
        ["\x65\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x92"],
        ["\x65\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x93"],
        ["\x65\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x94"],
        ["\x65\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x95"],
        ["\x65\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x96"],
        ["\x65\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x97"],
        ["\x65\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x98"],
        ["\x65\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x99"],
        ["\x65\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9A"],
        ["\x65\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9B"],
        ["\x65\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9C"],
        ["\x65\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9D"],
        ["\x65\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9E"],
        ["\x65\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9F"],
        ["\x65\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA0"],
        ["\x65\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA1"],
        ["\x65\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA2"],
        ["\x65\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA3"],
        ["\x65\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA4"],
        ["\x65\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA5"],
        ["\x65\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA6"],
        ["\x65\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA7"],
        ["\x65\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA8"],
        ["\x65\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA9"],
        ["\x65\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAA"],
        ["\x65\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAB"],
        ["\x65\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAC"],
        ["\x65\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAD"],
        ["\x65\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAE"],
        ["\x65\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAF"],
        ["\x65\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB0"],
        ["\x65\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB1"],
        ["\x65\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB2"],
        ["\x65\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB3"],
        ["\x65\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB4"],
        ["\x65\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB5"],
        ["\x65\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB6"],
        ["\x65\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB7"],
        ["\x65\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB8"],
        ["\x65\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB9"],
        ["\x65\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBA"],
        ["\x65\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBB"],
        ["\x65\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBC"],
        ["\x65\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBD"],
        ["\x65\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBE"],
        ["\x65\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBF"],
        ["\x65\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x80"],
        ["\x65\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x81"],
        ["\x65\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x82"],
        ["\x65\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x83"],
        ["\x65\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x84"],
        ["\x65\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x85"],
        ["\x65\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x86"],
        ["\x65\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x87"],
        ["\x65\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x88"],
        ["\x65\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x89"],
        ["\x65\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8A"],
        ["\x65\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8B"],
        ["\x65\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8C"],
        ["\x65\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8D"],
        ["\x65\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8E"],
        ["\x65\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8F"],
        ["\x65\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x90"],
        ["\x65\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x91"],
        ["\x65\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x92"],
        ["\x65\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x93"],
        ["\x65\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x94"],
        ["\x65\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x95"],
        ["\x66\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x96"],
        ["\x66\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x97"],
        ["\x66\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x98"],
        ["\x66\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x99"],
        ["\x66\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9A"],
        ["\x66\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9B"],
        ["\x66\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9C"],
        ["\x66\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9D"],
        ["\x66\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9E"],
        ["\x66\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9F"],
        ["\x66\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA0"],
        ["\x66\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA1"],
        ["\x66\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA2"],
        ["\x66\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA3"],
        ["\x66\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA4"],
        ["\x66\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA5"],
        ["\x66\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA6"],
        ["\x66\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA7"],
        ["\x66\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA8"],
        ["\x66\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA9"],
        ["\x66\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAA"],
        ["\x66\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAB"],
        ["\x66\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAC"],
        ["\x66\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAD"],
        ["\x66\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAE"],
        ["\x66\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAF"],
        ["\x66\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB0"],
        ["\x66\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB1"],
        ["\x66\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB2"],
        ["\x66\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB3"],
        ["\x66\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB4"],
        ["\x66\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB5"],
        ["\x66\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB6"],
        ["\x66\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB7"],
        ["\x66\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB8"],
        ["\x66\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB9"],
        ["\x66\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBA"],
        ["\x66\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBB"],
        ["\x66\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBC"],
        ["\x66\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBD"],
        ["\x66\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBE"],
        ["\x66\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBF"],
        ["\x66\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x80"],
        ["\x66\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x81"],
        ["\x66\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x82"],
        ["\x66\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x83"],
        ["\x66\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x84"],
        ["\x66\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x85"],
        ["\x66\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x86"],
        ["\x66\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x87"],
        ["\x66\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x88"],
        ["\x66\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x89"],
        ["\x66\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8A"],
        ["\x66\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8B"],
        ["\x66\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8C"],
        ["\x66\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8D"],
        ["\x66\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8E"],
        ["\x66\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8F"],
        ["\x66\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x90"],
        ["\x66\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x91"],
        ["\x66\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x92"],
        ["\x66\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x93"],
        ["\x66\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x94"],
        ["\x66\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x95"],
        ["\x66\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x96"],
        ["\x66\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x97"],
        ["\x66\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x98"],
        ["\x66\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x99"],
        ["\x66\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9A"],
        ["\x66\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9B"],
        ["\x66\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9C"],
        ["\x66\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9D"],
        ["\x66\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9E"],
        ["\x66\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9F"],
        ["\x66\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA0"],
        ["\x66\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA1"],
        ["\x66\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA2"],
        ["\x66\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA3"],
        ["\x66\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA4"],
        ["\x66\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA5"],
        ["\x66\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA6"],
        ["\x66\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA7"],
        ["\x66\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA8"],
        ["\x66\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA9"],
        ["\x66\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAA"],
        ["\x66\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAB"],
        ["\x66\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAC"],
        ["\x66\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAD"],
        ["\x66\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAE"],
        ["\x66\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAF"],
        ["\x66\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB0"],
        ["\x66\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB1"],
        ["\x66\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB2"],
        ["\x66\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB3"],
        ["\x67\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB4"],
        ["\x67\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB5"],
        ["\x67\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB6"],
        ["\x67\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB7"],
        ["\x67\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB8"],
        ["\x67\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB9"],
        ["\x67\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBA"],
        ["\x67\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBB"],
        ["\x67\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBC"],
        ["\x67\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBD"],
        ["\x67\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBE"],
        ["\x67\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBF"],
        ["\x67\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x80"],
        ["\x67\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x81"],
        ["\x67\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x82"],
        ["\x67\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x83"],
        ["\x67\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x84"],
        ["\x67\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x85"],
        ["\x67\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x86"],
        ["\x67\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x87"],
        ["\x67\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x88"],
        ["\x67\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x89"],
        ["\x67\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8A"],
        ["\x67\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8B"],
        ["\x67\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8C"],
        ["\x67\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8D"],
        ["\x67\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8E"],
        ["\x67\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8F"],
        ["\x67\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x90"],
        ["\x67\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x91"],
        ["\x67\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x92"],
        ["\x67\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x93"],
        ["\x67\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x94"],
        ["\x67\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x95"],
        ["\x67\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x96"],
        ["\x67\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x97"],
        ["\x67\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x98"],
        ["\x67\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x99"],
        ["\x67\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9A"],
        ["\x67\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9B"],
        ["\x67\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9C"],
        ["\x67\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9D"],
        ["\x67\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9E"],
        ["\x67\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9F"],
        ["\x67\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA0"],
        ["\x67\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA1"],
        ["\x67\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA2"],
        ["\x67\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA3"],
        ["\x67\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA4"],
        ["\x67\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA5"],
        ["\x67\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA6"],
        ["\x67\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA7"],
        ["\x67\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA8"],
        ["\x67\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA9"],
        ["\x67\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAA"],
        ["\x67\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAB"],
        ["\x67\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAC"],
        ["\x67\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAD"],
        ["\x67\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAE"],
        ["\x67\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAF"],
        ["\x67\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB0"],
        ["\x67\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB1"],
        ["\x67\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB2"],
        ["\x67\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB3"],
        ["\x67\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB4"],
        ["\x67\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB5"],
        ["\x67\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB6"],
        ["\x67\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB7"],
        ["\x67\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB8"],
        ["\x67\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB9"],
        ["\x67\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBA"],
        ["\x67\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBB"],
        ["\x67\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBC"],
        ["\x67\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBD"],
        ["\x67\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBE"],
        ["\x67\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBF"],
        ["\x67\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x80"],
        ["\x67\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x81"],
        ["\x67\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x82"],
        ["\x67\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x83"],
        ["\x67\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x84"],
        ["\x67\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x85"],
        ["\x67\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x86"],
        ["\x67\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x87"],
        ["\x67\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x88"],
        ["\x67\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x89"],
        ["\x67\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8A"],
        ["\x67\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8B"],
        ["\x67\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8C"],
        ["\x67\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8D"],
        ["\x67\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8E"],
        ["\x67\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8F"],
        ["\x67\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x90"],
        ["\x67\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x91"],
        ["\x68\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x92"],
        ["\x68\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x93"],
        ["\x68\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x94"],
        ["\x68\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x95"],
        ["\x68\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x96"],
        ["\x68\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x97"],
        ["\x68\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x98"],
        ["\x68\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x99"],
        ["\x68\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9A"],
        ["\x68\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9B"],
        ["\x68\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9C"],
        ["\x68\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9D"],
        ["\x68\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9E"],
        ["\x68\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9F"],
        ["\x68\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA0"],
        ["\x68\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA1"],
        ["\x68\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA2"],
        ["\x68\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA3"],
        ["\x68\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA4"],
        ["\x68\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA5"],
        ["\x68\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA6"],
        ["\x68\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA7"],
        ["\x68\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA8"],
        ["\x68\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA9"],
        ["\x68\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAA"],
        ["\x68\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAB"],
        ["\x68\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAC"],
        ["\x68\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAD"],
        ["\x68\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAE"],
        ["\x68\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAF"],
        ["\x68\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB0"],
        ["\x68\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB1"],
        ["\x68\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB2"],
        ["\x68\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB3"],
        ["\x68\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB4"],
        ["\x68\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB5"],
        ["\x68\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB6"],
        ["\x68\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB7"],
        ["\x68\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB8"],
        ["\x68\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB9"],
        ["\x68\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBA"],
        ["\x68\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBB"],
        ["\x68\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBC"],
        ["\x68\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBD"],
        ["\x68\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBE"],
        ["\x68\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBF"],
        ["\x68\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x80"],
        ["\x68\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x81"],
        ["\x68\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x82"],
        ["\x68\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x83"],
        ["\x68\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x84"],
        ["\x68\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x85"],
        ["\x68\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x86"],
        ["\x68\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x87"],
        ["\x68\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x88"],
        ["\x68\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x89"],
        ["\x68\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8A"],
        ["\x68\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8B"],
        ["\x68\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8C"],
        ["\x68\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8D"],
        ["\x68\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8E"],
        ["\x68\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8F"],
        ["\x68\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x90"],
        ["\x68\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x91"],
        ["\x68\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x92"],
        ["\x68\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x93"],
        ["\x68\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x94"],
        ["\x68\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x95"],
        ["\x68\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x96"],
        ["\x68\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x97"],
        ["\x68\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x98"],
        ["\x68\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x99"],
        ["\x68\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9A"],
        ["\x68\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9B"],
        ["\x68\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9C"],
        ["\x68\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9D"],
        ["\x68\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9E"],
        ["\x68\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9F"],
        ["\x68\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA0"],
        ["\x68\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA1"],
        ["\x68\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA2"],
        ["\x68\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA3"],
        ["\x68\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA4"],
        ["\x68\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA5"],
        ["\x68\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA6"],
        ["\x68\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA7"],
        ["\x68\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA8"],
        ["\x68\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA9"],
        ["\x68\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAA"],
        ["\x68\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAB"],
        ["\x68\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAC"],
        ["\x68\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAD"],
        ["\x68\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAE"],
        ["\x68\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAF"],
        ["\x69\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB0"],
        ["\x3C\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB1"],
        ["\x69\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB2"],
        ["\x69\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB3"],
        ["\x69\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB4"],
        ["\x69\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB5"],
        ["\x69\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB6"],
        ["\x69\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB7"],
        ["\x69\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB8"],
        ["\x69\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB9"],
        ["\x69\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBA"],
        ["\x69\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBB"],
        ["\x69\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBC"],
        ["\x4C\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBD"],
        ["\x69\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBE"],
        ["\x69\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBF"],
        ["\x69\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x80"],
        ["\x69\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x81"],
        ["\x69\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x82"],
        ["\x69\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x83"],
        ["\x69\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x84"],
        ["\x69\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x85"],
        ["\x69\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x86"],
        ["\x69\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x87"],
        ["\x69\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x88"],
        ["\x69\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x89"],
        ["\x69\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8A"],
        ["\x69\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8B"],
        ["\x69\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8C"],
        ["\x69\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8D"],
        ["\x69\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8E"],
        ["\x69\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8F"],
        ["\x69\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x90"],
        ["\x69\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x91"],
        ["\x69\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x92"],
        ["\x69\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x93"],
        ["\x69\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x94"],
        ["\x69\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x95"],
        ["\x69\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x96"],
        ["\x69\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x97"],
        ["\x69\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x98"],
        ["\x69\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x99"],
        ["\x69\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9A"],
        ["\x69\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9B"],
        ["\x69\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9C"],
        ["\x69\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9D"],
        ["\x69\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9E"],
        ["\x69\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9F"],
        ["\x69\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA0"],
        ["\x69\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA1"],
        ["\x69\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA2"],
        ["\x69\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA3"],
        ["\x69\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA4"],
        ["\x69\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA5"],
        ["\x69\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA6"],
        ["\x69\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA7"],
        ["\x69\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA8"],
        ["\x33\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA9"],
        ["\x69\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAA"],
        ["\x69\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAB"],
        ["\x69\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAC"],
        ["\x69\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAD"],
        ["\x69\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAE"],
        ["\x69\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAF"],
        ["\x69\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB0"],
        ["\x69\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB1"],
        ["\x69\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB2"],
        ["\x69\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB3"],
        ["\x69\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB4"],
        ["\x69\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB5"],
        ["\x69\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB6"],
        ["\x69\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB7"],
        ["\x69\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB8"],
        ["\x69\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB9"],
        ["\x69\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBA"],
        ["\x69\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBB"],
        ["\x69\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBC"],
        ["\x69\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBD"],
        ["\x69\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBE"],
        ["\x69\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBF"],
        ["\x69\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x80"],
        ["\x69\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x81"],
        ["\x69\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x82"],
        ["\x69\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x83"],
        ["\x69\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x84"],
        ["\x69\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x85"],
        ["\x69\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x86"],
        ["\x69\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x87"],
        ["\x69\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x88"],
        ["\x69\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x89"],
        ["\x69\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8A"],
        ["\x69\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8B"],
        ["\x69\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8C"],
        ["\x69\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8D"],
        ["\x6A\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8E"],
        ["\x6A\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8F"],
        ["\x6A\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x90"],
        ["\x47\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x91"],
        ["\x6A\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x92"],
        ["\x6A\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x93"],
        ["\x6A\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x94"],
        ["\x6A\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x95"],
        ["\x6A\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x96"],
        ["\x6A\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x97"],
        ["\x6A\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x98"],
        ["\x6A\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x99"],
        ["\x6A\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9A"],
        ["\x6A\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9B"],
        ["\x6A\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9C"],
        ["\x6A\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9D"],
        ["\x6A\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9E"],
        ["\x6A\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9F"],
        ["\x6A\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA0"],
        ["\x6A\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA1"],
        ["\x6A\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA2"],
        ["\x6A\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA3"],
        ["\x6A\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA4"],
        ["\x6A\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA5"],
        ["\x6A\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA6"],
        ["\x6A\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA7"],
        ["\x6A\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA8"],
        ["\x6A\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA9"],
        ["\x6A\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAA"],
        ["\x6A\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAB"],
        ["\x6A\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAC"],
        ["\x6A\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAD"],
        ["\x6A\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAE"],
        ["\x6A\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAF"],
        ["\x6A\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB0"],
        ["\x6A\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB1"],
        ["\x6A\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB2"],
        ["\x6A\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB3"],
        ["\x6A\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB4"],
        ["\x6A\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB5"],
        ["\x6A\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB6"],
        ["\x6A\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB7"],
        ["\x6A\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB8"],
        ["\x6A\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB9"],
        ["\x6A\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBA"],
        ["\x6A\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBB"],
        ["\x6A\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBC"],
        ["\x6A\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBD"],
        ["\x6A\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBE"],
        ["\x6A\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBF"],
        ["\x6A\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x80"],
        ["\x6A\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x81"],
        ["\x6A\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x82"],
        ["\x6A\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x83"],
        ["\x6A\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x84"],
        ["\x6A\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x85"],
        ["\x6A\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x86"],
        ["\x6A\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x87"],
        ["\x6A\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x88"],
        ["\x6A\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x89"],
        ["\x6A\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8A"],
        ["\x6A\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8B"],
        ["\x6A\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8C"],
        ["\x6A\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8D"],
        ["\x6A\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8E"],
        ["\x6A\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8F"],
        ["\x6A\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x90"],
        ["\x6A\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x91"],
        ["\x6A\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x92"],
        ["\x6A\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x93"],
        ["\x6A\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x94"],
        ["\x6A\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x95"],
        ["\x6A\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x96"],
        ["\x6A\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x97"],
        ["\x6A\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x98"],
        ["\x6A\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x99"],
        ["\x6A\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9A"],
        ["\x6A\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9B"],
        ["\x6A\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9C"],
        ["\x6A\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9D"],
        ["\x6A\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9E"],
        ["\x6A\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9F"],
        ["\x6A\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA0"],
        ["\x6A\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA1"],
        ["\x6A\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA2"],
        ["\x6A\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA3"],
        ["\x6A\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA4"],
        ["\x6A\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA5"],
        ["\x6A\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA6"],
        ["\x6A\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA7"],
        ["\x6A\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA8"],
        ["\x6A\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA9"],
        ["\x6A\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAA"],
        ["\x6A\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAB"],
        ["\x6B\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAC"],
        ["\x6B\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAD"],
        ["\x6B\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAE"],
        ["\x6B\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAF"],
        ["\x6B\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB0"],
        ["\x6B\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB1"],
        ["\x6B\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB2"],
        ["\x6B\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB3"],
        ["\x6B\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB4"],
        ["\x6B\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB5"],
        ["\x6B\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB6"],
        ["\x6B\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB7"],
        ["\x6B\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB8"],
        ["\x6B\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB9"],
        ["\x6B\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBA"],
        ["\x6B\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBB"],
        ["\x6B\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBC"],
        ["\x6B\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBD"],
        ["\x6B\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBE"],
        ["\x6B\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBF"],
        ["\x6B\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x80"],
        ["\x6B\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x81"],
        ["\x6B\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x82"],
        ["\x6B\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x83"],
        ["\x6B\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x84"],
        ["\x6B\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x85"],
        ["\x6B\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x86"],
        ["\x6B\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x87"],
        ["\x6B\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x88"],
        ["\x6B\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x89"],
        ["\x6B\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8A"],
        ["\x6B\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8B"],
        ["\x6B\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8C"],
        ["\x6B\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8D"],
        ["\x6B\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8E"],
        ["\x6B\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8F"],
        ["\x6B\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x90"],
        ["\x6B\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x91"],
        ["\x6B\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x92"],
        ["\x6B\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x93"],
        ["\x6B\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x94"],
        ["\x6B\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x95"],
        ["\x6B\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x96"],
        ["\x6B\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x97"],
        ["\x6B\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x98"],
        ["\x6B\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x99"],
        ["\x6B\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9A"],
        ["\x6B\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9B"],
        ["\x6B\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9C"],
        ["\x6B\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9D"],
        ["\x6B\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9E"],
        ["\x6B\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9F"],
        ["\x6B\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA0"],
        ["\x6B\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA1"],
        ["\x6B\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA2"],
        ["\x6B\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA3"],
        ["\x6B\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA4"],
        ["\x6B\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA5"],
        ["\x6B\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA6"],
        ["\x6B\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA7"],
        ["\x34\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA8"],
        ["\x6B\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA9"],
        ["\x6B\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAA"],
        ["\x6B\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAB"],
        ["\x6B\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAC"],
        ["\x6B\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAD"],
        ["\x6B\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAE"],
        ["\x6B\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAF"],
        ["\x6B\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB0"],
        ["\x6B\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB1"],
        ["\x6B\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB2"],
        ["\x6B\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB3"],
        ["\x6B\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB4"],
        ["\x6B\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB5"],
        ["\x6B\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB6"],
        ["\x6B\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB7"],
        ["\x6B\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB8"],
        ["\x6B\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB9"],
        ["\x6B\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBA"],
        ["\x6B\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBB"],
        ["\x6B\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBC"],
        ["\x6B\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBD"],
        ["\x6B\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBE"],
        ["\x6B\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBF"],
        ["\x6B\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x80"],
        ["\x6B\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x81"],
        ["\x6B\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x82"],
        ["\x6B\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x83"],
        ["\x6B\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x84"],
        ["\x6B\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x85"],
        ["\x6B\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x86"],
        ["\x6B\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x87"],
        ["\x6B\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x88"],
        ["\x6B\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x89"],
        ["\x6C\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8A"],
        ["\x6C\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8B"],
        ["\x6C\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8C"],
        ["\x6C\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8D"],
        ["\x6C\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8E"],
        ["\x6C\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8F"],
        ["\x6C\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x90"],
        ["\x6C\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x91"],
        ["\x6C\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x92"],
        ["\x6C\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x93"],
        ["\x6C\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x94"],
        ["\x6C\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x95"],
        ["\x6C\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x96"],
        ["\x6C\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x97"],
        ["\x6C\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x98"],
        ["\x6C\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x99"],
        ["\x6C\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9A"],
        ["\x6C\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9B"],
        ["\x6C\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9C"],
        ["\x6C\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9D"],
        ["\x6C\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9E"],
        ["\x6C\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9F"],
        ["\x6C\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA0"],
        ["\x6C\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA1"],
        ["\x6C\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA2"],
        ["\x6C\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA3"],
        ["\x6C\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA4"],
        ["\x6C\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA5"],
        ["\x6C\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA6"],
        ["\x6C\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA7"],
        ["\x6C\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA8"],
        ["\x6C\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA9"],
        ["\x6C\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAA"],
        ["\x6C\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAB"],
        ["\x6C\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAC"],
        ["\x6C\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAD"],
        ["\x6C\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAE"],
        ["\x6C\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAF"],
        ["\x6C\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB0"],
        ["\x6C\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB1"],
        ["\x6C\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB2"],
        ["\x6C\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB3"],
        ["\x6C\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB4"],
        ["\x6C\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB5"],
        ["\x41\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB6"],
        ["\x6C\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB7"],
        ["\x6C\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB8"],
        ["\x6C\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB9"],
        ["\x6C\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBA"],
        ["\x6C\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBB"],
        ["\x6C\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBC"],
        ["\x6C\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBD"],
        ["\x6C\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBE"],
        ["\x6C\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBF"],
        ["\x6C\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x80"],
        ["\x6C\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x81"],
        ["\x6C\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x82"],
        ["\x6C\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x83"],
        ["\x6C\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x84"],
        ["\x6C\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x85"],
        ["\x6C\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x86"],
        ["\x6C\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x87"],
        ["\x6C\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x88"],
        ["\x6C\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x89"],
        ["\x6C\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8A"],
        ["\x6C\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8B"],
        ["\x6C\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8C"],
        ["\x6C\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8D"],
        ["\x6C\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8E"],
        ["\x6C\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8F"],
        ["\x6C\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x90"],
        ["\x6C\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x91"],
        ["\x6C\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x92"],
        ["\x6C\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x93"],
        ["\x6C\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x94"],
        ["\x6C\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x95"],
        ["\x6C\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x96"],
        ["\x6C\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x97"],
        ["\x6C\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x98"],
        ["\x6C\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x99"],
        ["\x6C\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9A"],
        ["\x6C\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9B"],
        ["\x6C\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9C"],
        ["\x6C\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9D"],
        ["\x6C\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9E"],
        ["\x6C\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9F"],
        ["\x6C\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA0"],
        ["\x6C\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA1"],
        ["\x6C\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA2"],
        ["\x6C\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA3"],
        ["\x6C\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA4"],
        ["\x6C\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA5"],
        ["\x6C\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA6"],
        ["\x6C\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA7"],
        ["\x6D\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA8"],
        ["\x6D\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA9"],
        ["\x6D\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAA"],
        ["\x6D\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAB"],
        ["\x6D\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAC"],
        ["\x6D\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAD"],
        ["\x6D\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAE"],
        ["\x6D\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAF"],
        ["\x6D\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB0"],
        ["\x6D\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB1"],
        ["\x6D\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB2"],
        ["\x6D\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB3"],
        ["\x6D\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB4"],
        ["\x6D\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB5"],
        ["\x6D\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB6"],
        ["\x6D\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB7"],
        ["\x6D\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB8"],
        ["\x6D\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB9"],
        ["\x6D\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBA"],
        ["\x6D\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBB"],
        ["\x6D\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBC"],
        ["\x6D\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBD"],
        ["\x6D\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBE"],
        ["\x6D\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBF"],
        ["\x6D\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x80"],
        ["\x6D\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x81"],
        ["\x6D\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x82"],
        ["\x6D\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x83"],
        ["\x6D\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x84"],
        ["\x6D\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x85"],
        ["\x6D\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x86"],
        ["\x6D\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x87"],
        ["\x6D\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x88"],
        ["\x6D\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x89"],
        ["\x6D\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8A"],
        ["\x6D\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8B"],
        ["\x6D\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8C"],
        ["\x6D\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8D"],
        ["\x6D\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8E"],
        ["\x6D\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8F"],
        ["\x6D\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x90"],
        ["\x6D\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x91"],
        ["\x6D\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x92"],
        ["\x6D\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x93"],
        ["\x6D\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x94"],
        ["\x6D\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x95"],
        ["\x6D\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x96"],
        ["\x6D\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x97"],
        ["\x6D\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x98"],
        ["\x6D\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x99"],
        ["\x6D\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9A"],
        ["\x6D\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9B"],
        ["\x6D\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9C"],
        ["\x6D\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9D"],
        ["\x6D\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9E"],
        ["\x6D\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9F"],
        ["\x6D\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA0"],
        ["\x6D\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA1"],
        ["\x6D\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA2"],
        ["\x6D\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA3"],
        ["\x6D\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA4"],
        ["\x6D\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA5"],
        ["\x6D\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA6"],
        ["\x6D\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA7"],
        ["\x6D\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA8"],
        ["\x6D\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA9"],
        ["\x6D\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAA"],
        ["\x6D\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAB"],
        ["\x6D\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAC"],
        ["\x6D\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAD"],
        ["\x6D\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAE"],
        ["\x6D\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAF"],
        ["\x6D\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB0"],
        ["\x6D\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB1"],
        ["\x6D\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB2"],
        ["\x6D\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB3"],
        ["\x6D\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB4"],
        ["\x46\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB5"],
        ["\x6D\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB6"],
        ["\x6D\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB7"],
        ["\x6D\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB8"],
        ["\x6D\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB9"],
        ["\x6D\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBA"],
        ["\x6D\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBB"],
        ["\x6D\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBC"],
        ["\x6D\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBD"],
        ["\x6D\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBE"],
        ["\x6D\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBF"],
        ["\x6D\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x80"],
        ["\x6D\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x81"],
        ["\x6D\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x82"],
        ["\x6D\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x83"],
        ["\x6D\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x84"],
        ["\x6D\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x85"],
        ["\x6E\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x86"],
        ["\x6E\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x87"],
        ["\x6E\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x88"],
        ["\x6E\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x89"],
        ["\x6E\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8A"],
        ["\x6E\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8B"],
        ["\x6E\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8C"],
        ["\x6E\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8D"],
        ["\x6E\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8E"],
        ["\x6E\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8F"],
        ["\x6E\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x90"],
        ["\x6E\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x91"],
        ["\x6E\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x92"],
        ["\x6E\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x93"],
        ["\x6E\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x94"],
        ["\x6E\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x95"],
        ["\x6E\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x96"],
        ["\x6E\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x97"],
        ["\x6E\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x98"],
        ["\x6E\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x99"],
        ["\x6E\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9A"],
        ["\x6E\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9B"],
        ["\x6E\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9C"],
        ["\x6E\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9D"],
        ["\x6E\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9E"],
        ["\x6E\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9F"],
        ["\x6E\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA0"],
        ["\x6E\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA1"],
        ["\x6E\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA2"],
        ["\x6E\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA3"],
        ["\x6E\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA4"],
        ["\x6E\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA5"],
        ["\x6E\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA6"],
        ["\x6E\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA7"],
        ["\x6E\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA8"],
        ["\x6E\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA9"],
        ["\x6E\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAA"],
        ["\x6E\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAB"],
        ["\x6E\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAC"],
        ["\x6E\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAD"],
        ["\x6E\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAE"],
        ["\x6E\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAF"],
        ["\x6E\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB0"],
        ["\x6E\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB1"],
        ["\x6E\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB2"],
        ["\x6E\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB3"],
        ["\x6E\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB4"],
        ["\x6E\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB5"],
        ["\x6E\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB6"],
        ["\x6E\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB7"],
        ["\x6E\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB8"],
        ["\x6E\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB9"],
        ["\x6E\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBA"],
        ["\x6E\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBB"],
        ["\x6E\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBC"],
        ["\x6E\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBD"],
        ["\x6E\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBE"],
        ["\x6E\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBF"],
        ["\x6E\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x80"],
        ["\x6E\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x81"],
        ["\x6E\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x82"],
        ["\x6E\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x83"],
        ["\x6E\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x84"],
        ["\x6E\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x85"],
        ["\x6E\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x86"],
        ["\x6E\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x87"],
        ["\x6E\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x88"],
        ["\x6E\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x89"],
        ["\x6E\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8A"],
        ["\x6E\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8B"],
        ["\x6E\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8C"],
        ["\x6E\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8D"],
        ["\x6E\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8E"],
        ["\x6E\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8F"],
        ["\x6E\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x90"],
        ["\x6E\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x91"],
        ["\x6E\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x92"],
        ["\x6E\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x93"],
        ["\x6E\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x94"],
        ["\x6E\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x95"],
        ["\x6E\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x96"],
        ["\x6E\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x97"],
        ["\x6E\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x98"],
        ["\x6E\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x99"],
        ["\x6E\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9A"],
        ["\x6E\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9B"],
        ["\x6E\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9C"],
        ["\x6E\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9D"],
        ["\x6E\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9E"],
        ["\x6E\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9F"],
        ["\x6E\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA0"],
        ["\x6E\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA1"],
        ["\x6E\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA2"],
        ["\x6E\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA3"],
        ["\x6F\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA4"],
        ["\x6F\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA5"],
        ["\x6F\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA6"],
        ["\x6F\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA7"],
        ["\x6F\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA8"],
        ["\x6F\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA9"],
        ["\x6F\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAA"],
        ["\x6F\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAB"],
        ["\x6F\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAC"],
        ["\x6F\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAD"],
        ["\x6F\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAE"],
        ["\x6F\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAF"],
        ["\x6F\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB0"],
        ["\x6F\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB1"],
        ["\x6F\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB2"],
        ["\x6F\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB3"],
        ["\x6F\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB4"],
        ["\x6F\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB5"],
        ["\x6F\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB6"],
        ["\x6F\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB7"],
        ["\x6F\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB8"],
        ["\x6F\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB9"],
        ["\x6F\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBA"],
        ["\x6F\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBB"],
        ["\x6F\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBC"],
        ["\x6F\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBD"],
        ["\x6F\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBE"],
        ["\x6F\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBF"],
        ["\x6F\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x80"],
        ["\x6F\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x81"],
        ["\x6F\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x82"],
        ["\x6F\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x83"],
        ["\x6F\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x84"],
        ["\x6F\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x85"],
        ["\x6F\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x86"],
        ["\x6F\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x87"],
        ["\x6F\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x88"],
        ["\x6F\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x89"],
        ["\x6F\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8A"],
        ["\x6F\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8B"],
        ["\x6F\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8C"],
        ["\x6F\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8D"],
        ["\x6F\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8E"],
        ["\x6F\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8F"],
        ["\x6F\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x90"],
        ["\x6F\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x91"],
        ["\x6F\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x92"],
        ["\x6F\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x93"],
        ["\x6F\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x94"],
        ["\x6F\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x95"],
        ["\x6F\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x96"],
        ["\x6F\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x97"],
        ["\x6F\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x98"],
        ["\x6F\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x99"],
        ["\x6F\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9A"],
        ["\x6F\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9B"],
        ["\x6F\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9C"],
        ["\x6F\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9D"],
        ["\x6F\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9E"],
        ["\x6F\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9F"],
        ["\x6F\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA0"],
        ["\x6F\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA1"],
        ["\x6F\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA2"],
        ["\x6F\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA3"],
        ["\x6F\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA4"],
        ["\x6F\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA5"],
        ["\x6F\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA6"],
        ["\x6F\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA7"],
        ["\x6F\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA8"],
        ["\x6F\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA9"],
        ["\x6F\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAA"],
        ["\x6F\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAB"],
        ["\x6F\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAC"],
        ["\x6F\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAD"],
        ["\x6F\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAE"],
        ["\x6F\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAF"],
        ["\x6F\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB0"],
        ["\x6F\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB1"],
        ["\x6F\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB2"],
        ["\x6F\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB3"],
        ["\x6F\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB4"],
        ["\x6F\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB5"],
        ["\x6F\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB6"],
        ["\x6F\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB7"],
        ["\x6F\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB8"],
        ["\x6F\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB9"],
        ["\x6F\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBA"],
        ["\x6F\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBB"],
        ["\x6F\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBC"],
        ["\x6F\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBD"],
        ["\x6F\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBE"],
        ["\x6F\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBF"],
        ["\x6F\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x80"],
        ["\x6F\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x81"],
        ["\x70\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x82"],
        ["\x70\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x83"],
        ["\x70\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x84"],
        ["\x70\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x85"],
        ["\x70\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x86"],
        ["\x70\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x87"],
        ["\x70\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x88"],
        ["\x70\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x89"],
        ["\x70\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8A"],
        ["\x70\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8B"],
        ["\x70\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8C"],
        ["\x70\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8D"],
        ["\x70\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8E"],
        ["\x70\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8F"],
        ["\x70\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x90"],
        ["\x70\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x91"],
        ["\x70\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x92"],
        ["\x70\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x93"],
        ["\x70\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x94"],
        ["\x70\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x95"],
        ["\x70\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x96"],
        ["\x70\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x97"],
        ["\x70\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x98"],
        ["\x70\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x99"],
        ["\x70\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9A"],
        ["\x70\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9B"],
        ["\x70\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9C"],
        ["\x70\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9D"],
        ["\x70\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9E"],
        ["\x70\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9F"],
        ["\x70\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA0"],
        ["\x70\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA1"],
        ["\x70\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA2"],
        ["\x70\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA3"],
        ["\x70\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA4"],
        ["\x70\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA5"],
        ["\x70\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA6"],
        ["\x70\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA7"],
        ["\x70\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA8"],
        ["\x70\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA9"],
        ["\x70\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAA"],
        ["\x70\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAB"],
        ["\x70\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAC"],
        ["\x70\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAD"],
        ["\x70\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAE"],
        ["\x70\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAF"],
        ["\x70\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB0"],
        ["\x70\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB1"],
        ["\x70\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB2"],
        ["\x70\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB3"],
        ["\x70\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB4"],
        ["\x70\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB5"],
        ["\x70\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB6"],
        ["\x70\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB7"],
        ["\x3F\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB8"],
        ["\x70\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB9"],
        ["\x70\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBA"],
        ["\x70\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBB"],
        ["\x70\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBC"],
        ["\x70\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBD"],
        ["\x70\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBE"],
        ["\x70\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBF"],
        ["\x70\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x80"],
        ["\x70\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x81"],
        ["\x70\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x82"],
        ["\x70\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x83"],
        ["\x70\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x84"],
        ["\x70\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x85"],
        ["\x70\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x86"],
        ["\x70\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x87"],
        ["\x70\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x88"],
        ["\x70\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x89"],
        ["\x70\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8A"],
        ["\x70\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8B"],
        ["\x70\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8C"],
        ["\x70\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8D"],
        ["\x70\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8E"],
        ["\x70\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8F"],
        ["\x70\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x90"],
        ["\x70\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x91"],
        ["\x70\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x92"],
        ["\x70\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x93"],
        ["\x70\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x94"],
        ["\x37\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x95"],
        ["\x70\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x96"],
        ["\x70\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x97"],
        ["\x70\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x98"],
        ["\x70\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x99"],
        ["\x70\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9A"],
        ["\x70\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9B"],
        ["\x70\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9C"],
        ["\x70\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9D"],
        ["\x70\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9E"],
        ["\x70\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9F"],
        ["\x71\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA0"],
        ["\x71\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA1"],
        ["\x71\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA2"],
        ["\x71\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA3"],
        ["\x71\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA4"],
        ["\x71\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA5"],
        ["\x71\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA6"],
        ["\x71\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA7"],
        ["\x71\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA8"],
        ["\x71\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA9"],
        ["\x71\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAA"],
        ["\x71\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAB"],
        ["\x71\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAC"],
        ["\x71\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAD"],
        ["\x71\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAE"],
        ["\x71\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAF"],
        ["\x71\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB0"],
        ["\x71\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB1"],
        ["\x71\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB2"],
        ["\x71\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB3"],
        ["\x71\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB4"],
        ["\x71\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB5"],
        ["\x71\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB6"],
        ["\x71\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB7"],
        ["\x71\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB8"],
        ["\x71\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB9"],
        ["\x71\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBA"],
        ["\x71\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBB"],
        ["\x71\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBC"],
        ["\x71\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBD"],
        ["\x71\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBE"],
        ["\x71\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBF"],
        ["\x71\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x80"],
        ["\x71\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x81"],
        ["\x71\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x82"],
        ["\x71\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x83"],
        ["\x71\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x84"],
        ["\x71\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x85"],
        ["\x71\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x86"],
        ["\x71\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x87"],
        ["\x71\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x88"],
        ["\x71\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x89"],
        ["\x71\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8A"],
        ["\x71\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8B"],
        ["\x71\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8C"],
        ["\x71\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8D"],
        ["\x71\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8E"],
        ["\x71\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8F"],
        ["\x71\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x90"],
        ["\x71\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x91"],
        ["\x71\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x92"],
        ["\x71\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x93"],
        ["\x71\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x94"],
        ["\x71\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x95"],
        ["\x71\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x96"],
        ["\x71\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x97"],
        ["\x71\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x98"],
        ["\x71\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x99"],
        ["\x71\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9A"],
        ["\x71\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9B"],
        ["\x71\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9C"],
        ["\x71\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9D"],
        ["\x71\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9E"],
        ["\x71\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9F"],
        ["\x71\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA0"],
        ["\x71\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA1"],
        ["\x71\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA2"],
        ["\x71\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA3"],
        ["\x71\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA4"],
        ["\x71\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA5"],
        ["\x71\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA6"],
        ["\x71\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA7"],
        ["\x71\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA8"],
        ["\x71\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA9"],
        ["\x71\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAA"],
        ["\x71\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAB"],
        ["\x71\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAC"],
        ["\x71\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAD"],
        ["\x71\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAE"],
        ["\x71\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAF"],
        ["\x71\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB0"],
        ["\x71\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB1"],
        ["\x71\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB2"],
        ["\x71\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB3"],
        ["\x71\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB4"],
        ["\x71\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB5"],
        ["\x71\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB6"],
        ["\x71\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB7"],
        ["\x71\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB8"],
        ["\x71\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB9"],
        ["\x71\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBA"],
        ["\x71\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBB"],
        ["\x71\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBC"],
        ["\x71\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBD"],
        ["\x72\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBE"],
        ["\x72\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBF"],
        ["\x72\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x80"],
        ["\x72\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x81"],
        ["\x72\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x82"],
        ["\x72\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x83"],
        ["\x72\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x84"],
        ["\x72\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x85"],
        ["\x72\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x86"],
        ["\x72\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x87"],
        ["\x72\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x88"],
        ["\x72\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x89"],
        ["\x72\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8A"],
        ["\x72\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8B"],
        ["\x72\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8C"],
        ["\x72\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8D"],
        ["\x72\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8E"],
        ["\x72\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8F"],
        ["\x72\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x90"],
        ["\x72\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x91"],
        ["\x72\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x92"],
        ["\x72\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x93"],
        ["\x72\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x94"],
        ["\x72\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x95"],
        ["\x72\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x96"],
        ["\x72\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x97"],
        ["\x72\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x98"],
        ["\x72\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x99"],
        ["\x72\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9A"],
        ["\x72\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9B"],
        ["\x72\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9C"],
        ["\x72\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9D"],
        ["\x72\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9E"],
        ["\x72\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9F"],
        ["\x72\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA0"],
        ["\x72\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA1"],
        ["\x72\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA2"],
        ["\x72\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA3"],
        ["\x72\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA4"],
        ["\x72\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA5"],
        ["\x72\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA6"],
        ["\x72\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA7"],
        ["\x72\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA8"],
        ["\x72\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA9"],
        ["\x30\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAA"],
        ["\x72\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAB"],
        ["\x72\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAC"],
        ["\x72\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAD"],
        ["\x72\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAE"],
        ["\x72\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAF"],
        ["\x72\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB0"],
        ["\x72\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB1"],
        ["\x72\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB2"],
        ["\x72\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB3"],
        ["\x72\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB4"],
        ["\x72\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB5"],
        ["\x72\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB6"],
        ["\x72\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB7"],
        ["\x72\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB8"],
        ["\x72\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB9"],
        ["\x72\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBA"],
        ["\x72\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBB"],
        ["\x72\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBC"],
        ["\x72\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBD"],
        ["\x72\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBE"],
        ["\x72\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBF"],
        ["\x72\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x80"],
        ["\x72\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x81"],
        ["\x72\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x82"],
        ["\x72\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x83"],
        ["\x72\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x84"],
        ["\x72\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x85"],
        ["\x72\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x86"],
        ["\x72\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x87"],
        ["\x72\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x88"],
        ["\x72\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x89"],
        ["\x72\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8A"],
        ["\x72\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8B"],
        ["\x72\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8C"],
        ["\x72\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8D"],
        ["\x72\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8E"],
        ["\x72\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8F"],
        ["\x72\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x90"],
        ["\x32\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x91"],
        ["\x72\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x92"],
        ["\x72\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x93"],
        ["\x72\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x94"],
        ["\x72\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x95"],
        ["\x72\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x96"],
        ["\x72\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x97"],
        ["\x72\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x98"],
        ["\x72\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x99"],
        ["\x72\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9A"],
        ["\x72\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9B"],
        ["\x73\x21",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9C"],
        ["\x73\x22",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9D"],
        ["\x73\x23",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9E"],
        ["\x73\x24",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9F"],
        ["\x73\x25",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA0"],
        ["\x73\x26",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA1"],
        ["\x73\x27",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA2"],
        ["\x73\x28",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA3"],
        ["\x73\x29",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA4"],
        ["\x73\x2A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA5"],
        ["\x73\x2B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA6"],
        ["\x73\x2C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA7"],
        ["\x73\x2D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA8"],
        ["\x73\x2E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA9"],
        ["\x73\x2F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAA"],
        ["\x73\x30",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAB"],
        ["\x73\x31",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAC"],
        ["\x73\x32",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAD"],
        ["\x73\x33",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAE"],
        ["\x73\x34",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAF"],
        ["\x73\x35",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB0"],
        ["\x73\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB1"],
        ["\x73\x37",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB2"],
        ["\x73\x38",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB3"],
        ["\x73\x39",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB4"],
        ["\x73\x3A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB5"],
        ["\x73\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB6"],
        ["\x73\x3C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB7"],
        ["\x73\x3D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB8"],
        ["\x73\x3E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB9"],
        ["\x73\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBA"],
        ["\x73\x40",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBB"],
        ["\x73\x41",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBC"],
        ["\x73\x42",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBD"],
        ["\x73\x43",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBE"],
        ["\x73\x44",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBF"],
        ["\x73\x45",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x80"],
        ["\x73\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x81"],
        ["\x73\x47",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x82"],
        ["\x73\x48",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x83"],
        ["\x73\x49",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x84"],
        ["\x73\x4A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x85"],
        ["\x73\x4B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x86"],
        ["\x73\x4C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x87"],
        ["\x73\x4D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x88"],
        ["\x73\x4E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x89"],
        ["\x73\x4F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8A"],
        ["\x73\x50",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8B"],
        ["\x73\x51",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8C"],
        ["\x73\x52",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8D"],
        ["\x73\x53",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8E"],
        ["\x73\x54",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8F"],
        ["\x73\x55",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x90"],
        ["\x73\x56",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x91"],
        ["\x73\x57",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x92"],
        ["\x73\x58",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x93"],
        ["\x73\x59",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x94"],
        ["\x73\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x95"],
        ["\x73\x5B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x96"],
        ["\x73\x5C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x97"],
        ["\x73\x5D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x98"],
        ["\x73\x5E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x99"],
        ["\x73\x5F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9A"],
        ["\x73\x60",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9B"],
        ["\x73\x61",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9C"],
        ["\x73\x62",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9D"],
        ["\x73\x63",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9E"],
        ["\x73\x64",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9F"],
        ["\x73\x65",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA0"],
        ["\x73\x66",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA1"],
        ["\x73\x67",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA2"],
        ["\x73\x68",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA3"],
        ["\x73\x69",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA4"],
        ["\x73\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA5"],
        ["\x73\x6B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA6"],
        ["\x73\x6C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA7"],
        ["\x73\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA8"],
        ["\x73\x6E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA9"],
        ["\x73\x6F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAA"],
        ["\x73\x70",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAB"],
        ["\x73\x71",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAC"],
        ["\x73\x72",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAD"],
        ["\x73\x73",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAE"],
        ["\x73\x74",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAF"],
        ["\x73\x75",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB0"],
        ["\x73\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB1"],
        ["\x73\x77",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB2"],
        ["\x73\x78",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB3"],
        ["\x73\x79",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB4"],
        ["\x73\x7A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB5"],
        ["\x73\x7B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB6"],
        ["\x73\x7C",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB7"],
        ["\x73\x7D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB8"],
        ["\x73\x7E",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB9"],
        ["\x36\x46",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBA"],
        ["\x4B\x6A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBB"],
        ["\x4D\x5A",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBC"],
        ["\x60\x76",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBD"],
        ["\xB4\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBE"],
        ["\xC3\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBF"],
        ["\xA2\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9C"],
        ["\xA2\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9D"],
        ["\xA2\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9E"],
        ["\xA2\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\x9F"],
        ["\xA2\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA0"],
        ["\xA2\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA1"],
        ["\xA2\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA2"],
        ["\xA2\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA3"],
        ["\xA2\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA4"],
        ["\xA2\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xA5"],
        ["\xA5\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB1"],
        ["\xC9\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB8"],
        ["\xCE\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB9"],
        ["\xCC\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBC"],
        ["\xB2\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBD"],
        ["\xBD\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBF"],
        ["\xBF\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x80"],
        ["\xD2\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x81"],
        ["\xBD\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x82"],
        ["\xB2\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x84"],
        ["\xB2\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x85"],
        ["\xB2\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x87"],
        ["\xB2\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x88"],
        ["\xB2\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x89"],
        ["\xB2\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8A"],
        ["\xB2\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8B"],
        ["\xB2\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8C"],
        ["\xBA\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8D"],
        ["\xB2\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8E"],
        ["\xB2\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8F"],
        ["\xB3\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x90"],
        ["\xB3\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x91"],
        ["\xB3\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x92"],
        ["\xB3\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x93"],
        ["\xB3\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x94"],
        ["\xB3\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x95"],
        ["\xB3\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x96"],
        ["\xB3\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x97"],
        ["\xB3\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x99"],
        ["\xB3\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9A"],
        ["\xB3\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9B"],
        ["\xB3\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9C"],
        ["\xB4\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9D"],
        ["\xB4\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9F"],
        ["\xB4\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA0"],
        ["\xB4\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA1"],
        ["\xB4\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA2"],
        ["\xB4\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA3"],
        ["\xB4\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA4"],
        ["\xB5\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA7"],
        ["\xB5\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA8"],
        ["\xB5\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA9"],
        ["\xB5\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAA"],
        ["\xB5\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAC"],
        ["\xB5\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAE"],
        ["\xB5\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAF"],
        ["\xB5\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB0"],
        ["\xB6\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB2"],
        ["\xB6\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB3"],
        ["\xB6\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB4"],
        ["\xB6\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB5"],
        ["\xB7\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB9"],
        ["\xB7\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBA"],
        ["\xB7\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBC"],
        ["\xB7\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBD"],
        ["\xB7\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBF"],
        ["\xB7\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x80"],
        ["\xB8\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x81"],
        ["\xB8\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x82"],
        ["\xB8\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x83"],
        ["\xB8\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x84"],
        ["\xB8\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x86"],
        ["\xB8\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x87"],
        ["\xB8\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x88"],
        ["\xB9\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8D"],
        ["\xB9\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8E"],
        ["\xB9\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8F"],
        ["\xB9\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x90"],
        ["\xB9\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x91"],
        ["\xBA\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x92"],
        ["\xBA\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x93"],
        ["\xBA\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x94"],
        ["\xB5\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x99"],
        ["\xBB\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9A"],
        ["\xBB\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9B"],
        ["\xBB\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9D"],
        ["\xBB\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9F"],
        ["\xBB\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA0"],
        ["\xB6\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA1"],
        ["\xBB\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA2"],
        ["\xBC\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA3"],
        ["\xBC\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA6"],
        ["\xBC\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA7"],
        ["\xBD\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA9"],
        ["\xBD\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAA"],
        ["\xBD\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAC"],
        ["\xBD\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAD"],
        ["\xBD\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAE"],
        ["\xBD\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAF"],
        ["\xBD\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB1"],
        ["\xBD\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB2"],
        ["\xBD\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB4"],
        ["\xBD\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB5"],
        ["\xC5\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB6"],
        ["\xBE\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB7"],
        ["\xBE\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB8"],
        ["\xBE\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBA"],
        ["\xBE\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBC"],
        ["\xBE\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBD"],
        ["\xBE\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBE"],
        ["\xBE\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBF"],
        ["\xBE\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x81"],
        ["\xBF\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x84"],
        ["\xC6\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x86"],
        ["\xBF\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x87"],
        ["\xBF\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x88"],
        ["\xBF\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8A"],
        ["\xBF\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8B"],
        ["\xBF\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8C"],
        ["\xC0\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8E"],
        ["\xC0\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8F"],
        ["\xC0\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x90"],
        ["\xC0\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x91"],
        ["\xC0\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x92"],
        ["\xC0\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x93"],
        ["\xC0\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x94"],
        ["\xC1\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x95"],
        ["\xC1\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x96"],
        ["\xC1\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x97"],
        ["\xC1\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x98"],
        ["\xC1\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x99"],
        ["\xC1\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9D"],
        ["\xC1\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9E"],
        ["\xC1\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9F"],
        ["\xC1\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA1"],
        ["\xC2\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA2"],
        ["\xC2\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA3"],
        ["\xC2\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA4"],
        ["\xC2\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA5"],
        ["\xC2\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA6"],
        ["\xC2\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA7"],
        ["\xC2\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA9"],
        ["\xC2\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAA"],
        ["\xC3\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAB"],
        ["\xC3\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAC"],
        ["\xC3\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAD"],
        ["\xC3\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAE"],
        ["\xC3\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAF"],
        ["\xC3\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB2"],
        ["\xC3\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB3"],
        ["\xC3\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB4"],
        ["\xC3\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB5"],
        ["\xC4\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB7"],
        ["\xC4\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB8"],
        ["\xC4\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB9"],
        ["\xC4\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBA"],
        ["\xC4\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBB"],
        ["\xC4\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBC"],
        ["\xC4\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBD"],
        ["\xC4\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBF"],
        ["\xC4\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x80"],
        ["\xC4\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x81"],
        ["\xC4\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x82"],
        ["\xC4\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x84"],
        ["\xC4\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x85"],
        ["\xC5\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x87"],
        ["\xC5\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x89"],
        ["\xC5\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8B"],
        ["\xC5\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8C"],
        ["\xC5\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8E"],
        ["\xB4\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8F"],
        ["\xC6\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x90"],
        ["\xC6\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x91"],
        ["\xC6\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x92"],
        ["\xC6\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x93"],
        ["\xC7\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x98"],
        ["\xC7\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9A"],
        ["\xC7\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9B"],
        ["\xC7\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9E"],
        ["\xC8\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9F"],
        ["\xC9\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA1"],
        ["\xC9\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA3"],
        ["\xC9\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA6"],
        ["\xBF\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA7"],
        ["\xC9\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA8"],
        ["\xCB\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAA"],
        ["\xCB\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAC"],
        ["\xCC\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAD"],
        ["\xCB\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAE"],
        ["\xCC\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAF"],
        ["\xCC\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB0"],
        ["\xCC\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB1"],
        ["\xCC\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB2"],
        ["\xCC\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB3"],
        ["\xCE\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBA"],
        ["\xCE\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBB"],
        ["\xCE\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBC"],
        ["\xCE\xE2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBD"],
        ["\xCE\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBE"],
        ["\xCE\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBF"],
        ["\xCE\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x81"],
        ["\xCE\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x82"],
        ["\xCF\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x84"],
        ["\xCF\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x86"],
        ["\xCF\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x89"],
        ["\xD0\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x90"],
        ["\xD1\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x91"],
        ["\xD1\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x92"],
        ["\xD1\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x93"],
        ["\xD1\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x94"],
        ["\xD1\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x95"],
        ["\xD1\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x96"],
        ["\xD1\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x97"],
        ["\xD1\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x98"],
        ["\xD1\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x99"],
        ["\xD1\xCB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9A"],
        ["\xD1\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9B"],
        ["\xD1\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9C"],
        ["\xD1\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9D"],
        ["\xD1\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9E"],
        ["\xD1\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9F"],
        ["\xD1\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA0"],
        ["\xD1\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA1"],
        ["\xD1\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA2"],
        ["\xD1\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA3"],
        ["\xD1\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA4"],
        ["\xD1\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA6"],
        ["\xD1\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA7"],
        ["\xD1\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA8"],
        ["\xD2\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA9"],
        ["\xD2\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAB"],
        ["\xD1\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAC"],
        ["\xD1\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAD"],
        ["\xD2\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAE"],
        ["\xD2\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAF"],
        ["\xD2\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB0"],
        ["\xD2\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB2"],
        ["\xD2\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB3"],
        ["\xD2\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB4"],
        ["\xD2\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB5"],
        ["\xD2\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB6"],
        ["\xD2\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB7"],
        ["\xD2\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB8"],
        ["\xD2\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB9"],
        ["\xD2\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBA"],
        ["\xD2\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBB"],
        ["\xD2\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBC"],
        ["\xD2\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBD"],
        ["\xD2\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBE"],
        ["\xD3\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x82"],
        ["\xD3\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x83"],
        ["\xD3\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x84"],
        ["\xD3\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x86"],
        ["\xD3\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x88"],
        ["\xD3\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8A"],
        ["\xD4\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8B"],
        ["\xD4\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8C"],
        ["\xD4\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8F"],
        ["\xD4\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x94"],
        ["\xD4\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x95"],
        ["\xD4\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x97"],
        ["\xD4\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x98"],
        ["\xD5\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x99"],
        ["\xD5\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9A"],
        ["\xD3\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9B"],
        ["\xD5\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9C"],
        ["\xD5\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9E"],
        ["\xA5\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x9E"],
        ["\xA5\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x9F"],
        ["\xA5\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xA0"],
        ["\xA5\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xB8"],
        ["\xA5\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xB9"],
        ["\xA5\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBC"],
        ["\xA5\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBD"],
        ["\xA3\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\xBE"],
        ["\xA3\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8C"],
        ["\xA3\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8D"],
        ["\xA3\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8E"],
        ["\xA3\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x8F"],
        ["\xA3\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x90"],
        ["\xA3\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x91"],
        ["\xA3\xE2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x92"],
        ["\xA3\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x93"],
        ["\xA3\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB7\x94"],
        ["\xA5\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x86"],
        ["\xA4\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB8\x89"],
        ["\xA5\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBB\xBF"],
        ["\xA5\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x81"],
        ["\xA5\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x83"],
        ["\xA5\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x85"],
        ["\xA2\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9B"],
        ["\xA2\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBE\x9C"],
        ["\xA5\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x97"],
        ["\xA5\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x98"],
        ["\xA5\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9D"],
        ["\xA5\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9F"],
        ["\xA5\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA0"],
        ["\xA5\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA3"],
        ["\xA5\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA4"],
        ["\xA5\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA5"],
        ["\xA5\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA7"],
        ["\xA5\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA9"],
        ["\xA5\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAA"],
        ["\xA5\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAC"],
        ["\xA5\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAF"],
        ["\xA5\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB0"],
        ["\xA5\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB1"],
        ["\xA5\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB2"],
        ["\xA5\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB5"],
        ["\xA5\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB6"],
        ["\xA5\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB7"],
        ["\xA5\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB9"],
        ["\xA5\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBC"],
        ["\xA5\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBD"],
        ["\xA5\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBE"],
        ["\xA5\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBF"],
        ["\xA5\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x80"],
        ["\xA5\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x82"],
        ["\xA5\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x83"],
        ["\xA5\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x86"],
        ["\xA5\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x88"],
        ["\xA5\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x89"],
        ["\xA5\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8B"],
        ["\xA5\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8D"],
        ["\xA5\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8E"],
        ["\xA5\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8F"],
        ["\xA5\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x90"],
        ["\xA5\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x93"],
        ["\xA5\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x85"],
        ["\xA5\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x86"],
        ["\xA3\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9A"],
        ["\xA3\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9B"],
        ["\xA3\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9C"],
        ["\xA3\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9D"],
        ["\xA3\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9E"],
        ["\xA3\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\x9F"],
        ["\xA3\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA0"],
        ["\xA3\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA1"],
        ["\xA3\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA2"],
        ["\xA3\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xA3"],
        ["\xA2\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xB8"],
        ["\xA2\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xB9"],
        ["\xA1\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBA"],
        ["\xA1\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBB"],
        ["\xA1\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBC"],
        ["\xA1\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBD"],
        ["\xA1\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBE"],
        ["\xA1\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x84\xBF"],
        ["\xA1\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x80"],
        ["\xA1\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x81"],
        ["\xA1\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x82"],
        ["\xA1\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x83"],
        ["\xA1\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x84"],
        ["\xA4\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x85"],
        ["\xA4\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x86"],
        ["\xA4\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x87"],
        ["\xA4\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x88"],
        ["\xA4\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x89"],
        ["\xA4\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8A"],
        ["\xA4\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8B"],
        ["\xA4\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8C"],
        ["\xA4\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8D"],
        ["\xA4\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8E"],
        ["\xA4\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x8F"],
        ["\xA4\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x90"],
        ["\xA4\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x91"],
        ["\xA4\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x92"],
        ["\xA4\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x93"],
        ["\xA1\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x94"],
        ["\xA1\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x95"],
        ["\xA1\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x96"],
        ["\xA2\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x97"],
        ["\xA2\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x98"],
        ["\xA2\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x99"],
        ["\xA2\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9A"],
        ["\xA2\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9B"],
        ["\xA2\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9C"],
        ["\xA2\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\x9D"],
        ["\xA1\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA4"],
        ["\xA1\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA7"],
        ["\xA1\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA8"],
        ["\xA1\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xA9"],
        ["\xA1\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAA"],
        ["\xA1\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAB"],
        ["\xA1\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x85\xAC"],
        ["\xA2\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x86\x96"],
        ["\xA2\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x86\xAE"],
        ["\xB2\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9B"],
        ["\xB2\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9C"],
        ["\xB2\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9E"],
        ["\xB2\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9F"],
        ["\xB2\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA1"],
        ["\xB2\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA3"],
        ["\xB2\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA7"],
        ["\xB2\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA9"],
        ["\xB2\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAC"],
        ["\xB3\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB2"],
        ["\xB2\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB3"],
        ["\xB3\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB4"],
        ["\xB3\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB5"],
        ["\xB3\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBA"],
        ["\xB3\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBB"],
        ["\xB3\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBC"],
        ["\xB3\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBD"],
        ["\xB3\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBF"],
        ["\xB3\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x80"],
        ["\xB3\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x82"],
        ["\xB3\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x86"],
        ["\xB4\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8C"],
        ["\xB4\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8E"],
        ["\xB4\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8F"],
        ["\xB4\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x93"],
        ["\xB4\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x94"],
        ["\xB4\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x97"],
        ["\xB5\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA4"],
        ["\xB5\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA5"],
        ["\xB5\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA8"],
        ["\xB5\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAC"],
        ["\xB5\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB0"],
        ["\xB5\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB2"],
        ["\xB5\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB3"],
        ["\xB5\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB5"],
        ["\xB5\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB7"],
        ["\xB5\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBA"],
        ["\xB5\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x80"],
        ["\xB5\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x81"],
        ["\xB6\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x83"],
        ["\xB6\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x84"],
        ["\xB6\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x85"],
        ["\xB6\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x86"],
        ["\xB6\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x88"],
        ["\xB6\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8A"],
        ["\xB6\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8C"],
        ["\xB6\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8E"],
        ["\xB6\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x90"],
        ["\xB6\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x94"],
        ["\xB6\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x97"],
        ["\xB6\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x98"],
        ["\xB6\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x99"],
        ["\xB6\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA4"],
        ["\xB6\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA6"],
        ["\xC1\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA8"],
        ["\xB6\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA9"],
        ["\x45\x36",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAB"],
        ["\xB6\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAC"],
        ["\xB6\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAE"],
        ["\xB7\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAF"],
        ["\xB7\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB2"],
        ["\xB7\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB5"],
        ["\xB7\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB6"],
        ["\xB7\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB7"],
        ["\xB7\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB9"],
        ["\xB7\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBA"],
        ["\xB7\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBD"],
        ["\xB7\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBE"],
        ["\xB7\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBF"],
        ["\xB7\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x81"],
        ["\xB7\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x82"],
        ["\xB7\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x83"],
        ["\xB7\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x84"],
        ["\xB7\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x85"],
        ["\xB7\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x87"],
        ["\xB7\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x88"],
        ["\xB7\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x89"],
        ["\xB7\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8B"],
        ["\xB8\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8D"],
        ["\xB8\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8F"],
        ["\xB8\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAA"],
        ["\xB8\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAB"],
        ["\xB8\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB7"],
        ["\xB8\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB8"],
        ["\xB8\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB9"],
        ["\xB8\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBB"],
        ["\xB9\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBF"],
        ["\xB9\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x80"],
        ["\xB9\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8C"],
        ["\xB9\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8E"],
        ["\x57\x3B",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\x83\xBE"],
        ["\xB9\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x93"],
        ["\xB9\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x94"],
        ["\xB9\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x95"],
        ["\xBA\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x96"],
        ["\xBA\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x98"],
        ["\xBA\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9C"],
        ["\xBA\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA0"],
        ["\xBA\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA1"],
        ["\xBA\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA2"],
        ["\xBA\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA6"],
        ["\xBA\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA8"],
        ["\xBA\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA9"],
        ["\xBA\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAA"],
        ["\xD0\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAB"],
        ["\xBA\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAC"],
        ["\xBA\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAF"],
        ["\xBA\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB1"],
        ["\xBB\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB2"],
        ["\xBB\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB3"],
        ["\xBB\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB4"],
        ["\xBB\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB6"],
        ["\xBB\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB8"],
        ["\xBB\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBA"],
        ["\xBB\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBB"],
        ["\xBB\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x81"],
        ["\xBB\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x82"],
        ["\xBB\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x86"],
        ["\xBB\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x88"],
        ["\xBB\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8B"],
        ["\xBC\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8D"],
        ["\xBC\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8E"],
        ["\xBC\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8F"],
        ["\xBC\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x92"],
        ["\xBC\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x93"],
        ["\xBC\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x94"],
        ["\xBA\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x95"],
        ["\xBC\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x96"],
        ["\xBC\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x97"],
        ["\xBC\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x98"],
        ["\xBC\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x99"],
        ["\xBC\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9B"],
        ["\xBC\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA6"],
        ["\xBC\xE2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA7"],
        ["\xBC\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA9"],
        ["\xBC\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAA"],
        ["\xBC\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAE"],
        ["\xBC\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB0"],
        ["\xBD\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB8"],
        ["\xBD\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBA"],
        ["\xBD\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBB"],
        ["\xBD\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x80"],
        ["\xBD\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x84"],
        ["\xBD\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x87"],
        ["\xBD\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x88"],
        ["\xBD\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x89"],
        ["\xBE\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8D"],
        ["\xBE\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8F"],
        ["\xBE\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x92"],
        ["\xBE\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x94"],
        ["\xBE\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x96"],
        ["\xBE\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x98"],
        ["\xBE\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9A"],
        ["\xBE\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9C"],
        ["\xBE\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9D"],
        ["\xBE\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9E"],
        ["\xBE\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA0"],
        ["\xBE\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA2"],
        ["\xBE\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA6"],
        ["\xBE\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA8"],
        ["\xBE\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAF"],
        ["\xBF\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB1"],
        ["\xBF\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB2"],
        ["\xBF\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB3"],
        ["\xBF\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB4"],
        ["\xBF\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB5"],
        ["\xBF\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB6"],
        ["\xBF\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB7"],
        ["\xBF\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBA"],
        ["\xBF\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBB"],
        ["\xBF\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBD"],
        ["\xBF\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x80"],
        ["\xBF\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8C"],
        ["\xBF\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x91"],
        ["\xBF\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x92"],
        ["\xBF\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x94"],
        ["\xBF\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x98"],
        ["\xC0\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9E"],
        ["\xC0\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA1"],
        ["\xC0\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA4"],
        ["\xC0\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA5"],
        ["\xC0\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA6"],
        ["\xC0\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAB"],
        ["\xC0\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAD"],
        ["\xC0\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAF"],
        ["\xC0\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB4"],
        ["\xC0\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB5"],
        ["\xC0\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB6"],
        ["\xC0\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBB"],
        ["\xC0\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBE"],
        ["\xC0\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x80"],
        ["\xC0\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x81"],
        ["\xC0\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x82"],
        ["\xC0\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x83"],
        ["\xC0\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x84"],
        ["\xC1\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x87"],
        ["\xC1\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x88"],
        ["\xC1\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8A"],
        ["\xC1\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8D"],
        ["\xC1\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8F"],
        ["\xC1\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x92"],
        ["\xC1\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x95"],
        ["\xC1\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x96"],
        ["\xC1\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x97"],
        ["\xC1\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9E"],
        ["\xC1\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA0"],
        ["\xC2\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA2"],
        ["\xC2\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA4"],
        ["\xC2\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA7"],
        ["\xC2\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA9"],
        ["\xC2\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAB"],
        ["\xC2\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAD"],
        ["\xC2\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAE"],
        ["\xC2\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB0"],
        ["\xC2\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB1"],
        ["\xC2\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB3"],
        ["\xC2\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB4"],
        ["\xC2\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB5"],
        ["\xC2\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB7"],
        ["\xC2\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBC"],
        ["\xC2\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBD"],
        ["\xC2\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x83"],
        ["\xC2\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x86"],
        ["\xBD\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x89"],
        ["\xC2\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8B"],
        ["\xC3\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8C"],
        ["\xC3\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8D"],
        ["\xC3\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8E"],
        ["\xC3\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x91"],
        ["\xC3\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x99"],
        ["\xC3\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9B"],
        ["\xC3\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9E"],
        ["\xC3\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA0"],
        ["\xC3\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA3"],
        ["\xC3\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA5"],
        ["\xC3\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA8"],
        ["\xC3\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAB"],
        ["\xC3\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAE"],
        ["\xC3\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB1"],
        ["\xC4\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB5"],
        ["\xC4\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB6"],
        ["\xC4\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBD"],
        ["\xC4\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBF"],
        ["\xC4\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x81"],
        ["\xC4\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x84"],
        ["\xC4\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x85"],
        ["\xC4\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x88"],
        ["\xC4\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8A"],
        ["\xC4\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8D"],
        ["\xC4\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x90"],
        ["\xC4\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x92"],
        ["\xC4\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x93"],
        ["\xC4\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x97"],
        ["\xC4\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x98"],
        ["\xC4\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9B"],
        ["\xC5\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9E"],
        ["\xC5\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9F"],
        ["\xC4\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA0"],
        ["\xC5\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA3"],
        ["\xC5\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA4"],
        ["\xC5\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA5"],
        ["\xC5\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA6"],
        ["\xC5\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAC"],
        ["\xC5\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAD"],
        ["\xC5\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB0"],
        ["\xC5\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB1"],
        ["\xC5\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB5"],
        ["\xC5\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB6"],
        ["\xC5\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB8"],
        ["\xC5\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBD"],
        ["\xC5\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBE"],
        ["\xC5\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x80"],
        ["\xC5\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x86"],
        ["\xC5\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x89"],
        ["\xC5\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8A"],
        ["\xC5\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8D"],
        ["\xC5\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x90"],
        ["\xC5\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x92"],
        ["\xC5\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x94"],
        ["\xC5\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x96"],
        ["\xC5\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x97"],
        ["\xC6\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9C"],
        ["\xC6\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9E"],
        ["\xC6\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA0"],
        ["\xC6\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA4"],
        ["\xC6\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA5"],
        ["\xC6\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA9"],
        ["\xC6\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAC"],
        ["\xC6\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAD"],
        ["\xC6\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB0"],
        ["\xC6\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB1"],
        ["\xC6\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB9"],
        ["\xC7\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x83"],
        ["\xC7\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x84"],
        ["\xB9\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x85"],
        ["\xC8\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x87"],
        ["\xC7\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x89"],
        ["\xC7\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8B"],
        ["\xC7\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8D"],
        ["\xC7\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8E"],
        ["\xC5\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x91"],
        ["\xC7\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x92"],
        ["\xC7\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x96"],
        ["\xC7\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x98"],
        ["\xC8\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9A"],
        ["\xC8\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9C"],
        ["\xC8\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9E"],
        ["\xC8\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9F"],
        ["\xC8\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA0"],
        ["\xC8\xCB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA4"],
        ["\xC8\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA5"],
        ["\xC8\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA7"],
        ["\xC5\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA9"],
        ["\xC8\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAE"],
        ["\xC8\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAF"],
        ["\xC8\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB0"],
        ["\xC8\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB2"],
        ["\xC8\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB3"],
        ["\xC8\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB6"],
        ["\xC8\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB7"],
        ["\xC8\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB9"],
        ["\xC8\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBA"],
        ["\xC8\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBB"],
        ["\xC8\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBC"],
        ["\xC9\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBD"],
        ["\xC9\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBE"],
        ["\xC9\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x80"],
        ["\xC9\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x84"],
        ["\xC9\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x86"],
        ["\xC9\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x87"],
        ["\xC9\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8D"],
        ["\xC9\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8E"],
        ["\xC9\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8F"],
        ["\xC9\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x91"],
        ["\xC9\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x98"],
        ["\xC9\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x99"],
        ["\xC9\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9A"],
        ["\xC9\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9B"],
        ["\xC9\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9D"],
        ["\xC9\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9E"],
        ["\xCA\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA0"],
        ["\xCA\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA2"],
        ["\xCA\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA3"],
        ["\xCA\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA9"],
        ["\xCA\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAB"],
        ["\xCA\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAC"],
        ["\xD5\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB0"],
        ["\xCA\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB9"],
        ["\xCA\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBB"],
        ["\xCB\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBF"],
        ["\xCB\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x81"],
        ["\xCB\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x87"],
        ["\xCB\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x91"],
        ["\xCB\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x96"],
        ["\xCB\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x98"],
        ["\xCB\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x99"],
        ["\xCB\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9E"],
        ["\xCC\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA9"],
        ["\xCC\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB9"],
        ["\xCD\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBD"],
        ["\xCD\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBF"],
        ["\xCD\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x83"],
        ["\xCD\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x86"],
        ["\xCD\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x87"],
        ["\xCD\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x88"],
        ["\xCD\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8D"],
        ["\xCD\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x92"],
        ["\xCD\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x93"],
        ["\xCD\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x97"],
        ["\xCD\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9C"],
        ["\xCD\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA3"],
        ["\xCD\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA4"],
        ["\xCD\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA5"],
        ["\xCD\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA6"],
        ["\xCE\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAD"],
        ["\xCE\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAE"],
        ["\xCE\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAF"],
        ["\xCE\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB3"],
        ["\xCE\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB6"],
        ["\xCE\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB9"],
        ["\xCE\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBA"],
        ["\xCE\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBC"],
        ["\xCE\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBD"],
        ["\xCE\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBE"],
        ["\xCE\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBF"],
        ["\xCE\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x80"],
        ["\xB6\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8A"],
        ["\xCE\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8B"],
        ["\xCE\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8C"],
        ["\xCF\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8F"],
        ["\xCF\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x92"],
        ["\xCF\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x95"],
        ["\xCF\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9A"],
        ["\xCF\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9B"],
        ["\xCF\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9C"],
        ["\xCF\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9D"],
        ["\xCF\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA1"],
        ["\xCF\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA5"],
        ["\xCF\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA6"],
        ["\xCF\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA7"],
        ["\xCF\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA9"],
        ["\xB4\xE2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAB"],
        ["\xCF\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAC"],
        ["\xCF\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAD"],
        ["\xD0\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAE"],
        ["\xD0\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAF"],
        ["\xD0\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB1"],
        ["\xD0\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB3"],
        ["\xD0\xE2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB8"],
        ["\xD0\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB9"],
        ["\xD0\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBC"],
        ["\xD0\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBD"],
        ["\xD0\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBF"],
        ["\xD0\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x81"],
        ["\xD0\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x82"],
        ["\xD0\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x86"],
        ["\xD0\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8A"],
        ["\xD0\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8B"],
        ["\xD0\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8C"],
        ["\xD0\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8F"],
        ["\xD1\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x91"],
        ["\xCF\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x94"],
        ["\xD1\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x96"],
        ["\xD1\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9A"],
        ["\xD1\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9B"],
        ["\xD1\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9D"],
        ["\xD1\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA2"],
        ["\xD1\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA3"],
        ["\xD2\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xAD"],
        ["\xD2\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB1"],
        ["\xD2\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB3"],
        ["\xD2\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB9"],
        ["\xD2\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBC"],
        ["\xD2\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBD"],
        ["\xD2\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBE"],
        ["\xD2\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBF"],
        ["\xD2\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x80"],
        ["\xD2\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x82"],
        ["\xD2\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x83"],
        ["\xD2\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x85"],
        ["\xCD\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x88"],
        ["\xD3\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8B"],
        ["\xD3\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8C"],
        ["\xD3\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8D"],
        ["\xD3\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x92"],
        ["\xB6\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x93"],
        ["\xD3\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x97"],
        ["\xD5\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x99"],
        ["\xD3\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9B"],
        ["\xD3\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA0"],
        ["\xCE\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA2"],
        ["\xD3\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA4"],
        ["\xD5\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA7"],
        ["\xD3\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA8"],
        ["\xD3\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAA"],
        ["\xD3\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAE"],
        ["\xD3\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAF"],
        ["\xD3\xF6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB0"],
        ["\xD3\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB3"],
        ["\xD3\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB4"],
        ["\xD4\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB7"],
        ["\x45\x3F",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB8"],
        ["\xD4\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBB"],
        ["\xD4\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBC"],
        ["\xD4\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBD"],
        ["\xD4\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x81"],
        ["\xD4\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x82"],
        ["\xD4\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x85"],
        ["\xD4\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x86"],
        ["\xD4\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x87"],
        ["\xD4\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x90"],
        ["\xD4\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x91"],
        ["\xD4\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x95"],
        ["\xD4\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x96"],
        ["\xD4\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x97"],
        ["\xD4\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9A"],
        ["\xD4\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9D"],
        ["\xD5\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA0"],
        ["\xD5\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA1"],
        ["\xD5\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA5"],
        ["\xD5\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA9"],
        ["\xD5\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAA"],
        ["\xD5\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAC"],
        ["\xD5\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAD"],
        ["\xD5\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAE"],
        ["\xD5\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAF"],
        ["\xD5\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB0"],
        ["\xD5\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB4"],
        ["\xD5\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB6"],
        ["\xD5\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x81"],
        ["\xD5\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x82"],
        ["\x39\x6D",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x84"],
        ["\xD5\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x88"],
        ["\xD5\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x89"],
        ["\xBA\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8B"],
        ["\xD5\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8C"],
        ["\xB6\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8E"],
        ["\xB2\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x95"],
        ["\xB2\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x99"],
        ["\xB2\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9A"],
        ["\xB2\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA7"],
        ["\xB2\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAD"],
        ["\xB2\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB0"],
        ["\xB2\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB1"],
        ["\xB2\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB6"],
        ["\xB2\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB7"],
        ["\xB2\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBB"],
        ["\xB2\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x83"],
        ["\xB2\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x84"],
        ["\xB2\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x85"],
        ["\xB2\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x86"],
        ["\xB2\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x87"],
        ["\xB3\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8A"],
        ["\xB3\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8B"],
        ["\xB3\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8D"],
        ["\xB3\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8E"],
        ["\xB3\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x96"],
        ["\xB3\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x97"],
        ["\xB3\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x98"],
        ["\xB3\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x99"],
        ["\xB3\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA7"],
        ["\xB3\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB0"],
        ["\xB8\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBF"],
        ["\xB8\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x87"],
        ["\xB8\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x98"],
        ["\xB9\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9A"],
        ["\xB9\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9D"],
        ["\xB9\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9F"],
        ["\xB9\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA8"],
        ["\xB9\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAE"],
        ["\xB9\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB0"],
        ["\xB9\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB1"],
        ["\xB9\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBC"],
        ["\xB9\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x81"],
        ["\xB9\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x83"],
        ["\xB9\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x84"],
        ["\xB9\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x87"],
        ["\xB5\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9C"],
        ["\xB4\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9F"],
        ["\xB4\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA3"],
        ["\xB4\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA4"],
        ["\xB4\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA6"],
        ["\xB4\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB8"],
        ["\xB4\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBB"],
        ["\xC9\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBC"],
        ["\xB4\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x80"],
        ["\xB5\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x84"],
        ["\xB5\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8E"],
        ["\xB5\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8F"],
        ["\xB5\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x99"],
        ["\xB5\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA4"],
        ["\xB5\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAC"],
        ["\xB5\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAD"],
        ["\xB5\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB1"],
        ["\xB5\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB2"],
        ["\xB5\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB4"],
        ["\xB5\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB5"],
        ["\xB5\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBB"],
        ["\xB5\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x88"],
        ["\xB6\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8C"],
        ["\xB6\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x90"],
        ["\xB6\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x91"],
        ["\xB6\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9E"],
        ["\xB6\xC1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA1"],
        ["\xB6\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAE"],
        ["\xB6\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB6"],
        ["\xB6\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBA"],
        ["\xB6\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x83"],
        ["\xB6\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x87"],
        ["\xB6\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8B"],
        ["\xB6\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8C"],
        ["\xB6\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8F"],
        ["\xB7\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x97"],
        ["\xB6\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x98"],
        ["\xB7\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9C"],
        ["\xB7\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA4"],
        ["\xB7\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA8"],
        ["\xB7\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB3"],
        ["\xB7\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB6"],
        ["\xB7\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB9"],
        ["\xB7\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBB"],
        ["\xB7\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBD"],
        ["\xB7\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBF"],
        ["\xB7\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x88"],
        ["\xB7\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x89"],
        ["\xB7\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8C"],
        ["\xB7\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8D"],
        ["\xB8\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x93"],
        ["\xB8\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9B"],
        ["\xB8\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9D"],
        ["\xB8\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9F"],
        ["\xB8\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA1"],
        ["\xB8\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA6"],
        ["\xB8\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA7"],
        ["\xBA\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB6"],
        ["\xB2\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB7"],
        ["\xBA\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB8"],
        ["\xBA\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x83"],
        ["\xBA\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x87"],
        ["\xBA\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x89"],
        ["\xBA\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8A"],
        ["\xBA\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8B"],
        ["\xBA\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8C"],
        ["\xBB\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x90"],
        ["\xB4\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x95"],
        ["\xBB\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9A"],
        ["\xBB\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9B"],
        ["\xBB\xCB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA4"],
        ["\xBB\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA5"],
        ["\xBB\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA7"],
        ["\xBB\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAD"],
        ["\xBB\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB0"],
        ["\xBB\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB1"],
        ["\xBB\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB4"],
        ["\xBB\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB5"],
        ["\xBB\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB7"],
        ["\xBB\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB9"],
        ["\xBB\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBE"],
        ["\xBC\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x80"],
        ["\xBC\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x81"],
        ["\xBC\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8A"],
        ["\xBE\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8C"],
        ["\xBA\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x93"],
        ["\xBC\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x97"],
        ["\xBC\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x98"],
        ["\xBC\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9E"],
        ["\xBA\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA6"],
        ["\xBC\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAB"],
        ["\xBC\xD5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAD"],
        ["\xBC\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB3"],
        ["\xBC\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBC"],
        ["\xBC\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x81"],
        ["\xBC\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x84"],
        ["\xBC\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8D"],
        ["\xBD\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x94"],
        ["\xBD\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x95"],
        ["\xBD\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x99"],
        ["\xBD\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9A"],
        ["\xBD\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9C"],
        ["\xBD\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9D"],
        ["\xBD\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9E"],
        ["\xBD\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA0"],
        ["\xBD\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA1"],
        ["\xBD\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA6"],
        ["\xBD\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAA"],
        ["\xBD\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAB"],
        ["\xBD\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB1"],
        ["\xBD\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB5"],
        ["\xBE\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB6"],
        ["\xBE\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBD"],
        ["\xBE\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x83"],
        ["\xBE\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x86"],
        ["\xBE\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8B"],
        ["\xBE\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x96"],
        ["\xBE\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x99"],
        ["\xBE\xED",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA2"],
        ["\xB4\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA7"],
        ["\xBE\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB1"],
        ["\xBF\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB5"],
        ["\xBF\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB7"],
        ["\xBF\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x83"],
        ["\xBF\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x84"],
        ["\xBF\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x87"],
        ["\xBF\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8E"],
        ["\xBF\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x98"],
        ["\xB9\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9A"],
        ["\xBF\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9C"],
        ["\xBF\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA1"],
        ["\xBF\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAA"],
        ["\xBF\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAE"],
        ["\xBF\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB2"],
        ["\xBF\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBB"],
        ["\xBF\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x81"],
        ["\xBF\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x82"],
        ["\xC0\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x89"],
        ["\xC0\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8E"],
        ["\xC0\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8F"],
        ["\xC0\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x96"],
        ["\xC0\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x97"],
        ["\xC0\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9B"],
        ["\xC0\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9C"],
        ["\xC0\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9D"],
        ["\xD1\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA9"],
        ["\xC0\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAC"],
        ["\xBC\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAD"],
        ["\xD3\xE2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAE"],
        ["\xC0\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB2"],
        ["\xC0\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB7"],
        ["\xC0\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBB"],
        ["\xC0\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBD"],
        ["\xC0\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBF"],
        ["\xC0\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x84"],
        ["\xC0\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x87"],
        ["\xC1\xA2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x88"],
        ["\xC1\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8B"],
        ["\xC1\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8C"],
        ["\xC1\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8F"],
        ["\xC1\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x92"],
        ["\xC1\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x96"],
        ["\xC1\xCB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA7"],
        ["\xC1\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA8"],
        ["\xC1\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAB"],
        ["\xC1\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAC"],
        ["\xC1\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAE"],
        ["\xC1\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBA"],
        ["\xC1\xEA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBB"],
        ["\xC1\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBD"],
        ["\xC1\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBE"],
        ["\xC1\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x84"],
        ["\xC2\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x89"],
        ["\xC2\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x90"],
        ["\xC2\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x98"],
        ["\xC2\xC3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x99"],
        ["\xC2\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9A"],
        ["\xC2\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9E"],
        ["\xC2\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA3"],
        ["\xC2\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAF"],
        ["\xC2\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB7"],
        ["\xC2\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB8"],
        ["\xC7\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB9"],
        ["\xC2\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBD"],
        ["\xB3\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBE"],
        ["\xC3\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x87"],
        ["\xC3\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x88"],
        ["\xC3\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8C"],
        ["\xC3\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x90"],
        ["\xC3\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x91"],
        ["\xBD\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x93"],
        ["\xC3\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x98"],
        ["\xC3\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9A"],
        ["\xC9\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAC"],
        ["\xC3\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAF"],
        ["\xC3\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB3"],
        ["\xC3\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB4"],
        ["\xC3\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB7"],
        ["\xC3\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB8"],
        ["\xC3\xEF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBD"],
        ["\xC3\xF3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x85"],
        ["\xCD\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x88"],
        ["\xC3\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x89"],
        ["\xC3\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8B"],
        ["\xC4\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8E"],
        ["\xC4\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x95"],
        ["\xC4\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x96"],
        ["\xC4\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x99"],
        ["\xC4\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9A"],
        ["\xC4\xB2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9B"],
        ["\xC4\xBB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA0"],
        ["\xC4\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA3"],
        ["\xC4\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA4"],
        ["\xC4\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA7"],
        ["\xC4\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA9"],
        ["\xC4\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAA"],
        ["\xC4\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAB"],
        ["\xC4\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAD"],
        ["\xC4\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB2"],
        ["\xC4\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB4"],
        ["\xC4\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBB"],
        ["\xC4\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x80"],
        ["\xC5\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x81"],
        ["\xC5\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x93"],
        ["\xC5\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x96"],
        ["\xC5\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9A"],
        ["\xC5\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9D"],
        ["\xC5\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9E"],
        ["\xC5\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA7"],
        ["\xC5\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB2"],
        ["\xC5\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB9"],
        ["\xC5\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBD"],
        ["\xC5\xCB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x80"],
        ["\xC5\xE0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8D"],
        ["\xC5\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA0"],
        ["\xC5\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA2"],
        ["\xC5\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA7"],
        ["\xC5\xFD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA9"],
        ["\xC6\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAC"],
        ["\xC6\xA7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAE"],
        ["\xB2\xF0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAF"],
        ["\xC6\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB4"],
        ["\xC6\xAC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB5"],
        ["\xC6\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB8"],
        ["\xC6\xC5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x84"],
        ["\xC6\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x86"],
        ["\xC6\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x89"],
        ["\xC6\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8D"],
        ["\xC6\xCC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8E"],
        ["\xD2\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x91"],
        ["\xC6\xD0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x92"],
        ["\xC6\xDC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x99"],
        ["\xC6\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9C"],
        ["\xC6\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9E"],
        ["\xC6\xFA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9F"],
        ["\xC7\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA2"],
        ["\xC7\xB3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA8"],
        ["\xC7\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAC"],
        ["\xC7\xC4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB1"],
        ["\xC7\xCA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB2"],
        ["\xC7\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB4"],
        ["\xC7\xCB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB5"],
        ["\xC7\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB8"],
        ["\xC7\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBA"],
        ["\xC7\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBE"],
        ["\xC7\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x81"],
        ["\xC7\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x88"],
        ["\xC7\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8C"],
        ["\xC8\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x98"],
        ["\xC8\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9B"],
        ["\xC8\xA4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9D"],
        ["\xC8\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA5"],
        ["\xC8\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA6"],
        ["\xC8\xAF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA7"],
        ["\xC8\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAC"],
        ["\xC8\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAD"],
        ["\xC8\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB1"],
        ["\xC8\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB6"],
        ["\xC8\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB8"],
        ["\xC5\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBC"],
        ["\xC8\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBE"],
        ["\xC8\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x87"],
        ["\xC8\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x90"],
        ["\xC8\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x95"],
        ["\xD4\xBA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9A"],
        ["\xC8\xF7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9E"],
        ["\xC8\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9F"],
        ["\xC9\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA6"],
        ["\xC9\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA8"],
        ["\xC9\xAA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAE"],
        ["\xC9\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB4"],
        ["\xC9\xAE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB5"],
        ["\xC9\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBE"],
        ["\xC9\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x81"],
        ["\xC9\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x88"],
        ["\xC9\xC6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x89"],
        ["\xC9\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8A"],
        ["\xC9\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8F"],
        ["\xC9\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x90"],
        ["\xC9\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x93"],
        ["\xC9\xDE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9A"],
        ["\xC9\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9B"],
        ["\xC9\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9F"],
        ["\xC9\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA1"],
        ["\xC9\xE8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA2"],
        ["\xC9\xF4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAD"],
        ["\xC9\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB0"],
        ["\xC9\xFE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB2"],
        ["\xCA\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB3"],
        ["\xCA\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB6"],
        ["\xCA\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBB"],
        ["\xCA\xAB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBD"],
        ["\xCA\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x81"],
        ["\xCA\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8B"],
        ["\xCA\xC0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x93"],
        ["\xCA\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAA"],
        ["\xBE\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAC"],
        ["\xCA\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB4"],
        ["\xCA\xDB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB5"],
        ["\xCA\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB8"],
        ["\xCA\xDF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBA"],
        ["\xCA\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x89"],
        ["\xCB\xA8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x94"],
        ["\xCB\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA7"],
        ["\xCB\xF9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB3"],
        ["\xCC\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB8"],
        ["\xCC\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB9"],
        ["\xCC\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBD"],
        ["\xCC\xC9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x88"],
        ["\xCC\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x92"],
        ["\xCC\xE9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA5"],
        ["\xCD\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x89"],
        ["\xCD\xCD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8B"],
        ["\xCD\xCE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8C"],
        ["\xCD\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x95"],
        ["\xCD\xD9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA4"],
        ["\xCD\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAE"],
        ["\xCD\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB9"],
        ["\xCD\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x89"],
        ["\xCD\xE3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8B"],
        ["\xCD\xE6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8D"],
        ["\xCD\xE7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8F"],
        ["\xD0\xD4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x94"],
        ["\xCD\xEC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x95"],
        ["\xCD\xF8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9F"],
        ["\xCE\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA4"],
        ["\xCE\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA6"],
        ["\xC9\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB3"],
        ["\xCE\xBF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB6"],
        ["\xCE\xCB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x81"],
        ["\xCE\xD7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x87"],
        ["\xCE\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x88"],
        ["\xCE\xD3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x89"],
        ["\xCE\xE4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8E"],
        ["\xCE\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8F"],
        ["\xCE\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x97"],
        ["\xCF\xA3",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA3"],
        ["\xCF\xA5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA8"],
        ["\xCF\xA6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA9"],
        ["\xCA\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xAB"],
        ["\xCF\xB5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB7"],
        ["\xCF\xB9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB9"],
        ["\xCF\xC8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x81"],
        ["\xCF\xFB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\xBB"],
        ["\xD0\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x87"],
        ["\xD1\xE2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x8B"],
        ["\xD1\xEB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x93"],
        ["\xD3\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x9D"],
        ["\xB6\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA5"],
        ["\xD3\xB8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xAD"],
        ["\xD3\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x90"],
        ["\xD3\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x98"],
        ["\xC2\xB0",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9B"],
        ["\xD4\xDA",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAA"],
        ["\xD4\xE1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB8"],
        ["\xD4\xE5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBC"],
        ["\xD4\xEE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x88"],
        ["\xD4\xFC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x90"],
        ["\xD5\xA1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x93"],
        ["\xD5\xAD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x98"],
        ["\xD5\xA9",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x99"],
        ["\xD5\xB1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9D"],
        ["\xD5\xB4",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA8"],
        ["\xD5\xB6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA9"],
        ["\xD5\xB7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAB"],
        ["\xD5\xBC",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB9"],
        ["\xD5\xBD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBD"],
        ["\xD5\xBE",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBE"],
        ["\xD5\xC2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x84"],
        ["\xD5\xC7",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x89"],
        ["\xD5\xCF",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x92"],
        ["\xD5\xD1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x99"],
        ["\xD5\xD2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9C"],
        ["\xD5\xD6",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9E"],
        ["\xD3\xCB",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA0"],
        ["\xD5\xD8",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA3"],
        ["\xD5\xDD",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB1"],
        ["\xD5\xF1",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x84"],
        ["\xD5\xF2",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x86"],
        ["\xD5\xF5",'utf8jp','jipsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x89"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
