# Generated by default/object.tt
package Paws::Transfer::PosixProfile;
  use Moose;
  has Gid => (is => 'ro', isa => 'Int', required => 1);
  has SecondaryGids => (is => 'ro', isa => 'ArrayRef[Int]');
  has Uid => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transfer::PosixProfile

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transfer::PosixProfile object:

  $service_obj->Method(Att1 => { Gid => $value, ..., Uid => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transfer::PosixProfile object:

  $result = $service_obj->Method(...);
  $result->Att1->Gid

=head1 DESCRIPTION

The full POSIX identity, including user ID (C<Uid>), group ID (C<Gid>),
and any secondary groups IDs (C<SecondaryGids>), that controls your
users' access to your Amazon EFS file systems. The POSIX permissions
that are set on files and directories in your file system determine the
level of access your users get when transferring files into and out of
your Amazon EFS file systems.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Gid => Int

The POSIX group ID used for all EFS operations by this user.


=head2 SecondaryGids => ArrayRef[Int]

The secondary POSIX group IDs used for all EFS operations by this user.


=head2 B<REQUIRED> Uid => Int

The POSIX user ID used for all EFS operations by this user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transfer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

