package Locales::DB::Language::nn;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::nn::VERSION = '0.09';

$Locales::DB::Language::nn::cldr_version = '2.0';

%Locales::DB::Language::nn::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => ' ',
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}\.\.\.",
            'initial' => "\.\.\.\{0\}",
            'medial'  => "\{0\}\.\.\.\{1\}"
        },
        'language' => "Språk\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ og\ \{1\}",
            'end'    => "\{0\}\ og\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0 \%",
        'territory' => "Område\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '”',
        'alternate_quotation_start' => '“',
        'quotation_end'             => '»',
        'quotation_start'           => '«'
    },
    'fallback' => [
        'nb',
        'da',
        'sv',
        'en'
    ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list' => [
            'one',
            'other'
        ],
        'category_rules'          => { 'one' => "n\ is\ 1" },
        'category_rules_compiled' => {
            'one' => sub {
                if ( ( ( $_[0] == 1 ) ) ) { return 'one'; }
                return;
            }
        }
    },
    'posix' => {
        'nostr'  => "nei\:n",
        'yesstr' => "ja\:j"
    },
);

%Locales::DB::Language::nn::code_to_name = (
    'aa'     => 'afar',
    'ab'     => 'abkhasisk',
    'ace'    => 'achinesisk',
    'ach'    => 'acoli',
    'ada'    => 'adangme',
    'ady'    => 'adyghe',
    'ae'     => 'avestisk',
    'af'     => 'afrikaans',
    'afa'    => "afroasiatisk\ språk",
    'afh'    => 'afrihili',
    'agq'    => 'aghem',
    'ain'    => 'ainu',
    'ak'     => 'akan',
    'akk'    => 'akkadisk',
    'ale'    => 'aleutisk',
    'alg'    => "algonkinsk\ språk",
    'alt'    => "sør\-altai",
    'am'     => 'amharisk',
    'an'     => 'aragonsk',
    'ang'    => 'gammalengelsk',
    'anp'    => 'angika',
    'apa'    => "apache\-språk",
    'ar'     => 'arabisk',
    'arc'    => 'arameisk',
    'arn'    => 'araukansk',
    'arp'    => 'arapaho',
    'art'    => "kunstig\ språk",
    'arw'    => 'arawak',
    'as'     => 'assamisk',
    'asa'    => "asu\ \(Tanzania\)",
    'ast'    => 'asturisk',
    'ath'    => "athapaskansk\ språk",
    'aus'    => "australsk\ språk",
    'av'     => 'avarisk',
    'awa'    => 'awadhi',
    'ay'     => 'aymara',
    'az'     => 'aserbajdsjansk',
    'ba'     => 'basjkirsk',
    'bad'    => 'banda',
    'bai'    => "bamilekisk\ språk",
    'bal'    => 'baluchi',
    'ban'    => 'balinesisk',
    'bas'    => 'basa',
    'bat'    => "baltisk\ språk",
    'be'     => 'kviterussisk',
    'bej'    => 'beja',
    'bem'    => 'bemba',
    'ber'    => 'berbisk',
    'bez'    => "bena\ \(Tanzania\)",
    'bg'     => 'bulgarsk',
    'bh'     => 'bihari',
    'bho'    => 'bhojpuri',
    'bi'     => 'bislama',
    'bik'    => 'bikol',
    'bin'    => 'bini',
    'bla'    => 'siksika',
    'bm'     => 'bambara',
    'bn'     => 'bengali',
    'bnt'    => 'bantu',
    'bo'     => 'tibetansk',
    'br'     => 'bretonsk',
    'bra'    => 'braj',
    'brx'    => 'bodo',
    'bs'     => 'bosnisk',
    'btk'    => 'batak',
    'bua'    => 'burjatisk',
    'bug'    => 'buginesisk',
    'byn'    => 'blin',
    'ca'     => 'katalansk',
    'cad'    => 'caddo',
    'cai'    => "sentralamerikansk\ indiansk\ språk",
    'car'    => 'karibisk',
    'cau'    => "kaukasisk\ språk",
    'cay'    => 'Cayuga',
    'cch'    => 'atsam',
    'ce'     => 'tsjetsjensk',
    'ceb'    => 'cebuansk',
    'cel'    => "keltisk\ språk",
    'cgg'    => 'Chiga',
    'ch'     => 'chamorro',
    'chb'    => 'chibcha',
    'chg'    => 'chagatai',
    'chk'    => 'chuukesisk',
    'chm'    => 'mari',
    'chn'    => 'chinook',
    'cho'    => 'choctaw',
    'chp'    => 'chipewiansk',
    'chr'    => 'cherokee',
    'chy'    => 'cheyenne',
    'cmc'    => "kamisk\ språk",
    'co'     => 'korsikansk',
    'cop'    => 'koptisk',
    'cpe'    => "engelskbasert\ kreol\-\ eller\ pidginspråk",
    'cpf'    => "franskbasert\ kreol\-\ eller\ pidginspråk",
    'cpp'    => "portugisiskbasert\ kreol\-\ eller\ pidginspråk",
    'cr'     => 'cree',
    'crh'    => 'krimtatarisk',
    'crp'    => "kreol\-\ eller\ pidginspråk",
    'cs'     => 'tsjekkisk',
    'csb'    => 'kasjubisk',
    'cu'     => 'kyrkjeslavisk',
    'cus'    => "kusjitisk\ språk",
    'cv'     => 'tsjuvansk',
    'cy'     => 'walisisk',
    'da'     => 'dansk',
    'dak'    => 'dakota',
    'dar'    => 'dargwa',
    'dav'    => 'Taita',
    'day'    => 'dayak',
    'de'     => 'tysk',
    'de_at'  => "austerriksk\ tysk",
    'de_ch'  => "sveitsisk\ høgtysk",
    'del'    => 'delaware',
    'den'    => 'slavej',
    'dgr'    => 'dogrib',
    'din'    => 'dinka',
    'dje'    => 'zarma',
    'doi'    => 'dogri',
    'dra'    => "dravidisk\ språk",
    'dsb'    => 'lågsorbisk',
    'dua'    => 'duala',
    'dum'    => 'mellumnederlandsk',
    'dv'     => 'divehi',
    'dyo'    => "jola\-fonyi",
    'dyu'    => 'dyula',
    'dz'     => 'dzongkha',
    'ebu'    => 'kiembu',
    'ee'     => 'ewe',
    'efi'    => 'efik',
    'egy'    => 'gammalegyptisk',
    'eka'    => 'ekajuk',
    'el'     => 'gresk',
    'elx'    => 'elamittisk',
    'en'     => 'engelsk',
    'en_au'  => "australisk\ engelsk",
    'en_ca'  => "kanadisk\ engelsk",
    'en_gb'  => "britisk\ engelsk",
    'en_us'  => "engelsk\ \(amerikansk\)",
    'enm'    => 'mellomengelsk',
    'eo'     => 'esperanto',
    'es'     => 'spansk',
    'es_419' => "latinamerikansk\ spansk",
    'es_es'  => "iberisk\ spansk",
    'et'     => 'estisk',
    'eu'     => 'baskisk',
    'ewo'    => 'ewondo',
    'fa'     => 'persisk',
    'fan'    => 'fang',
    'fat'    => 'fanti',
    'ff'     => 'fulani',
    'fi'     => 'finsk',
    'fil'    => 'filippinsk',
    'fiu'    => "finsk\-ugrisk\ språk",
    'fj'     => 'fijiansk',
    'fo'     => 'færøysk',
    'fon'    => 'fon',
    'fr'     => 'fransk',
    'fr_ca'  => "kanadisk\ fransk",
    'fr_ch'  => "sveitsisk\ fransk",
    'frm'    => 'mellomfransk',
    'fro'    => 'gammalfransk',
    'frr'    => 'nordfrisisk',
    'frs'    => 'austfrisisk',
    'fur'    => 'friuliansk',
    'fy'     => 'vestfrisisk',
    'ga'     => 'irsk',
    'gaa'    => 'ga',
    'gay'    => 'gayo',
    'gba'    => 'gbaya',
    'gd'     => "skotsk\-gælisk",
    'gem'    => "germansk\ språk",
    'gez'    => 'ges',
    'gil'    => 'kiribatisk',
    'gl'     => 'galicisk',
    'gmh'    => 'mellomhøgtysk',
    'gn'     => 'guarani',
    'goh'    => 'gammalhøgtysk',
    'gon'    => 'gondi',
    'gor'    => 'gorontalo',
    'got'    => 'gotisk',
    'grb'    => 'grebo',
    'grc'    => 'gammalgresk',
    'gsw'    => 'sveitsertysk',
    'gu'     => 'gujarati',
    'guz'    => 'Gusii',
    'gv'     => 'manx',
    'gwi'    => 'gwichin',
    'ha'     => 'hausa',
    'hai'    => 'haida',
    'haw'    => 'hawaiisk',
    'he'     => 'hebraisk',
    'hi'     => 'hindi',
    'hil'    => 'hiligaynon',
    'him'    => 'himachali',
    'hit'    => 'hettittisk',
    'hmn'    => 'hmong',
    'ho'     => "hiri\ motu",
    'hr'     => 'kroatisk',
    'hsb'    => 'høgsorbisk',
    'ht'     => 'haitisk',
    'hu'     => 'ungarsk',
    'hup'    => 'hupa',
    'hy'     => 'armensk',
    'hz'     => 'herero',
    'ia'     => 'interlingua',
    'iba'    => 'iban',
    'id'     => 'indonesisk',
    'ie'     => 'interlingue',
    'ig'     => 'ibo',
    'ii'     => "sichuan\-yi",
    'ijo'    => 'ijo',
    'ik'     => 'inupiak',
    'ilo'    => 'iloko',
    'inc'    => "indisk\ språk",
    'ine'    => "indo\-europeisk\ språk",
    'inh'    => 'ingusjisk',
    'io'     => 'ido',
    'ira'    => "iransk\ språk",
    'iro'    => "irokansk\ språk",
    'is'     => 'islandsk',
    'it'     => 'italiensk',
    'iu'     => 'inuktitut',
    'ja'     => 'japansk',
    'jbo'    => 'lojban',
    'jmc'    => 'Machame',
    'jpr'    => 'jødepersisk',
    'jrb'    => 'jødearabisk',
    'jv'     => 'javanesisk',
    'ka'     => 'georgisk',
    'kaa'    => 'karakalpakisk',
    'kab'    => 'kabylsk',
    'kac'    => 'kachin',
    'kaj'    => 'jju',
    'kam'    => 'kamba',
    'kar'    => 'karensk',
    'kaw'    => 'kawi',
    'kbd'    => 'kabardisk',
    'kcg'    => 'tyap',
    'kde'    => 'Makonde',
    'kea'    => 'kapverdisk',
    'kfo'    => 'koro',
    'kg'     => 'kikongo',
    'kha'    => 'khasi',
    'khi'    => 'khoisanspråk',
    'kho'    => 'khotanesisk',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'kikuyu',
    'kj'     => 'kuanyama',
    'kk'     => 'kasakhisk',
    'kl'     => "kalaallisut\;\ grønlandsk",
    'kln'    => 'Kalenjin',
    'km'     => 'khmer',
    'kmb'    => 'kimbundu',
    'kn'     => 'kannada',
    'ko'     => 'koreansk',
    'kok'    => 'konkani',
    'kos'    => 'kosraeansk',
    'kpe'    => 'kpelle',
    'kr'     => 'kanuri',
    'krc'    => "karachay\-balkar",
    'krl'    => 'karelsk',
    'kro'    => 'kru',
    'kru'    => 'kurukh',
    'ks'     => 'kasjmiri',
    'ksb'    => 'Shambala',
    'ksf'    => 'bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'kurdisk',
    'kum'    => 'kumyk',
    'kut'    => 'kutenai',
    'kv'     => 'komi',
    'kw'     => 'kornisk',
    'ky'     => 'kirgisisk',
    'la'     => 'latin',
    'lad'    => 'ladinsk',
    'lag'    => 'Langi',
    'lah'    => 'lahnda',
    'lam'    => 'lamba',
    'lb'     => 'luxemburgsk',
    'lez'    => 'lezghian',
    'lg'     => 'ganda',
    'li'     => 'limburgisk',
    'ln'     => 'lingala',
    'lo'     => 'laotisk',
    'lol'    => 'mongo',
    'loz'    => 'lozi',
    'lt'     => 'litauisk',
    'lu'     => "luba\-katanga",
    'lua'    => "luba\-lulua",
    'lui'    => 'luiseno',
    'lun'    => 'lunda',
    'luo'    => 'luo',
    'lus'    => 'lushai',
    'luy'    => 'olulujia',
    'lv'     => 'latvisk',
    'mad'    => 'maduresisk',
    'mag'    => 'magahi',
    'mai'    => 'maithili',
    'mak'    => 'makasar',
    'man'    => 'mandingo',
    'map'    => "austronesisk\ språk",
    'mas'    => 'masai',
    'mdf'    => 'moksha',
    'mdr'    => 'mandar',
    'men'    => 'mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'madagassisk',
    'mga'    => 'mellomirsk',
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'marshallesisk',
    'mi'     => 'maori',
    'mic'    => 'micmac',
    'min'    => 'minangkabau',
    'mis'    => "anna\ språk",
    'mk'     => 'makedonsk',
    'mkh'    => "mon\-khmerspråk",
    'ml'     => 'malayalam',
    'mn'     => 'mongolsk',
    'mnc'    => 'mandsju',
    'mni'    => 'manipuri',
    'mno'    => 'manobospråk',
    'mo'     => 'moldavisk',
    'moh'    => 'mohawk',
    'mos'    => 'mossi',
    'mr'     => 'marathi',
    'ms'     => 'malayisk',
    'mt'     => 'maltesisk',
    'mua'    => 'mundang',
    'mul'    => "fleire\ språk",
    'mun'    => 'mundaspråk',
    'mus'    => 'creek',
    'mwl'    => 'mirandesisk',
    'mwr'    => 'marwari',
    'my'     => 'burmesisk',
    'myn'    => 'mayaspråk',
    'myv'    => 'erzya',
    'na'     => 'nauru',
    'nah'    => 'nahuatl',
    'nai'    => "nordamerikansk\ indiansk\ språk",
    'nap'    => 'napolitansk',
    'naq'    => 'Nama',
    'nb'     => 'bokmål',
    'nd'     => "nord\-ndebele",
    'nds'    => 'lågtysk',
    'ne'     => 'nepalsk',
    'new'    => 'newari',
    'ng'     => 'ndonga',
    'nia'    => 'nias',
    'nic'    => "niger\-kordofaniansk\ språk",
    'niu'    => 'niueansk',
    'nl'     => 'nederlandsk',
    'nl_be'  => 'flamsk',
    'nmg'    => 'kwasio',
    'nn'     => 'nynorsk',
    'no'     => 'norsk',
    'nog'    => 'nogai',
    'non'    => 'gammalnorsk',
    'nqo'    => "n\'ko",
    'nr'     => "sør\-ndebele",
    'nso'    => 'nordsotho',
    'nub'    => "nubisk\ språk",
    'nus'    => 'nuer',
    'nv'     => 'navajo',
    'nwc'    => "klassisk\ newarisk",
    'ny'     => 'nyanja',
    'nym'    => 'nyamwezi',
    'nyn'    => 'nyankole',
    'nyo'    => 'nyoro',
    'nzi'    => 'nzima',
    'oc'     => 'oksitansk',
    'oj'     => 'ojibwa',
    'om'     => 'oromo',
    'or'     => 'oriya',
    'os'     => 'ossetisk',
    'osa'    => 'osage',
    'ota'    => "ottomansk\ tyrkisk",
    'oto'    => "otomisk\ språk",
    'pa'     => 'panjabi',
    'paa'    => "papuisk\ språk",
    'pag'    => 'pangasinan',
    'pal'    => 'pahlavi',
    'pam'    => 'pampanga',
    'pap'    => 'papiamento',
    'pau'    => 'palauisk',
    'peo'    => 'gammalpersisk',
    'phi'    => "filippinsk\ språk",
    'phn'    => 'fønikisk',
    'pi'     => 'pali',
    'pl'     => 'polsk',
    'pon'    => 'ponapisk',
    'pra'    => "prakrit\-språk",
    'pro'    => 'gammalprovençalsk',
    'ps'     => 'pashto',
    'pt'     => 'portugisisk',
    'pt_br'  => "brasiliansk\ portugisisk",
    'pt_pt'  => "europeisk\ portugisisk",
    'qu'     => 'quechua',
    'raj'    => 'rajasthani',
    'rap'    => 'rapanui',
    'rar'    => 'rarotongansk',
    'rm'     => 'retoromansk',
    'rn'     => 'rundi',
    'ro'     => 'rumensk',
    'roa'    => "romansk\ språk",
    'rof'    => 'rombo',
    'rom'    => 'romani',
    'ru'     => 'russisk',
    'rup'    => 'aromansk',
    'rw'     => 'kinjarwanda',
    'rwk'    => 'rwa',
    'sa'     => 'sanskrit',
    'sad'    => 'sandawe',
    'sah'    => 'jakutsk',
    'sai'    => "søramerikansk\ indiansk\ språk",
    'sal'    => "salishansk\ språk",
    'sam'    => "samaritansk\ arameisk",
    'saq'    => 'Samburu',
    'sas'    => 'sasak',
    'sat'    => 'santali',
    'sbp'    => 'sangu',
    'sc'     => 'sardinsk',
    'scn'    => 'siciliansk',
    'sco'    => 'skotsk',
    'sd'     => 'sindhi',
    'se'     => 'nordsamisk',
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'selkupisk',
    'sem'    => "semittisk\ språk",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'sango',
    'sga'    => 'gammalirsk',
    'sgn'    => 'teiknspråk',
    'sh'     => 'serbokroatisk',
    'shi'    => 'Tachelhit',
    'shn'    => 'shan',
    'si'     => 'singalesisk',
    'sid'    => 'sidamo',
    'sio'    => "sioux\-språk",
    'sit'    => "sino\-tibetansk\ språk",
    'sk'     => 'slovakisk',
    'sl'     => 'slovensk',
    'sla'    => "slavisk\ språk",
    'sm'     => 'samoansk',
    'sma'    => 'sørsamisk',
    'smi'    => "samisk\ språk",
    'smj'    => 'lulesamisk',
    'smn'    => 'enaresamisk',
    'sms'    => 'skoltesamisk',
    'sn'     => 'shona',
    'snk'    => 'soninke',
    'so'     => 'somali',
    'sog'    => 'sogdisk',
    'son'    => 'songhai',
    'sq'     => 'albansk',
    'sr'     => 'serbisk',
    'srn'    => "sranan\ tongo",
    'srr'    => 'serer',
    'ss'     => 'swati',
    'ssa'    => "nilo\-saharaspråk",
    'ssy'    => 'Saho',
    'st'     => 'sørsotho',
    'su'     => 'sundanesisk',
    'suk'    => 'sukuma',
    'sus'    => 'susu',
    'sux'    => 'sumerisk',
    'sv'     => 'svensk',
    'sw'     => 'swahili',
    'swb'    => 'shimaore',
    'swc'    => "Congo\ Swahili",
    'syc'    => "klassisk\ syrisk",
    'syr'    => 'syrisk',
    'ta'     => 'tamil',
    'tai'    => 'taispråk',
    'te'     => 'telugu',
    'tem'    => 'temne',
    'teo'    => 'Teso',
    'ter'    => 'tereno',
    'tet'    => 'tetum',
    'tg'     => 'tatsjikisk',
    'th'     => 'thai',
    'ti'     => 'tigrinja',
    'tig'    => 'tigré',
    'tiv'    => 'tivi',
    'tk'     => 'turkmensk',
    'tkl'    => 'tokelau',
    'tl'     => 'tagalog',
    'tlh'    => 'klingon',
    'tli'    => 'tlingit',
    'tmh'    => 'tamasjek',
    'tn'     => 'tswana',
    'to'     => "tonga\ \(Tonga\-øyane\)",
    'tog'    => "tonga\ \(Nyasa\)",
    'tpi'    => "tok\ pisin",
    'tr'     => 'tyrkisk',
    'trv'    => 'Taroko',
    'ts'     => 'tsonga',
    'tsi'    => 'tsimshian',
    'tt'     => 'tatarisk',
    'tum'    => 'tumbuka',
    'tup'    => "tupi\-språk",
    'tut'    => "altaisk\ språk",
    'tvl'    => 'tuvalu',
    'tw'     => 'twi',
    'twq'    => 'tasawaq',
    'ty'     => 'tahitisk',
    'tyv'    => 'tuvinisk',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'udmurt',
    'ug'     => 'uigurisk',
    'uga'    => 'ugaritisk',
    'uk'     => 'ukrainsk',
    'umb'    => 'umbundu',
    'und'    => "ukjent\ språk",
    'ur'     => 'urdu',
    'uz'     => 'usbekisk',
    'vai'    => 'vai',
    've'     => 'venda',
    'vi'     => 'vietnamesisk',
    'vo'     => 'volapyk',
    'vot'    => 'votisk',
    'vun'    => 'Vunjo',
    'wa'     => 'vallonsk',
    'wae'    => 'Walser',
    'wak'    => "wakasjansk\ språk",
    'wal'    => 'walamo',
    'war'    => 'waray',
    'was'    => 'washo',
    'wen'    => "sorbisk\ språk",
    'wo'     => 'wolof',
    'xal'    => 'kalmyk',
    'xh'     => 'xhosa',
    'xog'    => 'Soga',
    'yao'    => 'yao',
    'yap'    => 'yapesisk',
    'yav'    => 'yangben',
    'yi'     => 'jiddisk',
    'yo'     => 'joruba',
    'ypk'    => "jupisk\ språk",
    'yue'    => 'kantonesisk',
    'za'     => 'zhuang',
    'zap'    => 'zapotec',
    'zbl'    => 'blissymbol',
    'zen'    => 'zenaga',
    'zh'     => 'kinesisk',
    'znd'    => 'zande',
    'zu'     => 'zulu',
    'zun'    => 'zuni',
    'zxx'    => "utan\ språkleg\ innhald",
    'zza'    => 'zaza',
);

%Locales::DB::Language::nn::name_to_code = (
    'abkhasisk'                               => 'ab',
    'achinesisk'                              => 'ace',
    'acoli'                                   => 'ach',
    'adangme'                                 => 'ada',
    'adyghe'                                  => 'ady',
    'afar'                                    => 'aa',
    'afrihili'                                => 'afh',
    'afrikaans'                               => 'af',
    'afroasiatiskspråk'                      => 'afa',
    'aghem'                                   => 'agq',
    'ainu'                                    => 'ain',
    'akan'                                    => 'ak',
    'akkadisk'                                => 'akk',
    'albansk'                                 => 'sq',
    'aleutisk'                                => 'ale',
    'algonkinskspråk'                        => 'alg',
    'altaiskspråk'                           => 'tut',
    'amharisk'                                => 'am',
    'angika'                                  => 'anp',
    'annaspråk'                              => 'mis',
    'apachespråk'                            => 'apa',
    'arabisk'                                 => 'ar',
    'aragonsk'                                => 'an',
    'arameisk'                                => 'arc',
    'arapaho'                                 => 'arp',
    'araukansk'                               => 'arn',
    'arawak'                                  => 'arw',
    'armensk'                                 => 'hy',
    'aromansk'                                => 'rup',
    'aserbajdsjansk'                          => 'az',
    'assamisk'                                => 'as',
    'asturisk'                                => 'ast',
    'asutanzania'                             => 'asa',
    'athapaskanskspråk'                      => 'ath',
    'atsam'                                   => 'cch',
    'austerriksktysk'                         => 'de_at',
    'austfrisisk'                             => 'frs',
    'australiskengelsk'                       => 'en_au',
    'australskspråk'                         => 'aus',
    'austronesiskspråk'                      => 'map',
    'avarisk'                                 => 'av',
    'avestisk'                                => 'ae',
    'awadhi'                                  => 'awa',
    'aymara'                                  => 'ay',
    'bafia'                                   => 'ksf',
    'balinesisk'                              => 'ban',
    'baltiskspråk'                           => 'bat',
    'baluchi'                                 => 'bal',
    'bambara'                                 => 'bm',
    'bamilekiskspråk'                        => 'bai',
    'banda'                                   => 'bad',
    'bantu'                                   => 'bnt',
    'basa'                                    => 'bas',
    'basjkirsk'                               => 'ba',
    'baskisk'                                 => 'eu',
    'batak'                                   => 'btk',
    'beja'                                    => 'bej',
    'bemba'                                   => 'bem',
    'benatanzania'                            => 'bez',
    'bengali'                                 => 'bn',
    'berbisk'                                 => 'ber',
    'bhojpuri'                                => 'bho',
    'bihari'                                  => 'bh',
    'bikol'                                   => 'bik',
    'bini'                                    => 'bin',
    'bislama'                                 => 'bi',
    'blin'                                    => 'byn',
    'blissymbol'                              => 'zbl',
    'bodo'                                    => 'brx',
    'bokmål'                                 => 'nb',
    'bosnisk'                                 => 'bs',
    'braj'                                    => 'bra',
    'brasilianskportugisisk'                  => 'pt_br',
    'bretonsk'                                => 'br',
    'britiskengelsk'                          => 'en_gb',
    'buginesisk'                              => 'bug',
    'bulgarsk'                                => 'bg',
    'burjatisk'                               => 'bua',
    'burmesisk'                               => 'my',
    'caddo'                                   => 'cad',
    'cayuga'                                  => 'cay',
    'cebuansk'                                => 'ceb',
    'centralmoroccotamazight'                 => 'tzm',
    'chagatai'                                => 'chg',
    'chamorro'                                => 'ch',
    'cherokee'                                => 'chr',
    'cheyenne'                                => 'chy',
    'chibcha'                                 => 'chb',
    'chiga'                                   => 'cgg',
    'chinook'                                 => 'chn',
    'chipewiansk'                             => 'chp',
    'choctaw'                                 => 'cho',
    'chuukesisk'                              => 'chk',
    'colognian'                               => 'ksh',
    'congoswahili'                            => 'swc',
    'cree'                                    => 'cr',
    'creek'                                   => 'mus',
    'dakota'                                  => 'dak',
    'dansk'                                   => 'da',
    'dargwa'                                  => 'dar',
    'dayak'                                   => 'day',
    'delaware'                                => 'del',
    'dinka'                                   => 'din',
    'divehi'                                  => 'dv',
    'dogri'                                   => 'doi',
    'dogrib'                                  => 'dgr',
    'dravidiskspråk'                         => 'dra',
    'duala'                                   => 'dua',
    'dyula'                                   => 'dyu',
    'dzongkha'                                => 'dz',
    'efik'                                    => 'efi',
    'ekajuk'                                  => 'eka',
    'elamittisk'                              => 'elx',
    'enaresamisk'                             => 'smn',
    'engelsk'                                 => 'en',
    'engelskamerikansk'                       => 'en_us',
    'engelskbasertkreolellerpidginspråk'     => 'cpe',
    'erzya'                                   => 'myv',
    'esperanto'                               => 'eo',
    'estisk'                                  => 'et',
    'europeiskportugisisk'                    => 'pt_pt',
    'ewe'                                     => 'ee',
    'ewondo'                                  => 'ewo',
    'fang'                                    => 'fan',
    'fanti'                                   => 'fat',
    'fijiansk'                                => 'fj',
    'filippinsk'                              => 'fil',
    'filippinskspråk'                        => 'phi',
    'finsk'                                   => 'fi',
    'finskugriskspråk'                       => 'fiu',
    'flamsk'                                  => 'nl_be',
    'fleirespråk'                            => 'mul',
    'fon'                                     => 'fon',
    'fransk'                                  => 'fr',
    'franskbasertkreolellerpidginspråk'      => 'cpf',
    'friuliansk'                              => 'fur',
    'fulani'                                  => 'ff',
    'færøysk'                               => 'fo',
    'fønikisk'                               => 'phn',
    'ga'                                      => 'gaa',
    'galicisk'                                => 'gl',
    'gammalegyptisk'                          => 'egy',
    'gammalengelsk'                           => 'ang',
    'gammalfransk'                            => 'fro',
    'gammalgresk'                             => 'grc',
    'gammalhøgtysk'                          => 'goh',
    'gammalirsk'                              => 'sga',
    'gammalnorsk'                             => 'non',
    'gammalpersisk'                           => 'peo',
    'gammalprovençalsk'                      => 'pro',
    'ganda'                                   => 'lg',
    'gayo'                                    => 'gay',
    'gbaya'                                   => 'gba',
    'georgisk'                                => 'ka',
    'germanskspråk'                          => 'gem',
    'ges'                                     => 'gez',
    'gondi'                                   => 'gon',
    'gorontalo'                               => 'gor',
    'gotisk'                                  => 'got',
    'grebo'                                   => 'grb',
    'gresk'                                   => 'el',
    'guarani'                                 => 'gn',
    'gujarati'                                => 'gu',
    'gusii'                                   => 'guz',
    'gwichin'                                 => 'gwi',
    'haida'                                   => 'hai',
    'haitisk'                                 => 'ht',
    'hausa'                                   => 'ha',
    'hawaiisk'                                => 'haw',
    'hebraisk'                                => 'he',
    'herero'                                  => 'hz',
    'hettittisk'                              => 'hit',
    'hiligaynon'                              => 'hil',
    'himachali'                               => 'him',
    'hindi'                                   => 'hi',
    'hirimotu'                                => 'ho',
    'hmong'                                   => 'hmn',
    'hupa'                                    => 'hup',
    'høgsorbisk'                             => 'hsb',
    'iban'                                    => 'iba',
    'iberiskspansk'                           => 'es_es',
    'ibo'                                     => 'ig',
    'ido'                                     => 'io',
    'ijo'                                     => 'ijo',
    'iloko'                                   => 'ilo',
    'indiskspråk'                            => 'inc',
    'indoeuropeiskspråk'                     => 'ine',
    'indonesisk'                              => 'id',
    'ingusjisk'                               => 'inh',
    'interlingua'                             => 'ia',
    'interlingue'                             => 'ie',
    'inuktitut'                               => 'iu',
    'inupiak'                                 => 'ik',
    'iranskspråk'                            => 'ira',
    'irokanskspråk'                          => 'iro',
    'irsk'                                    => 'ga',
    'islandsk'                                => 'is',
    'italiensk'                               => 'it',
    'jakutsk'                                 => 'sah',
    'japansk'                                 => 'ja',
    'javanesisk'                              => 'jv',
    'jiddisk'                                 => 'yi',
    'jju'                                     => 'kaj',
    'jolafonyi'                               => 'dyo',
    'joruba'                                  => 'yo',
    'jupiskspråk'                            => 'ypk',
    'jødearabisk'                            => 'jrb',
    'jødepersisk'                            => 'jpr',
    'kabardisk'                               => 'kbd',
    'kabylsk'                                 => 'kab',
    'kachin'                                  => 'kac',
    "kalaallisut\;grønlandsk"                => 'kl',
    'kalenjin'                                => 'kln',
    'kalmyk'                                  => 'xal',
    'kamba'                                   => 'kam',
    'kamiskspråk'                            => 'cmc',
    'kanadiskengelsk'                         => 'en_ca',
    'kanadiskfransk'                          => 'fr_ca',
    'kannada'                                 => 'kn',
    'kantonesisk'                             => 'yue',
    'kanuri'                                  => 'kr',
    'kapverdisk'                              => 'kea',
    'karachaybalkar'                          => 'krc',
    'karakalpakisk'                           => 'kaa',
    'karelsk'                                 => 'krl',
    'karensk'                                 => 'kar',
    'karibisk'                                => 'car',
    'kasakhisk'                               => 'kk',
    'kasjmiri'                                => 'ks',
    'kasjubisk'                               => 'csb',
    'katalansk'                               => 'ca',
    'kaukasiskspråk'                         => 'cau',
    'kawi'                                    => 'kaw',
    'keltiskspråk'                           => 'cel',
    'khasi'                                   => 'kha',
    'khmer'                                   => 'km',
    'khoisanspråk'                           => 'khi',
    'khotanesisk'                             => 'kho',
    'kiembu'                                  => 'ebu',
    'kikongo'                                 => 'kg',
    'kikuyu'                                  => 'ki',
    'kimbundu'                                => 'kmb',
    'kinesisk'                                => 'zh',
    'kinjarwanda'                             => 'rw',
    'kirgisisk'                               => 'ky',
    'kiribatisk'                              => 'gil',
    'klassisknewarisk'                        => 'nwc',
    'klassisksyrisk'                          => 'syc',
    'klingon'                                 => 'tlh',
    'komi'                                    => 'kv',
    'konkani'                                 => 'kok',
    'koptisk'                                 => 'cop',
    'koreansk'                                => 'ko',
    'kornisk'                                 => 'kw',
    'koro'                                    => 'kfo',
    'korsikansk'                              => 'co',
    'kosraeansk'                              => 'kos',
    'koyraborosenni'                          => 'ses',
    'koyrachiini'                             => 'khq',
    'kpelle'                                  => 'kpe',
    'kreolellerpidginspråk'                  => 'crp',
    'krimtatarisk'                            => 'crh',
    'kroatisk'                                => 'hr',
    'kru'                                     => 'kro',
    'kuanyama'                                => 'kj',
    'kumyk'                                   => 'kum',
    'kunstigspråk'                           => 'art',
    'kurdisk'                                 => 'ku',
    'kurukh'                                  => 'kru',
    'kusjitiskspråk'                         => 'cus',
    'kutenai'                                 => 'kut',
    'kviterussisk'                            => 'be',
    'kwasio'                                  => 'nmg',
    'kyrkjeslavisk'                           => 'cu',
    'ladinsk'                                 => 'lad',
    'lahnda'                                  => 'lah',
    'lamba'                                   => 'lam',
    'langi'                                   => 'lag',
    'laotisk'                                 => 'lo',
    'latin'                                   => 'la',
    'latinamerikanskspansk'                   => 'es_419',
    'latvisk'                                 => 'lv',
    'lezghian'                                => 'lez',
    'limburgisk'                              => 'li',
    'lingala'                                 => 'ln',
    'litauisk'                                => 'lt',
    'lojban'                                  => 'jbo',
    'lozi'                                    => 'loz',
    'lubakatanga'                             => 'lu',
    'lubalulua'                               => 'lua',
    'luiseno'                                 => 'lui',
    'lulesamisk'                              => 'smj',
    'lunda'                                   => 'lun',
    'luo'                                     => 'luo',
    'lushai'                                  => 'lus',
    'luxemburgsk'                             => 'lb',
    'lågsorbisk'                             => 'dsb',
    'lågtysk'                                => 'nds',
    'machame'                                 => 'jmc',
    'madagassisk'                             => 'mg',
    'maduresisk'                              => 'mad',
    'magahi'                                  => 'mag',
    'maithili'                                => 'mai',
    'makasar'                                 => 'mak',
    'makedonsk'                               => 'mk',
    'makhuwameetto'                           => 'mgh',
    'makonde'                                 => 'kde',
    'malayalam'                               => 'ml',
    'malayisk'                                => 'ms',
    'maltesisk'                               => 'mt',
    'mandar'                                  => 'mdr',
    'mandingo'                                => 'man',
    'mandsju'                                 => 'mnc',
    'manipuri'                                => 'mni',
    'manobospråk'                            => 'mno',
    'manx'                                    => 'gv',
    'maori'                                   => 'mi',
    'marathi'                                 => 'mr',
    'mari'                                    => 'chm',
    'marshallesisk'                           => 'mh',
    'marwari'                                 => 'mwr',
    'masai'                                   => 'mas',
    'mayaspråk'                              => 'myn',
    'mellomengelsk'                           => 'enm',
    'mellomfransk'                            => 'frm',
    'mellomhøgtysk'                          => 'gmh',
    'mellomirsk'                              => 'mga',
    'mellumnederlandsk'                       => 'dum',
    'mende'                                   => 'men',
    'meru'                                    => 'mer',
    'micmac'                                  => 'mic',
    'minangkabau'                             => 'min',
    'mirandesisk'                             => 'mwl',
    'mohawk'                                  => 'moh',
    'moksha'                                  => 'mdf',
    'moldavisk'                               => 'mo',
    'mongo'                                   => 'lol',
    'mongolsk'                                => 'mn',
    'monkhmerspråk'                          => 'mkh',
    'morisyen'                                => 'mfe',
    'mossi'                                   => 'mos',
    'mundang'                                 => 'mua',
    'mundaspråk'                             => 'mun',
    'nahuatl'                                 => 'nah',
    'nama'                                    => 'naq',
    'napolitansk'                             => 'nap',
    'nauru'                                   => 'na',
    'navajo'                                  => 'nv',
    'ndonga'                                  => 'ng',
    'nederlandsk'                             => 'nl',
    'nepalsk'                                 => 'ne',
    'newari'                                  => 'new',
    'nias'                                    => 'nia',
    'nigerkordofanianskspråk'                => 'nic',
    'nilosaharaspråk'                        => 'ssa',
    'niueansk'                                => 'niu',
    'nko'                                     => 'nqo',
    'nogai'                                   => 'nog',
    'nordamerikanskindianskspråk'            => 'nai',
    'nordfrisisk'                             => 'frr',
    'nordndebele'                             => 'nd',
    'nordsamisk'                              => 'se',
    'nordsotho'                               => 'nso',
    'norsk'                                   => 'no',
    'nubiskspråk'                            => 'nub',
    'nuer'                                    => 'nus',
    'nyamwezi'                                => 'nym',
    'nyanja'                                  => 'ny',
    'nyankole'                                => 'nyn',
    'nynorsk'                                 => 'nn',
    'nyoro'                                   => 'nyo',
    'nzima'                                   => 'nzi',
    'ojibwa'                                  => 'oj',
    'oksitansk'                               => 'oc',
    'olulujia'                                => 'luy',
    'oriya'                                   => 'or',
    'oromo'                                   => 'om',
    'osage'                                   => 'osa',
    'ossetisk'                                => 'os',
    'otomiskspråk'                           => 'oto',
    'ottomansktyrkisk'                        => 'ota',
    'pahlavi'                                 => 'pal',
    'palauisk'                                => 'pau',
    'pali'                                    => 'pi',
    'pampanga'                                => 'pam',
    'pangasinan'                              => 'pag',
    'panjabi'                                 => 'pa',
    'papiamento'                              => 'pap',
    'papuiskspråk'                           => 'paa',
    'pashto'                                  => 'ps',
    'persisk'                                 => 'fa',
    'polsk'                                   => 'pl',
    'ponapisk'                                => 'pon',
    'portugisisk'                             => 'pt',
    'portugisiskbasertkreolellerpidginspråk' => 'cpp',
    'prakritspråk'                           => 'pra',
    'quechua'                                 => 'qu',
    'rajasthani'                              => 'raj',
    'rapanui'                                 => 'rap',
    'rarotongansk'                            => 'rar',
    'retoromansk'                             => 'rm',
    'romani'                                  => 'rom',
    'romanskspråk'                           => 'roa',
    'rombo'                                   => 'rof',
    'rumensk'                                 => 'ro',
    'rundi'                                   => 'rn',
    'russisk'                                 => 'ru',
    'rwa'                                     => 'rwk',
    'saho'                                    => 'ssy',
    'salishanskspråk'                        => 'sal',
    'samaritanskarameisk'                     => 'sam',
    'samburu'                                 => 'saq',
    'samiskspråk'                            => 'smi',
    'samoansk'                                => 'sm',
    'sandawe'                                 => 'sad',
    'sango'                                   => 'sg',
    'sangu'                                   => 'sbp',
    'sanskrit'                                => 'sa',
    'santali'                                 => 'sat',
    'sardinsk'                                => 'sc',
    'sasak'                                   => 'sas',
    'selkupisk'                               => 'sel',
    'semittiskspråk'                         => 'sem',
    'sena'                                    => 'seh',
    'seneca'                                  => 'see',
    'sentralamerikanskindianskspråk'         => 'cai',
    'serbisk'                                 => 'sr',
    'serbokroatisk'                           => 'sh',
    'serer'                                   => 'srr',
    'shambala'                                => 'ksb',
    'shan'                                    => 'shn',
    'shimaore'                                => 'swb',
    'shona'                                   => 'sn',
    'sichuanyi'                               => 'ii',
    'siciliansk'                              => 'scn',
    'sidamo'                                  => 'sid',
    'siksika'                                 => 'bla',
    'sindhi'                                  => 'sd',
    'singalesisk'                             => 'si',
    'sinotibetanskspråk'                     => 'sit',
    'siouxspråk'                             => 'sio',
    'skoltesamisk'                            => 'sms',
    'skotsk'                                  => 'sco',
    'skotskgælisk'                           => 'gd',
    'slavej'                                  => 'den',
    'slaviskspråk'                           => 'sla',
    'slovakisk'                               => 'sk',
    'slovensk'                                => 'sl',
    'soga'                                    => 'xog',
    'sogdisk'                                 => 'sog',
    'somali'                                  => 'so',
    'songhai'                                 => 'son',
    'soninke'                                 => 'snk',
    'sorbiskspråk'                           => 'wen',
    'spansk'                                  => 'es',
    'sranantongo'                             => 'srn',
    'sukuma'                                  => 'suk',
    'sumerisk'                                => 'sux',
    'sundanesisk'                             => 'su',
    'susu'                                    => 'sus',
    'sveitsertysk'                            => 'gsw',
    'sveitsiskfransk'                         => 'fr_ch',
    'sveitsiskhøgtysk'                       => 'de_ch',
    'svensk'                                  => 'sv',
    'swahili'                                 => 'sw',
    'swati'                                   => 'ss',
    'syrisk'                                  => 'syr',
    'søraltai'                               => 'alt',
    'søramerikanskindianskspråk'            => 'sai',
    'sørndebele'                             => 'nr',
    'sørsamisk'                              => 'sma',
    'sørsotho'                               => 'st',
    'tachelhit'                               => 'shi',
    'tagalog'                                 => 'tl',
    'tahitisk'                                => 'ty',
    'taispråk'                               => 'tai',
    'taita'                                   => 'dav',
    'tamasjek'                                => 'tmh',
    'tamil'                                   => 'ta',
    'taroko'                                  => 'trv',
    'tasawaq'                                 => 'twq',
    'tatarisk'                                => 'tt',
    'tatsjikisk'                              => 'tg',
    'teiknspråk'                             => 'sgn',
    'telugu'                                  => 'te',
    'temne'                                   => 'tem',
    'tereno'                                  => 'ter',
    'teso'                                    => 'teo',
    'tetum'                                   => 'tet',
    'thai'                                    => 'th',
    'tibetansk'                               => 'bo',
    'tigrinja'                                => 'ti',
    'tigré'                                  => 'tig',
    'tivi'                                    => 'tiv',
    'tlingit'                                 => 'tli',
    'tokelau'                                 => 'tkl',
    'tokpisin'                                => 'tpi',
    'tonganyasa'                              => 'tog',
    'tongatongaøyane'                        => 'to',
    'tsimshian'                               => 'tsi',
    'tsjekkisk'                               => 'cs',
    'tsjetsjensk'                             => 'ce',
    'tsjuvansk'                               => 'cv',
    'tsonga'                                  => 'ts',
    'tswana'                                  => 'tn',
    'tumbuka'                                 => 'tum',
    'tupispråk'                              => 'tup',
    'turkmensk'                               => 'tk',
    'tuvalu'                                  => 'tvl',
    'tuvinisk'                                => 'tyv',
    'twi'                                     => 'tw',
    'tyap'                                    => 'kcg',
    'tyrkisk'                                 => 'tr',
    'tysk'                                    => 'de',
    'udmurt'                                  => 'udm',
    'ugaritisk'                               => 'uga',
    'uigurisk'                                => 'ug',
    'ukjentspråk'                            => 'und',
    'ukrainsk'                                => 'uk',
    'umbundu'                                 => 'umb',
    'ungarsk'                                 => 'hu',
    'urdu'                                    => 'ur',
    'usbekisk'                                => 'uz',
    'utanspråkleginnhald'                    => 'zxx',
    'vai'                                     => 'vai',
    'vallonsk'                                => 'wa',
    'venda'                                   => 've',
    'vestfrisisk'                             => 'fy',
    'vietnamesisk'                            => 'vi',
    'volapyk'                                 => 'vo',
    'votisk'                                  => 'vot',
    'vunjo'                                   => 'vun',
    'wakasjanskspråk'                        => 'wak',
    'walamo'                                  => 'wal',
    'walisisk'                                => 'cy',
    'walser'                                  => 'wae',
    'waray'                                   => 'war',
    'washo'                                   => 'was',
    'wolof'                                   => 'wo',
    'xhosa'                                   => 'xh',
    'yangben'                                 => 'yav',
    'yao'                                     => 'yao',
    'yapesisk'                                => 'yap',
    'zande'                                   => 'znd',
    'zapotec'                                 => 'zap',
    'zarma'                                   => 'dje',
    'zaza'                                    => 'zza',
    'zenaga'                                  => 'zen',
    'zhuang'                                  => 'za',
    'zulu'                                    => 'zu',
    'zuni'                                    => 'zun',
);

1;
