package XML::IODEF::Simple::Plugin::Malware;

use XML::IODEF::Simple::Plugin::Url;

sub prepare {
    my $class   = shift;
    my $info    = shift;

    return(0) unless($info->{'impact'});
    return(0) unless($info->{'impact'} =~ /(malware|exploit)/);

    # since malware url and malware sort of share this plugin
    # and url falls lower in the a-z pecking order
    # we use this as a work-around for that
    XML::IODEF::Simple::Plugin::Url->prepare($info);
    return(1);
}

sub convert {
    my $class = shift;
    my $info = shift;
    my $iodef = shift;

    unless($info->{'severity'}){
        # if we're talking about an actual piece of malware
        if($info->{'impact'} =~ /^(malware|binary)$/){
            $iodef->add('IncidentAssessmentImpactseverity','high');
        } else {
            # probably a malware url, which is less severe
            $iodef->add('IncidentAssessmentImpactseverity','medium');
        }
    }

    return($iodef);
}

1;

