[![Build Status](https://travis-ci.org/sixapart/Net-Airbrake.svg?branch=master)](https://travis-ci.org/sixapart/Net-Airbrake)
# NAME

Net::Airbrake - Airbrake Notifier API Client

# SYNOPSIS

    use Net::Airbrake;

    my $airbrake = Net::Airbrake->new(
        api_key    => 'xxxxxxx',
        project_id => 9999999,
    );

    eval { die 'Oops' };
    $airbrake->notify($@);

# DESCRIPTION

Net::Airbrake is a client of [Airbrake](https://airbrake.io).

# CLASS METHODS

## new(\\%param)

Create a new instance.

- api\_key

    Required. API Key of your project.

- project\_id

    Required. Project ID.

- environment

    Optional. The name of environment your application is running.
    Default value is ueded $ENV{AIRBRAKE\_ENV} or $ENV{PLACK\_ENV} or 'default'.

# INSTANCE METHODS

## add\_error($error)

Add an error. $error accepts HashRef, Object, string generated by die() or just
string message. If you want to send raw error report, use HashRef included
following key/value pairs:

- type => String

    Required. Error type.

- message => String

    Required. Error message.

- backtrace => ArrayRef\[HashRef\]

    Optional. HashRef can contain followings key/value pairs:

    - file => String

        File name an error occurred.

    - line => Integer

        Line number an error occurred.

    - function => String

        Subroutine name an error occurred.

## has\_error()

Return true value if the instance has been added error by add\_error().

## send(\\%option)

Send errors added by add\_error() to Airbrake. \\%option parameter is optional and
all key/value pairs of its also optional. You can specify followings to report
 error details.

details

- context => HashRef

    Context values of its error.

- environment => HashRef

    Environment variables. Set HTTP Headers on web application as usual.

- session => HashRef

    Session values. Set your application session parameters.

- params => HashRef

    Request parameters. Set HTTP Request parameters on web application as usual.

## notify(\\%error, \\%option)

Shortcut of add\_error() and send() combination.

# SEE ALSO

Notifier API V3 - [https://help.airbrake.io/kb/api-2/notifier-api-v3](https://help.airbrake.io/kb/api-2/notifier-api-v3)

# AUTHOR

Six Apart, Ltd. <sixapart@cpan.org>

# LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
