# Generated by default/object.tt
package Paws::WAFV2::IPSetReferenceStatement;
  use Moose;
  has ARN => (is => 'ro', isa => 'Str', required => 1);
  has IPSetForwardedIPConfig => (is => 'ro', isa => 'Paws::WAFV2::IPSetForwardedIPConfig');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::IPSetReferenceStatement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::IPSetReferenceStatement object:

  $service_obj->Method(Att1 => { ARN => $value, ..., IPSetForwardedIPConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::IPSetReferenceStatement object:

  $result = $service_obj->Method(...);
  $result->Att1->ARN

=head1 DESCRIPTION

A rule statement used to detect web requests coming from particular IP
addresses or address ranges. To use this, create an IPSet that
specifies the addresses you want to detect, then use the ARN of that
set in this statement. To create an IP set, see CreateIPSet.

Each IP set rule statement references an IP set. You create and
maintain the set independent of your rules. This allows you to use the
single set in multiple rules. When you update the referenced set, WAF
automatically updates all rules that reference it.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ARN => Str

The Amazon Resource Name (ARN) of the IPSet that this statement
references.


=head2 IPSetForwardedIPConfig => L<Paws::WAFV2::IPSetForwardedIPConfig>

The configuration for inspecting IP addresses in an HTTP header that
you specify, instead of using the IP address that's reported by the web
request origin. Commonly, this is the X-Forwarded-For (XFF) header, but
you can specify any header name.

If the specified header isn't present in the request, WAF doesn't apply
the rule to the web request at all.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

