# Generated by default/object.tt
package Paws::Synthetics::RuntimeVersion;
  use Moose;
  has DeprecationDate => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has ReleaseDate => (is => 'ro', isa => 'Str');
  has VersionName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Synthetics::RuntimeVersion

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Synthetics::RuntimeVersion object:

  $service_obj->Method(Att1 => { DeprecationDate => $value, ..., VersionName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Synthetics::RuntimeVersion object:

  $result = $service_obj->Method(...);
  $result->Att1->DeprecationDate

=head1 DESCRIPTION

This structure contains information about one canary runtime version.
For more information about runtime versions, see Canary Runtime
Versions
(https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).

=head1 ATTRIBUTES


=head2 DeprecationDate => Str

If this runtime version is deprecated, this value is the date of
deprecation.


=head2 Description => Str

A description of the runtime version, created by Amazon.


=head2 ReleaseDate => Str

The date that the runtime version was released.


=head2 VersionName => Str

The name of the runtime version. For a list of valid runtime versions,
see Canary Runtime Versions
(https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Synthetics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

