# Generated by default/object.tt
package Paws::SecurityHub::AwsSsmComplianceSummary;
  use Moose;
  has ComplianceType => (is => 'ro', isa => 'Str');
  has CompliantCriticalCount => (is => 'ro', isa => 'Int');
  has CompliantHighCount => (is => 'ro', isa => 'Int');
  has CompliantInformationalCount => (is => 'ro', isa => 'Int');
  has CompliantLowCount => (is => 'ro', isa => 'Int');
  has CompliantMediumCount => (is => 'ro', isa => 'Int');
  has CompliantUnspecifiedCount => (is => 'ro', isa => 'Int');
  has ExecutionType => (is => 'ro', isa => 'Str');
  has NonCompliantCriticalCount => (is => 'ro', isa => 'Int');
  has NonCompliantHighCount => (is => 'ro', isa => 'Int');
  has NonCompliantInformationalCount => (is => 'ro', isa => 'Int');
  has NonCompliantLowCount => (is => 'ro', isa => 'Int');
  has NonCompliantMediumCount => (is => 'ro', isa => 'Int');
  has NonCompliantUnspecifiedCount => (is => 'ro', isa => 'Int');
  has OverallSeverity => (is => 'ro', isa => 'Str');
  has PatchBaselineId => (is => 'ro', isa => 'Str');
  has PatchGroup => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsSsmComplianceSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsSsmComplianceSummary object:

  $service_obj->Method(Att1 => { ComplianceType => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsSsmComplianceSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ComplianceType

=head1 DESCRIPTION

Provides the details about the compliance status for a patch.

=head1 ATTRIBUTES


=head2 ComplianceType => Str

The type of resource for which the compliance was determined. For
C<AwsSsmPatchCompliance>, C<ComplianceType> is C<Patch>.


=head2 CompliantCriticalCount => Int

For the patches that are compliant, the number that have a severity of
C<CRITICAL>.


=head2 CompliantHighCount => Int

For the patches that are compliant, the number that have a severity of
C<HIGH>.


=head2 CompliantInformationalCount => Int

For the patches that are compliant, the number that have a severity of
C<INFORMATIONAL>.


=head2 CompliantLowCount => Int

For the patches that are compliant, the number that have a severity of
C<LOW>.


=head2 CompliantMediumCount => Int

For the patches that are compliant, the number that have a severity of
C<MEDIUM>.


=head2 CompliantUnspecifiedCount => Int

For the patches that are compliant, the number that have a severity of
C<UNSPECIFIED>.


=head2 ExecutionType => Str

The type of execution that was used determine compliance.


=head2 NonCompliantCriticalCount => Int

For the patch items that are noncompliant, the number of items that
have a severity of C<CRITICAL>.


=head2 NonCompliantHighCount => Int

For the patches that are noncompliant, the number that have a severity
of C<HIGH>.


=head2 NonCompliantInformationalCount => Int

For the patches that are noncompliant, the number that have a severity
of C<INFORMATIONAL>.


=head2 NonCompliantLowCount => Int

For the patches that are noncompliant, the number that have a severity
of C<LOW>.


=head2 NonCompliantMediumCount => Int

For the patches that are noncompliant, the number that have a severity
of C<MEDIUM>.


=head2 NonCompliantUnspecifiedCount => Int

For the patches that are noncompliant, the number that have a severity
of C<UNSPECIFIED>.


=head2 OverallSeverity => Str

The highest severity for the patches.


=head2 PatchBaselineId => Str

The identifier of the patch baseline. The patch baseline lists the
patches that are approved for installation.


=head2 PatchGroup => Str

The identifier of the patch group for which compliance was determined.
A patch group uses tags to group EC2 instances that should have the
same patch compliance.


=head2 Status => Str

The current patch compliance status.

The possible status values are:

=over

=item *

C<COMPLIANT>

=item *

C<NON_COMPLIANT>

=item *

C<UNSPECIFIED_DATA>

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

