# Generated by default/object.tt
package Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughput;
  use Moose;
  has LastDecreaseDateTime => (is => 'ro', isa => 'Str');
  has LastIncreaseDateTime => (is => 'ro', isa => 'Str');
  has NumberOfDecreasesToday => (is => 'ro', isa => 'Int');
  has ReadCapacityUnits => (is => 'ro', isa => 'Int');
  has WriteCapacityUnits => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughput object:

  $service_obj->Method(Att1 => { LastDecreaseDateTime => $value, ..., WriteCapacityUnits => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsDynamoDbTableProvisionedThroughput object:

  $result = $service_obj->Method(...);
  $result->Att1->LastDecreaseDateTime

=head1 DESCRIPTION

Information about the provisioned throughput for the table or for a
global secondary index.

=head1 ATTRIBUTES


=head2 LastDecreaseDateTime => Str

Indicates when the provisioned throughput was last decreased.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 LastIncreaseDateTime => Str

Indicates when the provisioned throughput was last increased.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 NumberOfDecreasesToday => Int

The number of times during the current UTC calendar day that the
provisioned throughput was decreased.


=head2 ReadCapacityUnits => Int

The maximum number of strongly consistent reads consumed per second
before DynamoDB returns a C<ThrottlingException>.


=head2 WriteCapacityUnits => Int

The maximum number of writes consumed per second before DynamoDB
returns a C<ThrottlingException>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

