# Generated by default/object.tt
package Paws::IoTSiteWise::Variant;
  use Moose;
  has BooleanValue => (is => 'ro', isa => 'Bool', request_name => 'booleanValue', traits => ['NameInRequest']);
  has DoubleValue => (is => 'ro', isa => 'Num', request_name => 'doubleValue', traits => ['NameInRequest']);
  has IntegerValue => (is => 'ro', isa => 'Int', request_name => 'integerValue', traits => ['NameInRequest']);
  has StringValue => (is => 'ro', isa => 'Str', request_name => 'stringValue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::Variant

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::Variant object:

  $service_obj->Method(Att1 => { BooleanValue => $value, ..., StringValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::Variant object:

  $result = $service_obj->Method(...);
  $result->Att1->BooleanValue

=head1 DESCRIPTION

Contains an asset property value (of a single type only).

=head1 ATTRIBUTES


=head2 BooleanValue => Bool

Asset property data of type Boolean (true or false).


=head2 DoubleValue => Num

Asset property data of type double (floating point number).


=head2 IntegerValue => Int

Asset property data of type integer (whole number).


=head2 StringValue => Str

Asset property data of type string (sequence of characters).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

