# Generated by default/object.tt
package Paws::AuditManager::AssessmentFrameworkMetadata;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has ComplianceType => (is => 'ro', isa => 'Str', request_name => 'complianceType', traits => ['NameInRequest']);
  has ControlsCount => (is => 'ro', isa => 'Int', request_name => 'controlsCount', traits => ['NameInRequest']);
  has ControlSetsCount => (is => 'ro', isa => 'Int', request_name => 'controlSetsCount', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has LastUpdatedAt => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedAt', traits => ['NameInRequest']);
  has Logo => (is => 'ro', isa => 'Str', request_name => 'logo', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::AssessmentFrameworkMetadata

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::AssessmentFrameworkMetadata object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::AssessmentFrameworkMetadata object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The metadata associated with a standard or custom framework.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the framework.


=head2 ComplianceType => Str

The compliance type that the new custom framework supports, such as CIS
or HIPAA.


=head2 ControlsCount => Int

The number of controls associated with the specified framework.


=head2 ControlSetsCount => Int

The number of control sets associated with the specified framework.


=head2 CreatedAt => Str

Specifies when the framework was created.


=head2 Description => Str

The description of the specified framework.


=head2 Id => Str

The unique identified for the specified framework.


=head2 LastUpdatedAt => Str

Specifies when the framework was most recently updated.


=head2 Logo => Str

The logo associated with the framework.


=head2 Name => Str

The name of the specified framework.


=head2 Type => Str

The framework type, such as standard or custom.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

