# Generated by default/object.tt
package Paws::GlueDataBrew::Output;
  use Moose;
  has CompressionFormat => (is => 'ro', isa => 'Str');
  has Format => (is => 'ro', isa => 'Str');
  has FormatOptions => (is => 'ro', isa => 'Paws::GlueDataBrew::OutputFormatOptions');
  has Location => (is => 'ro', isa => 'Paws::GlueDataBrew::S3Location', required => 1);
  has Overwrite => (is => 'ro', isa => 'Bool');
  has PartitionColumns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::Output

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::Output object:

  $service_obj->Method(Att1 => { CompressionFormat => $value, ..., PartitionColumns => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::Output object:

  $result = $service_obj->Method(...);
  $result->Att1->CompressionFormat

=head1 DESCRIPTION

Represents options that specify how and where DataBrew writes the
output generated by recipe jobs or profile jobs.

=head1 ATTRIBUTES


=head2 CompressionFormat => Str

The compression algorithm used to compress the output text of the job.


=head2 Format => Str

The data format of the output of the job.


=head2 FormatOptions => L<Paws::GlueDataBrew::OutputFormatOptions>

Represents options that define how DataBrew formats job output files.


=head2 B<REQUIRED> Location => L<Paws::GlueDataBrew::S3Location>

The location in Amazon S3 where the job writes its output.


=head2 Overwrite => Bool

A value that, if true, means that any data in the location specified
for output is overwritten with new output.


=head2 PartitionColumns => ArrayRef[Str|Undef]

The names of one or more partition columns for the output of the job.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

