
use Test ;

use Nagios::Report ;

=for comment

      July 2006
Su Mo Tu We Th Fr Sa 
                   1
 2  3  4  5  6  7  8
 9 10 11 12 13 14 15
16 17 18 19 20 21 22
23 24 25 26 27 28 29
30 31

     August 2006
Su Mo Tu We Th Fr Sa 
       1  2  3  4  5
 6  7  8  9 10 11 12
13 14 15 16 17 18 19
20 21 22 23 24 25 26
27 28 29 30 31


=cut

BEGIN { plan tests => 369 }

ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 0, 18, 7, 106] )), "Thu Aug 17 12:00:00 2006-Fri Aug 18 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 1, 18, 7, 106] )), "Thu Aug 17 13:00:00 2006-Fri Aug 18 01:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 2, 18, 7, 106] )), "Thu Aug 17 14:00:00 2006-Fri Aug 18 02:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 3, 18, 7, 106] )), "Thu Aug 17 15:00:00 2006-Fri Aug 18 03:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 4, 18, 7, 106] )), "Thu Aug 17 16:00:00 2006-Fri Aug 18 04:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 5, 18, 7, 106] )), "Thu Aug 17 17:00:00 2006-Fri Aug 18 05:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 6, 18, 7, 106] )), "Thu Aug 17 18:00:00 2006-Fri Aug 18 06:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 7, 18, 7, 106] )), "Thu Aug 17 19:00:00 2006-Fri Aug 18 07:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 8, 18, 7, 106] )), "Thu Aug 17 20:00:00 2006-Fri Aug 18 08:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0, 9, 18, 7, 106] )), "Thu Aug 17 21:00:00 2006-Fri Aug 18 09:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,10, 18, 7, 106] )), "Thu Aug 17 22:00:00 2006-Fri Aug 18 10:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,11, 18, 7, 106] )), "Thu Aug 17 23:00:00 2006-Fri Aug 18 11:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,12, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 12:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,13, 18, 7, 106] )), "Fri Aug 18 01:00:00 2006-Fri Aug 18 13:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,14, 18, 7, 106] )), "Fri Aug 18 02:00:00 2006-Fri Aug 18 14:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,15, 18, 7, 106] )), "Fri Aug 18 03:00:00 2006-Fri Aug 18 15:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,16, 18, 7, 106] )), "Fri Aug 18 04:00:00 2006-Fri Aug 18 16:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,17, 18, 7, 106] )), "Fri Aug 18 05:00:00 2006-Fri Aug 18 17:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,18, 18, 7, 106] )), "Fri Aug 18 06:00:00 2006-Fri Aug 18 18:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,19, 18, 7, 106] )), "Fri Aug 18 07:00:00 2006-Fri Aug 18 19:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,20, 18, 7, 106] )), "Fri Aug 18 08:00:00 2006-Fri Aug 18 20:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,21, 18, 7, 106] )), "Fri Aug 18 09:00:00 2006-Fri Aug 18 21:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,22, 18, 7, 106] )), "Fri Aug 18 10:00:00 2006-Fri Aug 18 22:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last12hours}->( 'last12hours', [0, 0,23, 18, 7, 106] )), "Fri Aug 18 11:00:00 2006-Fri Aug 18 23:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 0, 18, 7, 106] )), "Thu Aug 17 00:00:00 2006-Fri Aug 18 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 1, 18, 7, 106] )), "Thu Aug 17 01:00:00 2006-Fri Aug 18 01:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 2, 18, 7, 106] )), "Thu Aug 17 02:00:00 2006-Fri Aug 18 02:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 3, 18, 7, 106] )), "Thu Aug 17 03:00:00 2006-Fri Aug 18 03:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 4, 18, 7, 106] )), "Thu Aug 17 04:00:00 2006-Fri Aug 18 04:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 5, 18, 7, 106] )), "Thu Aug 17 05:00:00 2006-Fri Aug 18 05:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 6, 18, 7, 106] )), "Thu Aug 17 06:00:00 2006-Fri Aug 18 06:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 7, 18, 7, 106] )), "Thu Aug 17 07:00:00 2006-Fri Aug 18 07:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 8, 18, 7, 106] )), "Thu Aug 17 08:00:00 2006-Fri Aug 18 08:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0, 9, 18, 7, 106] )), "Thu Aug 17 09:00:00 2006-Fri Aug 18 09:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,10, 18, 7, 106] )), "Thu Aug 17 10:00:00 2006-Fri Aug 18 10:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,11, 18, 7, 106] )), "Thu Aug 17 11:00:00 2006-Fri Aug 18 11:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,12, 18, 7, 106] )), "Thu Aug 17 12:00:00 2006-Fri Aug 18 12:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,13, 18, 7, 106] )), "Thu Aug 17 13:00:00 2006-Fri Aug 18 13:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,14, 18, 7, 106] )), "Thu Aug 17 14:00:00 2006-Fri Aug 18 14:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,15, 18, 7, 106] )), "Thu Aug 17 15:00:00 2006-Fri Aug 18 15:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,16, 18, 7, 106] )), "Thu Aug 17 16:00:00 2006-Fri Aug 18 16:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,17, 18, 7, 106] )), "Thu Aug 17 17:00:00 2006-Fri Aug 18 17:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,18, 18, 7, 106] )), "Thu Aug 17 18:00:00 2006-Fri Aug 18 18:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,19, 18, 7, 106] )), "Thu Aug 17 19:00:00 2006-Fri Aug 18 19:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,20, 18, 7, 106] )), "Thu Aug 17 20:00:00 2006-Fri Aug 18 20:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,21, 18, 7, 106] )), "Thu Aug 17 21:00:00 2006-Fri Aug 18 21:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,22, 18, 7, 106] )), "Thu Aug 17 22:00:00 2006-Fri Aug 18 22:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0, 0,23, 18, 7, 106] )), "Thu Aug 17 23:00:00 2006-Fri Aug 18 23:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 0, 18, 7, 106] )), "Thu Aug 17 00:45:00 2006-Fri Aug 18 00:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 1, 18, 7, 106] )), "Thu Aug 17 01:45:00 2006-Fri Aug 18 01:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 2, 18, 7, 106] )), "Thu Aug 17 02:45:00 2006-Fri Aug 18 02:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 3, 18, 7, 106] )), "Thu Aug 17 03:45:00 2006-Fri Aug 18 03:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 4, 18, 7, 106] )), "Thu Aug 17 04:45:00 2006-Fri Aug 18 04:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 5, 18, 7, 106] )), "Thu Aug 17 05:45:00 2006-Fri Aug 18 05:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 6, 18, 7, 106] )), "Thu Aug 17 06:45:00 2006-Fri Aug 18 06:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 7, 18, 7, 106] )), "Thu Aug 17 07:45:00 2006-Fri Aug 18 07:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 8, 18, 7, 106] )), "Thu Aug 17 08:45:00 2006-Fri Aug 18 08:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45, 9, 18, 7, 106] )), "Thu Aug 17 09:45:00 2006-Fri Aug 18 09:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,10, 18, 7, 106] )), "Thu Aug 17 10:45:00 2006-Fri Aug 18 10:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,11, 18, 7, 106] )), "Thu Aug 17 11:45:00 2006-Fri Aug 18 11:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,12, 18, 7, 106] )), "Thu Aug 17 12:45:00 2006-Fri Aug 18 12:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,13, 18, 7, 106] )), "Thu Aug 17 13:45:00 2006-Fri Aug 18 13:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,14, 18, 7, 106] )), "Thu Aug 17 14:45:00 2006-Fri Aug 18 14:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,15, 18, 7, 106] )), "Thu Aug 17 15:45:00 2006-Fri Aug 18 15:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,16, 18, 7, 106] )), "Thu Aug 17 16:45:00 2006-Fri Aug 18 16:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,17, 18, 7, 106] )), "Thu Aug 17 17:45:00 2006-Fri Aug 18 17:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,18, 18, 7, 106] )), "Thu Aug 17 18:45:00 2006-Fri Aug 18 18:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,19, 18, 7, 106] )), "Thu Aug 17 19:45:00 2006-Fri Aug 18 19:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,20, 18, 7, 106] )), "Thu Aug 17 20:45:00 2006-Fri Aug 18 20:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,21, 18, 7, 106] )), "Thu Aug 17 21:45:00 2006-Fri Aug 18 21:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,22, 18, 7, 106] )), "Thu Aug 17 22:45:00 2006-Fri Aug 18 22:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [0,45,23, 18, 7, 106] )), "Thu Aug 17 23:45:00 2006-Fri Aug 18 23:45:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 0, 18, 7, 106] )), "Thu Aug 17 00:45:30 2006-Fri Aug 18 00:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 1, 18, 7, 106] )), "Thu Aug 17 01:45:30 2006-Fri Aug 18 01:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 2, 18, 7, 106] )), "Thu Aug 17 02:45:30 2006-Fri Aug 18 02:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 3, 18, 7, 106] )), "Thu Aug 17 03:45:30 2006-Fri Aug 18 03:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 4, 18, 7, 106] )), "Thu Aug 17 04:45:30 2006-Fri Aug 18 04:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 5, 18, 7, 106] )), "Thu Aug 17 05:45:30 2006-Fri Aug 18 05:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 6, 18, 7, 106] )), "Thu Aug 17 06:45:30 2006-Fri Aug 18 06:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 7, 18, 7, 106] )), "Thu Aug 17 07:45:30 2006-Fri Aug 18 07:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 8, 18, 7, 106] )), "Thu Aug 17 08:45:30 2006-Fri Aug 18 08:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45, 9, 18, 7, 106] )), "Thu Aug 17 09:45:30 2006-Fri Aug 18 09:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,10, 18, 7, 106] )), "Thu Aug 17 10:45:30 2006-Fri Aug 18 10:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,11, 18, 7, 106] )), "Thu Aug 17 11:45:30 2006-Fri Aug 18 11:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,12, 18, 7, 106] )), "Thu Aug 17 12:45:30 2006-Fri Aug 18 12:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,13, 18, 7, 106] )), "Thu Aug 17 13:45:30 2006-Fri Aug 18 13:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,14, 18, 7, 106] )), "Thu Aug 17 14:45:30 2006-Fri Aug 18 14:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,15, 18, 7, 106] )), "Thu Aug 17 15:45:30 2006-Fri Aug 18 15:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,16, 18, 7, 106] )), "Thu Aug 17 16:45:30 2006-Fri Aug 18 16:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,17, 18, 7, 106] )), "Thu Aug 17 17:45:30 2006-Fri Aug 18 17:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,18, 18, 7, 106] )), "Thu Aug 17 18:45:30 2006-Fri Aug 18 18:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,19, 18, 7, 106] )), "Thu Aug 17 19:45:30 2006-Fri Aug 18 19:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,20, 18, 7, 106] )), "Thu Aug 17 20:45:30 2006-Fri Aug 18 20:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,21, 18, 7, 106] )), "Thu Aug 17 21:45:30 2006-Fri Aug 18 21:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,22, 18, 7, 106] )), "Thu Aug 17 22:45:30 2006-Fri Aug 18 22:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last24hours}->( 'last24hours', [30,45,23, 18, 7, 106] )), "Thu Aug 17 23:45:30 2006-Fri Aug 18 23:45:30 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0,  1, 7, 106] )), "Tue Jul 25 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0,  2, 7, 106] )), "Wed Jul 26 00:00:00 2006-Wed Aug  2 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0,  3, 7, 106] )), "Thu Jul 27 00:00:00 2006-Thu Aug  3 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0,  4, 7, 106] )), "Fri Jul 28 00:00:00 2006-Fri Aug  4 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0,  5, 7, 106] )), "Sat Jul 29 00:00:00 2006-Sat Aug  5 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0,  6, 7, 106] )), "Sun Jul 30 00:00:00 2006-Sun Aug  6 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0,  7, 7, 106] )), "Mon Jul 31 00:00:00 2006-Mon Aug  7 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0,  8, 7, 106] )), "Tue Aug  1 00:00:00 2006-Tue Aug  8 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0,  9, 7, 106] )), "Wed Aug  2 00:00:00 2006-Wed Aug  9 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 10, 7, 106] )), "Thu Aug  3 00:00:00 2006-Thu Aug 10 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 11, 7, 106] )), "Fri Aug  4 00:00:00 2006-Fri Aug 11 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 12, 7, 106] )), "Sat Aug  5 00:00:00 2006-Sat Aug 12 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 13, 7, 106] )), "Sun Aug  6 00:00:00 2006-Sun Aug 13 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 14, 7, 106] )), "Mon Aug  7 00:00:00 2006-Mon Aug 14 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 15, 7, 106] )), "Tue Aug  8 00:00:00 2006-Tue Aug 15 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 16, 7, 106] )), "Wed Aug  9 00:00:00 2006-Wed Aug 16 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 17, 7, 106] )), "Thu Aug 10 00:00:00 2006-Thu Aug 17 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 18, 7, 106] )), "Fri Aug 11 00:00:00 2006-Fri Aug 18 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 19, 7, 106] )), "Sat Aug 12 00:00:00 2006-Sat Aug 19 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 20, 7, 106] )), "Sun Aug 13 00:00:00 2006-Sun Aug 20 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 21, 7, 106] )), "Mon Aug 14 00:00:00 2006-Mon Aug 21 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 22, 7, 106] )), "Tue Aug 15 00:00:00 2006-Tue Aug 22 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 23, 7, 106] )), "Wed Aug 16 00:00:00 2006-Wed Aug 23 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 24, 7, 106] )), "Thu Aug 17 00:00:00 2006-Thu Aug 24 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 25, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 25 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 26, 7, 106] )), "Sat Aug 19 00:00:00 2006-Sat Aug 26 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 27, 7, 106] )), "Sun Aug 20 00:00:00 2006-Sun Aug 27 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 28, 7, 106] )), "Mon Aug 21 00:00:00 2006-Mon Aug 28 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 29, 7, 106] )), "Tue Aug 22 00:00:00 2006-Tue Aug 29 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last7days}->( 'last7days', [0, 0, 0, 30, 7, 106] )), "Wed Aug 23 00:00:00 2006-Wed Aug 30 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  1, 7, 106] )), "Sat Jul  1 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  2, 7, 106] )), "Sun Jul  2 00:00:00 2006-Wed Aug  2 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  3, 7, 106] )), "Mon Jul  3 00:00:00 2006-Thu Aug  3 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  4, 7, 106] )), "Tue Jul  4 00:00:00 2006-Fri Aug  4 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  5, 7, 106] )), "Wed Jul  5 00:00:00 2006-Sat Aug  5 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  6, 7, 106] )), "Thu Jul  6 00:00:00 2006-Sun Aug  6 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  7, 7, 106] )), "Fri Jul  7 00:00:00 2006-Mon Aug  7 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  8, 7, 106] )), "Sat Jul  8 00:00:00 2006-Tue Aug  8 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  9, 7, 106] )), "Sun Jul  9 00:00:00 2006-Wed Aug  9 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 10, 7, 106] )), "Mon Jul 10 00:00:00 2006-Thu Aug 10 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 11, 7, 106] )), "Tue Jul 11 00:00:00 2006-Fri Aug 11 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 12, 7, 106] )), "Wed Jul 12 00:00:00 2006-Sat Aug 12 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 13, 7, 106] )), "Thu Jul 13 00:00:00 2006-Sun Aug 13 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 14, 7, 106] )), "Fri Jul 14 00:00:00 2006-Mon Aug 14 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 15, 7, 106] )), "Sat Jul 15 00:00:00 2006-Tue Aug 15 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 16, 7, 106] )), "Sun Jul 16 00:00:00 2006-Wed Aug 16 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 17, 7, 106] )), "Mon Jul 17 00:00:00 2006-Thu Aug 17 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 18, 7, 106] )), "Tue Jul 18 00:00:00 2006-Fri Aug 18 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 19, 7, 106] )), "Wed Jul 19 00:00:00 2006-Sat Aug 19 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 20, 7, 106] )), "Thu Jul 20 00:00:00 2006-Sun Aug 20 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 21, 7, 106] )), "Fri Jul 21 00:00:00 2006-Mon Aug 21 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 22, 7, 106] )), "Sat Jul 22 00:00:00 2006-Tue Aug 22 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 23, 7, 106] )), "Sun Jul 23 00:00:00 2006-Wed Aug 23 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 24, 7, 106] )), "Mon Jul 24 00:00:00 2006-Thu Aug 24 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 25, 7, 106] )), "Tue Jul 25 00:00:00 2006-Fri Aug 25 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 26, 7, 106] )), "Wed Jul 26 00:00:00 2006-Sat Aug 26 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 27, 7, 106] )), "Thu Jul 27 00:00:00 2006-Sun Aug 27 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 28, 7, 106] )), "Fri Jul 28 00:00:00 2006-Mon Aug 28 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 29, 7, 106] )), "Sat Jul 29 00:00:00 2006-Tue Aug 29 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 30, 7, 106] )), "Sun Jul 30 00:00:00 2006-Wed Aug 30 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 31, 7, 106] )), "Mon Jul 31 00:00:00 2006-Thu Aug 31 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  1, 6, 106] )), "Wed May 31 00:00:00 2006-Sat Jul  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  2, 6, 106] )), "Thu Jun  1 00:00:00 2006-Sun Jul  2 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  3, 6, 106] )), "Fri Jun  2 00:00:00 2006-Mon Jul  3 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  4, 6, 106] )), "Sat Jun  3 00:00:00 2006-Tue Jul  4 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  5, 6, 106] )), "Sun Jun  4 00:00:00 2006-Wed Jul  5 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  6, 6, 106] )), "Mon Jun  5 00:00:00 2006-Thu Jul  6 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  7, 6, 106] )), "Tue Jun  6 00:00:00 2006-Fri Jul  7 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  8, 6, 106] )), "Wed Jun  7 00:00:00 2006-Sat Jul  8 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0,  9, 6, 106] )), "Thu Jun  8 00:00:00 2006-Sun Jul  9 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 10, 6, 106] )), "Fri Jun  9 00:00:00 2006-Mon Jul 10 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 11, 6, 106] )), "Sat Jun 10 00:00:00 2006-Tue Jul 11 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 12, 6, 106] )), "Sun Jun 11 00:00:00 2006-Wed Jul 12 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 13, 6, 106] )), "Mon Jun 12 00:00:00 2006-Thu Jul 13 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 14, 6, 106] )), "Tue Jun 13 00:00:00 2006-Fri Jul 14 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 15, 6, 106] )), "Wed Jun 14 00:00:00 2006-Sat Jul 15 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 16, 6, 106] )), "Thu Jun 15 00:00:00 2006-Sun Jul 16 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 17, 6, 106] )), "Fri Jun 16 00:00:00 2006-Mon Jul 17 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 18, 6, 106] )), "Sat Jun 17 00:00:00 2006-Tue Jul 18 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 19, 6, 106] )), "Sun Jun 18 00:00:00 2006-Wed Jul 19 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 20, 6, 106] )), "Mon Jun 19 00:00:00 2006-Thu Jul 20 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 21, 6, 106] )), "Tue Jun 20 00:00:00 2006-Fri Jul 21 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 22, 6, 106] )), "Wed Jun 21 00:00:00 2006-Sat Jul 22 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 23, 6, 106] )), "Thu Jun 22 00:00:00 2006-Sun Jul 23 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 24, 6, 106] )), "Fri Jun 23 00:00:00 2006-Mon Jul 24 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 25, 6, 106] )), "Sat Jun 24 00:00:00 2006-Tue Jul 25 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 26, 6, 106] )), "Sun Jun 25 00:00:00 2006-Wed Jul 26 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 27, 6, 106] )), "Mon Jun 26 00:00:00 2006-Thu Jul 27 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 28, 6, 106] )), "Tue Jun 27 00:00:00 2006-Fri Jul 28 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 29, 6, 106] )), "Wed Jun 28 00:00:00 2006-Sat Jul 29 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 30, 6, 106] )), "Thu Jun 29 00:00:00 2006-Sun Jul 30 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last31days}->( 'last31days', [0, 0, 0, 31, 6, 106] )), "Fri Jun 30 00:00:00 2006-Mon Jul 31 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0,  1, 6, 106] )), "Fri Jun 30 00:00:00 2006-Sat Jul  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0,  2, 6, 106] )), "Sat Jul  1 00:00:00 2006-Sun Jul  2 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0,  3, 6, 106] )), "Sun Jul  2 00:00:00 2006-Mon Jul  3 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0,  4, 6, 106] )), "Mon Jul  3 00:00:00 2006-Tue Jul  4 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0,  5, 6, 106] )), "Tue Jul  4 00:00:00 2006-Wed Jul  5 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0,  6, 6, 106] )), "Wed Jul  5 00:00:00 2006-Thu Jul  6 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0,  7, 6, 106] )), "Thu Jul  6 00:00:00 2006-Fri Jul  7 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0,  8, 6, 106] )), "Fri Jul  7 00:00:00 2006-Sat Jul  8 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0,  9, 6, 106] )), "Sat Jul  8 00:00:00 2006-Sun Jul  9 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 10, 6, 106] )), "Sun Jul  9 00:00:00 2006-Mon Jul 10 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 11, 6, 106] )), "Mon Jul 10 00:00:00 2006-Tue Jul 11 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 12, 6, 106] )), "Tue Jul 11 00:00:00 2006-Wed Jul 12 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 13, 6, 106] )), "Wed Jul 12 00:00:00 2006-Thu Jul 13 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 14, 6, 106] )), "Thu Jul 13 00:00:00 2006-Fri Jul 14 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 15, 6, 106] )), "Fri Jul 14 00:00:00 2006-Sat Jul 15 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 16, 6, 106] )), "Sat Jul 15 00:00:00 2006-Sun Jul 16 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 17, 6, 106] )), "Sun Jul 16 00:00:00 2006-Mon Jul 17 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 18, 6, 106] )), "Mon Jul 17 00:00:00 2006-Tue Jul 18 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 19, 6, 106] )), "Tue Jul 18 00:00:00 2006-Wed Jul 19 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 20, 6, 106] )), "Wed Jul 19 00:00:00 2006-Thu Jul 20 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 21, 6, 106] )), "Thu Jul 20 00:00:00 2006-Fri Jul 21 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 22, 6, 106] )), "Fri Jul 21 00:00:00 2006-Sat Jul 22 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 23, 6, 106] )), "Sat Jul 22 00:00:00 2006-Sun Jul 23 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 24, 6, 106] )), "Sun Jul 23 00:00:00 2006-Mon Jul 24 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 25, 6, 106] )), "Mon Jul 24 00:00:00 2006-Tue Jul 25 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 26, 6, 106] )), "Tue Jul 25 00:00:00 2006-Wed Jul 26 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 27, 6, 106] )), "Wed Jul 26 00:00:00 2006-Thu Jul 27 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 28, 6, 106] )), "Thu Jul 27 00:00:00 2006-Fri Jul 28 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 29, 6, 106] )), "Fri Jul 28 00:00:00 2006-Sat Jul 29 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 30, 6, 106] )), "Sat Jul 29 00:00:00 2006-Sun Jul 30 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{yesterday}->( 'yesterday', [0, 0, 0, 31, 6, 106] )), "Sun Jul 30 00:00:00 2006-Mon Jul 31 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 0, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 1, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 01:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 2, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 02:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 3, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 03:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 4, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 04:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 5, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 05:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 6, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 06:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 7, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 07:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 8, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 08:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0, 9, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 09:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,10, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 10:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,11, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 11:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,12, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 12:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,13, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 13:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,14, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 14:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,15, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 15:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,16, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 16:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,17, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 17:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,18, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 18:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,19, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 19:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,20, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 20:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,21, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 21:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,22, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 22:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{today}->( 'today', [0, 0,23, 18, 7, 106] )), "Fri Aug 18 00:00:00 2006-Fri Aug 18 23:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0,  1, 7, 106, 2] )), "Mon Jul 24 00:00:00 2006-Sun Jul 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0,  2, 7, 106, 3] )), "Mon Jul 24 00:00:00 2006-Sun Jul 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0,  3, 7, 106, 4] )), "Mon Jul 24 00:00:00 2006-Sun Jul 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0,  4, 7, 106, 5] )), "Mon Jul 24 00:00:00 2006-Sun Jul 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0,  5, 7, 106, 6] )), "Mon Jul 24 00:00:00 2006-Sun Jul 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0,  6, 7, 106, 0] )), "Mon Jul 31 00:00:00 2006-Sun Aug  6 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0,  7, 7, 106, 1] )), "Mon Jul 31 00:00:00 2006-Sun Aug  6 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0, 14, 7, 106, 1] )), "Mon Aug  7 00:00:00 2006-Sun Aug 13 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0, 21, 7, 106, 1] )), "Mon Aug 14 00:00:00 2006-Sun Aug 20 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastweek}->( 'lastweek', [0, 0, 0, 28, 7, 106, 1] )), "Mon Aug 21 00:00:00 2006-Sun Aug 27 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thisweek}->( 'thisweek', [0, 0, 0,  7, 7, 106, 1] )), "Mon Aug  7 00:00:00 2006-Mon Aug  7 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thisweek}->( 'thisweek', [0, 0, 0,  8, 7, 106, 2] )), "Mon Aug  7 00:00:00 2006-Tue Aug  8 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thisweek}->( 'thisweek', [0, 0, 0,  9, 7, 106, 3] )), "Mon Aug  7 00:00:00 2006-Wed Aug  9 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thisweek}->( 'thisweek', [0, 0, 0, 10, 7, 106, 4] )), "Mon Aug  7 00:00:00 2006-Thu Aug 10 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thisweek}->( 'thisweek', [0, 0, 0, 11, 7, 106, 5] )), "Mon Aug  7 00:00:00 2006-Fri Aug 11 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thisweek}->( 'thisweek', [0, 0, 0, 12, 7, 106, 6] )), "Mon Aug  7 00:00:00 2006-Sat Aug 12 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thisweek}->( 'thisweek', [0, 0, 0, 13, 7, 106, 7] )), "Mon Aug  7 00:00:00 2006-Sun Aug 13 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thismonth}->( 'thismonth', [0, 0, 0,  7, 7, 106, 1] )), "Tue Aug  1 00:00:00 2006-Mon Aug  7 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thismonth}->( 'thismonth', [0, 0, 0,  1, 7, 106, 1] )), "Tue Aug  1 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thismonth}->( 'thismonth', [0, 0, 0, 31, 7, 106, 1] )), "Tue Aug  1 00:00:00 2006-Thu Aug 31 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastmonth}->( 'lastmonth', [0, 0, 0,  1, 7, 106] )), "Sat Jul  1 00:00:00 2006-Mon Jul 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastmonth}->( 'lastmonth', [0, 0, 0,  1, 6, 106] )), "Thu Jun  1 00:00:00 2006-Fri Jun 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastmonth}->( 'lastmonth', [0, 0, 0,  1, 5, 106] )), "Mon May  1 00:00:00 2006-Wed May 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastmonth}->( 'lastmonth', [0, 0, 0,  1, 4, 106] )), "Sat Apr  1 00:00:00 2006-Sun Apr 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastmonth}->( 'lastmonth', [0, 0, 0,  1, 3, 106] )), "Wed Mar  1 00:00:00 2006-Fri Mar 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastmonth}->( 'lastmonth', [0, 0, 0,  1, 2, 106] )), "Wed Feb  1 00:00:00 2006-Tue Feb 28 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{thisyear}->( 'thisyear', [0, 0, 0, 19, 7, 106, 6, 230] )), "Sun Jan  1 00:00:00 2006-Sat Aug 19 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{lastyear}->( 'lastyear', [0, 0, 0, 19, 7, 106] )), "Sat Jan  1 00:00:00 2005-Sat Dec 31 23:59:59 2005" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_days}->( '0', [0, 0, 0,  1, 7, 106] )), "Tue Aug  1 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_days}->( '1', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_days}->( '32', [0, 0, 0,  1, 7, 106] )), "Fri Jun 30 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_days}->( '62', [0, 0, 0,  1, 7, 106] )), "Wed May 31 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_days}->( '93', [0, 0, 0,  1, 7, 106] )), "Sun Apr 30 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last0day', [0, 0, 0,  1, 7, 106] )), "Tue Aug  1 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last1days', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last32days', [0, 0, 0,  1, 7, 106] )), "Fri Jun 30 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last62days', [0, 0, 0,  1, 7, 106] )), "Wed May 31 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last93days', [0, 0, 0,  1, 7, 106] )), "Sun Apr 30 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '1', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 23:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '2', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 22:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '3', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 21:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '4', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 20:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '5', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 19:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '6', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 18:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '7', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 17:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '8', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 16:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '9', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 15:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '10', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 14:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '11', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 13:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '12', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 12:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '23', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 01:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '24', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '25', [0, 0, 0,  1, 7, 106] )), "Sun Jul 30 23:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_hours}->( '168', [0, 0, 0,  1, 7, 106] )), "Tue Jul 25 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last1hour', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 23:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last2hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 22:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last3hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 21:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last4hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 20:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last5hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 19:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last6hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 18:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last7hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 17:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last8hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 16:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last9hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 15:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last10hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 14:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last11hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 13:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last12hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 12:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last23hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 01:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last24hours', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last25hours', [0, 0, 0,  1, 7, 106] )), "Sun Jul 30 23:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last168hours', [0, 0, 0,  1, 7, 106] )), "Tue Jul 25 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_mins}->( '1', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 23:59:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_mins}->( '60', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 23:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{last_n_mins}->( '1440', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last1min', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 23:59:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last60mins', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 23:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'last1440mins', [0, 0, 0,  1, 7, 106] )), "Mon Jul 31 00:00:00 2006-Tue Aug  1 00:00:00 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Jan 2006', [localtime] )), "Sun Jan  1 00:00:00 2006-Tue Jan 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Feb 2006', [localtime] )), "Wed Feb  1 00:00:00 2006-Tue Feb 28 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Mar 2006', [localtime] )), "Wed Mar  1 00:00:00 2006-Fri Mar 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Apr 2006', [localtime] )), "Sat Apr  1 00:00:00 2006-Sun Apr 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'May 2006', [localtime] )), "Mon May  1 00:00:00 2006-Wed May 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Jun 2006', [localtime] )), "Thu Jun  1 00:00:00 2006-Fri Jun 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Jul 2006', [localtime] )), "Sat Jul  1 00:00:00 2006-Mon Jul 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Aug 2006', [localtime] )), "Tue Aug  1 00:00:00 2006-Thu Aug 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Sep 2006', [localtime] )), "Fri Sep  1 00:00:00 2006-Sat Sep 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Oct 2006', [localtime] )), "Sun Oct  1 00:00:00 2006-Tue Oct 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Nov 2006', [localtime] )), "Wed Nov  1 00:00:00 2006-Thu Nov 30 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Dec 2006', [localtime] )), "Fri Dec  1 00:00:00 2006-Sun Dec 31 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Jan 2000', [localtime] )), "Sat Jan  1 00:00:00 2000-Mon Jan 31 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Feb 2000', [localtime] )), "Tue Feb  1 00:00:00 2000-Tue Feb 29 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Mar 2000', [localtime] )), "Wed Mar  1 00:00:00 2000-Fri Mar 31 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Apr 2000', [localtime] )), "Sat Apr  1 00:00:00 2000-Sun Apr 30 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'May 2000', [localtime] )), "Mon May  1 00:00:00 2000-Wed May 31 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Jun 2000', [localtime] )), "Thu Jun  1 00:00:00 2000-Fri Jun 30 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Jul 2000', [localtime] )), "Sat Jul  1 00:00:00 2000-Mon Jul 31 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Aug 2000', [localtime] )), "Tue Aug  1 00:00:00 2000-Thu Aug 31 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Sep 2000', [localtime] )), "Fri Sep  1 00:00:00 2000-Sat Sep 30 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Oct 2000', [localtime] )), "Sun Oct  1 00:00:00 2000-Tue Oct 31 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Nov 2000', [localtime] )), "Wed Nov  1 00:00:00 2000-Thu Nov 30 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Dec 2000', [localtime] )), "Fri Dec  1 00:00:00 2000-Sun Dec 31 23:59:59 2000" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Jan 2004', [localtime] )), "Thu Jan  1 00:00:00 2004-Sat Jan 31 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Feb 2004', [localtime] )), "Sun Feb  1 00:00:00 2004-Sun Feb 29 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Mar 2004', [localtime] )), "Mon Mar  1 00:00:00 2004-Wed Mar 31 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Apr 2004', [localtime] )), "Thu Apr  1 00:00:00 2004-Fri Apr 30 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'May 2004', [localtime] )), "Sat May  1 00:00:00 2004-Mon May 31 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Jun 2004', [localtime] )), "Tue Jun  1 00:00:00 2004-Wed Jun 30 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Jul 2004', [localtime] )), "Thu Jul  1 00:00:00 2004-Sat Jul 31 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Aug 2004', [localtime] )), "Sun Aug  1 00:00:00 2004-Tue Aug 31 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Sep 2004', [localtime] )), "Wed Sep  1 00:00:00 2004-Thu Sep 30 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Oct 2004', [localtime] )), "Fri Oct  1 00:00:00 2004-Sun Oct 31 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Nov 2004', [localtime] )), "Mon Nov  1 00:00:00 2004-Tue Nov 30 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( 'Dec 2004', [localtime] )), "Wed Dec  1 00:00:00 2004-Fri Dec 31 23:59:59 2004" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '21:09', [59,59,23, 7, 7, 106] )), "Mon Aug  7 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '2109', [59,59,23, 7, 7, 106] )), "Mon Aug  7 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '1.8.06', [59,59,23, 7, 7, 106] )), "Tue Aug  1 00:00:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '1.8.2006', [59,59,23, 7, 7, 106] )), "Tue Aug  1 00:00:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '21:09 1.8.06', [59,59,23, 7, 7, 106] )), "Tue Aug  1 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '2109  1.8.06', [59,59,23, 7, 7, 106] )), "Tue Aug  1 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '21:09 1.8.2006', [59,59,23, 7, 7, 106] )), "Tue Aug  1 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '2109  1.8.2006', [59,59,23, 7, 7, 106] )), "Tue Aug  1 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '8/1/06', [59,59,23, 7, 7, 106] )), "Tue Aug  1 00:00:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '8/1/2006', [59,59,23, 7, 7, 106] )), "Tue Aug  1 00:00:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '21:09 8/1/06', [59,59,23, 7, 7, 106] )), "Tue Aug  1 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '2109  8/1/06', [59,59,23, 7, 7, 106] )), "Tue Aug  1 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '21:09 8/1/2006', [59,59,23, 7, 7, 106] )), "Tue Aug  1 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
ok( join('-', map { scalar(localtime($_)) } $st_et{__DEFAULT__}->( '2109  8/1/2006', [59,59,23, 7, 7, 106] )), "Tue Aug  1 21:09:00 2006-Mon Aug  7 23:59:59 2006" ) ;
