#!/usr/bin/env perl

use 5.010;
use strict;
use warnings;

package Medical::Growth::NHANES_2000::BMI_for_Age::Child::Male;

our ($VERSION) = '1.00';

use Moo::Lax;    # Vanilla Moo considered harmful

extends 'Medical::Growth::NHANES_2000::Base';

__PACKAGE__->_declare_params_LMS;

# Inlined rather than in a base class - too small to merit reading
# another file
sub bmi {
    my ( $self, $wt_kg, $ht_cm ) = @_;
    return unless $ht_cm and $wt_kg;
    return 10000 * $wt_kg / $ht_cm**2;
}

1;

# bmiagerev, sex = 1

__DATA__

24	-2.01118107	16.57502768	0.080592465
24.5	-1.982373595	16.54777487	0.080127429
25.5	-1.924100169	16.49442763	0.079233994
26.5	-1.86549793	16.44259552	0.078389356
27.5	-1.807261899	16.3922434	0.077593501
28.5	-1.750118905	16.34333654	0.076846462
29.5	-1.69481584	16.29584097	0.076148308
30.5	-1.642106779	16.24972371	0.075499126
31.5	-1.592744414	16.20495268	0.074898994
32.5	-1.547442391	16.16149871	0.074347997
33.5	-1.506902601	16.11933258	0.073846139
34.5	-1.471770047	16.07842758	0.07339337
35.5	-1.442628957	16.03875896	0.072989551
36.5	-1.419991255	16.00030401	0.072634432
37.5	-1.404277619	15.96304277	0.072327649
38.5	-1.39586317	15.92695418	0.07206864
39.5	-1.394935252	15.89202582	0.071856805
40.5	-1.401671596	15.85824093	0.071691278
41.5	-1.416100312	15.82558822	0.071571093
42.5	-1.438164899	15.79405728	0.071495113
43.5	-1.467669032	15.76364255	0.071462106
44.5	-1.504376347	15.73433668	0.071470646
45.5	-1.547942838	15.70613566	0.071519218
46.5	-1.597896397	15.67904062	0.071606277
47.5	-1.653732283	15.65305192	0.071730167
48.5	-1.714869347	15.62817269	0.071889214
49.5	-1.780673181	15.604408	0.072081737
50.5	-1.850468473	15.58176458	0.072306081
51.5	-1.923551865	15.56025067	0.072560637
52.5	-1.999220429	15.5398746	0.07284384
53.5	-2.076707178	15.52064993	0.073154324
54.5	-2.155348017	15.50258427	0.073490667
55.5	-2.234438552	15.48568973	0.073851672
56.5	-2.313321723	15.46997718	0.074236235
57.5	-2.391381273	15.45545692	0.074643374
58.5	-2.468032491	15.44213961	0.075072264
59.5	-2.542781541	15.43003207	0.075522104
60.5	-2.61516595	15.41914163	0.07599225
61.5	-2.684789516	15.40947356	0.076482128
62.5	-2.751316949	15.40103139	0.076991232
63.5	-2.81445945	15.39381785	0.077519149
64.5	-2.87402476	15.38783094	0.07806539
65.5	-2.92984048	15.38306945	0.078629592
66.5	-2.981796828	15.37952958	0.079211369
67.5	-3.029831343	15.37720582	0.079810334
68.5	-3.073924224	15.37609107	0.080426086
69.5	-3.114093476	15.37617677	0.081058206
70.5	-3.15039004	15.37745304	0.081706249
71.5	-3.182893018	15.37990886	0.082369741
72.5	-3.21170511	15.38353217	0.083048178
73.5	-3.23694834	15.38831005	0.083741021
74.5	-3.25876011	15.39422883	0.0844477
75.5	-3.277281546	15.40127496	0.085167651
76.5	-3.292683774	15.40943252	0.085900184
77.5	-3.305124073	15.41868691	0.086644667
78.5	-3.314768951	15.42902273	0.087400421
79.5	-3.321785992	15.44042439	0.088166744
80.5	-3.326345795	15.45287581	0.088942897
81.5	-3.328602731	15.46636218	0.089728202
82.5	-3.328725277	15.48086704	0.090521875
83.5	-3.32687018	15.49637465	0.091323162
84.5	-3.323188896	15.51286936	0.092131305
85.5	-3.317827016	15.53033563	0.092945544
86.5	-3.310923871	15.54875807	0.093765118
87.5	-3.302612272	15.56812143	0.09458927
88.5	-3.293018361	15.58841065	0.095417247
89.5	-3.282260813	15.60961101	0.096248301
90.5	-3.270454609	15.63170735	0.097081694
91.5	-3.257703616	15.65468563	0.097916698
92.5	-3.244108214	15.67853139	0.098752593
93.5	-3.229761713	15.70323052	0.099588675
94.5	-3.214751287	15.72876911	0.100424251
95.5	-3.199158184	15.75513347	0.101258643
96.5	-3.18305795	15.78231007	0.102091189
97.5	-3.166520664	15.8102856	0.102921245
98.5	-3.1496103	15.83904708	0.103748189
99.5	-3.132389637	15.86858123	0.104571386
100.5	-3.114911153	15.89887562	0.105390269
101.5	-3.097226399	15.92991765	0.106204258
102.5	-3.079383079	15.96169481	0.107012788
103.5	-3.061423765	15.99419489	0.107815327
104.5	-3.043386071	16.02740607	0.108611374
105.5	-3.025310003	16.0613159	0.109400388
106.5	-3.007225737	16.09591292	0.110181915
107.5	-2.989164598	16.13118532	0.110955478
108.5	-2.971148225	16.16712234	0.111720691
109.5	-2.953208047	16.20371168	0.112477059
110.5	-2.935363951	16.24094239	0.1132242
111.5	-2.917635157	16.27880346	0.113961734
112.5	-2.900039803	16.31728385	0.114689291
113.5	-2.882593796	16.35637267	0.115406523
114.5	-2.865311266	16.39605916	0.116113097
115.5	-2.848204697	16.43633265	0.116808702
116.5	-2.831285052	16.47718256	0.117493042
117.5	-2.81456189	16.51859843	0.11816584
118.5	-2.79804347	16.56056987	0.118826835
119.5	-2.781736856	16.60308661	0.119475785
120.5	-2.765648008	16.64613844	0.120112464
121.5	-2.749782197	16.68971518	0.120736656
122.5	-2.734142443	16.73380695	0.121348181
123.5	-2.718732873	16.77840363	0.121946849
124.5	-2.703555506	16.82349538	0.122532501
125.5	-2.688611957	16.86907238	0.123104991
126.5	-2.673903164	16.91512487	0.123664186
127.5	-2.659429443	16.96164317	0.124209969
128.5	-2.645190534	17.00861766	0.124742239
129.5	-2.631185649	17.05603879	0.125260905
130.5	-2.617413511	17.10389705	0.125765895
131.5	-2.603872392	17.15218302	0.126257147
132.5	-2.590560148	17.20088732	0.126734613
133.5	-2.577474253	17.25000062	0.12719826
134.5	-2.564611831	17.29951367	0.127648067
135.5	-2.551969684	17.34941726	0.128084023
136.5	-2.539539972	17.39970308	0.128506192
137.5	-2.527325681	17.45036072	0.128914497
138.5	-2.515320235	17.50138161	0.129309001
139.5	-2.503519447	17.55275674	0.129689741
140.5	-2.491918934	17.60447714	0.130056765
141.5	-2.480514136	17.6565339	0.130410133
142.5	-2.469300331	17.70891811	0.130749913
143.5	-2.458272656	17.76162094	0.131076187
144.5	-2.447426113	17.81463359	0.131389042
145.5	-2.436755595	17.86794729	0.131688579
146.5	-2.426255887	17.92155332	0.131974905
147.5	-2.415921689	17.97544299	0.132248138
148.5	-2.405747619	18.02960765	0.132508403
149.5	-2.395728233	18.08403868	0.132755834
150.5	-2.385858029	18.1387275	0.132990575
151.5	-2.376131459	18.19366555	0.133212776
152.5	-2.366542942	18.24884431	0.133422595
153.5	-2.357086871	18.3042553	0.133620197
154.5	-2.347757625	18.35989003	0.133805756
155.5	-2.338549576	18.41574009	0.133979452
156.5	-2.3294571	18.47179706	0.13414147
157.5	-2.320474586	18.52805255	0.134292005
158.5	-2.311596446	18.5844982	0.134431256
159.5	-2.302817124	18.64112567	0.134559427
160.5	-2.294131107	18.69792663	0.134676731
161.5	-2.285532933	18.75489278	0.134783385
162.5	-2.277017201	18.81201584	0.134879611
163.5	-2.268578584	18.86928753	0.134965637
164.5	-2.260211837	18.92669959	0.135041695
165.5	-2.251911809	18.98424378	0.135108024
166.5	-2.243673453	19.04191185	0.135164867
167.5	-2.235491842	19.09969557	0.135212469
168.5	-2.227362173	19.15758672	0.135251083
169.5	-2.21927979	19.21557707	0.135280963
170.5	-2.211240187	19.27365839	0.135302371
171.5	-2.203239029	19.33182247	0.135315568
172.5	-2.195272161	19.39006106	0.135320824
173.5	-2.187335625	19.44836594	0.135318407
174.5	-2.179425674	19.50672885	0.135308594
175.5	-2.171538789	19.56514153	0.135291662
176.5	-2.163671689	19.62359571	0.135267891
177.5	-2.155821357	19.6820831	0.135237567
178.5	-2.147985046	19.74059538	0.135200976
179.5	-2.140160305	19.7991242	0.135158409
180.5	-2.132344989	19.85766121	0.135110159
181.5	-2.124537282	19.916198	0.135056522
182.5	-2.116735712	19.97472615	0.134997797
183.5	-2.108939167	20.03323719	0.134934285
184.5	-2.10114692	20.09172262	0.134866291
185.5	-2.093358637	20.15017387	0.134794121
186.5	-2.085574403	20.20858236	0.134718085
187.5	-2.077794735	20.26693944	0.134638494
188.5	-2.070020599	20.32523642	0.134555663
189.5	-2.062253431	20.38346455	0.13446991
190.5	-2.054495145	20.44161501	0.134381553
191.5	-2.046748156	20.49967894	0.134290916
192.5	-2.039015385	20.5576474	0.134198323
193.5	-2.031300282	20.6155114	0.134104101
194.5	-2.023606828	20.67326189	0.134008581
195.5	-2.015942013	20.73088905	0.133912066
196.5	-2.008305745	20.7883851	0.133814954
197.5	-2.000706389	20.84574003	0.133717552
198.5	-1.993150137	20.90294449	0.1336202
199.5	-1.985643741	20.95998909	0.133523244
200.5	-1.97819451	21.01686433	0.133427032
201.5	-1.970810308	21.07356067	0.133331914
202.5	-1.96349954	21.1300685	0.133238245
203.5	-1.956271141	21.18637813	0.133146383
204.5	-1.949134561	21.24247982	0.13305669
205.5	-1.942099744	21.29836376	0.132969531
206.5	-1.935177101	21.35402009	0.132885274
207.5	-1.92837748	21.40943891	0.132804292
208.5	-1.921712136	21.46461026	0.132726962
209.5	-1.915192685	21.51952414	0.132653664
210.5	-1.908831065	21.57417053	0.132584784
211.5	-1.902639482	21.62853937	0.132520711
212.5	-1.896630358	21.68262062	0.132461838
213.5	-1.890816268	21.73640419	0.132408563
214.5	-1.885209876	21.78988003	0.132361289
215.5	-1.879823505	21.84303819	0.132320427
216.5	-1.874670324	21.8958685	0.132286382
217.5	-1.869760299	21.94836168	0.1322596
218.5	-1.865113245	22.00050569	0.132240418
219.5	-1.860734944	22.05229242	0.13222933
220.5	-1.85663384	22.10371305	0.132226801
221.5	-1.852827186	22.15475603	0.132233201
222.5	-1.849323204	22.20541249	0.132248993
223.5	-1.846131607	22.255673	0.132274625
224.5	-1.843261294	22.30552831	0.132310549
225.5	-1.840720248	22.3549693	0.132357221
226.5	-1.83851544	22.40398706	0.132415103
227.5	-1.83665586	22.45257182	0.132484631
228.5	-1.835138046	22.50071778	0.132566359
229.5	-1.833972004	22.54841437	0.132660699
230.5	-1.833157751	22.59565422	0.132768153
231.5	-1.83269562	22.64242956	0.132889211
232.5	-1.832584342	22.68873292	0.133024368
233.5	-1.832820974	22.73455713	0.133174129
234.5	-1.833400825	22.7798953	0.133338999
235.5	-1.834317405	22.82474087	0.133519496
236.5	-1.83555752	22.86908912	0.133716192
237.5	-1.837119466	22.91293151	0.133929525
238.5	-1.838987063	22.95626373	0.134160073
239.5	-1.841146139	22.99908062	0.134408381
240	-1.84233016	23.02029424	0.134539365
240.5	-1.843580575	23.04137734	0.134675001

__END__

=head1 NAME

Medical::Growth::NHANES_2000::BMI_for_Age::Child::Male

=head1 SYNOPSIS

  use Medical::Growth::NHANES_2000;
  Medical::Growth::NHANES_2000->find_measure_class(
    ages => 'Child', sex => 'Male',
    measure => 'BMI for Age')->pct_for_value($bmi,$age);

=head1 DESCRIPTION

This class provides the NHANES 2000 parameters for BMI-for-age
tables for boys ages 2-20 years.

BMI values are expressed in kg/m2, and ages in months.

For details of the methods provided to operate on observations, please see
L<Medical::Growth::NHANES_2000::Base>.  For overall information on use of
the NHANES 2000 system, please see L<Medical::Growth::NHANES_2000>.

This class provides one additional convenience method:

=over 4

=item B<bmi>(I<wt_kg>, I<ht_cm>)

Returns the BMI in kg/m2 computed from I<wt_kg> and I<ht_cm>.  If
either I<wt_kg> or I<ht_cm> is missing or zero, returns C<undef>.

=back

=head1 VERSION

version 1.00

=head1 AUTHOR

Charles Bailey <cbail@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2012-2014 Charles Bailey.

This software may be used under the terms of the Artistic License or
the GNU General Public License, as the user prefers.

=head1 ACKNOWLEDGMENT

The code incorporated into this package was originally written with
United States federal funding as part of research work done by the
author at the Children's Hospital of Philadelphia.

=cut
