package App::InteractivePerlTutorial::Chapter::Hashes::Functions;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Functions';

use constant EXERCISES => [
	{ statement => 'Read the name and surname of 5 people, make a hash that links the names to the surnames and print the surnames in the alphabetical order of the names of that person that has them' ,input => "George\nWashinton\nAbraham\nLincoln\n
Thomas\nJefferson\nJohn\nKennedy\nBarrack\nObama" , check => sub {
	my ($out, $r1, $r2, $r3, $r4, $r5)=@_;
	return ($r1 eq "Lincoln") && ($r2 eq "Obama") && ($r3 eq "Washinton") && ($r4 eq "Kennedy") && ($r5 eq "Jefferson");
} },
];

1;
__DATA__

=encoding utf-8

=head1 Hash Functions

There are several functions that work on hashes:

The C<keys> function gives you a list of the keys in a hash, and the C<values> gives you a list of the values:

  my %hash=(1=>3,5=>2,3=>7);
  my @a=keys %hash;      #contains 1,5,3
  my @b=values %hash;    #contains 3,2,7
  foreach (sort @a) {
        say $hash{$_};   #says 3,7,2
  }

The C<each> function gives you a key-value pair in a list with two elements. When there are no more pairs in the hash it returns an empty list. The each function is mostly used in a while loop:

  while (($key,$value)=each %hash) {
        say "$key => $value";
  }

The C<exists> function returns true if a key is in a hash, and false if it isn't:

  if (exists $numberhash{3}) {
        say "3 is in the numberhash";
  }

The C<delete> function deletes a key and its value from a hash:

  delete $numberhash{'A'};


=cut
