/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached;

import org.couchbase.mock.memcached.CommandExecutor;
import org.couchbase.mock.memcached.Item;
import org.couchbase.mock.memcached.MemcachedConnection;
import org.couchbase.mock.memcached.MemcachedServer;
import org.couchbase.mock.memcached.VBucketStore;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.BinaryResponse;
import org.couchbase.mock.memcached.protocol.BinaryStoreCommand;
import org.couchbase.mock.memcached.protocol.BinaryStoreResponse;
import org.couchbase.mock.memcached.protocol.ErrorCode;

class AppendPrependCommandExecutor
implements CommandExecutor {
    AppendPrependCommandExecutor() {
    }

    @Override
    public void execute(BinaryCommand cmd, MemcachedServer server, MemcachedConnection client) {
        ErrorCode err;
        BinaryStoreCommand command = (BinaryStoreCommand)cmd;
        VBucketStore cache = server.getStorage().getCache(server, cmd.getVBucketId());
        Item existing = cache.get(command.getKeySpec());
        switch (cmd.getComCode()) {
            case APPEND: 
            case APPENDQ: {
                err = cache.append(command.getItem());
                break;
            }
            case PREPEND: 
            case PREPENDQ: {
                err = cache.prepend(command.getItem());
                break;
            }
            default: {
                return;
            }
        }
        if (err == ErrorCode.SUCCESS) {
            switch (cmd.getComCode()) {
                case APPEND: 
                case PREPEND: {
                    client.sendResponse(new BinaryStoreResponse(command, err, existing.getCas()));
                }
            }
        } else {
            if (err == ErrorCode.KEY_ENOENT) {
                err = ErrorCode.NOT_STORED;
            }
            client.sendResponse(new BinaryResponse(cmd, err));
        }
    }
}

