use strict;
use warnings;
use Test::More;
use Git::Version::Compare;

my @tests = (
    [ undef, undef ],

    # actual output from `git --version`
    [ '0.99.7',                '000.099.007.000.000.000' ],
    [ '0.99.9l',               '000.099.009.012.000.000' ],
    [ '1.2.3',                 '001.002.003.000.000.000' ],
    [ '1.2.3',                 '001.002.003.000.000.000' ],
    [ '1.8.0.rc3',             '001.008.000.000-003.000' ],
    [ '1.8.0',                 '001.008.000.000.000.000' ],
    [ '1.8.0.3',               '001.008.000.003.000.000' ],
    [ '1.8.5.4.19.g5032098',   '001.008.005.004.000.019' ],
    [ '2.3.0.rc0.36.g63a0e83', '002.003.000.000-000.036' ],

    # Win32 msysgit
    [ '1.9.4.msysgit.0', '001.009.004.000.000.000' ],
    [ '1.9.5.msysgit.1', '001.009.005.000.000.000' ],

    # plausible version numbers
    [ '1.0.rc4', '000.099.009.012.000.000' ],
    [ '1.0rc4',  '000.099.009.012.000.000' ],
    [ '1.6',     '001.006.000.000.000.000' ],

    # tags from git.git
    [ 'v1.0rc4',              '000.099.009.012.000.000' ],
    [ 'v1.7.12-rc2',          '001.007.012.000-002.000' ],
    [ 'v1.8.4.5',             '001.008.004.005.000.000' ],
    [ 'v1.8.5.4-19-g5032098', '001.008.005.004.000.019' ],
    [ 'v2.0.0-rc0',           '002.000.000.000-000.000' ],
);

plan tests => scalar @tests;

for my $t (@tests) {
    is( Git::Version::Compare::_normalize( $t->[0] ),
        $t->[1], $t->[0] || 'undef' );
}
