# Generated by default/object.tt
package Paws::SageMaker::OutputConfig;
  use Moose;
  has CompilerOptions => (is => 'ro', isa => 'Str');
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has S3OutputLocation => (is => 'ro', isa => 'Str', required => 1);
  has TargetDevice => (is => 'ro', isa => 'Str');
  has TargetPlatform => (is => 'ro', isa => 'Paws::SageMaker::TargetPlatform');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::OutputConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::OutputConfig object:

  $service_obj->Method(Att1 => { CompilerOptions => $value, ..., TargetPlatform => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::OutputConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->CompilerOptions

=head1 DESCRIPTION

Contains information about the output location for the compiled model
and the target device that the model runs on. C<TargetDevice> and
C<TargetPlatform> are mutually exclusive, so you need to choose one
between the two to specify your target device or platform. If you
cannot find your device you want to use from the C<TargetDevice> list,
use C<TargetPlatform> to describe the platform of your edge device and
C<CompilerOptions> if there are specific settings that are required or
recommended to use for particular TargetPlatform.

=head1 ATTRIBUTES


=head2 CompilerOptions => Str

Specifies additional parameters for compiler options in JSON format.
The compiler options are C<TargetPlatform> specific. It is required for
NVIDIA accelerators and highly recommended for CPU compilations. For
any other cases, it is optional to specify C<CompilerOptions.>

=over

=item *

C<DTYPE>: Specifies the data type for the input. When compiling for
C<ml_*> (except for C<ml_inf>) instances using PyTorch framework,
provide the data type (dtype) of the model's input. C<"float32"> is
used if C<"DTYPE"> is not specified. Options for data type are:

=over

=item *

float32: Use either C<"float"> or C<"float32">.

=item *

int64: Use either C<"int64"> or C<"long">.

=back

For example, C<{"dtype" : "float32"}>.

=item *

C<CPU>: Compilation for CPU supports the following compiler options.

=over

=item *

C<mcpu>: CPU micro-architecture. For example, C<{'mcpu':
'skylake-avx512'}>

=item *

C<mattr>: CPU flags. For example, C<{'mattr': ['+neon', '+vfpv4']}>

=back

=item *

C<ARM>: Details of ARM CPU compilations.

=over

=item *

C<NEON>: NEON is an implementation of the Advanced SIMD extension used
in ARMv7 processors.

For example, add C<{'mattr': ['+neon']}> to the compiler options if
compiling for ARM 32-bit platform with the NEON support.

=back

=item *

C<NVIDIA>: Compilation for NVIDIA GPU supports the following compiler
options.

=over

=item *

C<gpu_code>: Specifies the targeted architecture.

=item *

C<trt-ver>: Specifies the TensorRT versions in x.y.z. format.

=item *

C<cuda-ver>: Specifies the CUDA version in x.y format.

=back

For example, C<{'gpu-code': 'sm_72', 'trt-ver': '6.0.1', 'cuda-ver':
'10.1'}>

=item *

C<ANDROID>: Compilation for the Android OS supports the following
compiler options:

=over

=item *

C<ANDROID_PLATFORM>: Specifies the Android API levels. Available levels
range from 21 to 29. For example, C<{'ANDROID_PLATFORM': 28}>.

=item *

C<mattr>: Add C<{'mattr': ['+neon']}> to compiler options if compiling
for ARM 32-bit platform with NEON support.

=back

=item *

C<INFERENTIA>: Compilation for target ml_inf1 uses compiler options
passed in as a JSON string. For example, C<"CompilerOptions":
"\"--verbose 1 --num-neuroncores 2 -O2\"">.

For information about supported compiler options, see Neuron Compiler
CLI
(https://github.com/aws/aws-neuron-sdk/blob/master/docs/neuron-cc/command-line-reference.md).

=item *

C<CoreML>: Compilation for the CoreML OutputConfig$TargetDevice
supports the following compiler options:

=over

=item *

C<class_labels>: Specifies the classification labels file name inside
input tar.gz file. For example, C<{"class_labels":
"imagenet_labels_1000.txt"}>. Labels inside the txt file should be
separated by newlines.

=back

=item *

C<EIA>: Compilation for the Elastic Inference Accelerator supports the
following compiler options:

=over

=item *

C<precision_mode>: Specifies the precision of compiled artifacts.
Supported values are C<"FP16"> and C<"FP32">. Default is C<"FP32">.

=item *

C<signature_def_key>: Specifies the signature to use for models in
SavedModel format. Defaults is TensorFlow's default signature def key.

=item *

C<output_names>: Specifies a list of output tensor names for models in
FrozenGraph format. Set at most one API field, either:
C<signature_def_key> or C<output_names>.

=back

For example: C<{"precision_mode": "FP32", "output_names":
["output:0"]}>

=back



=head2 KmsKeyId => Str

The Amazon Web Services Key Management Service key (Amazon Web Services
KMS) that Amazon SageMaker uses to encrypt your output models with
Amazon S3 server-side encryption after compilation job. If you don't
provide a KMS key ID, Amazon SageMaker uses the default KMS key for
Amazon S3 for your role's account. For more information, see
KMS-Managed Encryption Keys
(https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingKMSEncryption.html)
in the I<Amazon Simple Storage Service Developer Guide.>

The KmsKeyId can be any of the following formats:

=over

=item *

Key ID: C<1234abcd-12ab-34cd-56ef-1234567890ab>

=item *

Key ARN:
C<arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab>

=item *

Alias name: C<alias/ExampleAlias>

=item *

Alias name ARN:
C<arn:aws:kms:us-west-2:111122223333:alias/ExampleAlias>

=back



=head2 B<REQUIRED> S3OutputLocation => Str

Identifies the S3 bucket where you want Amazon SageMaker to store the
model artifacts. For example, C<s3://bucket-name/key-name-prefix>.


=head2 TargetDevice => Str

Identifies the target device or the machine learning instance that you
want to run your model on after the compilation has completed.
Alternatively, you can specify OS, architecture, and accelerator using
TargetPlatform fields. It can be used instead of C<TargetPlatform>.


=head2 TargetPlatform => L<Paws::SageMaker::TargetPlatform>

Contains information about a target platform that you want your model
to run on, such as OS, architecture, and accelerators. It is an
alternative of C<TargetDevice>.

The following examples show how to configure the C<TargetPlatform> and
C<CompilerOptions> JSON strings for popular target platforms:

=over

=item *

Raspberry Pi 3 Model B+

C<"TargetPlatform": {"Os": "LINUX", "Arch": "ARM_EABIHF"},>

C<"CompilerOptions": {'mattr': ['+neon']}>

=item *

Jetson TX2

C<"TargetPlatform": {"Os": "LINUX", "Arch": "ARM64", "Accelerator":
"NVIDIA"},>

C<"CompilerOptions": {'gpu-code': 'sm_62', 'trt-ver': '6.0.1',
'cuda-ver': '10.0'}>

=item *

EC2 m5.2xlarge instance OS

C<"TargetPlatform": {"Os": "LINUX", "Arch": "X86_64", "Accelerator":
"NVIDIA"},>

C<"CompilerOptions": {'mcpu': 'skylake-avx512'}>

=item *

RK3399

C<"TargetPlatform": {"Os": "LINUX", "Arch": "ARM64", "Accelerator":
"MALI"}>

=item *

ARMv7 phone (CPU)

C<"TargetPlatform": {"Os": "ANDROID", "Arch": "ARM_EABI"},>

C<"CompilerOptions": {'ANDROID_PLATFORM': 25, 'mattr': ['+neon']}>

=item *

ARMv8 phone (CPU)

C<"TargetPlatform": {"Os": "ANDROID", "Arch": "ARM64"},>

C<"CompilerOptions": {'ANDROID_PLATFORM': 29}>

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

