# Generated by default/object.tt
package Paws::CloudFront::ParametersInCacheKeyAndForwardedToOrigin;
  use Moose;
  has CookiesConfig => (is => 'ro', isa => 'Paws::CloudFront::CachePolicyCookiesConfig', required => 1);
  has EnableAcceptEncodingBrotli => (is => 'ro', isa => 'Bool');
  has EnableAcceptEncodingGzip => (is => 'ro', isa => 'Bool', required => 1);
  has HeadersConfig => (is => 'ro', isa => 'Paws::CloudFront::CachePolicyHeadersConfig', required => 1);
  has QueryStringsConfig => (is => 'ro', isa => 'Paws::CloudFront::CachePolicyQueryStringsConfig', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::ParametersInCacheKeyAndForwardedToOrigin

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::ParametersInCacheKeyAndForwardedToOrigin object:

  $service_obj->Method(Att1 => { CookiesConfig => $value, ..., QueryStringsConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::ParametersInCacheKeyAndForwardedToOrigin object:

  $result = $service_obj->Method(...);
  $result->Att1->CookiesConfig

=head1 DESCRIPTION

This object determines the values that CloudFront includes in the cache
key. These values can include HTTP headers, cookies, and URL query
strings. CloudFront uses the cache key to find an object in its cache
that it can return to the viewer.

The headers, cookies, and query strings that are included in the cache
key are automatically included in requests that CloudFront sends to the
origin. CloudFront sends a request when it canE<rsquo>t find an object
in its cache that matches the requestE<rsquo>s cache key. If you want
to send values to the origin but I<not> include them in the cache key,
use C<OriginRequestPolicy>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CookiesConfig => L<Paws::CloudFront::CachePolicyCookiesConfig>

An object that determines whether any cookies in viewer requests (and
if so, which cookies) are included in the cache key and automatically
included in requests that CloudFront sends to the origin.


=head2 EnableAcceptEncodingBrotli => Bool

A flag that can affect whether the C<Accept-Encoding> HTTP header is
included in the cache key and included in requests that CloudFront
sends to the origin.

This field is related to the C<EnableAcceptEncodingGzip> field. If one
or both of these fields is C<true> I<and> the viewer request includes
the C<Accept-Encoding> header, then CloudFront does the following:

=over

=item *

Normalizes the value of the viewerE<rsquo>s C<Accept-Encoding> header

=item *

Includes the normalized header in the cache key

=item *

Includes the normalized header in the request to the origin, if a
request is necessary

=back

For more information, see Compression support
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects)
in the I<Amazon CloudFront Developer Guide>.

If you set this value to C<true>, and this cache behavior also has an
origin request policy attached, do not include the C<Accept-Encoding>
header in the origin request policy. CloudFront always includes the
C<Accept-Encoding> header in origin requests when the value of this
field is C<true>, so including this header in an origin request policy
has no effect.

If both of these fields are C<false>, then CloudFront treats the
C<Accept-Encoding> header the same as any other HTTP header in the
viewer request. By default, itE<rsquo>s not included in the cache key
and itE<rsquo>s not included in origin requests. In this case, you can
manually add C<Accept-Encoding> to the headers whitelist like any other
HTTP header.


=head2 B<REQUIRED> EnableAcceptEncodingGzip => Bool

A flag that can affect whether the C<Accept-Encoding> HTTP header is
included in the cache key and included in requests that CloudFront
sends to the origin.

This field is related to the C<EnableAcceptEncodingBrotli> field. If
one or both of these fields is C<true> I<and> the viewer request
includes the C<Accept-Encoding> header, then CloudFront does the
following:

=over

=item *

Normalizes the value of the viewerE<rsquo>s C<Accept-Encoding> header

=item *

Includes the normalized header in the cache key

=item *

Includes the normalized header in the request to the origin, if a
request is necessary

=back

For more information, see Compression support
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html#cache-policy-compressed-objects)
in the I<Amazon CloudFront Developer Guide>.

If you set this value to C<true>, and this cache behavior also has an
origin request policy attached, do not include the C<Accept-Encoding>
header in the origin request policy. CloudFront always includes the
C<Accept-Encoding> header in origin requests when the value of this
field is C<true>, so including this header in an origin request policy
has no effect.

If both of these fields are C<false>, then CloudFront treats the
C<Accept-Encoding> header the same as any other HTTP header in the
viewer request. By default, itE<rsquo>s not included in the cache key
and itE<rsquo>s not included in origin requests. In this case, you can
manually add C<Accept-Encoding> to the headers whitelist like any other
HTTP header.


=head2 B<REQUIRED> HeadersConfig => L<Paws::CloudFront::CachePolicyHeadersConfig>

An object that determines whether any HTTP headers (and if so, which
headers) are included in the cache key and automatically included in
requests that CloudFront sends to the origin.


=head2 B<REQUIRED> QueryStringsConfig => L<Paws::CloudFront::CachePolicyQueryStringsConfig>

An object that determines whether any URL query strings in viewer
requests (and if so, which query strings) are included in the cache key
and automatically included in requests that CloudFront sends to the
origin.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

