/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions;

import junit.framework.Test;
import junit.framework.TestResult;
import junit.framework.TestSuite;

public class ActiveTestSuite
extends TestSuite {
    private volatile int fActiveTestDeathCount;

    public void run(TestResult result) {
        this.fActiveTestDeathCount = 0;
        super.run(result);
        this.waitUntilFinished();
    }

    public synchronized void runFinished(Test test) {
        ++this.fActiveTestDeathCount;
        this.notifyAll();
    }

    public void runTest(final Test test, final TestResult result) {
        Thread t = new Thread(){

            public void run() {
                try {
                    test.run(result);
                }
                finally {
                    Object var2_1 = null;
                    this.runFinished(test);
                }
            }
        };
        t.start();
    }

    synchronized void waitUntilFinished() {
        while (this.fActiveTestDeathCount < this.testCount()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

