/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.history;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.parser.history.HistoryNode;
import org.maltparser.parser.history.action.GuideUserAction;

public class HistoryListNode
implements HistoryNode {
    private HistoryNode previousNode;
    private GuideUserAction action;
    private int position;

    public HistoryListNode(HistoryNode previousNode, GuideUserAction action) {
        this.setPreviousNode(previousNode);
        this.setAction(action);
        if (previousNode != null) {
            this.setPosition(previousNode.getPosition() + 1);
        } else {
            this.setPosition(1);
        }
    }

    public HistoryNode getPreviousNode() {
        return this.previousNode;
    }

    public GuideUserAction getAction() {
        return this.action;
    }

    public void setPreviousNode(HistoryNode node) {
        this.previousNode = node;
    }

    public void setAction(GuideUserAction action) {
        this.action = action;
    }

    private void setPosition(int p) {
        this.position = p;
    }

    public int getPosition() {
        return this.position;
    }

    public void clear() throws MaltChainedException {
        this.setPreviousNode(null);
        this.setAction(null);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.action);
        return sb.toString();
    }
}

