/*
 * Decompiled with CFR 0.152.
 */
package gma.simr;

import gma.MapPoint;
import gma.simr.PointDisplacementComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class MappingChain
implements Comparable {
    public static final String CHAIN_SIZE = "chainSize";
    public static final String SLOPE = "slope";
    public static final String ANGLE_DEVIATION = "angleDeviation";
    public static final String LINEAR_REGRESSION_ERROR = "linearRegressionError";
    private int defaultChainSize;
    private double defaultSlope;
    private float defaultAngleDeviation;
    private float defaultLinearRegressionError;
    private Properties properties = null;
    private List mapPoints = new ArrayList();
    private boolean isAmbiguous = false;
    private double slope = Double.NaN;
    private double interception = Double.NaN;
    private double sumSquareError = Double.NaN;

    public MappingChain(Properties properties) {
        this.properties = properties;
        this.defaultChainSize = Integer.parseInt(properties.getProperty(CHAIN_SIZE));
        this.defaultSlope = Double.parseDouble(properties.getProperty(SLOPE));
        this.defaultAngleDeviation = Float.parseFloat(properties.getProperty(ANGLE_DEVIATION));
        this.defaultLinearRegressionError = Float.parseFloat(properties.getProperty(LINEAR_REGRESSION_ERROR));
        this.defaultLinearRegressionError *= this.defaultLinearRegressionError;
        this.defaultLinearRegressionError *= (float)this.defaultChainSize;
    }

    public List disambiguateChain() {
        List ambiguousMapPoints = this.groupAmbiguousMapPoints(this.mapPoints);
        return this.generateDisambiguatedMappingChains(ambiguousMapPoints);
    }

    private List groupAmbiguousMapPoints(List mapPoints) {
        Float yAxisIndex;
        Float xAxisIndex;
        MapPoint mapPoint;
        ArrayList ambiguousMapPoints = new ArrayList();
        Hashtable<Float, Integer> xAxisIndexCounter = new Hashtable<Float, Integer>();
        Hashtable<Float, Integer> yAxisIndexCounter = new Hashtable<Float, Integer>();
        Hashtable<Float, Integer> xAmbiguousMapPointPointers = new Hashtable<Float, Integer>();
        Hashtable yAmbiguousMapPointPointers = new Hashtable();
        Iterator iterator = mapPoints.iterator();
        while (iterator.hasNext()) {
            mapPoint = (MapPoint)iterator.next();
            xAxisIndex = new Float(mapPoint.getXAxisTick().getPosition());
            if (xAxisIndexCounter.containsKey(xAxisIndex)) {
                xAxisIndexCounter.put(xAxisIndex, new Integer((Integer)xAxisIndexCounter.get(xAxisIndex) + 1));
            } else {
                xAxisIndexCounter.put(xAxisIndex, new Integer(1));
            }
            yAxisIndex = new Float(mapPoint.getYAxisTick().getPosition());
            if (yAxisIndexCounter.containsKey(yAxisIndex)) {
                yAxisIndexCounter.put(yAxisIndex, new Integer((Integer)yAxisIndexCounter.get(yAxisIndex) + 1));
                continue;
            }
            yAxisIndexCounter.put(yAxisIndex, new Integer(1));
        }
        iterator = mapPoints.iterator();
        while (iterator.hasNext()) {
            mapPoint = (MapPoint)iterator.next();
            xAxisIndex = new Float(mapPoint.getXAxisTick().getPosition());
            yAxisIndex = new Float(mapPoint.getYAxisTick().getPosition());
            if ((Integer)xAxisIndexCounter.get(xAxisIndex) == 1 && (Integer)yAxisIndexCounter.get(yAxisIndex) == 1) {
                ArrayList<MapPoint> currentMapPoints = new ArrayList<MapPoint>();
                currentMapPoints.add(mapPoint);
                ambiguousMapPoints.add(currentMapPoints);
                continue;
            }
            if (xAmbiguousMapPointPointers.containsKey(xAxisIndex) && yAmbiguousMapPointPointers.containsKey(yAxisIndex)) {
                Integer xAmbiguousMapPointPointer = (Integer)xAmbiguousMapPointPointers.get(xAxisIndex);
                Integer yAmbiguousMapPointPointer = (Integer)yAmbiguousMapPointPointers.get(yAxisIndex);
                if (xAmbiguousMapPointPointer.intValue() != yAmbiguousMapPointPointer.intValue()) {
                    Iterator innerIterator = ((List)ambiguousMapPoints.get(xAmbiguousMapPointPointer)).iterator();
                    while (innerIterator.hasNext()) {
                        MapPoint ambiguousMapPoint = (MapPoint)innerIterator.next();
                        yAmbiguousMapPointPointers.put(new Float(ambiguousMapPoint.getYAxisTick().getPosition()), yAmbiguousMapPointPointers.get(yAxisIndex));
                    }
                    innerIterator = ((List)ambiguousMapPoints.get(xAmbiguousMapPointPointer)).iterator();
                    while (innerIterator.hasNext()) {
                        MapPoint currentMapPoint = (MapPoint)innerIterator.next();
                        ((List)ambiguousMapPoints.get(yAmbiguousMapPointPointer)).add(currentMapPoint);
                    }
                    TreeSet sortedMapPoints = new TreeSet(new PointDisplacementComparator());
                    Iterator iter = ((List)ambiguousMapPoints.get(yAmbiguousMapPointPointer)).iterator();
                    while (iter.hasNext()) {
                        sortedMapPoints.add(iter.next());
                    }
                    ambiguousMapPoints.remove(yAmbiguousMapPointPointer);
                    ambiguousMapPoints.add(yAmbiguousMapPointPointer, new ArrayList(sortedMapPoints));
                    ((List)ambiguousMapPoints.get(xAmbiguousMapPointPointer)).clear();
                    xAmbiguousMapPointPointers.put(xAxisIndex, yAmbiguousMapPointPointer);
                }
            } else if (yAmbiguousMapPointPointers.containsKey(yAxisIndex)) {
                xAmbiguousMapPointPointers.put(xAxisIndex, (Integer)yAmbiguousMapPointPointers.get(yAxisIndex));
            } else if (xAmbiguousMapPointPointers.containsKey(xAxisIndex)) {
                yAmbiguousMapPointPointers.put(yAxisIndex, xAmbiguousMapPointPointers.get(xAxisIndex));
            } else {
                Integer index = new Integer(ambiguousMapPoints.size());
                xAmbiguousMapPointPointers.put(xAxisIndex, index);
                yAmbiguousMapPointPointers.put(yAxisIndex, index);
                ambiguousMapPoints.add(index, new ArrayList());
            }
            ((List)ambiguousMapPoints.get((Integer)xAmbiguousMapPointPointers.get(xAxisIndex))).add(mapPoint);
        }
        Iterator iter = ambiguousMapPoints.iterator();
        while (iter.hasNext()) {
            int ambiguousMapPointSize = ((List)iter.next()).size();
            if (ambiguousMapPointSize != 0) continue;
            iter.remove();
        }
        return ambiguousMapPoints;
    }

    private List generateDisambiguatedMappingChains(List groupedAmbiguousMapPoints) {
        ArrayList unambiguousMapPoints = new ArrayList();
        ArrayList<List> ambiguousMapPoints = new ArrayList<List>();
        Iterator splitIterator = groupedAmbiguousMapPoints.iterator();
        while (splitIterator.hasNext()) {
            List mapPoints = (List)splitIterator.next();
            if (mapPoints.size() == 1) {
                unambiguousMapPoints.add(mapPoints.get(0));
                continue;
            }
            ambiguousMapPoints.add(mapPoints);
        }
        ArrayList<List> disambiguatedMappingChains = new ArrayList<List>();
        int count = 1;
        Iterator outerIterator = ambiguousMapPoints.iterator();
        while (outerIterator.hasNext()) {
            HashMap ambiguousMappingChainMap = new HashMap();
            List ambiguousMapPointGroup = (List)outerIterator.next();
            List disambiguated = this.doDisambiguation(ambiguousMapPointGroup, ambiguousMappingChainMap);
            count = disambiguated.size() * count;
            disambiguatedMappingChains.add(disambiguated);
        }
        ArrayList<MappingChain> mappingChains = new ArrayList<MappingChain>(count);
        for (int index = 0; index < count; ++index) {
            MappingChain mappingChain = new MappingChain(this.properties);
            Iterator iter = unambiguousMapPoints.iterator();
            while (iter.hasNext()) {
                mappingChain.addMapPoint((MapPoint)iter.next(), true);
            }
            mappingChains.add(mappingChain);
        }
        int[] sizes = new int[disambiguatedMappingChains.size()];
        int[] counters = new int[disambiguatedMappingChains.size()];
        for (int i = 0; i < counters.length; ++i) {
            sizes[i] = ((List)disambiguatedMappingChains.get(i)).size();
            counters[i] = 0;
        }
        Iterator iterator = mappingChains.iterator();
        while (iterator.hasNext()) {
            MappingChain mappingChain = (MappingChain)iterator.next();
            int countersIndex = 0;
            Iterator middleIterator = disambiguatedMappingChains.iterator();
            while (middleIterator.hasNext()) {
                List middleAmbiguousMapPoints = (List)middleIterator.next();
                List innerAmbiguousMapPoints = (List)middleAmbiguousMapPoints.get(counters[countersIndex]);
                Iterator innerIterator = innerAmbiguousMapPoints.iterator();
                while (innerIterator.hasNext()) {
                    mappingChain.addMapPoint((MapPoint)innerIterator.next(), true);
                }
                if (countersIndex == ambiguousMapPoints.size() - 1) {
                    int n = countersIndex;
                    counters[n] = counters[n] + 1;
                    int tempIndex = countersIndex;
                    while (counters[tempIndex] >= sizes[tempIndex]) {
                        counters[tempIndex--] = 0;
                        if (tempIndex < 0) break;
                        int n2 = tempIndex;
                        counters[n2] = counters[n2] + 1;
                    }
                }
                ++countersIndex;
            }
        }
        return mappingChains;
    }

    private List doDisambiguation(List ambiguousMapPointGroup, Map ambiguousMappingChainMap) {
        LinkedList<List> disambiguatedMappingChains = new LinkedList<List>();
        if (ambiguousMapPointGroup.size() == 2) {
            MapPoint first = (MapPoint)ambiguousMapPointGroup.get(0);
            MapPoint second = (MapPoint)ambiguousMapPointGroup.get(1);
            if (!first.getXAxisTick().equals(second.getXAxisTick()) && !first.getYAxisTick().equals(second.getYAxisTick())) {
                disambiguatedMappingChains.add(ambiguousMapPointGroup);
            } else {
                Iterator innerIterator = ambiguousMapPointGroup.iterator();
                while (innerIterator.hasNext()) {
                    ArrayList disambiguatedMapPointGroup = new ArrayList();
                    disambiguatedMapPointGroup.add(innerIterator.next());
                    disambiguatedMappingChains.add(disambiguatedMapPointGroup);
                }
            }
            return disambiguatedMappingChains;
        }
        String hashKey = "";
        boolean isFirst = true;
        Iterator hashKeyIterator = ambiguousMapPointGroup.iterator();
        while (hashKeyIterator.hasNext()) {
            if (isFirst) {
                isFirst = false;
            } else {
                hashKey = hashKey + "#";
            }
            hashKey = hashKey + ((MapPoint)hashKeyIterator.next()).toString();
        }
        Iterator middleIterator = ambiguousMapPointGroup.iterator();
        while (middleIterator.hasNext()) {
            LinkedList<MapPoint> mapPoints;
            MapPoint middle;
            ArrayList<MapPoint> disambiguatedMapPointGroup = new ArrayList<MapPoint>();
            MapPoint previous = middle = (MapPoint)middleIterator.next();
            Iterator innerIterator = ambiguousMapPointGroup.iterator();
            while (innerIterator.hasNext()) {
                MapPoint inner = (MapPoint)innerIterator.next();
                if (middle.getXAxisTick().equals(inner.getXAxisTick()) || middle.getYAxisTick().equals(inner.getYAxisTick())) continue;
                disambiguatedMapPointGroup.add(inner);
                previous = inner;
            }
            if (disambiguatedMapPointGroup.size() > 1) {
                List subset = this.doDisambiguation(disambiguatedMapPointGroup, ambiguousMappingChainMap);
                Iterator subsetIterator = subset.iterator();
                while (subsetIterator.hasNext()) {
                    List mapPoints2 = (List)subsetIterator.next();
                    MapPoint mapPoint = (MapPoint)mapPoints2.get(0);
                    if (!(middle.getDisplacement() < mapPoint.getDisplacement())) continue;
                    mapPoints2.add(0, middle);
                    disambiguatedMappingChains.add(mapPoints2);
                }
                continue;
            }
            if (disambiguatedMapPointGroup.size() == 1) {
                mapPoints = new LinkedList<MapPoint>();
                mapPoints.add(middle);
                mapPoints.add(previous);
                disambiguatedMappingChains.add(mapPoints);
                continue;
            }
            mapPoints = new LinkedList();
            mapPoints.add(middle);
            disambiguatedMappingChains.add(mapPoints);
        }
        ambiguousMappingChainMap.put(hashKey, disambiguatedMappingChains);
        return disambiguatedMappingChains;
    }

    public int getChainSize() {
        return this.mapPoints.size();
    }

    public boolean addMapPoint(MapPoint mapPoint, boolean forceOnAmbiguity) {
        Iterator iterator = this.mapPoints.iterator();
        while (iterator.hasNext()) {
            if (!mapPoint.isConflict((MapPoint)iterator.next())) continue;
            this.isAmbiguous = true;
            break;
        }
        if (this.isAmbiguous && !forceOnAmbiguity) {
            this.isAmbiguous = false;
            return false;
        }
        this.mapPoints.add(mapPoint);
        return true;
    }

    public boolean isConflict(MappingChain compareMappingChain) {
        MappingChain lowerMappingChain = null;
        MappingChain upperMappingChain = null;
        if (this.getEndMapPoint(true, true).isMaxMapPoint(compareMappingChain.getEndMapPoint(true, true), true) == -1) {
            lowerMappingChain = this;
            upperMappingChain = compareMappingChain;
        } else {
            lowerMappingChain = compareMappingChain;
            upperMappingChain = this;
        }
        if (lowerMappingChain.getEndMapPoint(true, false).isMaxMapPoint(upperMappingChain.getEndMapPoint(true, true), true) == -1 && lowerMappingChain.getEndMapPoint(false, false).isMaxMapPoint(upperMappingChain.getEndMapPoint(false, true), false) != -1) {
            return true;
        }
        TreeSet<MapPoint> lowerMapPoints = new TreeSet<MapPoint>();
        TreeSet<MapPoint> upperMapPoints = new TreeSet<MapPoint>();
        int upperYMin = -1;
        int lowerYMax = -1;
        for (int i = 0; i < this.defaultChainSize; ++i) {
            lowerMapPoints.add(lowerMappingChain.getMapPoint(i));
            upperMapPoints.add(upperMappingChain.getMapPoint(i));
            float testYMin = upperMappingChain.getMapPoint(i).getYAxisTick().getPosition();
            if (upperYMin != -1 && !(testYMin < upperMappingChain.getMapPoint(upperYMin).getYAxisTick().getPosition())) continue;
            upperYMin = i;
        }
        boolean checkingConflict = false;
        Iterator lowerIterator = lowerMapPoints.iterator();
        Iterator upperIterator = upperMapPoints.iterator();
        while (lowerIterator.hasNext() && upperIterator.hasNext()) {
            MapPoint lowerMapPoint = (MapPoint)lowerIterator.next();
            MapPoint upperMapPoint = (MapPoint)upperIterator.next();
            while (!checkingConflict && lowerMapPoint.isMaxMapPoint(upperMapPoint, true) == -1 && lowerMapPoint.isMaxMapPoint(upperMappingChain.getMapPoint(upperYMin), false) == -1) {
                if (lowerIterator.hasNext()) {
                    lowerMapPoint = (MapPoint)lowerIterator.next();
                    continue;
                }
                return false;
            }
            checkingConflict = true;
            if (lowerMapPoint.isMaxMapPoint(upperMapPoint, true) == 0 && lowerMapPoint.isMaxMapPoint(upperMapPoint, false) == 0) continue;
            return true;
        }
        return false;
    }

    public MapPoint getEndMapPoint(boolean xAxisCompare, boolean isMinIndex) {
        Iterator iterator = this.mapPoints.iterator();
        MapPoint endMapPoint = (MapPoint)iterator.next();
        while (iterator.hasNext()) {
            MapPoint mapPoint = (MapPoint)iterator.next();
            if (isMinIndex && mapPoint.isMaxMapPoint(endMapPoint, xAxisCompare) == -1) {
                endMapPoint = mapPoint;
                continue;
            }
            if (isMinIndex || endMapPoint.isMaxMapPoint(mapPoint, xAxisCompare) != -1) continue;
            endMapPoint = mapPoint;
        }
        return endMapPoint;
    }

    public boolean isLegalMappingChain() {
        for (int i = 0; i < this.defaultChainSize; ++i) {
            float XPos1 = ((MapPoint)this.mapPoints.get(i)).getXAxisTick().getPosition();
            float YPos1 = ((MapPoint)this.mapPoints.get(i)).getYAxisTick().getPosition();
            for (int j = i + 1; j < this.defaultChainSize; ++j) {
                float XPos2 = ((MapPoint)this.mapPoints.get(j)).getXAxisTick().getPosition();
                float YPos2 = ((MapPoint)this.mapPoints.get(j)).getYAxisTick().getPosition();
                if (XPos1 != XPos2 && YPos1 != YPos2) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isQualifiedMappingChain() {
        this.computeRegression();
        this.sumSquareError = this.computeSumSquareError();
        double slopeDeviation = Math.abs(Math.atan(this.slope) - Math.atan(this.defaultSlope));
        return slopeDeviation <= (double)this.defaultAngleDeviation && this.sumSquareError <= (double)this.defaultLinearRegressionError;
    }

    private void computeRegression() {
        double sumX = 0.0;
        double sumY = 0.0;
        double sumXY = 0.0;
        double sumSquareX = 0.0;
        Iterator iterator = this.mapPoints.iterator();
        while (iterator.hasNext()) {
            MapPoint mapPoint = (MapPoint)iterator.next();
            double x = mapPoint.getXAxisTick().getPosition();
            double y = mapPoint.getYAxisTick().getPosition();
            sumX += x;
            sumY += y;
            sumXY += x * y;
            sumSquareX += x * x;
        }
        double meanX = sumX / (double)this.defaultChainSize;
        double meanY = sumY / (double)this.defaultChainSize;
        double denominator = sumSquareX - (double)this.defaultChainSize * meanX * meanX;
        if (denominator == 0.0) {
            this.slope = 3.4028234663852886E38;
            this.interception = 3.4028234663852886E38;
        } else {
            this.slope = (sumXY - (double)this.defaultChainSize * meanX * meanY) / denominator;
            this.interception = meanY - this.slope * meanX;
        }
    }

    private double computeSumSquareError() {
        double sumSquareDisplacement = 0.0;
        if (this.slope == 0.0) {
            Iterator iterator = this.mapPoints.iterator();
            while (iterator.hasNext()) {
                MapPoint mapPoint = (MapPoint)iterator.next();
                double displacement = (double)mapPoint.getYAxisTick().getPosition() - this.interception;
                sumSquareDisplacement = displacement * displacement;
            }
        } else {
            double ratio = Math.sin(Math.atan(this.slope));
            double squareRatio = ratio * ratio;
            Iterator iterator = this.mapPoints.iterator();
            while (iterator.hasNext()) {
                MapPoint mapPoint = (MapPoint)iterator.next();
                double xDisplacement = ((double)mapPoint.getYAxisTick().getPosition() - this.interception) / this.slope - (double)mapPoint.getXAxisTick().getPosition();
                sumSquareDisplacement += xDisplacement * xDisplacement * squareRatio;
            }
        }
        sumSquareDisplacement = (float)sumSquareDisplacement;
        return sumSquareDisplacement;
    }

    public double getSumSquareError() {
        if (this.sumSquareError == Double.NaN) {
            this.sumSquareError = this.computeSumSquareError();
        }
        return this.sumSquareError;
    }

    public boolean isLessDisplaced(MappingChain chain) {
        double diff = chain.getSumSquareError() - this.sumSquareError;
        if (Math.abs(diff) < 1.0E-14) {
            return true;
        }
        return this.sumSquareError < chain.getSumSquareError();
    }

    public boolean isAmbiguous() {
        return this.isAmbiguous;
    }

    public MapPoint getMapPoint(int index) {
        return (MapPoint)this.mapPoints.get(index);
    }

    public Object clone() {
        MappingChain mappingChain = new MappingChain(this.properties);
        Iterator iterator = this.mapPoints.iterator();
        while (iterator.hasNext()) {
            mappingChain.addMapPoint((MapPoint)iterator.next(), true);
        }
        return mappingChain;
    }

    public int compareTo(Object compareMappingChain) {
        MapPoint mapPoint = this.getEndMapPoint(true, true);
        MapPoint compareMapPoint = ((MappingChain)compareMappingChain).getEndMapPoint(true, true);
        return mapPoint.isMaxMapPoint(compareMapPoint, true);
    }

    public boolean equals(Object compareMappingChain) {
        for (int index = 0; index < this.getChainSize(); ++index) {
            if (((MapPoint)this.mapPoints.get(index)).equals(((MappingChain)compareMappingChain).getMapPoint(index))) {
                continue;
            }
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.mapPoints.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((MapPoint)iterator.next()).toString() + "\n");
        }
        return stringBuffer.toString();
    }

    public List sort(MappingChain mapChain) {
        ArrayList<MapPoint> sortedMC = new ArrayList<MapPoint>();
        while (sortedMC.size() < mapChain.getChainSize()) {
            float lowest = mapChain.getEndMapPoint(true, false).getXAxisTick().getPosition();
            MapPoint pointToAdd = mapChain.getEndMapPoint(true, false);
            for (int mp = 0; mp < mapChain.getChainSize(); ++mp) {
                MapPoint point = mapChain.getMapPoint(mp);
                float xcord = point.getXAxisTick().getPosition();
                if (!(xcord < lowest) || sortedMC.contains(point)) continue;
                lowest = point.getXAxisTick().getPosition();
                pointToAdd = point;
            }
            sortedMC.add(pointToAdd);
        }
        return sortedMC;
    }
}

