/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok.lexicon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import opennlp.common.parse.LexException;
import opennlp.common.parse.Lexicon;
import opennlp.common.synsem.Sign;
import opennlp.common.xml.NLPDocument;
import opennlp.common.xml.XmlUtils;
import opennlp.grok.expression.AtomCat;
import opennlp.grok.expression.GSign;
import opennlp.grok.expression.SignHash;
import opennlp.grok.lexicon.NameChopper;
import org.jdom.Element;

public abstract class LexiconAdapter
implements Lexicon {
    public LexiconAdapter(Properties g) {
    }

    public List getWords(NLPDocument doc) throws LexException {
        ArrayList entries = new ArrayList();
        this.snarfTokens(doc, entries);
        return entries;
    }

    public List getWords(String s) throws LexException {
        ArrayList<SignHash> entries = new ArrayList<SignHash>();
        StringTokenizer st = new StringTokenizer(s);
        while (st.hasMoreTokens()) {
            String w = st.nextToken();
            ArrayList<Sign> c = this.getWord(w);
            if (c.size() == 0) {
                c = new ArrayList<Sign>();
                c.add(this.unknownWord(w));
            }
            entries.add(new SignHash(c));
        }
        return entries;
    }

    private Sign unknownWord(String w) {
        return new GSign(w, new AtomCat("n"));
    }

    protected void snarfTokens(NLPDocument doc, List entries) throws LexException {
        Iterator i = doc.tokenIterator();
        while (i.hasNext()) {
            Element tokEl = (Element)i.next();
            String type = tokEl.getAttributeValue("type");
            if (type == null) {
                List wordEls = doc.getWordElements(tokEl);
                Iterator j = wordEls.iterator();
                while (j.hasNext()) {
                    String orthog = ((Element)j.next()).getText();
                    if (orthog.length() <= 0) continue;
                    ArrayList<Sign> c = this.getWord(orthog);
                    if (c.size() == 0) {
                        c = new ArrayList<Sign>();
                        c.add(this.unknownWord(orthog));
                    }
                    entries.add(new SignHash(c));
                }
                continue;
            }
            String orth = XmlUtils.getAllTextNested((Element)tokEl);
            StringBuffer sem = new StringBuffer();
            if (type.equals("name")) {
                sem.append("^NAME(").append(NameChopper.segmentName(orth)).append(')');
            } else if (type.equals("email")) {
                sem.append("^EMAIL(").append(orth).append(')');
            }
            entries.add(new SignHash(this.unknownWord(sem.toString())));
        }
    }

    public abstract Collection getWord(String var1) throws LexException;
}

