/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import opennlp.common.Pipeline;
import opennlp.common.PipelineException;
import opennlp.common.parse.LexException;
import opennlp.common.parse.Lexicon;
import opennlp.common.parse.ParseException;
import opennlp.common.parse.Parser;
import opennlp.common.parse.RuleGroup;
import opennlp.common.synsem.Category;
import opennlp.common.synsem.Sign;
import opennlp.common.util.Pair;
import opennlp.common.xml.NLPDocument;
import opennlp.grok.expression.AtomCat;
import opennlp.grok.io.RuleReader;
import opennlp.grok.lexicon.LMRLexicon;
import opennlp.grok.parse.CKY;
import opennlp.grok.util.Debug;
import opennlp.grok.util.Params;

public class Grokling {
    public boolean interpreting = false;
    public boolean showSyntax = true;
    public boolean showSemantics = false;
    private Properties _grammarInfo = new Properties();
    private Parser _parser;
    private Pipeline _pipeline;
    private String[] ppLinks = new String[]{"opennlp.grok.preprocess.sentdetect.EnglishSentenceDetectorME", "opennlp.grok.preprocess.tokenize.EnglishTokenizerME"};

    public Grokling(Lexicon lexicon, RuleGroup rules) {
        this._parser = new CKY(lexicon, rules);
    }

    public Grokling(URL grammar) throws IOException, PipelineException {
        this.loadGrammar(grammar);
        Params.setProperty("Enable:Databases", "false");
        Params.setProperty("Results:All Derivs", "false");
        System.out.print("Loading Lex... ");
        LMRLexicon lexicon = new LMRLexicon(this._grammarInfo);
        System.out.print("Rules... ");
        RuleGroup rules = RuleReader.getRules(this._grammarInfo.getProperty("rules"));
        this._parser = new CKY(lexicon, rules);
        System.out.println("Pipeline... ");
        this._pipeline = new Pipeline(this.ppLinks);
    }

    public Pair[] grok(String s) throws ParseException, PipelineException {
        if (s.equals("")) {
            throw new ParseException("Nothing to Parse!");
        }
        this.interpreting = true;
        NLPDocument doc = this._pipeline.run((Object)s);
        this._parser.parse(doc);
        ArrayList interps = this.getPreferredResult(this._parser.getResult());
        if (interps.isEmpty()) {
            throw new ParseException("No result ");
        }
        Pair[] answers = new Pair[interps.size()];
        int curIndex = 0;
        while (curIndex < answers.length) {
            Sign constit = (Sign)interps.get(curIndex);
            answers[curIndex] = new Pair((Object)constit.getCategory().toString(), (Object)"no LF");
            ++curIndex;
        }
        return answers;
    }

    public String[] grokAndReturnStrings(String sentence) throws LexException, ParseException, IOException, PipelineException {
        Pair[] res = this.grok(sentence);
        String[] s = new String[res.length];
        if (this.showSyntax && this.showSemantics) {
            int i = 0;
            while (i < res.length) {
                s[i] = res[i].a.toString() + " : " + res[i].b.toString();
                ++i;
            }
        } else if (this.showSemantics) {
            int i = 0;
            while (i < res.length) {
                s[i] = res[i].b.toString();
                ++i;
            }
        } else {
            int i = 0;
            while (i < res.length) {
                s[i] = res[i].a.toString();
                ++i;
            }
        }
        return s;
    }

    private ArrayList getPreferredResult(ArrayList unranked) {
        ArrayList<Sign> reranked = new ArrayList<Sign>();
        Iterator i = ((AbstractList)unranked).iterator();
        while (i.hasNext()) {
            String type;
            Sign w = (Sign)i.next();
            Category syn = w.getCategory();
            if (!(syn instanceof AtomCat) || !(type = ((AtomCat)syn).getType()).equals("s")) continue;
            reranked.add(w);
            i.remove();
        }
        Iterator i2 = ((AbstractList)unranked).iterator();
        while (i2.hasNext()) {
            String type;
            Sign w = (Sign)i2.next();
            Category syn = w.getCategory();
            if (!(syn instanceof AtomCat) || !(type = ((AtomCat)syn).getType()).equals("n")) continue;
            reranked.add(w);
            i2.remove();
        }
        reranked.addAll(unranked);
        return reranked;
    }

    private void loadGrammar(URL grammar) throws IOException {
        this._grammarInfo.load(grammar.openStream());
        String gram = grammar.toString();
        String dir = gram.substring(0, gram.lastIndexOf(47));
        Iterator it = ((Hashtable)this._grammarInfo).keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String file = this._grammarInfo.getProperty(key);
            if (file.charAt(0) == '/') {
                this._grammarInfo.setProperty(key, "file:" + file);
                continue;
            }
            this._grammarInfo.setProperty(key, dir + "/" + file);
        }
    }

    private static String flattenStringArray(String[] a) {
        String f = "";
        int i = 1;
        while (i <= a.length) {
            f = f + "Interpretation " + i + ":\n " + a[i - 1] + "\n\n";
            ++i;
        }
        return f;
    }

    public static void main(String[] args) throws IOException, LexException, PipelineException {
        String gram;
        if (args.length == 0) {
            System.out.println("\nUsage: java opennlp.grok.Grokling <grammar file>\n");
            System.exit(0);
        }
        gram = (gram = args[0]).charAt(0) == '/' ? "file:" + gram : "file:" + System.getProperty("user.dir") + "/" + gram;
        System.out.println("Loading grammar at URL: " + gram);
        Grokling g = null;
        try {
            g = new Grokling(new URL(gram));
        }
        catch (PipelineException ple) {
            System.out.println("Something wrong with preprocessing pipeline: " + ple.toString());
            System.exit(0);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        boolean showall = false;
        System.out.println("\nEnter sentences to parse. Ctrl-C to quit.\n");
        block8: while (true) {
            try {
                System.out.print("grok> ");
                String input = br.readLine();
                if (input.equals(":filter off") || input.equals(":foff")) {
                    Params.setProperty("Results:Use Filter", "false");
                    continue;
                }
                if (input.equals(":filter on") || input.equals(":fon")) {
                    Params.setProperty("Results:Use Filter", "true");
                    continue;
                }
                if (input.equals(":debug on") || input.equals(":don")) {
                    Debug.Register("Apply Rule", true);
                    continue;
                }
                if (input.equals(":debug off") || input.equals(":doff")) {
                    Debug.Register("Chart Parser", false);
                    Debug.Register("Lexicon", false);
                    continue;
                }
                if (input.equals(":show feats") || input.equals(":feats")) {
                    Params.setProperty("Display:Features", "true");
                    continue;
                }
                if (input.equals(":show syntax") || input.equals(":syn")) {
                    g.showSyntax = true;
                    continue;
                }
                if (input.equals(":show all") || input.equals(":all")) {
                    showall = true;
                    continue;
                }
                if (input.equals(":show best") || input.equals(":best")) {
                    showall = false;
                    continue;
                }
                String[] sa = g.grokAndReturnStrings(input);
                int resLength = sa.length;
                switch (resLength) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        System.out.println(resLength + " parse found.");
                        break;
                    }
                    default: {
                        System.out.println(resLength + " parses found.");
                    }
                }
                if (showall) {
                    int i = 0;
                    while (true) {
                        if (i >= resLength) continue block8;
                        System.out.println(sa[i]);
                        ++i;
                    }
                }
                System.out.println(sa[0]);
                continue;
            }
            catch (ParseException pe) {
                System.out.println((Object)pe);
                continue;
            }
            break;
        }
    }
}

