/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.identification;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.identification.AggregateInformation;
import org.opengis.metadata.identification.AssociationType;
import org.opengis.metadata.identification.InitiativeType;

@XmlType(name="MD_AssociatedResource_Type")
@XmlRootElement(name="MD_AssociatedResource")
@UML(identifier="MD_AssociatedResource", specification=Specification.ISO_19115)
public class DefaultAssociatedResource
extends ISOMetadata {
    private static final long serialVersionUID = -803259032236939135L;
    private Citation name;
    private AssociationType associationType;
    private InitiativeType initiativeType;
    private Citation metadataReference;

    public DefaultAssociatedResource() {
    }

    public DefaultAssociatedResource(Citation citation, AssociationType associationType) {
        this.name = citation;
        this.associationType = associationType;
    }

    DefaultAssociatedResource(DefaultAssociatedResource defaultAssociatedResource) {
        this.associationType = defaultAssociatedResource.associationType;
        this.initiativeType = defaultAssociatedResource.initiativeType;
        this.name = defaultAssociatedResource.name;
        this.metadataReference = defaultAssociatedResource.metadataReference;
    }

    DefaultAssociatedResource(AggregateInformation aggregateInformation) {
        if (aggregateInformation != null) {
            this.associationType = aggregateInformation.getAssociationType();
            this.initiativeType = aggregateInformation.getInitiativeType();
            if (aggregateInformation instanceof DefaultAssociatedResource) {
                this.name = ((DefaultAssociatedResource)((Object)aggregateInformation)).getName();
                this.metadataReference = ((DefaultAssociatedResource)((Object)aggregateInformation)).getMetadataReference();
            }
        }
    }

    static DefaultAssociatedResource castOrCopy(AggregateInformation aggregateInformation) {
        if (aggregateInformation == null || aggregateInformation instanceof DefaultAssociatedResource) {
            return (DefaultAssociatedResource)((Object)aggregateInformation);
        }
        return new DefaultAssociatedResource(aggregateInformation);
    }

    @UML(identifier="name", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Citation getName() {
        return this.name;
    }

    public void setName(Citation citation) {
        this.checkWritePermission();
        this.name = citation;
    }

    @UML(identifier="associationType", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public AssociationType getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(AssociationType associationType) {
        this.checkWritePermission();
        this.associationType = associationType;
    }

    @UML(identifier="initiativeType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public InitiativeType getInitiativeType() {
        return this.initiativeType;
    }

    public void setInitiativeType(InitiativeType initiativeType) {
        this.checkWritePermission();
        this.initiativeType = initiativeType;
    }

    @UML(identifier="metadataReference", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Citation getMetadataReference() {
        return this.metadataReference;
    }

    public void setMetadataReference(Citation citation) {
        this.checkWritePermission();
        this.metadataReference = citation;
    }
}

