/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTailIterator<T extends Item>
implements SequenceIterator<T>,
GroundedIterator<T>,
LookaheadIterator<T> {
    private GroundedValue<T> baseValue;
    private int start;
    private int pos = 0;

    public ValueTailIterator(GroundedValue<T> base, int start) {
        this.baseValue = base;
        this.start = start;
        this.pos = 0;
    }

    @Override
    public T next() throws XPathException {
        return this.baseValue.itemAt(this.start + this.pos++);
    }

    @Override
    public T current() {
        return this.baseValue.itemAt(this.start + this.pos - 1);
    }

    @Override
    public int position() {
        return this.pos;
    }

    @Override
    public boolean hasNext() {
        return this.baseValue.itemAt(this.start + this.pos) != null;
    }

    @Override
    public void close() {
    }

    @Override
    public ValueTailIterator<T> getAnother() throws XPathException {
        return new ValueTailIterator<T>(this.baseValue, this.start);
    }

    @Override
    public GroundedValue<T> materialize() throws XPathException {
        if (this.start == 0) {
            return this.baseValue;
        }
        return this.baseValue.subsequence(this.start, Integer.MAX_VALUE);
    }

    @Override
    public int getProperties() {
        return 5;
    }
}

