/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TreeLocation;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPatternRoot;
import edu.stanford.nlp.util.Pair;

class MoveNode
extends TsurgeonPattern {
    TreeLocation l;

    public MoveNode(TsurgeonPattern child, TreeLocation l) {
        super("move", new TsurgeonPattern[]{child});
        this.l = l;
    }

    @Override
    protected void setRoot(TsurgeonPatternRoot root) {
        super.setRoot(root);
        this.l.setRoot(root);
    }

    @Override
    public Tree evaluate(Tree t, TregexMatcher m) {
        Tree nodeToMove = this.children[0].evaluate(t, m);
        Tree oldParent = nodeToMove.parent(t);
        oldParent.removeChild(Trees.objectEqualityIndexOf(oldParent, nodeToMove));
        Pair<Tree, Integer> position = this.l.evaluate(t, m);
        position.first().insertDtr(nodeToMove, position.second());
        return t;
    }

    @Override
    public String toString() {
        return this.label + "(" + this.children[0] + " " + this.l + ")";
    }
}

