/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.StringUtils;
import java.util.Comparator;
import java.util.TreeMap;

public class CyclicCoreLabel
extends CoreLabel {
    private static final long serialVersionUID = 1L;
    private static String printOptions = "value-index";
    private static final Comparator<Class<?>> asClassComparator = new Comparator<Class<?>>(){

        @Override
        public int compare(Class<?> o1, Class<?> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };

    public CyclicCoreLabel() {
    }

    public CyclicCoreLabel(Label label) {
        super(label);
    }

    public CyclicCoreLabel(CoreMap label) {
        super(label);
    }

    public CyclicCoreLabel(CoreLabel label) {
        super(label);
    }

    public CyclicCoreLabel(CyclicCoreLabel label) {
        this((CoreMap)label);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CoreLabel)) {
            return false;
        }
        CoreLabel other = (CoreLabel)obj;
        if (!((Object)this.keySet()).equals(other.keySet())) {
            return false;
        }
        for (Class<?> key : this.keySet()) {
            if (this.get(key) == other.get(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int keyscode = 0;
        int valuescode = 0;
        for (Class<?> key : this.keySet()) {
            keyscode += key.hashCode();
            valuescode += this.get(key) != null ? System.identityHashCode(this.get(key)) : 0;
        }
        return keyscode * 37 + valuescode;
    }

    @Override
    public String toString() {
        return this.toString(printOptions);
    }

    public String toString(String format) {
        StringBuilder buf = new StringBuilder();
        if (format.equals("value")) {
            buf.append(this.value());
        } else if (format.equals("{map}")) {
            TreeMap map2 = new TreeMap(asClassComparator);
            for (Class<?> key : this.keySet()) {
                map2.put(key, this.get(key));
            }
            buf.append(map2);
        } else if (format.equals("value{map}")) {
            buf.append(this.value());
            TreeMap map2 = new TreeMap(asClassComparator);
            for (Class<?> key : this.keySet()) {
                map2.put(key, this.get(key));
            }
            map2.remove(CoreAnnotations.ValueAnnotation.class);
            buf.append(map2);
        } else if (format.equals("value-index")) {
            buf.append(this.value());
            Integer index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
            if (index != null) {
                buf.append("-").append(index);
            }
            buf.append(this.toPrimes());
        } else if (format.equals("value-index{map}")) {
            buf.append(this.value());
            Integer index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
            if (index != null) {
                buf.append("-").append(index);
            }
            TreeMap map2 = new TreeMap();
            for (Class<?> key : this.keySet()) {
                String cls = key.getName();
                int idx = cls.indexOf(36);
                if (idx >= 0) {
                    cls = cls.substring(idx + 1);
                }
                map2.put(cls, this.get(key));
            }
            map2.remove("IndexAnnotation");
            map2.remove("ValueAnnotation");
            if (!map2.isEmpty()) {
                buf.append(map2);
            }
        } else if (format.equals("word")) {
            buf.append(this.word());
        } else if (format.equals("text-index")) {
            buf.append((String)this.get(CoreAnnotations.TextAnnotation.class));
            Integer index = (Integer)this.get(CoreAnnotations.IndexAnnotation.class);
            if (index != null) {
                buf.append("-").append(index);
            }
            buf.append(this.toPrimes());
        }
        return buf.toString();
    }

    public String toPrimes() {
        Integer copy = (Integer)this.get(CoreAnnotations.CopyAnnotation.class);
        if (copy == null || copy == 0) {
            return "";
        }
        return StringUtils.repeat('\'', (int)copy);
    }

    public static LabelFactory factory() {
        return new LabelFactory(){

            @Override
            public Label newLabel(String labelStr) {
                CyclicCoreLabel label = new CyclicCoreLabel();
                label.setValue(labelStr);
                return label;
            }

            @Override
            public Label newLabel(String labelStr, int options) {
                return this.newLabel(labelStr);
            }

            @Override
            public Label newLabel(Label oldLabel) {
                return new CyclicCoreLabel(oldLabel);
            }

            @Override
            public Label newLabelFromString(String encodedLabelStr) {
                throw new UnsupportedOperationException("This code branch left blank because we do not understand what this method should do.");
            }
        };
    }

    @Override
    public LabelFactory labelFactory() {
        return CyclicCoreLabel.factory();
    }
}

