/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xqj.pull;

import com.saxonica.xqj.pull.PullNamespaceReducer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pull.NamespaceContextImpl;
import net.sf.saxon.pull.PullProvider;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Whitespace;

public class PullToStax
implements XMLStreamReader {
    private PullNamespaceReducer provider;
    private boolean previousAtomic;
    private FastStringBuffer currentTextNode = new FastStringBuffer(64);
    private int currentStaxEvent = 7;
    private XPathException pendingException = null;

    public PullToStax(PullProvider provider) {
        this.provider = provider instanceof PullNamespaceReducer ? (PullNamespaceReducer)provider : new PullNamespaceReducer(provider);
    }

    public int getAttributeCount() {
        try {
            return this.provider.getAttributes().getLength();
        }
        catch (XPathException e) {
            this.pendingException = e;
            return 0;
        }
    }

    public boolean isAttributeSpecified(int i) {
        return true;
    }

    public QName getAttributeName(int i) {
        try {
            AttributeCollection atts = this.provider.getAttributes();
            return new QName(atts.getURI(i), atts.getLocalName(i), atts.getPrefix(i));
        }
        catch (XPathException e) {
            this.pendingException = e;
            return new QName("http://saxon.sf.net/error", "error", "");
        }
    }

    public String getAttributeLocalName(int i) {
        try {
            return this.provider.getAttributes().getLocalName(i);
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "error";
        }
    }

    public String getAttributeNamespace(int i) {
        try {
            return this.provider.getAttributes().getURI(i);
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "http://saxon.sf.net/error";
        }
    }

    public String getAttributePrefix(int i) {
        try {
            return this.provider.getAttributes().getPrefix(i);
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "";
        }
    }

    public String getAttributeType(int i) {
        try {
            AttributeCollection ac = this.provider.getAttributes();
            if (ac.isId(i)) {
                return "ID";
            }
            if (ac.isIdref(i)) {
                return "IDREFS";
            }
            return "CDATA";
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "CDATA";
        }
    }

    public String getAttributeValue(int i) {
        try {
            return this.provider.getAttributes().getValue(i);
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "error";
        }
    }

    public String getAttributeValue(String uri, String local) {
        try {
            return this.provider.getAttributes().getValue(uri, local);
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "";
        }
    }

    public int getEventType() {
        return this.currentStaxEvent;
    }

    public int getNamespaceCount() {
        try {
            NamespaceBinding[] bindings = this.provider.getNamespaceDeclarations();
            int count = bindings.length;
            for (int i = 0; i < count; ++i) {
                if (bindings[i] != null) continue;
                return i;
            }
            return count;
        }
        catch (XPathException e) {
            this.pendingException = e;
            return 0;
        }
    }

    public String getText() {
        if (this.previousAtomic) {
            return this.currentTextNode.toString();
        }
        try {
            return this.provider.getStringValue().toString();
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "";
        }
    }

    public int getTextLength() {
        if (this.previousAtomic) {
            return this.currentTextNode.length();
        }
        try {
            return this.provider.getStringValue().length();
        }
        catch (XPathException e) {
            this.pendingException = e;
            return 0;
        }
    }

    public int getTextStart() {
        return 0;
    }

    public char[] getTextCharacters() {
        if (this.previousAtomic) {
            return this.currentTextNode.toCharArray();
        }
        try {
            String stringValue = this.provider.getStringValue().toString();
            char[] chars = new char[stringValue.length()];
            stringValue.getChars(0, chars.length, chars, 0);
            return chars;
        }
        catch (XPathException e) {
            this.pendingException = e;
            return new char[0];
        }
    }

    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        if (this.previousAtomic) {
            int end = sourceStart + length;
            if (end > this.currentTextNode.length()) {
                end = this.currentTextNode.length();
            }
            this.currentTextNode.getChars(sourceStart, end, target, targetStart);
            return end - sourceStart;
        }
        try {
            String stringValue = this.provider.getStringValue().subSequence(sourceStart, sourceStart + length).toString();
            stringValue.getChars(0, length, target, targetStart);
            return length;
        }
        catch (XPathException e) {
            this.pendingException = e;
            return 0;
        }
    }

    public int next() throws XMLStreamException {
        int p;
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        try {
            p = this.provider.next();
        }
        catch (XPathException e) {
            throw new XMLStreamException(e);
        }
        switch (p) {
            case 0: {
                return this.next();
            }
            case 1: {
                this.currentTextNode.setLength(0);
                if (this.previousAtomic) {
                    this.currentTextNode.append(' ');
                }
                this.currentTextNode.append(this.provider.getAtomicValue().getStringValue());
                this.currentStaxEvent = 4;
                break;
            }
            case 2: {
                this.currentStaxEvent = 7;
                return this.next();
            }
            case 3: {
                this.currentStaxEvent = 8;
                break;
            }
            case 4: {
                this.currentStaxEvent = 1;
                break;
            }
            case 5: {
                this.currentStaxEvent = 2;
                break;
            }
            case 8: {
                this.currentStaxEvent = 4;
                break;
            }
            case 9: {
                this.currentStaxEvent = 5;
                break;
            }
            case 10: {
                this.currentStaxEvent = 3;
                break;
            }
            case -1: {
                this.currentStaxEvent = 8;
                break;
            }
            case 6: {
                throw new XMLStreamException("Free-standing attributes cannot be serialized");
            }
            case 7: {
                throw new XMLStreamException("Free-standing namespace nodes cannot be serialized");
            }
            default: {
                throw new IllegalStateException("Unknown Stax event " + p);
            }
        }
        this.previousAtomic = p == 1;
        return this.currentStaxEvent;
    }

    public int nextTag() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    public void close() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        this.provider.close();
    }

    public boolean hasName() {
        return this.currentStaxEvent == 1 || this.currentStaxEvent == 2;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        return this.currentStaxEvent != 8;
    }

    public boolean hasText() {
        return this.currentStaxEvent == 4 || this.currentStaxEvent == 5;
    }

    public boolean isCharacters() {
        return this.currentStaxEvent == 4;
    }

    public boolean isEndElement() {
        return this.currentStaxEvent == 2;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean isStartElement() {
        return this.currentStaxEvent == 1;
    }

    public boolean isWhiteSpace() {
        try {
            return this.currentStaxEvent == 4 && Whitespace.isWhite((CharSequence)this.provider.getStringValue());
        }
        catch (XPathException e) {
            this.pendingException = e;
            return false;
        }
    }

    public boolean standaloneSet() {
        return false;
    }

    public String getCharacterEncodingScheme() {
        return null;
    }

    public String getElementText() throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        if (this.getEventType() != 1) {
            throw new XMLStreamException("parser must be on START_ELEMENT to read next text", this.getLocation());
        }
        int eventType = this.next();
        StringBuffer content = new StringBuffer();
        while (eventType != 2) {
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                content.append(this.getText());
            } else if (eventType != 3 && eventType != 5) {
                if (eventType == 8) {
                    throw new XMLStreamException("unexpected end of document when reading element text content", this.getLocation());
                }
                if (eventType == 1) {
                    throw new XMLStreamException("element text content may not contain START_ELEMENT", this.getLocation());
                }
                throw new XMLStreamException("Unexpected event type " + eventType, this.getLocation());
            }
            eventType = this.next();
        }
        return content.toString();
    }

    public String getEncoding() {
        return null;
    }

    public String getLocalName() {
        return this.provider.getNodeName().getLocalPart();
    }

    public String getNamespaceURI() {
        return this.provider.getNodeName().getURI();
    }

    public String getPIData() {
        if (this.currentStaxEvent != 3) {
            throw new IllegalStateException("Not positioned at a processing instruction");
        }
        try {
            return this.provider.getStringValue().toString();
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "";
        }
    }

    public String getPITarget() {
        if (this.currentStaxEvent != 3) {
            throw new IllegalStateException("Not positioned at a processing instruction");
        }
        return this.provider.getNodeName().getLocalPart();
    }

    public String getPrefix() {
        return this.provider.getNodeName().getPrefix();
    }

    public String getVersion() {
        return "1.0";
    }

    public String getNamespacePrefix(int i) {
        try {
            return this.provider.getNamespaceDeclarations()[i].getPrefix();
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "";
        }
    }

    public String getNamespaceURI(int i) {
        try {
            return this.provider.getNamespaceDeclarations()[i].getURI();
        }
        catch (XPathException e) {
            this.pendingException = e;
            return "";
        }
    }

    public NamespaceContext getNamespaceContext() {
        return new NamespaceContextImpl((NamespaceResolver)this.provider);
    }

    public QName getName() {
        NodeName nn = this.provider.getNodeName();
        return new QName(nn.getURI(), nn.getLocalPart(), nn.getPrefix());
    }

    public Location getLocation() {
        net.sf.saxon.expr.parser.Location sourceLocator = this.provider.getSourceLocator();
        if (sourceLocator == null) {
            sourceLocator = ExplicitLocation.UNKNOWN_LOCATION;
        }
        return new SourceStreamLocation(sourceLocator);
    }

    public Object getProperty(String s) throws IllegalArgumentException {
        throw new IllegalArgumentException("Unknown property " + s);
    }

    public void require(int event, String uri, String local) throws XMLStreamException {
        if (this.pendingException != null) {
            throw new XMLStreamException(this.pendingException);
        }
        if (this.currentStaxEvent != event) {
            throw new XMLStreamException("Required event type is " + event + ", actual event is " + this.currentStaxEvent);
        }
        if (uri != null && !uri.equals(this.getNamespaceURI())) {
            throw new XMLStreamException("Required namespace is " + uri + ", actual is " + this.getNamespaceURI());
        }
        if (local != null && !local.equals(this.getLocalName())) {
            throw new XMLStreamException("Required local name is " + local + ", actual is " + this.getLocalName());
        }
    }

    public String getNamespaceURI(String s) {
        return this.provider.getURIForPrefix(s, true);
    }

    public static class SourceStreamLocation
    implements Location {
        private net.sf.saxon.expr.parser.Location locator;

        public SourceStreamLocation(net.sf.saxon.expr.parser.Location locator) {
            this.locator = locator;
        }

        public int getCharacterOffset() {
            return -1;
        }

        public int getColumnNumber() {
            return this.locator.getColumnNumber();
        }

        public int getLineNumber() {
            return this.locator.getLineNumber();
        }

        public String getPublicId() {
            return this.locator.getPublicId();
        }

        public String getSystemId() {
            return this.locator.getSystemId();
        }
    }
}

