%option never-interactive

%s NAMED
%s VALED

N	[a-zA-Z$]+[a-zA-Z0-9$_.\-]*[a-zA-Z0-9$_.]*
XV	[^\001]+
KV	[^\001=]+
SP	[\001]

%{
/*                                                                
**  Copyright (C) 2007  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 2 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "pfile.h"
#include "pargs.h"
#include "iarg_yac.h"

#define YY_SKIP_YYWRAP
#define YY_NEVER_INTERACTIVE 1

extern int t_valu;

#define StrCpy(res, str, len)	( strncpy((res=malloc(len + 1)), str, len),\
					res[len] = '\0', res)

#undef  YY_INPUT
#define YY_INPUT(buf,result,max_size)	{				\
		if ( *buf = ArgvChar(((ArgStream) iarg_in)) )		\
			result = 1;					\
		else							\
			result = YY_NULL;				\
	}

/* default iargwrap function - always treat EOF as an EOF */
int
iarg_wrap(void) {
	return 1;
}
%}

%%

{N}/[+-]{SP} 	{ /* Match a shortcut boolean assignment
		  ** The [+-] must be contigious to the name.
		  **/
			StrCpy(iarg_lval.stri, iarg_text, iarg_leng);
			BEGIN(NAMED);
			return T_name;
		}
{N}/{SP}*[=]	{ /* Normal <name> = <value>
		  **/
			StrCpy(iarg_lval.stri, iarg_text, iarg_leng);
			BEGIN(NAMED);
			return T_name;
		}
--{N}/[+-]{SP} 	{ /* Match a shortcut boolean assignment
		  ** The [+-] must be contigious to the name.
                  ** Same as above but allow --name=<value>
                  ** for GNU-like syntax
		  **/
			StrCpy(iarg_lval.stri, iarg_text+2, iarg_leng-2);
			BEGIN(NAMED);
			return T_name;
		}
--{N}/{SP}*[=]	{ /* Normal <name> = <value>
                  ** Same as above but allow --name=<value>
                  ** for GNU-like syntax
		  **/
			StrCpy(iarg_lval.stri, iarg_text+2, iarg_leng-2);
			BEGIN(NAMED);
			return T_name;
		}
\=		{ /* Snag the assignment.
		  ** Note that positional parameters are done.
		  **/
			t_valu = T_valu;
			BEGIN(VALED);
			return '=';
		}
<NAMED>\+	{
			StrCpy(iarg_lval.stri, "yes", 3);
			BEGIN(0);
			return T_mark;	}
<NAMED>\-	{
			StrCpy(iarg_lval.stri, "no",  2);
			BEGIN(0);
			return T_mark;	}
{KV}(\[{XV}\])*	{ /* A normal value (= not allowed, except in [])
		  **/
                        if ( iarg_leng == 2 && !strncmp(iarg_text, "\"\"", 2) )
                          StrCpy(iarg_lval.stri, "", 0);
                        else
                          StrCpy(iarg_lval.stri, iarg_text, iarg_leng);

			BEGIN(0);
			return t_valu;
		}

<VALED>{XV}	{
			StrCpy(iarg_lval.stri, iarg_text, iarg_leng);
			BEGIN(0);
			return T_valu;
		}

{SP}*		{
			BEGIN(0);
		}
