# Generated by default/object.tt
package Paws::SecretsManager::ReplicaRegionType;
  use Moose;
  has KmsKeyId => (is => 'ro', isa => 'Str');
  has Region => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecretsManager::ReplicaRegionType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecretsManager::ReplicaRegionType object:

  $service_obj->Method(Att1 => { KmsKeyId => $value, ..., Region => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecretsManager::ReplicaRegionType object:

  $result = $service_obj->Method(...);
  $result->Att1->KmsKeyId

=head1 DESCRIPTION

(Optional) Custom type consisting of a C<Region> (required) and the
C<KmsKeyId> which can be an C<ARN>, C<Key ID>, or C<Alias>.

=head1 ATTRIBUTES


=head2 KmsKeyId => Str

Can be an C<ARN>, C<Key ID>, or C<Alias>.


=head2 Region => Str

Describes a single instance of Region objects.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecretsManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

