package Alien::TRNG;

# ABSTRACT: Build and Install the TRNG library

use v5.12;
use strict;
use warnings;

#<<<
our $VERSION = 'v4.27.0.1'; # TRIAL

BEGIN {
    ## no critic( Variables::ProhibitReusedNames )
    our $VERSION = 'v4.27.0.1'; # TRIAL VERSION is automatically inserted at dist create time; need it at compile time
}
#>>>

use base qw( Alien::Base );

use constant TRNG_VERSION => do {
    my @V = $VERSION =~ /(\d+)(?:[.]|$)/g;
    pop @V;
    $V[0] + ( ( $V[1] // 0 ) + ( $V[2] // 0 ) / 100 ) / 100;
};

1;

#
# This file is part of Alien-TRNG
#
# This software is Copyright (c) 2024 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

__END__

=pod

=for :stopwords Diab Jerius Smithsonian Astrophysical Observatory metacpan

=head1 NAME

Alien::TRNG - Build and Install the TRNG library

=head1 VERSION

version v4.27.0.1

=head1 SYNOPSIS

  use Alien::TRNG;

=head1 DESCRIPTION

This module finds or builds the I<TRNG> (Tina's Random Number Generator) library.

The TRNG library is distributed under the terms of a BSD style license
(3-clause license).

=head1 USAGE

Please see L<Alien::Build::Manual::AlienUser> (or equivalently on L<metacpan|https://metacpan.org/pod/distribution/Alien-Build/lib/Alien/Build/Manual/AlienUser.pod>).

=head1 SUPPORT

=head2 Bugs

Please report any bugs or feature requests to bug-alien-trng@rt.cpan.org  or through the web interface at: L<https://rt.cpan.org/Public/Dist/Display.html?Name=Alien-TRNG>

=head2 Source

Source is available at

  https://gitlab.com/djerius/alien-trng

and may be cloned from

  https://gitlab.com/djerius/alien-trng.git

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<https://www.numbercrunch.de/trng/|https://www.numbercrunch.de/trng/>

=item *

L<Alien::Build|Alien::Build>

=back

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
