/*                                                                
**  Copyright (C) 1996,2007,2010,2019  Smithsonian Astrophysical Observatory 
*/                                                                

/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 3 of the License, or       */
/*  (at your option) any later version.                                     */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License along */
/*  with this program; if not, write to the Free Software Foundation, Inc., */
/*  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.             */
/*                                                                          */

/* mode.c
**
	The mode parameter class.
**/


#include <string.h>
#include "pfile.h"
#include "mode.h"


static Converter Converters[] = {
  {StringType, ModeType, (ConverterType) String2Mode},
  {0, 0, NULL}
};


vtype modeRec = {
  "mode",
  Converters,

  VXSize,
  VXAcce,
  NULL
};

void *
String2Mode (char *value, int *copy)
{
  if (value == NULL)
    return NULL;
  if (copy == NULL)
    return NULL;

  *copy = 0;

  /* first check for words query/learn/auto/hidden */
  if (strstr (value, "query") != 0)
    *copy |= QMODE;
  if (strstr (value, "learn") != 0)
    *copy |= LMODE;
  if (strstr (value, "hidden") != 0)
    *copy |= HMODE;
  if (strstr (value, "auto") != 0)
    *copy |= AMODE;

  /* if mode not determined, check qlha letters */
  if (*copy == 0)
    {
      while (*value)
	{
	  switch (*value++)
	    {
	    case 'q':
	      *copy |= QMODE;
	      break;
	    case 'l':
	      *copy |= LMODE;
	      break;
	    case 'h':
	      *copy |= HMODE;
	      break;
	    case 'a':
	      *copy |= AMODE;
	      break;
 	    case 'H':
 	      *copy |= HHMODE;
 	      break;
 	    case 'L':
 	      *copy |= LLMODE;
	    }
	}
    }

  if (*copy)
    return copy;
  else
    {
      parerr = PARCANTCONVERT;
      return NULL;
    }
}
