# Generated by default/object.tt
package Paws::CloudFront::ActiveTrustedKeyGroups;
  use Moose;
  has Enabled => (is => 'ro', isa => 'Bool', required => 1);
  has Items => (is => 'ro', isa => 'ArrayRef[Paws::CloudFront::KGKeyPairIds]', request_name => 'KeyGroup', traits => ['NameInRequest']);
  has Quantity => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::ActiveTrustedKeyGroups

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::ActiveTrustedKeyGroups object:

  $service_obj->Method(Att1 => { Enabled => $value, ..., Quantity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::ActiveTrustedKeyGroups object:

  $result = $service_obj->Method(...);
  $result->Att1->Enabled

=head1 DESCRIPTION

A list of key groups, and the public keys in each key group, that
CloudFront can use to verify the signatures of signed URLs and signed
cookies.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Enabled => Bool

This field is C<true> if any of the key groups have public keys that
CloudFront can use to verify the signatures of signed URLs and signed
cookies. If not, this field is C<false>.


=head2 Items => ArrayRef[L<Paws::CloudFront::KGKeyPairIds>]

A list of key groups, including the identifiers of the public keys in
each key group that CloudFront can use to verify the signatures of
signed URLs and signed cookies.


=head2 B<REQUIRED> Quantity => Int

The number of key groups in the list.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

