package Google::Ads::AdWords::v201806::DisplayCallToAction;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201806' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %text_of :ATTR(:get<text>);
my %textColor_of :ATTR(:get<textColor>);
my %urlId_of :ATTR(:get<urlId>);

__PACKAGE__->_factory(
    [ qw(        text
        textColor
        urlId

    ) ],
    {
        'text' => \%text_of,
        'textColor' => \%textColor_of,
        'urlId' => \%urlId_of,
    },
    {
        'text' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'textColor' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'urlId' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'text' => 'text',
        'textColor' => 'textColor',
        'urlId' => 'urlId',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201806::DisplayCallToAction

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DisplayCallToAction from the namespace https://adwords.google.com/api/adwords/cm/v201806.

Represents display-call-to-action specific data. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * text


=item * textColor


=item * urlId




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

