package Google::Ads::AdWords::v201802::StoreSalesTransaction;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201802' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %userIdentifiers_of :ATTR(:get<userIdentifiers>);
my %transactionTime_of :ATTR(:get<transactionTime>);
my %transactionAmount_of :ATTR(:get<transactionAmount>);
my %conversionName_of :ATTR(:get<conversionName>);

__PACKAGE__->_factory(
    [ qw(        userIdentifiers
        transactionTime
        transactionAmount
        conversionName

    ) ],
    {
        'userIdentifiers' => \%userIdentifiers_of,
        'transactionTime' => \%transactionTime_of,
        'transactionAmount' => \%transactionAmount_of,
        'conversionName' => \%conversionName_of,
    },
    {
        'userIdentifiers' => 'Google::Ads::AdWords::v201802::UserIdentifier',
        'transactionTime' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'transactionAmount' => 'Google::Ads::AdWords::v201802::MoneyWithCurrency',
        'conversionName' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    },
    {

        'userIdentifiers' => 'userIdentifiers',
        'transactionTime' => 'transactionTime',
        'transactionAmount' => 'transactionAmount',
        'conversionName' => 'conversionName',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201802::StoreSalesTransaction

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
StoreSalesTransaction from the namespace https://adwords.google.com/api/adwords/rm/v201802.

Contains store sales transaction information. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * userIdentifiers


=item * transactionTime


=item * transactionAmount


=item * conversionName




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

