# Copyright 2020, Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package Google::Ads::GoogleAds::V17::Enums::RecommendationTypeEnum;

use strict;
use warnings;

use Const::Exporter enums => [
  UNSPECIFIED                  => "UNSPECIFIED",
  UNKNOWN                      => "UNKNOWN",
  CAMPAIGN_BUDGET              => "CAMPAIGN_BUDGET",
  KEYWORD                      => "KEYWORD",
  TEXT_AD                      => "TEXT_AD",
  TARGET_CPA_OPT_IN            => "TARGET_CPA_OPT_IN",
  MAXIMIZE_CONVERSIONS_OPT_IN  => "MAXIMIZE_CONVERSIONS_OPT_IN",
  ENHANCED_CPC_OPT_IN          => "ENHANCED_CPC_OPT_IN",
  SEARCH_PARTNERS_OPT_IN       => "SEARCH_PARTNERS_OPT_IN",
  MAXIMIZE_CLICKS_OPT_IN       => "MAXIMIZE_CLICKS_OPT_IN",
  OPTIMIZE_AD_ROTATION         => "OPTIMIZE_AD_ROTATION",
  KEYWORD_MATCH_TYPE           => "KEYWORD_MATCH_TYPE",
  MOVE_UNUSED_BUDGET           => "MOVE_UNUSED_BUDGET",
  FORECASTING_CAMPAIGN_BUDGET  => "FORECASTING_CAMPAIGN_BUDGET",
  TARGET_ROAS_OPT_IN           => "TARGET_ROAS_OPT_IN",
  RESPONSIVE_SEARCH_AD         => "RESPONSIVE_SEARCH_AD",
  MARGINAL_ROI_CAMPAIGN_BUDGET => "MARGINAL_ROI_CAMPAIGN_BUDGET",
  USE_BROAD_MATCH_KEYWORD      => "USE_BROAD_MATCH_KEYWORD",
  RESPONSIVE_SEARCH_AD_ASSET   => "RESPONSIVE_SEARCH_AD_ASSET",
  UPGRADE_SMART_SHOPPING_CAMPAIGN_TO_PERFORMANCE_MAX =>
    "UPGRADE_SMART_SHOPPING_CAMPAIGN_TO_PERFORMANCE_MAX",
  RESPONSIVE_SEARCH_AD_IMPROVE_AD_STRENGTH =>
    "RESPONSIVE_SEARCH_AD_IMPROVE_AD_STRENGTH",
  DISPLAY_EXPANSION_OPT_IN                  => "DISPLAY_EXPANSION_OPT_IN",
  UPGRADE_LOCAL_CAMPAIGN_TO_PERFORMANCE_MAX =>
    "UPGRADE_LOCAL_CAMPAIGN_TO_PERFORMANCE_MAX",
  RAISE_TARGET_CPA_BID_TOO_LOW      => "RAISE_TARGET_CPA_BID_TOO_LOW",
  FORECASTING_SET_TARGET_ROAS       => "FORECASTING_SET_TARGET_ROAS",
  CALLOUT_ASSET                     => "CALLOUT_ASSET",
  SITELINK_ASSET                    => "SITELINK_ASSET",
  CALL_ASSET                        => "CALL_ASSET",
  SHOPPING_ADD_AGE_GROUP            => "SHOPPING_ADD_AGE_GROUP",
  SHOPPING_ADD_COLOR                => "SHOPPING_ADD_COLOR",
  SHOPPING_ADD_GENDER               => "SHOPPING_ADD_GENDER",
  SHOPPING_ADD_GTIN                 => "SHOPPING_ADD_GTIN",
  SHOPPING_ADD_MORE_IDENTIFIERS     => "SHOPPING_ADD_MORE_IDENTIFIERS",
  SHOPPING_ADD_SIZE                 => "SHOPPING_ADD_SIZE",
  SHOPPING_ADD_PRODUCTS_TO_CAMPAIGN => "SHOPPING_ADD_PRODUCTS_TO_CAMPAIGN",
  SHOPPING_FIX_DISAPPROVED_PRODUCTS => "SHOPPING_FIX_DISAPPROVED_PRODUCTS",
  SHOPPING_TARGET_ALL_OFFERS        => "SHOPPING_TARGET_ALL_OFFERS",
  SHOPPING_FIX_SUSPENDED_MERCHANT_CENTER_ACCOUNT =>
    "SHOPPING_FIX_SUSPENDED_MERCHANT_CENTER_ACCOUNT",
  SHOPPING_FIX_MERCHANT_CENTER_ACCOUNT_SUSPENSION_WARNING =>
    "SHOPPING_FIX_MERCHANT_CENTER_ACCOUNT_SUSPENSION_WARNING",
  SHOPPING_MIGRATE_REGULAR_SHOPPING_CAMPAIGN_OFFERS_TO_PERFORMANCE_MAX =>
    "SHOPPING_MIGRATE_REGULAR_SHOPPING_CAMPAIGN_OFFERS_TO_PERFORMANCE_MAX",
  DYNAMIC_IMAGE_EXTENSION_OPT_IN      => "DYNAMIC_IMAGE_EXTENSION_OPT_IN",
  RAISE_TARGET_CPA                    => "RAISE_TARGET_CPA",
  LOWER_TARGET_ROAS                   => "LOWER_TARGET_ROAS",
  PERFORMANCE_MAX_OPT_IN              => "PERFORMANCE_MAX_OPT_IN",
  IMPROVE_PERFORMANCE_MAX_AD_STRENGTH => "IMPROVE_PERFORMANCE_MAX_AD_STRENGTH",
  MIGRATE_DYNAMIC_SEARCH_ADS_CAMPAIGN_TO_PERFORMANCE_MAX =>
    "MIGRATE_DYNAMIC_SEARCH_ADS_CAMPAIGN_TO_PERFORMANCE_MAX",
  FORECASTING_SET_TARGET_CPA       => "FORECASTING_SET_TARGET_CPA",
  SET_TARGET_CPA                   => "SET_TARGET_CPA",
  SET_TARGET_ROAS                  => "SET_TARGET_ROAS",
  MAXIMIZE_CONVERSION_VALUE_OPT_IN => "MAXIMIZE_CONVERSION_VALUE_OPT_IN",
  IMPROVE_GOOGLE_TAG_COVERAGE      => "IMPROVE_GOOGLE_TAG_COVERAGE",
  PERFORMANCE_MAX_FINAL_URL_OPT_IN => "PERFORMANCE_MAX_FINAL_URL_OPT_IN",
  REFRESH_CUSTOMER_MATCH_LIST      => "REFRESH_CUSTOMER_MATCH_LIST",
  CUSTOM_AUDIENCE_OPT_IN           => "CUSTOM_AUDIENCE_OPT_IN",
  LEAD_FORM_ASSET                  => "LEAD_FORM_ASSET",
  IMPROVE_DEMAND_GEN_AD_STRENGTH   => "IMPROVE_DEMAND_GEN_AD_STRENGTH"
];

1;
