package
    Pinto::Remote::SelfContained::HasHttptiny; # hide from PAUSE
# ABSTRACT: role providing an HTTP::Tiny instance

use v5.10;
use Moo::Role;

use HTTP::Tiny;
use Types::Standard qw(InstanceOf);

use namespace::clean;

our $VERSION = '1.999'; # TRIAL VERSION

has httptiny => (
    is => 'lazy',
    isa => InstanceOf['HTTP::Tiny'],
    default => sub { HTTP::Tiny->new(verify_SSL => 1) },
);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Pinto::Remote::SelfContained::HasHttptiny - role providing an HTTP::Tiny instance

=head1 VERSION

version 1.999

=head1 AUTHOR

Brad Lhotsky <brad@divisionbyzero.net>

=head1 CONTRIBUTOR

=for stopwords Aaron Crane

Aaron Crane <arc@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by Aaron Crane.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
