#!/usr/bin/perl

package eBay::API::XML::Call::GetCharities::GetCharitiesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetCharitiesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetCharities::GetCharitiesRequestType

=head1 DESCRIPTION

Searches for nonprofit charity organizations that meet the criteria specified in the request.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetCharities::GetCharitiesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::Enum::StringMatchCodeType;


my @gaProperties = ( [ 'CharityDomain', 'xs:int', '', '', '' ]
	, [ 'CharityID', 'xs:string', '', '', '' ]
	, [ 'CharityName', 'xs:string', '', '', '' ]
	, [ 'CharityRegion', 'xs:int', '', '', '' ]
	, [ 'Featured', 'xs:boolean', '', '', '' ]
	, [ 'IncludeDescription', 'xs:boolean', '', '', '' ]
	, [ 'MatchType', 'ns:StringMatchCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StringMatchCodeType', '' ]
	, [ 'Query', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCharityDomain()

Domain (mission area) that a nonprofit charity organization
belongs to. Nonprofit charity organizations may belong to multiple
mission areas. Meaning of input values differs depending on the
site. See GetCharities in the API Developer's Guide for the meaning
of each input/output value. CharityDomain input value must be valid for
that SiteID.

  RequiredInput: No
#    Argument: 'xs:int'

=cut

sub setCharityDomain {
  my $self = shift;
  $self->{'CharityDomain'} = shift
}

=head2 getCharityDomain()

#    Returns: 'xs:int'

=cut

sub getCharityDomain {
  my $self = shift;
  return $self->{'CharityDomain'};
}


=head2 setCharityID()

A unique identification number assigned by eBay to registered nonprofit
charity organizations.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setCharityID {
  my $self = shift;
  $self->{'CharityID'} = shift
}

=head2 getCharityID()

#    Returns: 'xs:string'

=cut

sub getCharityID {
  my $self = shift;
  return $self->{'CharityID'};
}


=head2 setCharityName()

A name assigned to a specified nonprofit
organization. Accepts full charity nonprofit name
or partial name as input. For example, enter a
CharityName of "heart" (case-insensitive) to
return all charity nonprofits that start with
"heart." Use with a MatchType value of "Contains"
to return all charity nonprofits that contain the
string "heart."

MaxLength: 150

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setCharityName {
  my $self = shift;
  $self->{'CharityName'} = shift
}

=head2 getCharityName()

#    Returns: 'xs:string'

=cut

sub getCharityName {
  my $self = shift;
  return $self->{'CharityName'};
}


=head2 setCharityRegion()

Region that the nonprofit charity organization is associated
with. A specific nonprofit charity organization may be associated
with only one region. Meaning of input values differs depending on
the site. See GetCharities in the API Developer's Guide for the meaning
of each input/output value. CharityRegion input value must be
valid for that SiteID.

  RequiredInput: No
#    Argument: 'xs:int'

=cut

sub setCharityRegion {
  my $self = shift;
  $self->{'CharityRegion'} = shift
}

=head2 getCharityRegion()

#    Returns: 'xs:int'

=cut

sub getCharityRegion {
  my $self = shift;
  return $self->{'CharityRegion'};
}


=head2 setFeatured()

Used to decide if the search is only for featured charities.
A value of true will search for only featured charities.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setFeatured {
  my $self = shift;
  $self->{'Featured'} = shift
}

=head2 isFeatured()

#    Returns: 'xs:boolean'

=cut

sub isFeatured {
  my $self = shift;
  return $self->{'Featured'};
}


=head2 setIncludeDescription()

Used with Query to search for charity nonprofit
organizations. A value of true will search the Mission field as
well as the CharityName field for a string specified in Query.

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setIncludeDescription {
  my $self = shift;
  $self->{'IncludeDescription'} = shift
}

=head2 isIncludeDescription()

#    Returns: 'xs:boolean'

=cut

sub isIncludeDescription {
  my $self = shift;
  return $self->{'IncludeDescription'};
}


=head2 setMatchType()

Indicates the type of string matching to use when a value is submitted in
CharityName. If no value is specified, default behavior is "StartsWith."
Does not apply to Query.

  RequiredInput: No
#    Argument: 'ns:StringMatchCodeType'

=cut

sub setMatchType {
  my $self = shift;
  $self->{'MatchType'} = shift
}

=head2 getMatchType()

#    Returns: 'ns:StringMatchCodeType'

=cut

sub getMatchType {
  my $self = shift;
  return $self->{'MatchType'};
}


=head2 setQuery()

Accepts a case-insensitive string used to
find a nonprofit charity organization. Default
behavior is to search the CharityName field. Use
with an IncludeDescription value of true to
include the Mission field in the search.

MaxLength: 350 (characters)

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setQuery {
  my $self = shift;
  $self->{'Query'} = shift
}

=head2 getQuery()

#    Returns: 'xs:string'

=cut

sub getQuery {
  my $self = shift;
  return $self->{'Query'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
