# -*- rpm-spec -*-
# Copyright (C) 2006 Daniel Berrange <dan@berrange.com>
#

use strict;

die unless (scalar @ARGV == 1);

open PM, './lib/Sys/Virt.pm' or die "lib/Sys/Virt.pm: $!";
my $ver;
while (<PM>) {
    if (/our \$VERSION = '(.*)'/) {
        $ver = $1;
	last;
    }
}
die "cannot find version" unless $ver;

local $/ = undef;
$_ = <DATA>;
s/\@VERSION\@/$ver/g;

open SPEC, ">$ARGV[0]" or die "$!";
print SPEC $_;
close SPEC;
__DATA__
# Automatically generated by perl-Sys-Virt.spec.PL

Name:           perl-Sys-Virt
Version:        @VERSION@
Release:        1%{?dist}
Summary:        Represent and manage a libvirt hypervisor connection
License:        GPLv2+ or Artistic
Group:          Development/Libraries
URL:            http://search.cpan.org/dist/Sys-Virt/
Source0:        http://www.cpan.org/authors/id/D/DA/DANBERR/Sys-Virt-v%{version}.tar.gz
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires:  perl(ExtUtils::CBuilder)
BuildRequires:  perl(Module::Build)
BuildRequires:  perl(Test::Pod)
BuildRequires:  perl(Test::Pod::Coverage)
BuildRequires:  perl(Test::CPAN::Changes)
BuildRequires:  perl(XML::XPath)
BuildRequires:  perl(Time::HiRes)
BuildRequires:  libvirt-devel >= %{version}
Requires:       perl(:MODULE_COMPAT_%(eval "`%{__perl} -V:version`"; echo $version))

%description
The Sys::Virt module provides a Perl XS binding to the libvirt virtual
machine management APIs. This allows machines running within arbitrary
virtualization containers to be managed with a consistent API.

%prep
%setup -q -n Sys-Virt-v%{version}


%build
%{__perl} Build.PL installdirs=vendor
./Build

%install
./Build install destdir=$RPM_BUILD_ROOT create_packlist=0

#find $RPM_BUILD_ROOT -type f \( -name .packlist -o -name '*.bs' -empty \) |
#	xargs rm -f
#find $RPM_BUILD_ROOT -depth -type d -empty -exec rmdir {} \;

%{_fixperms} $RPM_BUILD_ROOT/*

%check
./Build test

%files
%defattr(-,root,root,-)
%doc AUTHORS Changes LICENSE README examples/
%{perl_vendorarch}/auto/*
%{perl_vendorarch}/Sys*
%{_mandir}/man3/*

%changelog
