/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.openqa.selenium.server.SeleniumCommandTimedOutException;

public class SingleEntryAsyncQueue {
    private static int idGenerator = 1;
    private Object thing = null;
    private boolean done = false;
    private static int defaultTimeout = 1800;
    private int timeout;
    private int id = idGenerator++;
    private boolean hasBlockedGetter = false;
    private String loggingPreamble;
    private String label;
    private int countOfCallsToGet = 0;
    private int clearCallsToGetPrecedingThisThreshold = 0;
    private int waitingThreadCount = 0;
    private final Lock dataLock;
    private final Condition condition;

    public SingleEntryAsyncQueue(String label, Lock dataLock, Condition condition) {
        this.label = label;
        this.dataLock = dataLock;
        this.condition = condition;
        this.timeout = defaultTimeout;
        this.loggingPreamble = this.label + this.id + ": ";
    }

    public void clear() {
        this.clearCallsToGetPrecedingThisThreshold = this.countOfCallsToGet;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() {
        int thisCall = this.countOfCallsToGet++;
        if (this.done) {
            return null;
        }
        int retries = 0;
        this.hasBlockedGetter = true;
        Object t = null;
        ++this.waitingThreadCount;
        try {
            while (this.thing == null) {
                if (this.thing == null & retries >= this.timeout) {
                    throw new SeleniumCommandTimedOutException();
                }
                try {
                    this.condition.await(1000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    continue;
                }
                if (this.done || thisCall < this.clearCallsToGetPrecedingThisThreshold) {
                    Object var4_5 = null;
                    return var4_5;
                }
                ++retries;
            }
            t = this.thing;
        }
        finally {
            this.hasBlockedGetter = false;
            --this.waitingThreadCount;
        }
        if (this.waitingThreadCount == 0) {
            this.thing = null;
        }
        return t;
    }

    public Object peek() {
        if (this.done) {
            throw new RuntimeException("peek(" + this + ") on a retired queue");
        }
        if (this.isEmpty()) {
            throw new RuntimeException("peek() called on an empty queue");
        }
        return this.thing;
    }

    public boolean isEmpty() {
        return this.thing == null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.loggingPreamble);
        sb.append(this.thing == null ? "null" : this.thing.toString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object newObj) {
        if (this.done) {
            throw new RuntimeException("put(" + newObj + ") on a retired queue");
        }
        if (newObj == null) {
            this.thing = null;
        } else {
            this.dataLock.lock();
            try {
                this.thing = newObj;
                this.condition.signalAll();
            }
            finally {
                this.dataLock.unlock();
            }
        }
    }

    public static void setDefaultTimeout(int defaultTimeout) {
        SingleEntryAsyncQueue.defaultTimeout = defaultTimeout;
    }

    public boolean hasBlockedGetter() {
        return this.hasBlockedGetter;
    }
}

