use strict;
use warnings;
package Software::License::Mozilla_1_0 0.104006;

use parent 'Software::License';
# ABSTRACT: Mozilla Public License 1.0

sub name { 'The Mozilla Public License 1.0' }
sub url  { 'http://www.mozilla.org/MPL/MPL-1.0.txt' }
sub meta_name  { 'mozilla' }
sub meta2_name { 'mozilla_1_0' }
sub spdx_expression  { 'MPL-1.0' }

1;

=pod

=encoding UTF-8

=head1 NAME

Software::License::Mozilla_1_0 - Mozilla Public License 1.0

=head1 VERSION

version 0.104006

=head1 PERL VERSION

This module is part of CPAN toolchain, or is treated as such.  As such, it
follows the agreement of the Perl Toolchain Gang to require no newer version
of perl than one released in the last ten years.  This version may change by
agreement of the Toolchain Gang, but for now is governed by the L<Lancaster
Consensus|https://github.com/Perl-Toolchain-Gang/toolchain-site/blob/master/lancaster-consensus.md>
of 2013 and the Lyon Amendment of 2023 (described at the linked-to document).

Although it may work on older versions of perl, no guarantee is made that the
minimum required version will not be increased.  The version may be increased
for any reason, and there is no promise that patches will be accepted to
lower the minimum required perl.

=head1 AUTHOR

Ricardo Signes <cpan@semiotic.systems>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by Ricardo Signes.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
__LICENSE__
Mozilla Public License (Version 1.0)

1. Definitions. 

     1.1. "Contributor" means each entity that creates or
     contributes to the creation of Modifications. 

     1.2. "Contributor Version" means the combination of
     the Original Code, prior Modifications used by a
     Contributor, and the Modifications made by that
     particular Contributor. 

     1.3. "Covered Code" means the Original Code or
     Modifications or the combination of the Original Code
     and Modifications, in each case including portions
     thereof. 

     1.4. "Electronic Distribution Mechanism" means a
     mechanism generally accepted in the software
     development community for the electronic transfer of
     data. 

     1.5. "Executable" means Covered Code in any form
     other than Source Code. 

     1.6. "Initial Developer" means the individual or entity
     identified as the Initial Developer in the Source Code
     notice required by Exhibit A. 

     1.7. "Larger Work" means a work which combines
     Covered Code or portions thereof with code not
     governed by the terms of this License. 

     1.8. "License" means this document. 

     1.9. "Modifications" means any addition to or deletion
     from the substance or structure of either the Original
     Code or any previous Modifications. When Covered
     Code is released as a series of files, a Modification is: 

          A. Any addition to or deletion from the contents
          of a file containing Original Code or previous
          Modifications. 

          B. Any new file that contains any part of the
          Original Code or previous Modifications. 

     1.10. "Original Code" means Source Code of
     computer software code which is described in the
     Source Code notice required by Exhibit A as Original
     Code, and which, at the time of its release under this
     License is not already Covered Code governed by this
     License. 

     1.11. "Source Code" means the preferred form of the
     Covered Code for making modifications to it, including
     all modules it contains, plus any associated interface
     definition files, scripts used to control compilation and
     installation of an Executable, or a list of source code
     differential comparisons against either the Original
     Code or another well known, available Covered Code of
     the Contributor's choice. The Source Code can be in a
     compressed or archival form, provided the appropriate
     decompression or de-archiving software is widely
     available for no charge. 

     1.12. "You" means an individual or a legal entity
     exercising rights under, and complying with all of the
     terms of, this License or a future version of this License
     issued under Section 6.1. For legal entities, "You"
     includes any entity which controls, is controlled by, or
     is under common control with You. For purposes of this
     definition, "control" means (a) the power, direct or
     indirect, to cause the direction or management of such
     entity, whether by contract or otherwise, or (b)
     ownership of fifty percent (50%) or more of the
     outstanding shares or beneficial ownership of such
     entity. 

2. Source Code License. 

     2.1. The Initial Developer Grant. 
     The Initial Developer hereby grants You a world-wide,
     royalty-free, non-exclusive license, subject to third
     party intellectual property claims: 

          (a) to use, reproduce, modify, display, perform,
          sublicense and distribute the Original Code (or
          portions thereof) with or without Modifications, or
          as part of a Larger Work; and 

          (b) under patents now or hereafter owned or
          controlled by Initial Developer, to make, have
          made, use and sell ("Utilize") the Original Code
          (or portions thereof), but solely to the extent that
          any such patent is reasonably necessary to
          enable You to Utilize the Original Code (or
          portions thereof) and not to any greater extent
          that may be necessary to Utilize further
          Modifications or combinations. 

     2.2. Contributor Grant. 
     Each Contributor hereby grants You a world-wide,
     royalty-free, non-exclusive license, subject to third
     party intellectual property claims: 

          (a) to use, reproduce, modify, display, perform,
          sublicense and distribute the Modifications
          created by such Contributor (or portions thereof)
          either on an unmodified basis, with other
          Modifications, as Covered Code or as part of a
          Larger Work; and 

          (b) under patents now or hereafter owned or
          controlled by Contributor, to Utilize the
          Contributor Version (or portions thereof), but
          solely to the extent that any such patent is
          reasonably necessary to enable You to Utilize
          the Contributor Version (or portions thereof), and
          not to any greater extent that may be necessary
          to Utilize further Modifications or combinations. 

3. Distribution Obligations. 

     3.1. Application of License. 
     The Modifications which You create or to which You
     contribute are governed by the terms of this License,
     including without limitation Section 2.2. The Source
     Code version of Covered Code may be distributed only
     under the terms of this License or a future version of
     this License released under Section 6.1, and You must
     include a copy of this License with every copy of the
     Source Code You distribute. You may not offer or
     impose any terms on any Source Code version that
     alters or restricts the applicable version of this License
     or the recipients' rights hereunder. However, You may
     include an additional document offering the additional
     rights described in Section 3.5. 

     3.2. Availability of Source Code. 
     Any Modification which You create or to which You
     contribute must be made available in Source Code form
     under the terms of this License either on the same
     media as an Executable version or via an accepted
     Electronic Distribution Mechanism to anyone to whom
     you made an Executable version available; and if made
     available via Electronic Distribution Mechanism, must
     remain available for at least twelve (12) months after the
     date it initially became available, or at least six (6)
     months after a subsequent version of that particular
     Modification has been made available to such
     recipients. You are responsible for ensuring that the
     Source Code version remains available even if the
     Electronic Distribution Mechanism is maintained by a
     third party. 

     3.3. Description of Modifications. 
     You must cause all Covered Code to which you
     contribute to contain a file documenting the changes
     You made to create that Covered Code and the date of
     any change. You must include a prominent statement
     that the Modification is derived, directly or indirectly,
     from Original Code provided by the Initial Developer and
     including the name of the Initial Developer in (a) the
     Source Code, and (b) in any notice in an Executable
     version or related documentation in which You describe
     the origin or ownership of the Covered Code. 

     3.4. Intellectual Property Matters 

          (a) Third Party Claims. 
          If You have knowledge that a party claims an
          intellectual property right in particular
          functionality or code (or its utilization under this
          License), you must include a text file with the
          source code distribution titled "LEGAL" which
          describes the claim and the party making the
          claim in sufficient detail that a recipient will
          know whom to contact. If you obtain such
          knowledge after You make Your Modification
          available as described in Section 3.2, You shall
          promptly modify the LEGAL file in all copies You
          make available thereafter and shall take other
          steps (such as notifying appropriate mailing lists
          or newsgroups) reasonably calculated to inform
          those who received the Covered Code that new
          knowledge has been obtained. 

          (b) Contributor APIs. 
          If Your Modification is an application
          programming interface and You own or control
          patents which are reasonably necessary to
          implement that API, you must also include this
          information in the LEGAL file. 

     3.5. Required Notices. 
     You must duplicate the notice in Exhibit A in each file
     of the Source Code, and this License in any
     documentation for the Source Code, where You
     describe recipients' rights relating to Covered Code. If
     You created one or more Modification(s), You may add
     your name as a Contributor to the notice described in
     Exhibit A. If it is not possible to put such notice in a
     particular Source Code file due to its structure, then
     you must include such notice in a location (such as a
     relevant directory file) where a user would be likely to
     look for such a notice. You may choose to offer, and to
     charge a fee for, warranty, support, indemnity or liability
     obligations to one or more recipients of Covered Code.
     However, You may do so only on Your own behalf, and
     not on behalf of the Initial Developer or any Contributor.
     You must make it absolutely clear than any such
     warranty, support, indemnity or liability obligation is
     offered by You alone, and You hereby agree to
     indemnify the Initial Developer and every Contributor for
     any liability incurred by the Initial Developer or such
     Contributor as a result of warranty, support, indemnity
     or liability terms You offer. 

     3.6. Distribution of Executable Versions. 
     You may distribute Covered Code in Executable form
     only if the requirements of Section 3.1-3.5 have been
     met for that Covered Code, and if You include a notice
     stating that the Source Code version of the Covered
     Code is available under the terms of this License,
     including a description of how and where You have
     fulfilled the obligations of Section 3.2. The notice must
     be conspicuously included in any notice in an
     Executable version, related documentation or collateral
     in which You describe recipients' rights relating to the
     Covered Code. You may distribute the Executable
     version of Covered Code under a license of Your
     choice, which may contain terms different from this
     License, provided that You are in compliance with the
     terms of this License and that the license for the
     Executable version does not attempt to limit or alter the
     recipient's rights in the Source Code version from the
     rights set forth in this License. If You distribute the
     Executable version under a different license You must
     make it absolutely clear that any terms which differ
     from this License are offered by You alone, not by the
     Initial Developer or any Contributor. You hereby agree
     to indemnify the Initial Developer and every Contributor
     for any liability incurred by the Initial Developer or such
     Contributor as a result of any such terms You offer. 

     3.7. Larger Works. 
     You may create a Larger Work by combining Covered
     Code with other code not governed by the terms of this
     License and distribute the Larger Work as a single
     product. In such a case, You must make sure the
     requirements of this License are fulfilled for the Covered
     Code. 

4. Inability to Comply Due to Statute or Regulation. 

     If it is impossible for You to comply with any of the
     terms of this License with respect to some or all of the
     Covered Code due to statute or regulation then You
     must: (a) comply with the terms of this License to the
     maximum extent possible; and (b) describe the
     limitations and the code they affect. Such description
     must be included in the LEGAL file described in
     Section 3.4 and must be included with all distributions
     of the Source Code. Except to the extent prohibited by
     statute or regulation, such description must be
     sufficiently detailed for a recipient of ordinary skill to be
     able to understand it. 

5. Application of this License. 

     This License applies to code to which the Initial
     Developer has attached the notice in Exhibit A, and to
     related Covered Code. 

6. Versions of the License. 

     6.1. New Versions. 
     Netscape Communications Corporation ("Netscape")
     may publish revised and/or new versions of the License
     from time to time. Each version will be given a
     distinguishing version number. 

     6.2. Effect of New Versions. 
     Once Covered Code has been published under a
     particular version of the License, You may always
     continue to use it under the terms of that version. You
     may also choose to use such Covered Code under the
     terms of any subsequent version of the License
     published by Netscape. No one other than Netscape
     has the right to modify the terms applicable to Covered
     Code created under this License. 

     6.3. Derivative Works. 
     If you create or use a modified version of this License
     (which you may only do in order to apply it to code
     which is not already Covered Code governed by this
     License), you must (a) rename Your license so that the
     phrases "Mozilla", "MOZILLAPL", "MOZPL",
     "Netscape", "NPL" or any confusingly similar phrase do
     not appear anywhere in your license and (b) otherwise
     make it clear that your version of the license contains
     terms which differ from the Mozilla Public License and
     Netscape Public License. (Filling in the name of the
     Initial Developer, Original Code or Contributor in the
     notice described in Exhibit A shall not of themselves
     be deemed to be modifications of this License.) 

7. DISCLAIMER OF WARRANTY. 

     COVERED CODE IS PROVIDED UNDER THIS
     LICENSE ON AN "AS IS" BASIS, WITHOUT
     WARRANTY OF ANY KIND, EITHER EXPRESSED
     OR IMPLIED, INCLUDING, WITHOUT LIMITATION,
     WARRANTIES THAT THE COVERED CODE IS FREE
     OF DEFECTS, MERCHANTABLE, FIT FOR A
     PARTICULAR PURPOSE OR NON-INFRINGING. THE
     ENTIRE RISK AS TO THE QUALITY AND
     PERFORMANCE OF THE COVERED CODE IS WITH
     YOU. SHOULD ANY COVERED CODE PROVE
     DEFECTIVE IN ANY RESPECT, YOU (NOT THE
     INITIAL DEVELOPER OR ANY OTHER
     CONTRIBUTOR) ASSUME THE COST OF ANY
     NECESSARY SERVICING, REPAIR OR
     CORRECTION. THIS DISCLAIMER OF WARRANTY
     CONSTITUTES AN ESSENTIAL PART OF THIS
     LICENSE. NO USE OF ANY COVERED CODE IS
     AUTHORIZED HEREUNDER EXCEPT UNDER THIS
     DISCLAIMER. 

8. TERMINATION. 

     This License and the rights granted hereunder will
     terminate automatically if You fail to comply with terms
     herein and fail to cure such breach within 30 days of
     becoming aware of the breach. All sublicenses to the
     Covered Code which are properly granted shall survive
     any termination of this License. Provisions which, by
     their nature, must remain in effect beyond the
     termination of this License shall survive. 

9. LIMITATION OF LIABILITY. 

     UNDER NO CIRCUMSTANCES AND UNDER NO
     LEGAL THEORY, WHETHER TORT (INCLUDING
     NEGLIGENCE), CONTRACT, OR OTHERWISE,
     SHALL THE INITIAL DEVELOPER, ANY OTHER
     CONTRIBUTOR, OR ANY DISTRIBUTOR OF
     COVERED CODE, OR ANY SUPPLIER OF ANY OF
     SUCH PARTIES, BE LIABLE TO YOU OR ANY
     OTHER PERSON FOR ANY INDIRECT, SPECIAL,
     INCIDENTAL, OR CONSEQUENTIAL DAMAGES OF
     ANY CHARACTER INCLUDING, WITHOUT
     LIMITATION, DAMAGES FOR LOSS OF GOODWILL,
     WORK STOPPAGE, COMPUTER FAILURE OR
     MALFUNCTION, OR ANY AND ALL OTHER
     COMMERCIAL DAMAGES OR LOSSES, EVEN IF
     SUCH PARTY SHALL HAVE BEEN INFORMED OF
     THE POSSIBILITY OF SUCH DAMAGES. THIS
     LIMITATION OF LIABILITY SHALL NOT APPLY TO
     LIABILITY FOR DEATH OR PERSONAL INJURY
     RESULTING FROM SUCH PARTY'S NEGLIGENCE
     TO THE EXTENT APPLICABLE LAW PROHIBITS
     SUCH LIMITATION. SOME JURISDICTIONS DO NOT
     ALLOW THE EXCLUSION OR LIMITATION OF
     INCIDENTAL OR CONSEQUENTIAL DAMAGES, SO
     THAT EXCLUSION AND LIMITATION MAY NOT
     APPLY TO YOU. 

10. U.S. GOVERNMENT END USERS. 

     The Covered Code is a "commercial item," as that term
     is defined in 48 C.F.R. 2.101 (Oct. 1995), consisting of
     "commercial computer software" and "commercial
     computer software documentation," as such terms are
     used in 48 C.F.R. 12.212 (Sept. 1995). Consistent with
     48 C.F.R. 12.212 and 48 C.F.R. 227.7202-1 through
     227.7202-4 (June 1995), all U.S. Government End
     Users acquire Covered Code with only those rights set
     forth herein. 

11. MISCELLANEOUS. 

     This License represents the complete agreement
     concerning subject matter hereof. If any provision of
     this License is held to be unenforceable, such provision
     shall be reformed only to the extent necessary to make
     it enforceable. This License shall be governed by
     California law provisions (except to the extent
     applicable law, if any, provides otherwise), excluding its
     conflict-of-law provisions. With respect to disputes in
     which at least one party is a citizen of, or an entity
     chartered or registered to do business in, the United
     States of America: (a) unless otherwise agreed in
     writing, all disputes relating to this License (excepting
     any dispute relating to intellectual property rights) shall
     be subject to final and binding arbitration, with the
     losing party paying all costs of arbitration; (b) any
     arbitration relating to this Agreement shall be held in
     Santa Clara County, California, under the auspices of
     JAMS/EndDispute; and (c) any litigation relating to this
     Agreement shall be subject to the jurisdiction of the
     Federal Courts of the Northern District of California,
     with venue lying in Santa Clara County, California, with
     the losing party responsible for costs, including without
     limitation, court costs and reasonable attorneys fees
     and expenses. The application of the United Nations
     Convention on Contracts for the International Sale of
     Goods is expressly excluded. Any law or regulation
     which provides that the language of a contract shall be
     construed against the drafter shall not apply to this
     License. 

12. RESPONSIBILITY FOR CLAIMS. 

     Except in cases where another Contributor has failed to
     comply with Section 3.4, You are responsible for
     damages arising, directly or indirectly, out of Your
     utilization of rights under this License, based on the
     number of copies of Covered Code you made available,
     the revenues you received from utilizing such rights,
     and other relevant factors. You agree to work with
     affected parties to distribute responsibility on an
     equitable basis. 

EXHIBIT A. 

     "The contents of this file are subject to the Mozilla
     Public License Version 1.0 (the "License"); you may
     not use this file except in compliance with the License.
     You may obtain a copy of the License at
     http://www.mozilla.org/MPL/ 

     Software distributed under the License is distributed on
     an "AS IS" basis, WITHOUT WARRANTY OF ANY
     KIND, either express or implied. See the License for
     the specific language governing rights and limitations
     under the License. 

     The Original Code is
     ______________________________________. 

     The Initial Developer of the Original Code is
     ________________________. Portions created by
     ______________________ are Copyright (C) ______
     _______________________. All Rights Reserved. 

     Contributor(s):
     ______________________________________." 
