# Generated by default/object.tt
package Paws::WAFV2::FirewallManagerRuleGroup;
  use Moose;
  has FirewallManagerStatement => (is => 'ro', isa => 'Paws::WAFV2::FirewallManagerStatement', required => 1);
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has OverrideAction => (is => 'ro', isa => 'Paws::WAFV2::OverrideAction', required => 1);
  has Priority => (is => 'ro', isa => 'Int', required => 1);
  has VisibilityConfig => (is => 'ro', isa => 'Paws::WAFV2::VisibilityConfig', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::FirewallManagerRuleGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::FirewallManagerRuleGroup object:

  $service_obj->Method(Att1 => { FirewallManagerStatement => $value, ..., VisibilityConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::FirewallManagerRuleGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->FirewallManagerStatement

=head1 DESCRIPTION

A rule group that's defined for an Firewall Manager WAF policy.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FirewallManagerStatement => L<Paws::WAFV2::FirewallManagerStatement>

The processing guidance for an Firewall Manager rule. This is like a
regular rule Statement, but it can only contain a rule group reference.


=head2 B<REQUIRED> Name => Str

The name of the rule group. You cannot change the name of a rule group
after you create it.


=head2 B<REQUIRED> OverrideAction => L<Paws::WAFV2::OverrideAction>

The override action to apply to the rules in a rule group. Used only
for rule statements that reference a rule group, like
C<RuleGroupReferenceStatement> and C<ManagedRuleGroupStatement>.

Set the override action to none to leave the rule actions in effect.
Set it to count to only count matches, regardless of the rule action
settings.

In a Rule, you must specify either this C<OverrideAction> setting or
the rule C<Action> setting, but not both:

=over

=item *

If the rule statement references a rule group, use this override action
setting and not the action setting.

=item *

If the rule statement does not reference a rule group, use the rule
action setting and not this rule override action setting.

=back



=head2 B<REQUIRED> Priority => Int

If you define more than one rule group in the first or last Firewall
Manager rule groups, WAF evaluates each request against the rule groups
in order, starting from the lowest priority setting. The priorities
don't need to be consecutive, but they must all be different.


=head2 B<REQUIRED> VisibilityConfig => L<Paws::WAFV2::VisibilityConfig>

Defines and enables Amazon CloudWatch metrics and web request sample
collection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

