# Generated by default/object.tt
package Paws::SageMaker::ArtifactSummary;
  use Moose;
  has ArtifactArn => (is => 'ro', isa => 'Str');
  has ArtifactName => (is => 'ro', isa => 'Str');
  has ArtifactType => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str');
  has Source => (is => 'ro', isa => 'Paws::SageMaker::ArtifactSource');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::ArtifactSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::ArtifactSummary object:

  $service_obj->Method(Att1 => { ArtifactArn => $value, ..., Source => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::ArtifactSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ArtifactArn

=head1 DESCRIPTION

Lists a summary of the properties of an artifact. An artifact
represents a URI addressable object or data. Some examples are a
dataset and a model.

=head1 ATTRIBUTES


=head2 ArtifactArn => Str

The Amazon Resource Name (ARN) of the artifact.


=head2 ArtifactName => Str

The name of the artifact.


=head2 ArtifactType => Str

The type of the artifact.


=head2 CreationTime => Str

When the artifact was created.


=head2 LastModifiedTime => Str

When the artifact was last modified.


=head2 Source => L<Paws::SageMaker::ArtifactSource>

The source of the artifact.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

