package Sport::Analytics::NHL::Report::TV;
use strict;
use warnings FATAL => 'all';

use parent 'Sport::Analytics::NHL::Report::TI';
1;

=head1 NAME

Sport::Analytics::NHL::TV - Class for the NHL HTML Team Visitor shift report

=head1 SYNOPSIS

Class for the NHL HTML TV report. Should not be constructed directly, but via Sport::Analytics::NHL::Report (q.v.)

A subclass for Sport::Analytics::NHL::TI, just for convenience.

=head1 AUTHOR

More Hockey Stats, C<< <contact at morehockeystats.com> >>

=head1 BUGS

Please report any bugs or feature requests to C<contact at morehockeystats.com>, or through
the web interface at L<https://rt.cpan.org/NoAuth/ReportBug.html?Queue=Sport::Analytics::NHL::TV>.  I will be notified, and then you'll
automatically be notified of progress on your bug as I make changes.


=head1 SUPPORT

You can find documentation for this module with the perldoc command.

    perldoc Sport::Analytics::NHL::TV

You can also look for information at:

=over 4

=item * RT: CPAN's request tracker (report bugs here)

L<https://rt.cpan.org/NoAuth/Bugs.html?Dist=Sport::Analytics::NHL::TV>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Sport::Analytics::NHL::TV>

=item * CPAN Ratings

L<https://cpanratings.perl.org/d/Sport::Analytics::NHL::TV>

=item * Search CPAN

L<https://metacpan.org/release/Sport::Analytics::NHL::TV>

=back

=cut
