package Game::HeroesVsAliens::Alien;

use Moo;

with 'Game::HeroesVsAliens::Role::ResourceDirectory';

has x => (
	is => 'rw'
);

has y => (
	is => 'rw'
);

has width => (
	is => 'rw',
	default => sub { 100 }
);

has height => (
	is => 'rw',
	default => sub { 100 }
);

has speed => (
	is => 'rw',
	default => sub {  
		rand(50) * 0.2 + 0.4;
	}
);

has movement => (
	is => 'rw',
	default => sub {  
		rand(50) * 0.2 + 0.4;
	}
);

has health => (
	is => 'rw',
	default => sub { 100 }
);

has max_health => (
	is => 'rw',
	default => sub { 100 }
);

has walking_sprite => (
	is => 'rw',
	default => sub {
                my $sprite = SDLx::Sprite::Animated->new(
                        image => $_[0]->resource_directory . 'resources/alien1-walk.png',
                        width => 100,
                        height => 100
                );
                return $sprite;
	}
);

has attacking_sprite => (
	is => 'rw',
	default => sub {
                my $sprite = SDLx::Sprite::Animated->new(
                        image => $_[0]->resource_directory . 'resources/alien1-attack.png',
                        width => 100,
                        height => 100
                );
                return $sprite;
	}
);

has dead => (
	is => 'rw',
	default => sub { 0 }
);


has death_sprite => (
	is => 'rw',
	default => sub {
                my $sprite = SDLx::Sprite::Animated->new(
                        image => $_[0]->resource_directory . 'resources/alien1-death.png',
                        width => 100,
                        height => 100
                );
                return $sprite;
	}
);

sub draw {
	my ($self, $app) = @_;
	if ($self->dead) {
		$self->death_sprite->rect->x($self->x);
		$self->death_sprite->rect->y($self->y);
		if ($app->frame % 3 == 0) {
			$self->death_sprite->next;
		}
		$self->death_sprite->draw($app->ctx);
	} elsif  (!$self->movement) {
		$self->attacking_sprite->rect->x($self->x);
		$self->attacking_sprite->rect->y($self->y);
		if ($app->frame % 3 == 0) {
			$self->attacking_sprite->next;
		}
		$self->attacking_sprite->draw($app->ctx);
	} else {
		$self->walking_sprite->rect->x($self->x);
		$self->walking_sprite->rect->y($self->y);
		if ($app->frame % 3 == 0) {
			$self->walking_sprite->next;
		}
		$self->walking_sprite->draw($app->ctx);
	}
	$app->draw_text($self->x + 15, $self->y + 15, 18, [100, 100, 100, 255], int($self->health))
}

sub update {
	my ($self, $app) = @_;
	$self->x($self->x - $self->movement);
}

1;
