use strict;
use Test::More tests => 25;

use WWW::Baseball::NPB;

{
    local $^W = 0;
    *LWP::Simple::get = sub ($) {
	local $/;
	require FileHandle;
	my $handle = FileHandle->new("t/20020330.html");
	return <$handle>;
    };
}

my $baseball = WWW::Baseball::NPB->new;

{
    my @games = $baseball->games;
    is @games, 6;

    isa_ok $_, 'WWW::Baseball::NPB::Game' for @games;

    my $game = $games[0];
    is $game->league, 'central';
    is $game->home, '';
    is $game->visitor, '';
    is $game->score(''), 1;
    is $game->score(''), 3;
    is $game->status, 'λ';
    is $game->stadium, 'ɡ';
}

{
    my @games = $baseball->games('pacific');
    is @games, 3;

    isa_ok $_, 'WWW::Baseball::NPB::Game' for @games;

    my $game = $games[0];
    is $game->league, 'pacific';
    is $game->home, 'Ŵ';
    is $game->visitor, 'å';
    is $game->score('Ŵ'), 6;
    is $game->score('å'), 3;
    is $game->status, 'λ';
    is $game->stadium, 'ɡ';
}



