#============================================================= -*-Perl-*-
#
# Lemplate::Grammar
#
# DESCRIPTION
#   Grammar file for the Template Toolkit language containing token
#   definitions and parser state/rules tables generated by Parse::Yapp.
#
# AUTHOR
#   Ingy döt Net   <ingy@cpan.org>
#
# ORIGINAL AUTHOR
#   Andy Wardley   <abw@kfs.org>
#
# COPYRIGHT
#   Copyright (C) 2006-2008 Ingy döt Net.
#   Copyright (C) 1996-2000 Andy Wardley.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#------------------------------------------------------------------------
#
# NOTE: this module is constructed from the parser/Grammar.pm.skel
# file by running the parser/yc script.  You only need to do this if
# you have modified the grammar in the parser/Parser.yp file and need
# to-recompile it.  See the README in the 'parser' directory for more
# information (sub-directory of the Lemplate distribution).
#
#========================================================================

package Lemplate::Grammar;

require 5.004;

use strict;
use vars qw( $VERSION );

$VERSION  = '0.10';

my (@RESERVED, %CMPOP, $LEXTABLE, $RULES, $STATES);
my ($factory, $rawstart);


#========================================================================
# Reserved words, comparison and binary operators
#========================================================================

@RESERVED = qw( 
	GET CALL SET DEFAULT INSERT INCLUDE PROCESS WRAPPER BLOCK END
	USE RAW PLUGIN FILTER MACRO JAVASCRIPT TO STEP AND OR NOT DIV MOD
	IF UNLESS ELSE ELSIF FOR NEXT WHILE SWITCH CASE META IN
	TRY THROW CATCH FINAL LAST RETURN STOP CLEAR VIEW DEBUG
    );

# for historical reasons, != and == are converted to ne and eq to perform 
# stringwise comparison (mainly because it doesn't generate "non-numerical 
# comparison" warnings which != and == can) but the others (e.g. < > <= >=)
# are not converted to their stringwise equivalents.  I added 'gt' et al, 
# briefly for v2.04d and then took them out again in 2.04e.

%CMPOP = qw( 
    != ~=
    == ==
    <  <
    >  >
    >= >=
    <= <=
);


#========================================================================
# Lexer Token Table
#========================================================================

# lookup table used by lexer is initialised with special-cases
$LEXTABLE = {
    'FOREACH' => 'FOR',
    'BREAK'   => 'LAST',
    '&&'      => 'AND',
    '||'      => 'OR',
    '!'       => 'NOT',
    '|'	      => 'FILTER',
    '.'       => 'DOT',
    '_'       => 'CAT',
    '..'      => 'TO',
#    ':'       => 'MACRO',
    '='       => 'ASSIGN',
    '=>'      => 'ASSIGN',
#    '->'      => 'ARROW',
    ','       => 'COMMA',
    '\\'      => 'REF',
    'and'     => 'AND',		# explicitly specified so that qw( and or
    'or'      => 'OR',		# not ) can always be used in lower case, 
    'not'     => 'NOT',		# regardless of ANYCASE flag
    'mod'     => 'MOD',
    'div'     => 'DIV',
};

# localise the temporary variables needed to complete lexer table
{ 
#    my @tokens = qw< ( ) [ ] { } ${ $ / ; : ? >;
    my @tokens = qw< ( ) [ ] { } ${ $ + / ; : ? >;
    my @cmpop  = keys %CMPOP;
#    my @binop  = qw( + - * % );              # '/' above, in @tokens
    my @binop  = qw( - * % );              # '+' and '/' above, in @tokens

    # fill lexer table, slice by slice, with reserved words and operators
    @$LEXTABLE{ @RESERVED, @cmpop, @binop, @tokens } 
	= ( @RESERVED, ('CMPOP') x @cmpop, ('BINOP') x @binop, @tokens );
}


#========================================================================
# CLASS METHODS
#========================================================================

sub new {
    my $class = shift;
    bless {
	LEXTABLE => $LEXTABLE,
	STATES   => $STATES,
	RULES    => $RULES,
    }, $class;
}

# update method to set package-scoped $factory lexical 
sub install_factory {
    my ($self, $new_factory) = @_;
    $factory = $new_factory;
}


#========================================================================
# States
#========================================================================

$STATES = [
	{#State 0
		ACTIONS => {
			'perl' => 68,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			"\"" => 37,
			'THROW' => 38,
			'VIEW' => 74,
			'STOP' => 75,
			'FOR' => 20,
			'NOT' => 22,
			'GET' => 60,
			'LITERAL' => 59,
			"\$" => 26,
			'FILTER' => 61,
			'USE' => 63,
			'CALL' => 62,
			'IF' => 27,
			";" => -19,
			'REF' => 28,
			'NEXT' => 66,
			'META' => 67,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'CLEAR' => 11,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'DEBUG' => 16,
			"{" => 53,
			'NUMBER' => 54,
			'MACRO' => 55,
			'INSERT' => 17,
			'rawperl' => 18,
			'BLOCK' => 42,
			'LAST' => 3,
			'WHILE' => 41,
			'SET' => 2,
			'UNLESS' => 43,
			'RAW' => 44,
			'RETURN' => 45,
			'TRY' => 5,
			"[" => 6,
			"\${" => 47,
			"(" => 48
		},
		DEFAULT => -3,
		GOTOS => {
			'try' => 15,
			'use' => 10,
			'defblock' => 50,
			'setlist' => 9,
			'javascript' => 52,
			'atomdir' => 14,
			'filter' => 12,
			'defblockname' => 4,
			'assign' => 7,
			'block' => 46,
			'chunks' => 40,
			'atomexpr' => 1,
			'loop' => 35,
			'template' => 34,
			'node' => 32,
			'capture' => 39,
			'anonblock' => 73,
			'term' => 72,
			'view' => 31,
			'raw' => 30,
			'directive' => 69,
			'statement' => 64,
			'item' => 25,
			'sterm' => 29,
			'switch' => 65,
			'condition' => 21,
			'expr' => 57,
			'ident' => 19,
			'chunk' => 56,
			'macro' => 24,
			'wrapper' => 58,
			'lterm' => 23
		}
	},
	{#State 1
		ACTIONS => {
			'UNLESS' => 79,
			'WHILE' => 80,
			'IF' => 77,
			'FILTER' => 81,
			'FOR' => 76,
			'WRAPPER' => 78
		}
	},
	{#State 2
		ACTIONS => {
			'IDENT' => 70,
			"\$" => 26,
			'LITERAL' => 84,
			"\${" => 47
		},
		GOTOS => {
			'item' => 25,
			'node' => 32,
			'setlist' => 82,
			'ident' => 83,
			'assign' => 7
		}
	},
	{#State 3
		DEFAULT => -41
	},
	{#State 4
		ACTIONS => {
			'IDENT' => 87
		},
		DEFAULT => -88,
		GOTOS => {
			'meta' => 88,
			'blockargs' => 85,
			'metadata' => 86
		}
	},
	{#State 5
		ACTIONS => {
			";" => 89
		}
	},
	{#State 6
		ACTIONS => {
			'IDENT' => 70,
			'NUMBER' => 54,
			"\$" => 26,
			'LITERAL' => 95,
			"{" => 53,
			"\"" => 37,
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			"]" => 91
		},
		GOTOS => {
			'item' => 25,
			'node' => 32,
			'range' => 90,
			'list' => 94,
			'term' => 96,
			'sterm' => 93,
			'ident' => 92,
			'lterm' => 23
		}
	},
	{#State 7
		DEFAULT => -150
	},
	{#State 8
		ACTIONS => {
			"\"" => 105,
			"\$" => 107,
			'LITERAL' => 98,
			'FILENAME' => 101,
			'IDENT' => 97,
			'NUMBER' => 99
		},
		GOTOS => {
			'filename' => 104,
			'names' => 103,
			'name' => 100,
			'filepart' => 106,
			'nameargs' => 102
		}
	},
	{#State 9
		ACTIONS => {
			"\${" => 47,
			"\$" => 26,
			'LITERAL' => 84,
			'COMMA' => 108,
			'IDENT' => 70
		},
		DEFAULT => -20,
		GOTOS => {
			'assign' => 109,
			'node' => 32,
			'item' => 25,
			'ident' => 83
		}
	},
	{#State 10
		DEFAULT => -13
	},
	{#State 11
		DEFAULT => -40
	},
	{#State 12
		DEFAULT => -45
	},
	{#State 13
		DEFAULT => -6
	},
	{#State 14
		ACTIONS => {
			";" => -21
		},
		DEFAULT => -29
	},
	{#State 15
		DEFAULT => -25
	},
	{#State 16
		ACTIONS => {
			"\"" => 105,
			'FILENAME' => 101,
			"\$" => 107,
			'LITERAL' => 98,
			'NUMBER' => 99,
			'IDENT' => 97
		},
		GOTOS => {
			'nameargs' => 110,
			'name' => 100,
			'filepart' => 106,
			'filename' => 104,
			'names' => 103
		}
	},
	{#State 17
		ACTIONS => {
			"\"" => 105,
			'FILENAME' => 101,
			"\$" => 107,
			'LITERAL' => 98,
			'NUMBER' => 99,
			'IDENT' => 97
		},
		GOTOS => {
			'filename' => 104,
			'names' => 103,
			'nameargs' => 111,
			'name' => 100,
			'filepart' => 106
		}
	},
	{#State 18
		DEFAULT => -16
	},
	{#State 19
		ACTIONS => {
			'ASSIGN' => 112,
			'DOT' => 113
		},
		DEFAULT => -110
	},
	{#State 20
		ACTIONS => {
			'IDENT' => 115,
			'NUMBER' => 54,
			"\$" => 26,
			'LITERAL' => 95,
			"{" => 53,
			"\"" => 37,
			'REF' => 28,
			"\${" => 47,
			"[" => 6
		},
		GOTOS => {
			'ident' => 92,
			'loopvar' => 116,
			'item' => 25,
			'node' => 32,
			'sterm' => 29,
			'term' => 114,
			'lterm' => 23
		}
	},
	{#State 21
		DEFAULT => -22
	},
	{#State 22
		ACTIONS => {
			'NOT' => 22,
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			'IDENT' => 70,
			'NUMBER' => 54,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53
		},
		GOTOS => {
			'expr' => 117,
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'sterm' => 29,
			'term' => 72,
			'lterm' => 23
		}
	},
	{#State 23
		DEFAULT => -104
	},
	{#State 24
		DEFAULT => -12
	},
	{#State 25
		ACTIONS => {
			"(" => 118
		},
		DEFAULT => -129
	},
	{#State 26
		ACTIONS => {
			'IDENT' => 119
		}
	},
	{#State 27
		ACTIONS => {
			'NOT' => 22,
			'NUMBER' => 54,
			'IDENT' => 70,
			"{" => 53,
			'LITERAL' => 95,
			"\$" => 26,
			"\"" => 37,
			"(" => 48,
			"\${" => 47,
			"[" => 6,
			'REF' => 28
		},
		GOTOS => {
			'sterm' => 29,
			'term' => 72,
			'lterm' => 23,
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'expr' => 120
		}
	},
	{#State 28
		ACTIONS => {
			"\${" => 47,
			'IDENT' => 70,
			"\$" => 26
		},
		GOTOS => {
			'item' => 25,
			'node' => 32,
			'ident' => 121
		}
	},
	{#State 29
		DEFAULT => -105
	},
	{#State 30
		DEFAULT => -14
	},
	{#State 31
		DEFAULT => -15
	},
	{#State 32
		DEFAULT => -128
	},
	{#State 33
		ACTIONS => {
			"\"" => 105,
			'LITERAL' => 98,
			"\$" => 107,
			'FILENAME' => 101,
			'IDENT' => 97,
			'NUMBER' => 99
		},
		GOTOS => {
			'names' => 103,
			'filename' => 104,
			'nameargs' => 122,
			'name' => 100,
			'filepart' => 106
		}
	},
	{#State 34
		ACTIONS => {
			'' => 123
		}
	},
	{#State 35
		DEFAULT => -24
	},
	{#State 36
		ACTIONS => {
			'LITERAL' => 84,
			"\$" => 26,
			'IDENT' => 70,
			"\${" => 47
		},
		GOTOS => {
			'item' => 25,
			'node' => 32,
			'ident' => 83,
			'setlist' => 124,
			'assign' => 7
		}
	},
	{#State 37
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 125
		}
	},
	{#State 38
		ACTIONS => {
			"\"" => 105,
			'NUMBER' => 99,
			'IDENT' => 97,
			'FILENAME' => 101,
			"\$" => 107,
			'LITERAL' => 98
		},
		GOTOS => {
			'filename' => 104,
			'names' => 103,
			'filepart' => 106,
			'name' => 100,
			'nameargs' => 126
		}
	},
	{#State 39
		DEFAULT => -11
	},
	{#State 40
		ACTIONS => {
			'RAW' => 44,
			'UNLESS' => 43,
			'WHILE' => 41,
			'SET' => 2,
			'LAST' => 3,
			'BLOCK' => 42,
			'TRY' => 5,
			'RETURN' => 45,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'CLEAR' => 11,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'NUMBER' => 54,
			'DEBUG' => 16,
			"{" => 53,
			'rawperl' => 18,
			'INSERT' => 17,
			'MACRO' => 55,
			'NOT' => 22,
			'FOR' => 20,
			'IF' => 27,
			'USE' => 63,
			'CALL' => 62,
			'FILTER' => 61,
			'GET' => 60,
			"\$" => 26,
			'LITERAL' => 59,
			'META' => 67,
			'NEXT' => 66,
			'REF' => 28,
			";" => -19,
			'perl' => 68,
			'IDENT' => 70,
			'INCLUDE' => 33,
			'STOP' => 75,
			'VIEW' => 74,
			"\"" => 37,
			'THROW' => 38,
			'SWITCH' => 71,
			'DEFAULT' => 36
		},
		DEFAULT => -2,
		GOTOS => {
			'use' => 10,
			'defblock' => 50,
			'setlist' => 9,
			'view' => 31,
			'javascript' => 52,
			'raw' => 30,
			'directive' => 69,
			'atomdir' => 14,
			'filter' => 12,
			'loop' => 35,
			'node' => 32,
			'try' => 15,
			'anonblock' => 73,
			'capture' => 39,
			'term' => 72,
			'condition' => 21,
			'expr' => 57,
			'ident' => 19,
			'atomexpr' => 1,
			'chunk' => 127,
			'macro' => 24,
			'wrapper' => 58,
			'lterm' => 23,
			'statement' => 64,
			'defblockname' => 4,
			'item' => 25,
			'assign' => 7,
			'switch' => 65,
			'sterm' => 29
		}
	},
	{#State 41
		ACTIONS => {
			'NOT' => 22,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			"\"" => 37,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			'IDENT' => 70,
			'NUMBER' => 54
		},
		GOTOS => {
			'expr' => 128,
			'ident' => 92,
			'node' => 32,
			'item' => 25,
			'sterm' => 29,
			'term' => 72,
			'lterm' => 23
		}
	},
	{#State 42
		ACTIONS => {
			'NUMBER' => 99,
			'IDENT' => 129,
			'FILENAME' => 101,
			'LITERAL' => 130
		},
		DEFAULT => -88,
		GOTOS => {
			'blockargs' => 133,
			'filename' => 132,
			'metadata' => 86,
			'blockname' => 131,
			'meta' => 88,
			'filepart' => 106
		}
	},
	{#State 43
		ACTIONS => {
			'NOT' => 22,
			"[" => 6,
			"\${" => 47,
			'REF' => 28,
			"\"" => 37,
			"(" => 48,
			"{" => 53,
			"\$" => 26,
			'LITERAL' => 95,
			'NUMBER' => 54,
			'IDENT' => 70
		},
		GOTOS => {
			'expr' => 134,
			'item' => 25,
			'node' => 32,
			'ident' => 92,
			'lterm' => 23,
			'sterm' => 29,
			'term' => 72
		}
	},
	{#State 44
		ACTIONS => {
			"\${" => 47,
			"\"" => 140,
			"\$" => 138,
			'LITERAL' => 135,
			'FILENAME' => 101,
			'IDENT' => 136,
			'NUMBER' => 99
		},
		GOTOS => {
			'names' => 103,
			'lvalue' => 137,
			'nameargs' => 141,
			'filepart' => 106,
			'name' => 100,
			'lnameargs' => 142,
			'filename' => 104,
			'item' => 139
		}
	},
	{#State 45
		DEFAULT => -38
	},
	{#State 46
		DEFAULT => -1
	},
	{#State 47
		ACTIONS => {
			'NUMBER' => 54,
			'IDENT' => 70,
			"\$" => 26,
			'LITERAL' => 95,
			"\"" => 37,
			"\${" => 47,
			'REF' => 28
		},
		GOTOS => {
			'node' => 32,
			'item' => 25,
			'ident' => 92,
			'sterm' => 143
		}
	},
	{#State 48
		ACTIONS => {
			'NUMBER' => 54,
			'IDENT' => 70,
			"{" => 53,
			'LITERAL' => 59,
			"\$" => 26,
			"\"" => 37,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'REF' => 28,
			'NOT' => 22
		},
		GOTOS => {
			'node' => 32,
			'item' => 25,
			'assign' => 144,
			'term' => 72,
			'sterm' => 29,
			'expr' => 146,
			'ident' => 145,
			'lterm' => 23
		}
	},
	{#State 49
		ACTIONS => {
			'FILENAME' => 101,
			"\$" => 107,
			'LITERAL' => 98,
			'NUMBER' => 99,
			'IDENT' => 97,
			"\"" => 105
		},
		GOTOS => {
			'filename' => 104,
			'names' => 103,
			'filepart' => 106,
			'name' => 100,
			'nameargs' => 147
		}
	},
	{#State 50
		DEFAULT => -9
	},
	{#State 51
		ACTIONS => {
			";" => 148
		}
	},
	{#State 52
		DEFAULT => -26
	},
	{#State 53
		ACTIONS => {
			'IDENT' => 70,
			"\$" => 26,
			'LITERAL' => 153,
			"\${" => 47
		},
		DEFAULT => -120,
		GOTOS => {
			'hash' => 149,
			'param' => 152,
			'item' => 151,
			'params' => 150
		}
	},
	{#State 54
		DEFAULT => -114
	},
	{#State 55
		ACTIONS => {
			'IDENT' => 154
		}
	},
	{#State 56
		DEFAULT => -5
	},
	{#State 57
		ACTIONS => {
			"/" => 157,
			'BINOP' => 160,
			'MOD' => 164,
			";" => -17,
			'CAT' => 163,
			"+" => 158,
			'DIV' => 161,
			"?" => 159,
			'AND' => 155,
			'OR' => 162,
			'CMPOP' => 156
		},
		DEFAULT => -28
	},
	{#State 58
		DEFAULT => -44
	},
	{#State 59
		ACTIONS => {
			'ASSIGN' => 165
		},
		DEFAULT => -113
	},
	{#State 60
		ACTIONS => {
			'NOT' => 22,
			'IDENT' => 70,
			'NUMBER' => 54,
			"\$" => 26,
			'LITERAL' => 95,
			"{" => 53,
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"[" => 6,
			"\${" => 47
		},
		GOTOS => {
			'sterm' => 29,
			'term' => 72,
			'lterm' => 23,
			'ident' => 92,
			'node' => 32,
			'item' => 25,
			'expr' => 166
		}
	},
	{#State 61
		ACTIONS => {
			"\"" => 140,
			"\${" => 47,
			'NUMBER' => 99,
			'IDENT' => 136,
			'FILENAME' => 101,
			"\$" => 138,
			'LITERAL' => 135
		},
		GOTOS => {
			'item' => 139,
			'filename' => 104,
			'nameargs' => 141,
			'lnameargs' => 167,
			'name' => 100,
			'filepart' => 106,
			'lvalue' => 137,
			'names' => 103
		}
	},
	{#State 62
		ACTIONS => {
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			"\"" => 37,
			"\$" => 26,
			'LITERAL' => 95,
			"{" => 53,
			'IDENT' => 70,
			'NUMBER' => 54,
			'NOT' => 22
		},
		GOTOS => {
			'ident' => 92,
			'node' => 32,
			'item' => 25,
			'expr' => 168,
			'term' => 72,
			'sterm' => 29,
			'lterm' => 23
		}
	},
	{#State 63
		ACTIONS => {
			"\${" => 47,
			"\"" => 140,
			"\$" => 138,
			'LITERAL' => 135,
			'FILENAME' => 101,
			'IDENT' => 136,
			'NUMBER' => 99
		},
		GOTOS => {
			'names' => 103,
			'lvalue' => 137,
			'filepart' => 106,
			'name' => 100,
			'lnameargs' => 169,
			'nameargs' => 141,
			'filename' => 104,
			'item' => 139
		}
	},
	{#State 64
		ACTIONS => {
			";" => 170
		}
	},
	{#State 65
		DEFAULT => -23
	},
	{#State 66
		DEFAULT => -42
	},
	{#State 67
		ACTIONS => {
			'IDENT' => 87
		},
		GOTOS => {
			'meta' => 88,
			'metadata' => 171
		}
	},
	{#State 68
		DEFAULT => -27
	},
	{#State 69
		DEFAULT => -8
	},
	{#State 70
		DEFAULT => -131
	},
	{#State 71
		ACTIONS => {
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			'IDENT' => 70,
			'NUMBER' => 54,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			'NOT' => 22
		},
		GOTOS => {
			'sterm' => 29,
			'term' => 72,
			'lterm' => 23,
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'expr' => 172
		}
	},
	{#State 72
		DEFAULT => -147
	},
	{#State 73
		DEFAULT => -10
	},
	{#State 74
		ACTIONS => {
			'FILENAME' => 101,
			'LITERAL' => 98,
			"\$" => 107,
			'NUMBER' => 99,
			'IDENT' => 97,
			"\"" => 105
		},
		GOTOS => {
			'filename' => 104,
			'names' => 103,
			'filepart' => 106,
			'name' => 100,
			'nameargs' => 173
		}
	},
	{#State 75
		DEFAULT => -39
	},
	{#State 76
		ACTIONS => {
			"{" => 53,
			'LITERAL' => 95,
			"\$" => 26,
			'NUMBER' => 54,
			'IDENT' => 115,
			"\${" => 47,
			"[" => 6,
			'REF' => 28,
			"\"" => 37
		},
		GOTOS => {
			'term' => 114,
			'sterm' => 29,
			'lterm' => 23,
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'loopvar' => 174
		}
	},
	{#State 77
		ACTIONS => {
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			'IDENT' => 70,
			'NUMBER' => 54,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			'NOT' => 22
		},
		GOTOS => {
			'lterm' => 23,
			'term' => 72,
			'sterm' => 29,
			'item' => 25,
			'node' => 32,
			'ident' => 92,
			'expr' => 175
		}
	},
	{#State 78
		ACTIONS => {
			'NUMBER' => 99,
			'IDENT' => 97,
			'FILENAME' => 101,
			"\$" => 107,
			'LITERAL' => 98,
			"\"" => 105
		},
		GOTOS => {
			'filepart' => 106,
			'name' => 100,
			'nameargs' => 176,
			'filename' => 104,
			'names' => 103
		}
	},
	{#State 79
		ACTIONS => {
			'NOT' => 22,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			"\"" => 37,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			'IDENT' => 70,
			'NUMBER' => 54
		},
		GOTOS => {
			'lterm' => 23,
			'sterm' => 29,
			'term' => 72,
			'expr' => 177,
			'item' => 25,
			'node' => 32,
			'ident' => 92
		}
	},
	{#State 80
		ACTIONS => {
			'NOT' => 22,
			"\${" => 47,
			"[" => 6,
			'REF' => 28,
			"\"" => 37,
			"(" => 48,
			"{" => 53,
			"\$" => 26,
			'LITERAL' => 95,
			'NUMBER' => 54,
			'IDENT' => 70
		},
		GOTOS => {
			'sterm' => 29,
			'term' => 72,
			'lterm' => 23,
			'ident' => 92,
			'node' => 32,
			'item' => 25,
			'expr' => 178
		}
	},
	{#State 81
		ACTIONS => {
			'LITERAL' => 135,
			"\$" => 138,
			'FILENAME' => 101,
			'IDENT' => 136,
			'NUMBER' => 99,
			"\${" => 47,
			"\"" => 140
		},
		GOTOS => {
			'item' => 139,
			'filename' => 104,
			'filepart' => 106,
			'name' => 100,
			'lnameargs' => 179,
			'nameargs' => 141,
			'names' => 103,
			'lvalue' => 137
		}
	},
	{#State 82
		ACTIONS => {
			"\${" => 47,
			"\$" => 26,
			'LITERAL' => 84,
			'IDENT' => 70,
			'COMMA' => 108
		},
		DEFAULT => -32,
		GOTOS => {
			'assign' => 109,
			'item' => 25,
			'node' => 32,
			'ident' => 83
		}
	},
	{#State 83
		ACTIONS => {
			'ASSIGN' => 180,
			'DOT' => 113
		}
	},
	{#State 84
		ACTIONS => {
			'ASSIGN' => 165
		}
	},
	{#State 85
		ACTIONS => {
			";" => 181
		}
	},
	{#State 86
		ACTIONS => {
			'IDENT' => 87,
			'COMMA' => 183
		},
		DEFAULT => -87,
		GOTOS => {
			'meta' => 182
		}
	},
	{#State 87
		ACTIONS => {
			'ASSIGN' => 184
		}
	},
	{#State 88
		DEFAULT => -100
	},
	{#State 89
		ACTIONS => {
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'CLEAR' => 11,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			"{" => 53,
			'DEBUG' => 16,
			'NUMBER' => 54,
			'MACRO' => 55,
			'INSERT' => 17,
			'rawperl' => 18,
			'SET' => 2,
			'WHILE' => 41,
			'LAST' => 3,
			'BLOCK' => 42,
			'RAW' => 44,
			'UNLESS' => 43,
			'RETURN' => 45,
			'TRY' => 5,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			'perl' => 68,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			"\"" => 37,
			'THROW' => 38,
			'VIEW' => 74,
			'STOP' => 75,
			'FOR' => 20,
			'NOT' => 22,
			'LITERAL' => 59,
			'GET' => 60,
			"\$" => 26,
			'FILTER' => 61,
			'CALL' => 62,
			'USE' => 63,
			'IF' => 27,
			";" => -19,
			'REF' => 28,
			'NEXT' => 66,
			'META' => 67
		},
		DEFAULT => -3,
		GOTOS => {
			'javascript' => 52,
			'view' => 31,
			'raw' => 30,
			'directive' => 69,
			'atomdir' => 14,
			'filter' => 12,
			'defblock' => 50,
			'use' => 10,
			'setlist' => 9,
			'capture' => 39,
			'anonblock' => 73,
			'term' => 72,
			'loop' => 35,
			'node' => 32,
			'try' => 15,
			'macro' => 24,
			'lterm' => 23,
			'wrapper' => 58,
			'expr' => 57,
			'condition' => 21,
			'ident' => 19,
			'chunks' => 40,
			'atomexpr' => 1,
			'chunk' => 56,
			'assign' => 7,
			'switch' => 65,
			'sterm' => 29,
			'block' => 185,
			'statement' => 64,
			'defblockname' => 4,
			'item' => 25
		}
	},
	{#State 90
		ACTIONS => {
			"]" => 186
		}
	},
	{#State 91
		DEFAULT => -108
	},
	{#State 92
		ACTIONS => {
			'DOT' => 113
		},
		DEFAULT => -110
	},
	{#State 93
		ACTIONS => {
			'TO' => 187
		},
		DEFAULT => -105
	},
	{#State 94
		ACTIONS => {
			"{" => 53,
			'LITERAL' => 95,
			"\$" => 26,
			'NUMBER' => 54,
			'COMMA' => 189,
			'IDENT' => 70,
			"\${" => 47,
			"[" => 6,
			'REF' => 28,
			"\"" => 37,
			"]" => 188
		},
		GOTOS => {
			'lterm' => 23,
			'sterm' => 29,
			'term' => 190,
			'node' => 32,
			'item' => 25,
			'ident' => 92
		}
	},
	{#State 95
		DEFAULT => -113
	},
	{#State 96
		DEFAULT => -117
	},
	{#State 97
		DEFAULT => -174
	},
	{#State 98
		DEFAULT => -170
	},
	{#State 99
		DEFAULT => -175
	},
	{#State 100
		DEFAULT => -167
	},
	{#State 101
		DEFAULT => -173
	},
	{#State 102
		DEFAULT => -36
	},
	{#State 103
		ACTIONS => {
			"+" => 191,
			"(" => 192
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 193
		}
	},
	{#State 104
		ACTIONS => {
			'DOT' => 194
		},
		DEFAULT => -169
	},
	{#State 105
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 195
		}
	},
	{#State 106
		DEFAULT => -172
	},
	{#State 107
		ACTIONS => {
			"\${" => 47,
			"\$" => 26,
			'IDENT' => 70
		},
		GOTOS => {
			'ident' => 196,
			'item' => 25,
			'node' => 32
		}
	},
	{#State 108
		DEFAULT => -149
	},
	{#State 109
		DEFAULT => -148
	},
	{#State 110
		DEFAULT => -43
	},
	{#State 111
		DEFAULT => -34
	},
	{#State 112
		ACTIONS => {
			'perl' => 68,
			'THROW' => 38,
			"\"" => 37,
			'STOP' => 75,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			'IDENT' => 70,
			'INCLUDE' => 33,
			'FOR' => 20,
			'NOT' => 22,
			'NEXT' => 66,
			'REF' => 28,
			'FILTER' => 61,
			'CALL' => 62,
			'IF' => 27,
			'GET' => 60,
			"\$" => 26,
			'LITERAL' => 59,
			'JAVASCRIPT' => 51,
			'CLEAR' => 11,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'INSERT' => 17,
			'NUMBER' => 54,
			"{" => 53,
			'DEBUG' => 16,
			'UNLESS' => 43,
			'BLOCK' => 200,
			'LAST' => 3,
			'SET' => 2,
			'WHILE' => 41,
			"(" => 48,
			"\${" => 47,
			"[" => 6,
			'RETURN' => 45,
			'TRY' => 5
		},
		GOTOS => {
			'try' => 15,
			'node' => 32,
			'loop' => 35,
			'term' => 72,
			'mdir' => 199,
			'setlist' => 9,
			'directive' => 198,
			'atomdir' => 14,
			'filter' => 12,
			'javascript' => 52,
			'item' => 25,
			'switch' => 65,
			'sterm' => 29,
			'assign' => 7,
			'ident' => 145,
			'atomexpr' => 1,
			'expr' => 197,
			'condition' => 21,
			'lterm' => 23,
			'wrapper' => 58
		}
	},
	{#State 113
		ACTIONS => {
			"\${" => 47,
			'IDENT' => 70,
			'NUMBER' => 201,
			"\$" => 26
		},
		GOTOS => {
			'item' => 25,
			'node' => 202
		}
	},
	{#State 114
		DEFAULT => -157,
		GOTOS => {
			'args' => 203
		}
	},
	{#State 115
		ACTIONS => {
			'ASSIGN' => 205,
			'IN' => 204
		},
		DEFAULT => -131
	},
	{#State 116
		ACTIONS => {
			";" => 206
		}
	},
	{#State 117
		ACTIONS => {
			"/" => 157,
			'CMPOP' => 156,
			'CAT' => 163,
			'MOD' => 164,
			'BINOP' => 160,
			"+" => 158,
			'DIV' => 161
		},
		DEFAULT => -143
	},
	{#State 118
		DEFAULT => -157,
		GOTOS => {
			'args' => 207
		}
	},
	{#State 119
		DEFAULT => -133
	},
	{#State 120
		ACTIONS => {
			'BINOP' => 160,
			'DIV' => 161,
			"?" => 159,
			"+" => 158,
			'AND' => 155,
			"/" => 157,
			'CMPOP' => 156,
			'CAT' => 163,
			'MOD' => 164,
			'OR' => 162,
			";" => 208
		}
	},
	{#State 121
		ACTIONS => {
			'DOT' => 113
		},
		DEFAULT => -111
	},
	{#State 122
		DEFAULT => -35
	},
	{#State 123
		DEFAULT => 0
	},
	{#State 124
		ACTIONS => {
			'IDENT' => 70,
			'COMMA' => 108,
			"\$" => 26,
			'LITERAL' => 84,
			"\${" => 47
		},
		DEFAULT => -33,
		GOTOS => {
			'assign' => 109,
			'ident' => 83,
			'item' => 25,
			'node' => 32
		}
	},
	{#State 125
		ACTIONS => {
			"\"" => 212,
			";" => 210,
			"\${" => 47,
			'TEXT' => 209,
			'IDENT' => 70,
			"\$" => 26
		},
		GOTOS => {
			'ident' => 211,
			'item' => 25,
			'node' => 32,
			'quotable' => 213
		}
	},
	{#State 126
		DEFAULT => -37
	},
	{#State 127
		DEFAULT => -4
	},
	{#State 128
		ACTIONS => {
			'CAT' => 163,
			'CMPOP' => 156,
			";" => 214,
			'MOD' => 164,
			'OR' => 162,
			'BINOP' => 160,
			'AND' => 155,
			"/" => 157,
			'DIV' => 161,
			"+" => 158,
			"?" => 159
		}
	},
	{#State 129
		ACTIONS => {
			'ASSIGN' => 184
		},
		DEFAULT => -174
	},
	{#State 130
		DEFAULT => -86
	},
	{#State 131
		DEFAULT => -84
	},
	{#State 132
		ACTIONS => {
			'DOT' => 194
		},
		DEFAULT => -85
	},
	{#State 133
		ACTIONS => {
			";" => 215
		}
	},
	{#State 134
		ACTIONS => {
			'CMPOP' => 156,
			'CAT' => 163,
			'OR' => 162,
			'MOD' => 164,
			";" => 216,
			'BINOP' => 160,
			"?" => 159,
			"+" => 158,
			'DIV' => 161,
			"/" => 157,
			'AND' => 155
		}
	},
	{#State 135
		ACTIONS => {
			'ASSIGN' => -162
		},
		DEFAULT => -170
	},
	{#State 136
		ACTIONS => {
			'ASSIGN' => -131
		},
		DEFAULT => -174
	},
	{#State 137
		ACTIONS => {
			'ASSIGN' => 217
		}
	},
	{#State 138
		ACTIONS => {
			'IDENT' => 218,
			"\$" => 26,
			"\${" => 47
		},
		GOTOS => {
			'ident' => 196,
			'item' => 25,
			'node' => 32
		}
	},
	{#State 139
		DEFAULT => -160
	},
	{#State 140
		DEFAULT => -177,
		GOTOS => {
			'quoted' => 219
		}
	},
	{#State 141
		DEFAULT => -159
	},
	{#State 142
		DEFAULT => -76
	},
	{#State 143
		ACTIONS => {
			"}" => 220
		}
	},
	{#State 144
		ACTIONS => {
			")" => 221
		}
	},
	{#State 145
		ACTIONS => {
			'ASSIGN' => 180,
			'DOT' => 113
		},
		DEFAULT => -110
	},
	{#State 146
		ACTIONS => {
			")" => 222,
			'OR' => 162,
			'MOD' => 164,
			'CAT' => 163,
			'CMPOP' => 156,
			'AND' => 155,
			"/" => 157,
			"+" => 158,
			'DIV' => 161,
			"?" => 159,
			'BINOP' => 160
		}
	},
	{#State 147
		ACTIONS => {
			";" => 223
		}
	},
	{#State 148
		DEFAULT => -79,
		GOTOS => {
			'@4-2' => 224
		}
	},
	{#State 149
		ACTIONS => {
			"}" => 225
		}
	},
	{#State 150
		ACTIONS => {
			'COMMA' => 227,
			'IDENT' => 70,
			'LITERAL' => 153,
			"\$" => 26,
			"\${" => 47
		},
		DEFAULT => -119,
		GOTOS => {
			'param' => 226,
			'item' => 151
		}
	},
	{#State 151
		ACTIONS => {
			'ASSIGN' => 228
		}
	},
	{#State 152
		DEFAULT => -123
	},
	{#State 153
		ACTIONS => {
			'ASSIGN' => 229
		}
	},
	{#State 154
		ACTIONS => {
			"(" => 232,
			"[" => 6,
			"\${" => 47,
			'RETURN' => 45,
			'TRY' => 5,
			'UNLESS' => 43,
			'WHILE' => 41,
			'LAST' => 3,
			'BLOCK' => 200,
			'SET' => 2,
			'INSERT' => 17,
			'NUMBER' => 54,
			'DEBUG' => 16,
			"{" => 53,
			'JAVASCRIPT' => 51,
			'CLEAR' => 11,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'NEXT' => 66,
			'REF' => 28,
			'FILTER' => 61,
			'CALL' => 62,
			'IF' => 27,
			'LITERAL' => 59,
			"\$" => 26,
			'GET' => 60,
			'FOR' => 20,
			'NOT' => 22,
			'THROW' => 38,
			"\"" => 37,
			'STOP' => 75,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'IDENT' => 70,
			'INCLUDE' => 33,
			'perl' => 68
		},
		GOTOS => {
			'term' => 72,
			'mdir' => 231,
			'node' => 32,
			'try' => 15,
			'loop' => 35,
			'filter' => 12,
			'atomdir' => 14,
			'directive' => 198,
			'javascript' => 52,
			'setlist' => 9,
			'sterm' => 29,
			'switch' => 65,
			'assign' => 7,
			'item' => 25,
			'wrapper' => 58,
			'lterm' => 23,
			'ident' => 145,
			'atomexpr' => 1,
			'expr' => 230,
			'condition' => 21
		}
	},
	{#State 155
		ACTIONS => {
			'IDENT' => 70,
			'NUMBER' => 54,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			'NOT' => 22
		},
		GOTOS => {
			'expr' => 233,
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'sterm' => 29,
			'term' => 72,
			'lterm' => 23
		}
	},
	{#State 156
		ACTIONS => {
			'NOT' => 22,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			"\"" => 37,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			'IDENT' => 70,
			'NUMBER' => 54
		},
		GOTOS => {
			'expr' => 234,
			'node' => 32,
			'item' => 25,
			'ident' => 92,
			'lterm' => 23,
			'term' => 72,
			'sterm' => 29
		}
	},
	{#State 157
		ACTIONS => {
			'NOT' => 22,
			"[" => 6,
			"\${" => 47,
			'REF' => 28,
			"\"" => 37,
			"(" => 48,
			"{" => 53,
			"\$" => 26,
			'LITERAL' => 95,
			'NUMBER' => 54,
			'IDENT' => 70
		},
		GOTOS => {
			'lterm' => 23,
			'sterm' => 29,
			'term' => 72,
			'node' => 32,
			'item' => 25,
			'ident' => 92,
			'expr' => 235
		}
	},
	{#State 158
		ACTIONS => {
			'NUMBER' => 54,
			'IDENT' => 70,
			"{" => 53,
			"\$" => 26,
			'LITERAL' => 95,
			"\"" => 37,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'REF' => 28,
			'NOT' => 22
		},
		GOTOS => {
			'lterm' => 23,
			'sterm' => 29,
			'term' => 72,
			'node' => 32,
			'item' => 25,
			'ident' => 92,
			'expr' => 236
		}
	},
	{#State 159
		ACTIONS => {
			'NOT' => 22,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			"\"" => 37,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			'IDENT' => 70,
			'NUMBER' => 54
		},
		GOTOS => {
			'term' => 72,
			'sterm' => 29,
			'lterm' => 23,
			'expr' => 237,
			'ident' => 92,
			'node' => 32,
			'item' => 25
		}
	},
	{#State 160
		ACTIONS => {
			'NOT' => 22,
			"{" => 53,
			"\$" => 26,
			'LITERAL' => 95,
			'NUMBER' => 54,
			'IDENT' => 70,
			"\${" => 47,
			"[" => 6,
			'REF' => 28,
			"\"" => 37,
			"(" => 48
		},
		GOTOS => {
			'expr' => 238,
			'item' => 25,
			'node' => 32,
			'ident' => 92,
			'lterm' => 23,
			'term' => 72,
			'sterm' => 29
		}
	},
	{#State 161
		ACTIONS => {
			'NUMBER' => 54,
			'IDENT' => 70,
			"{" => 53,
			'LITERAL' => 95,
			"\$" => 26,
			"\"" => 37,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'REF' => 28,
			'NOT' => 22
		},
		GOTOS => {
			'expr' => 239,
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'sterm' => 29,
			'term' => 72,
			'lterm' => 23
		}
	},
	{#State 162
		ACTIONS => {
			'NOT' => 22,
			'IDENT' => 70,
			'NUMBER' => 54,
			"\$" => 26,
			'LITERAL' => 95,
			"{" => 53,
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"\${" => 47,
			"[" => 6
		},
		GOTOS => {
			'item' => 25,
			'node' => 32,
			'ident' => 92,
			'expr' => 240,
			'lterm' => 23,
			'sterm' => 29,
			'term' => 72
		}
	},
	{#State 163
		ACTIONS => {
			'IDENT' => 70,
			'NUMBER' => 54,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			'NOT' => 22
		},
		GOTOS => {
			'term' => 72,
			'sterm' => 29,
			'lterm' => 23,
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'expr' => 241
		}
	},
	{#State 164
		ACTIONS => {
			'NOT' => 22,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			"\"" => 37,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			'IDENT' => 70,
			'NUMBER' => 54
		},
		GOTOS => {
			'item' => 25,
			'node' => 32,
			'ident' => 92,
			'expr' => 242,
			'lterm' => 23,
			'sterm' => 29,
			'term' => 72
		}
	},
	{#State 165
		ACTIONS => {
			"\$" => 26,
			'LITERAL' => 95,
			"{" => 53,
			'IDENT' => 70,
			'NUMBER' => 54,
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			"\"" => 37,
			'NOT' => 22
		},
		GOTOS => {
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'expr' => 243,
			'term' => 72,
			'sterm' => 29,
			'lterm' => 23
		}
	},
	{#State 166
		ACTIONS => {
			'MOD' => 164,
			'CAT' => 163,
			"/" => 157,
			'BINOP' => 160,
			'OR' => 162,
			'CMPOP' => 156,
			'AND' => 155,
			'DIV' => 161,
			"+" => 158,
			"?" => 159
		},
		DEFAULT => -30
	},
	{#State 167
		ACTIONS => {
			";" => 244
		}
	},
	{#State 168
		ACTIONS => {
			"/" => 157,
			'BINOP' => 160,
			'MOD' => 164,
			'CAT' => 163,
			'AND' => 155,
			"+" => 158,
			'DIV' => 161,
			"?" => 159,
			'OR' => 162,
			'CMPOP' => 156
		},
		DEFAULT => -31
	},
	{#State 169
		DEFAULT => -75
	},
	{#State 170
		DEFAULT => -7
	},
	{#State 171
		ACTIONS => {
			'COMMA' => 183,
			'IDENT' => 87
		},
		DEFAULT => -18,
		GOTOS => {
			'meta' => 182
		}
	},
	{#State 172
		ACTIONS => {
			'BINOP' => 160,
			'DIV' => 161,
			"+" => 158,
			"?" => 159,
			"/" => 157,
			'AND' => 155,
			'CMPOP' => 156,
			'CAT' => 163,
			'OR' => 162,
			'MOD' => 164,
			";" => 245
		}
	},
	{#State 173
		ACTIONS => {
			";" => 246
		}
	},
	{#State 174
		DEFAULT => -60
	},
	{#State 175
		ACTIONS => {
			"+" => 158,
			"?" => 159,
			'DIV' => 161,
			"/" => 157,
			'AND' => 155,
			'BINOP' => 160,
			'OR' => 162,
			'MOD' => 164,
			'CAT' => 163,
			'CMPOP' => 156
		},
		DEFAULT => -47
	},
	{#State 176
		DEFAULT => -68
	},
	{#State 177
		ACTIONS => {
			"/" => 157,
			'AND' => 155,
			"+" => 158,
			'DIV' => 161,
			"?" => 159,
			'BINOP' => 160,
			'MOD' => 164,
			'OR' => 162,
			'CMPOP' => 156,
			'CAT' => 163
		},
		DEFAULT => -49
	},
	{#State 178
		ACTIONS => {
			'CMPOP' => 156,
			'CAT' => 163,
			'MOD' => 164,
			'OR' => 162,
			'BINOP' => 160,
			'AND' => 155,
			"/" => 157,
			"?" => 159,
			"+" => 158,
			'DIV' => 161
		},
		DEFAULT => -63
	},
	{#State 179
		DEFAULT => -82
	},
	{#State 180
		ACTIONS => {
			'IDENT' => 70,
			'NUMBER' => 54,
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			'NOT' => 22
		},
		GOTOS => {
			'term' => 72,
			'sterm' => 29,
			'lterm' => 23,
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'expr' => 247
		}
	},
	{#State 181
		ACTIONS => {
			'FOR' => 20,
			'NOT' => 22,
			";" => -19,
			'REF' => 28,
			'NEXT' => 66,
			'META' => 67,
			'LITERAL' => 59,
			'GET' => 60,
			"\$" => 26,
			'FILTER' => 61,
			'CALL' => 62,
			'USE' => 63,
			'IF' => 27,
			'perl' => 68,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'THROW' => 38,
			"\"" => 37,
			'VIEW' => 74,
			'STOP' => 75,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'LAST' => 3,
			'BLOCK' => 42,
			'WHILE' => 41,
			'SET' => 2,
			'RAW' => 44,
			'UNLESS' => 43,
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			'RETURN' => 45,
			'TRY' => 5,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'CLEAR' => 11,
			'MACRO' => 55,
			'INSERT' => 17,
			'rawperl' => 18,
			"{" => 53,
			'DEBUG' => 16,
			'NUMBER' => 54
		},
		DEFAULT => -3,
		GOTOS => {
			'chunks' => 40,
			'atomexpr' => 1,
			'assign' => 7,
			'block' => 46,
			'defblockname' => 4,
			'javascript' => 52,
			'atomdir' => 14,
			'filter' => 12,
			'use' => 10,
			'defblock' => 50,
			'setlist' => 9,
			'try' => 15,
			'macro' => 24,
			'wrapper' => 58,
			'lterm' => 23,
			'expr' => 57,
			'condition' => 21,
			'ident' => 19,
			'chunk' => 56,
			'sterm' => 29,
			'switch' => 65,
			'statement' => 64,
			'item' => 25,
			'raw' => 30,
			'view' => 31,
			'directive' => 69,
			'anonblock' => 73,
			'capture' => 39,
			'term' => 72,
			'loop' => 35,
			'template' => 248,
			'node' => 32
		}
	},
	{#State 182
		DEFAULT => -98
	},
	{#State 183
		DEFAULT => -99
	},
	{#State 184
		ACTIONS => {
			'NUMBER' => 250,
			'LITERAL' => 249,
			"\"" => 251
		}
	},
	{#State 185
		ACTIONS => {
			'CATCH' => 253,
			'FINAL' => 252
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 254
		}
	},
	{#State 186
		DEFAULT => -107
	},
	{#State 187
		ACTIONS => {
			"\"" => 37,
			"\${" => 47,
			'REF' => 28,
			'NUMBER' => 54,
			'IDENT' => 70,
			"\$" => 26,
			'LITERAL' => 95
		},
		GOTOS => {
			'ident' => 92,
			'item' => 25,
			'node' => 32,
			'sterm' => 255
		}
	},
	{#State 188
		DEFAULT => -106
	},
	{#State 189
		DEFAULT => -116
	},
	{#State 190
		DEFAULT => -115
	},
	{#State 191
		ACTIONS => {
			'LITERAL' => 98,
			'FILENAME' => 101,
			'IDENT' => 97,
			'NUMBER' => 99,
			"\"" => 105
		},
		GOTOS => {
			'filename' => 104,
			'filepart' => 106,
			'name' => 256
		}
	},
	{#State 192
		DEFAULT => -157,
		GOTOS => {
			'args' => 257
		}
	},
	{#State 193
		ACTIONS => {
			'NOT' => 22,
			'COMMA' => 259,
			'LITERAL' => 258,
			"\$" => 26,
			"(" => 48,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			'IDENT' => 70,
			'NUMBER' => 54,
			"{" => 53,
			"\"" => 37
		},
		DEFAULT => -164,
		GOTOS => {
			'item' => 262,
			'node' => 32,
			'sterm' => 29,
			'term' => 72,
			'param' => 261,
			'ident' => 263,
			'expr' => 260,
			'lterm' => 23
		}
	},
	{#State 194
		ACTIONS => {
			'IDENT' => 97,
			'NUMBER' => 99,
			'FILENAME' => 101
		},
		GOTOS => {
			'filepart' => 264
		}
	},
	{#State 195
		ACTIONS => {
			"\"" => 265,
			";" => 210,
			"\${" => 47,
			'TEXT' => 209,
			'IDENT' => 70,
			"\$" => 26
		},
		GOTOS => {
			'item' => 25,
			'node' => 32,
			'quotable' => 213,
			'ident' => 211
		}
	},
	{#State 196
		ACTIONS => {
			'DOT' => 113
		},
		DEFAULT => -157,
		GOTOS => {
			'args' => 266
		}
	},
	{#State 197
		ACTIONS => {
			'OR' => 162,
			'CMPOP' => 156,
			'IDENT' => -151,
			'AND' => 155,
			'DIV' => 161,
			"?" => 159,
			"+" => 158,
			"\${" => -151,
			";" => -151,
			'MOD' => 164,
			'CAT' => 163,
			'LITERAL' => -151,
			"\$" => -151,
			'COMMA' => -151,
			"/" => 157,
			'BINOP' => 160
		},
		DEFAULT => -28
	},
	{#State 198
		DEFAULT => -93
	},
	{#State 199
		DEFAULT => -90
	},
	{#State 200
		ACTIONS => {
			";" => 267
		}
	},
	{#State 201
		DEFAULT => -127
	},
	{#State 202
		DEFAULT => -126
	},
	{#State 203
		ACTIONS => {
			'NOT' => 22,
			'IDENT' => 70,
			'COMMA' => 259,
			'NUMBER' => 54,
			'LITERAL' => 258,
			"\$" => 26,
			"{" => 53,
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"\${" => 47,
			"[" => 6
		},
		DEFAULT => -66,
		GOTOS => {
			'expr' => 260,
			'ident' => 263,
			'param' => 261,
			'lterm' => 23,
			'node' => 32,
			'item' => 262,
			'sterm' => 29,
			'term' => 72
		}
	},
	{#State 204
		ACTIONS => {
			"\"" => 37,
			"[" => 6,
			"\${" => 47,
			'REF' => 28,
			'NUMBER' => 54,
			'IDENT' => 70,
			"{" => 53,
			"\$" => 26,
			'LITERAL' => 95
		},
		GOTOS => {
			'node' => 32,
			'item' => 25,
			'ident' => 92,
			'lterm' => 23,
			'sterm' => 29,
			'term' => 268
		}
	},
	{#State 205
		ACTIONS => {
			"{" => 53,
			"\$" => 26,
			'LITERAL' => 95,
			'NUMBER' => 54,
			'IDENT' => 70,
			"\${" => 47,
			"[" => 6,
			'REF' => 28,
			"\"" => 37
		},
		GOTOS => {
			'ident' => 92,
			'node' => 32,
			'item' => 25,
			'term' => 269,
			'sterm' => 29,
			'lterm' => 23
		}
	},
	{#State 206
		DEFAULT => -58,
		GOTOS => {
			'@1-3' => 270
		}
	},
	{#State 207
		ACTIONS => {
			'COMMA' => 259,
			'NUMBER' => 54,
			'IDENT' => 70,
			"{" => 53,
			'LITERAL' => 258,
			"\$" => 26,
			"\"" => 37,
			"(" => 48,
			"\${" => 47,
			"[" => 6,
			")" => 271,
			'REF' => 28,
			'NOT' => 22
		},
		GOTOS => {
			'node' => 32,
			'item' => 262,
			'term' => 72,
			'sterm' => 29,
			'ident' => 263,
			'param' => 261,
			'expr' => 260,
			'lterm' => 23
		}
	},
	{#State 208
		ACTIONS => {
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'CLEAR' => 11,
			'MACRO' => 55,
			'rawperl' => 18,
			'INSERT' => 17,
			"{" => 53,
			'DEBUG' => 16,
			'NUMBER' => 54,
			'LAST' => 3,
			'SET' => 2,
			'BLOCK' => 42,
			'WHILE' => 41,
			'RAW' => 44,
			'UNLESS' => 43,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			'TRY' => 5,
			'RETURN' => 45,
			'perl' => 68,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'STOP' => 75,
			'VIEW' => 74,
			"\"" => 37,
			'THROW' => 38,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'NOT' => 22,
			'FOR' => 20,
			'REF' => 28,
			";" => -19,
			'META' => 67,
			'NEXT' => 66,
			'GET' => 60,
			'LITERAL' => 59,
			"\$" => 26,
			'CALL' => 62,
			'IF' => 27,
			'USE' => 63,
			'FILTER' => 61
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 4,
			'item' => 25,
			'statement' => 64,
			'sterm' => 29,
			'switch' => 65,
			'block' => 272,
			'assign' => 7,
			'atomexpr' => 1,
			'chunks' => 40,
			'ident' => 19,
			'chunk' => 56,
			'condition' => 21,
			'expr' => 57,
			'lterm' => 23,
			'wrapper' => 58,
			'macro' => 24,
			'try' => 15,
			'node' => 32,
			'loop' => 35,
			'term' => 72,
			'capture' => 39,
			'anonblock' => 73,
			'setlist' => 9,
			'defblock' => 50,
			'use' => 10,
			'directive' => 69,
			'atomdir' => 14,
			'filter' => 12,
			'javascript' => 52,
			'view' => 31,
			'raw' => 30
		}
	},
	{#State 209
		DEFAULT => -179
	},
	{#State 210
		DEFAULT => -180
	},
	{#State 211
		ACTIONS => {
			'DOT' => 113
		},
		DEFAULT => -178
	},
	{#State 212
		DEFAULT => -112
	},
	{#State 213
		DEFAULT => -176
	},
	{#State 214
		DEFAULT => -61,
		GOTOS => {
			'@2-3' => 273
		}
	},
	{#State 215
		ACTIONS => {
			'UNLESS' => 43,
			'RAW' => 44,
			'WHILE' => 41,
			'BLOCK' => 42,
			'LAST' => 3,
			'SET' => 2,
			'RETURN' => 45,
			'TRY' => 5,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'CLEAR' => 11,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'NUMBER' => 54,
			'DEBUG' => 16,
			"{" => 53,
			'INSERT' => 17,
			'rawperl' => 18,
			'MACRO' => 55,
			'FOR' => 20,
			'NOT' => 22,
			'FILTER' => 61,
			'USE' => 63,
			'CALL' => 62,
			'IF' => 27,
			"\$" => 26,
			'GET' => 60,
			'LITERAL' => 59,
			'NEXT' => 66,
			'META' => 67,
			";" => -19,
			'REF' => 28,
			'perl' => 68,
			'IDENT' => 70,
			'INCLUDE' => 33,
			"\"" => 37,
			'THROW' => 38,
			'STOP' => 75,
			'VIEW' => 74,
			'DEFAULT' => 36,
			'SWITCH' => 71
		},
		DEFAULT => -3,
		GOTOS => {
			'defblockname' => 4,
			'item' => 25,
			'statement' => 64,
			'sterm' => 29,
			'switch' => 65,
			'block' => 274,
			'assign' => 7,
			'chunks' => 40,
			'ident' => 19,
			'atomexpr' => 1,
			'chunk' => 56,
			'condition' => 21,
			'expr' => 57,
			'lterm' => 23,
			'wrapper' => 58,
			'macro' => 24,
			'node' => 32,
			'try' => 15,
			'loop' => 35,
			'term' => 72,
			'capture' => 39,
			'anonblock' => 73,
			'setlist' => 9,
			'defblock' => 50,
			'use' => 10,
			'directive' => 69,
			'atomdir' => 14,
			'filter' => 12,
			'javascript' => 52,
			'raw' => 30,
			'view' => 31
		}
	},
	{#State 216
		ACTIONS => {
			'UNLESS' => 43,
			'RAW' => 44,
			'LAST' => 3,
			'WHILE' => 41,
			'BLOCK' => 42,
			'SET' => 2,
			"(" => 48,
			"\${" => 47,
			"[" => 6,
			'RETURN' => 45,
			'TRY' => 5,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'CLEAR' => 11,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'INSERT' => 17,
			'rawperl' => 18,
			'MACRO' => 55,
			'NUMBER' => 54,
			"{" => 53,
			'DEBUG' => 16,
			'FOR' => 20,
			'NOT' => 22,
			'NEXT' => 66,
			'META' => 67,
			";" => -19,
			'REF' => 28,
			'FILTER' => 61,
			'IF' => 27,
			'USE' => 63,
			'CALL' => 62,
			"\$" => 26,
			'GET' => 60,
			'LITERAL' => 59,
			'perl' => 68,
			'THROW' => 38,
			"\"" => 37,
			'VIEW' => 74,
			'STOP' => 75,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'IDENT' => 70,
			'INCLUDE' => 33
		},
		DEFAULT => -3,
		GOTOS => {
			'defblock' => 50,
			'use' => 10,
			'setlist' => 9,
			'javascript' => 52,
			'view' => 31,
			'raw' => 30,
			'atomdir' => 14,
			'directive' => 69,
			'filter' => 12,
			'loop' => 35,
			'node' => 32,
			'try' => 15,
			'capture' => 39,
			'anonblock' => 73,
			'term' => 72,
			'expr' => 57,
			'condition' => 21,
			'ident' => 19,
			'atomexpr' => 1,
			'chunks' => 40,
			'chunk' => 56,
			'macro' => 24,
			'wrapper' => 58,
			'lterm' => 23,
			'statement' => 64,
			'defblockname' => 4,
			'item' => 25,
			'assign' => 7,
			'switch' => 65,
			'sterm' => 29,
			'block' => 275
		}
	},
	{#State 217
		ACTIONS => {
			"\"" => 105,
			'IDENT' => 97,
			'NUMBER' => 99,
			'LITERAL' => 98,
			"\$" => 107,
			'FILENAME' => 101
		},
		GOTOS => {
			'names' => 103,
			'filename' => 104,
			'name' => 100,
			'filepart' => 106,
			'nameargs' => 276
		}
	},
	{#State 218
		ACTIONS => {
			'ASSIGN' => -133
		},
		DEFAULT => -131
	},
	{#State 219
		ACTIONS => {
			"\"" => 277,
			'TEXT' => 209,
			"\${" => 47,
			";" => 210,
			'IDENT' => 70,
			"\$" => 26
		},
		GOTOS => {
			'ident' => 211,
			'quotable' => 213,
			'item' => 25,
			'node' => 32
		}
	},
	{#State 220
		DEFAULT => -132
	},
	{#State 221
		DEFAULT => -145
	},
	{#State 222
		DEFAULT => -146
	},
	{#State 223
		ACTIONS => {
			'NOT' => 22,
			'FOR' => 20,
			'REF' => 28,
			";" => -19,
			'META' => 67,
			'NEXT' => 66,
			'LITERAL' => 59,
			"\$" => 26,
			'GET' => 60,
			'IF' => 27,
			'CALL' => 62,
			'USE' => 63,
			'FILTER' => 61,
			'perl' => 68,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			'STOP' => 75,
			'VIEW' => 74,
			'THROW' => 38,
			"\"" => 37,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'BLOCK' => 42,
			'LAST' => 3,
			'WHILE' => 41,
			'SET' => 2,
			'RAW' => 44,
			'UNLESS' => 43,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			'TRY' => 5,
			'RETURN' => 45,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'CLEAR' => 11,
			'MACRO' => 55,
			'rawperl' => 18,
			'INSERT' => 17,
			'DEBUG' => 16,
			"{" => 53,
			'NUMBER' => 54
		},
		DEFAULT => -3,
		GOTOS => {
			'macro' => 24,
			'lterm' => 23,
			'wrapper' => 58,
			'expr' => 57,
			'condition' => 21,
			'chunk' => 56,
			'ident' => 19,
			'chunks' => 40,
			'atomexpr' => 1,
			'assign' => 7,
			'block' => 278,
			'sterm' => 29,
			'switch' => 65,
			'statement' => 64,
			'item' => 25,
			'defblockname' => 4,
			'javascript' => 52,
			'raw' => 30,
			'view' => 31,
			'filter' => 12,
			'directive' => 69,
			'atomdir' => 14,
			'defblock' => 50,
			'use' => 10,
			'setlist' => 9,
			'capture' => 39,
			'anonblock' => 73,
			'term' => 72,
			'loop' => 35,
			'node' => 32,
			'try' => 15
		}
	},
	{#State 224
		ACTIONS => {
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			'RETURN' => 45,
			'TRY' => 5,
			'LAST' => 3,
			'BLOCK' => 42,
			'WHILE' => 41,
			'SET' => 2,
			'RAW' => 44,
			'UNLESS' => 43,
			'MACRO' => 55,
			'INSERT' => 17,
			'rawperl' => 18,
			'DEBUG' => 16,
			"{" => 53,
			'NUMBER' => 54,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'CLEAR' => 11,
			";" => -19,
			'REF' => 28,
			'NEXT' => 66,
			'META' => 67,
			'GET' => 60,
			'LITERAL' => 59,
			"\$" => 26,
			'FILTER' => 61,
			'CALL' => 62,
			'USE' => 63,
			'IF' => 27,
			'FOR' => 20,
			'NOT' => 22,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			"\"" => 37,
			'THROW' => 38,
			'STOP' => 75,
			'VIEW' => 74,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'perl' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'try' => 15,
			'node' => 32,
			'loop' => 35,
			'term' => 72,
			'anonblock' => 73,
			'capture' => 39,
			'setlist' => 9,
			'defblock' => 50,
			'use' => 10,
			'filter' => 12,
			'directive' => 69,
			'atomdir' => 14,
			'javascript' => 52,
			'raw' => 30,
			'view' => 31,
			'item' => 25,
			'defblockname' => 4,
			'statement' => 64,
			'block' => 279,
			'switch' => 65,
			'sterm' => 29,
			'assign' => 7,
			'chunk' => 56,
			'chunks' => 40,
			'ident' => 19,
			'atomexpr' => 1,
			'condition' => 21,
			'expr' => 57,
			'wrapper' => 58,
			'lterm' => 23,
			'macro' => 24
		}
	},
	{#State 225
		DEFAULT => -109
	},
	{#State 226
		DEFAULT => -121
	},
	{#State 227
		DEFAULT => -122
	},
	{#State 228
		ACTIONS => {
			"\${" => 47,
			"[" => 6,
			'REF' => 28,
			"\"" => 37,
			"(" => 48,
			"{" => 53,
			"\$" => 26,
			'LITERAL' => 95,
			'NUMBER' => 54,
			'IDENT' => 70,
			'NOT' => 22
		},
		GOTOS => {
			'term' => 72,
			'sterm' => 29,
			'lterm' => 23,
			'expr' => 280,
			'ident' => 92,
			'node' => 32,
			'item' => 25
		}
	},
	{#State 229
		ACTIONS => {
			'NOT' => 22,
			'NUMBER' => 54,
			'IDENT' => 70,
			"{" => 53,
			"\$" => 26,
			'LITERAL' => 95,
			"\"" => 37,
			"(" => 48,
			"\${" => 47,
			"[" => 6,
			'REF' => 28
		},
		GOTOS => {
			'lterm' => 23,
			'term' => 72,
			'sterm' => 29,
			'expr' => 281,
			'node' => 32,
			'item' => 25,
			'ident' => 92
		}
	},
	{#State 230
		ACTIONS => {
			'AND' => 155,
			"+" => 158,
			"?" => 159,
			'DIV' => 161,
			'CMPOP' => 156,
			'OR' => 162,
			'BINOP' => 160,
			"/" => 157,
			'CAT' => 163,
			'MOD' => 164
		},
		DEFAULT => -28
	},
	{#State 231
		DEFAULT => -92
	},
	{#State 232
		ACTIONS => {
			"\"" => 37,
			"(" => 48,
			"\${" => 47,
			"[" => 6,
			'REF' => 28,
			'NUMBER' => 54,
			'IDENT' => 283,
			"{" => 53,
			'LITERAL' => 59,
			"\$" => 26,
			'NOT' => 22
		},
		GOTOS => {
			'assign' => 144,
			'term' => 72,
			'sterm' => 29,
			'item' => 25,
			'node' => 32,
			'lterm' => 23,
			'expr' => 146,
			'margs' => 282,
			'ident' => 145
		}
	},
	{#State 233
		ACTIONS => {
			'DIV' => 161,
			"+" => 158,
			'BINOP' => 160,
			'MOD' => 164,
			'CAT' => 163,
			'CMPOP' => 156,
			"/" => 157
		},
		DEFAULT => -141
	},
	{#State 234
		ACTIONS => {
			"/" => 157,
			'MOD' => 164,
			'BINOP' => 160,
			"+" => 158,
			'DIV' => 161
		},
		DEFAULT => -139
	},
	{#State 235
		ACTIONS => {
			'DIV' => 161,
			'MOD' => 164
		},
		DEFAULT => -135
	},
	{#State 236
		ACTIONS => {
			"/" => 157,
			'DIV' => 161,
			'MOD' => 164
		},
		DEFAULT => -136
	},
	{#State 237
		ACTIONS => {
			'CAT' => 163,
			'CMPOP' => 156,
			'MOD' => 164,
			'OR' => 162,
			":" => 284,
			'BINOP' => 160,
			"/" => 157,
			'AND' => 155,
			'DIV' => 161,
			"+" => 158,
			"?" => 159
		}
	},
	{#State 238
		ACTIONS => {
			'MOD' => 164,
			"+" => 158,
			'DIV' => 161,
			"/" => 157
		},
		DEFAULT => -134
	},
	{#State 239
		ACTIONS => {
			'MOD' => 164
		},
		DEFAULT => -137
	},
	{#State 240
		ACTIONS => {
			"/" => 157,
			'CMPOP' => 156,
			'BINOP' => 160,
			'MOD' => 164,
			'CAT' => 163,
			'DIV' => 161,
			"+" => 158
		},
		DEFAULT => -142
	},
	{#State 241
		ACTIONS => {
			'BINOP' => 160,
			'MOD' => 164,
			'DIV' => 161,
			"+" => 158,
			"/" => 157,
			'CMPOP' => 156
		},
		DEFAULT => -140
	},
	{#State 242
		DEFAULT => -138
	},
	{#State 243
		ACTIONS => {
			'AND' => 155,
			"?" => 159,
			"+" => 158,
			'DIV' => 161,
			'OR' => 162,
			'CMPOP' => 156,
			"/" => 157,
			'BINOP' => 160,
			'MOD' => 164,
			'CAT' => 163
		},
		DEFAULT => -152
	},
	{#State 244
		ACTIONS => {
			'RAW' => 44,
			'UNLESS' => 43,
			'WHILE' => 41,
			'SET' => 2,
			'LAST' => 3,
			'BLOCK' => 42,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'TRY' => 5,
			'RETURN' => 45,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'CLEAR' => 11,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'rawperl' => 18,
			'INSERT' => 17,
			'MACRO' => 55,
			'NUMBER' => 54,
			'DEBUG' => 16,
			"{" => 53,
			'NOT' => 22,
			'FOR' => 20,
			'META' => 67,
			'NEXT' => 66,
			'REF' => 28,
			";" => -19,
			'IF' => 27,
			'USE' => 63,
			'CALL' => 62,
			'FILTER' => 61,
			'GET' => 60,
			"\$" => 26,
			'LITERAL' => 59,
			'perl' => 68,
			'STOP' => 75,
			'VIEW' => 74,
			'THROW' => 38,
			"\"" => 37,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			'IDENT' => 70,
			'INCLUDE' => 33
		},
		DEFAULT => -3,
		GOTOS => {
			'term' => 72,
			'anonblock' => 73,
			'capture' => 39,
			'try' => 15,
			'node' => 32,
			'loop' => 35,
			'atomdir' => 14,
			'directive' => 69,
			'filter' => 12,
			'javascript' => 52,
			'raw' => 30,
			'view' => 31,
			'setlist' => 9,
			'defblock' => 50,
			'use' => 10,
			'sterm' => 29,
			'switch' => 65,
			'block' => 285,
			'assign' => 7,
			'defblockname' => 4,
			'item' => 25,
			'statement' => 64,
			'lterm' => 23,
			'wrapper' => 58,
			'macro' => 24,
			'atomexpr' => 1,
			'ident' => 19,
			'chunks' => 40,
			'chunk' => 56,
			'condition' => 21,
			'expr' => 57
		}
	},
	{#State 245
		ACTIONS => {
			'TRY' => 5,
			'RETURN' => 45,
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			'LAST' => 3,
			'SET' => 2,
			'BLOCK' => 42,
			'WHILE' => 41,
			'RAW' => 44,
			'UNLESS' => 43,
			"{" => 53,
			'DEBUG' => 16,
			'NUMBER' => 54,
			'MACRO' => 55,
			'rawperl' => 18,
			'INSERT' => 17,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'CLEAR' => 11,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			"\$" => 26,
			'LITERAL' => 59,
			'GET' => 60,
			'IF' => 27,
			'USE' => 63,
			'CALL' => 62,
			'FILTER' => 61,
			'REF' => 28,
			";" => -19,
			'META' => 67,
			'NEXT' => 66,
			'NOT' => 22,
			'FOR' => 20,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			'VIEW' => 74,
			'STOP' => 75,
			'THROW' => 38,
			"\"" => 37,
			'perl' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'try' => 15,
			'node' => 32,
			'loop' => 35,
			'term' => 72,
			'capture' => 39,
			'anonblock' => 73,
			'setlist' => 9,
			'use' => 10,
			'defblock' => 50,
			'filter' => 12,
			'directive' => 69,
			'atomdir' => 14,
			'raw' => 30,
			'view' => 31,
			'javascript' => 52,
			'item' => 25,
			'defblockname' => 4,
			'statement' => 64,
			'block' => 286,
			'sterm' => 29,
			'switch' => 65,
			'assign' => 7,
			'chunk' => 56,
			'chunks' => 40,
			'atomexpr' => 1,
			'ident' => 19,
			'expr' => 57,
			'condition' => 21,
			'wrapper' => 58,
			'lterm' => 23,
			'macro' => 24
		}
	},
	{#State 246
		DEFAULT => -77,
		GOTOS => {
			'@3-3' => 287
		}
	},
	{#State 247
		ACTIONS => {
			'MOD' => 164,
			'CAT' => 163,
			"/" => 157,
			'BINOP' => 160,
			'OR' => 162,
			'CMPOP' => 156,
			'AND' => 155,
			"+" => 158,
			"?" => 159,
			'DIV' => 161
		},
		DEFAULT => -151
	},
	{#State 248
		ACTIONS => {
			'END' => 288
		}
	},
	{#State 249
		DEFAULT => -101
	},
	{#State 250
		DEFAULT => -103
	},
	{#State 251
		ACTIONS => {
			'TEXT' => 289
		}
	},
	{#State 252
		ACTIONS => {
			";" => 290
		}
	},
	{#State 253
		ACTIONS => {
			'IDENT' => 97,
			'NUMBER' => 99,
			'FILENAME' => 101,
			'DEFAULT' => 293,
			";" => 291
		},
		GOTOS => {
			'filepart' => 106,
			'filename' => 292
		}
	},
	{#State 254
		ACTIONS => {
			'END' => 294
		}
	},
	{#State 255
		DEFAULT => -118
	},
	{#State 256
		DEFAULT => -166
	},
	{#State 257
		ACTIONS => {
			'LITERAL' => 258,
			"\$" => 26,
			"{" => 53,
			'IDENT' => 70,
			'COMMA' => 259,
			'NUMBER' => 54,
			'REF' => 28,
			")" => 295,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			"\"" => 37,
			'NOT' => 22
		},
		GOTOS => {
			'sterm' => 29,
			'term' => 72,
			'node' => 32,
			'item' => 262,
			'lterm' => 23,
			'expr' => 260,
			'param' => 261,
			'ident' => 263
		}
	},
	{#State 258
		ACTIONS => {
			'ASSIGN' => 229
		},
		DEFAULT => -113
	},
	{#State 259
		DEFAULT => -156
	},
	{#State 260
		ACTIONS => {
			'CAT' => 163,
			'MOD' => 164,
			'BINOP' => 160,
			"/" => 157,
			'CMPOP' => 156,
			'OR' => 162,
			'DIV' => 161,
			"?" => 159,
			"+" => 158,
			'AND' => 155
		},
		DEFAULT => -153
	},
	{#State 261
		DEFAULT => -154
	},
	{#State 262
		ACTIONS => {
			"(" => 118,
			'ASSIGN' => 228
		},
		DEFAULT => -129
	},
	{#State 263
		ACTIONS => {
			'ASSIGN' => 296,
			'DOT' => 113
		},
		DEFAULT => -110
	},
	{#State 264
		DEFAULT => -171
	},
	{#State 265
		DEFAULT => -168
	},
	{#State 266
		ACTIONS => {
			"(" => 48,
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			'COMMA' => 259,
			"\$" => 26,
			'LITERAL' => 258,
			'NOT' => 22,
			"\"" => 37,
			'IDENT' => 70,
			'NUMBER' => 54,
			"{" => 53
		},
		DEFAULT => -163,
		GOTOS => {
			'item' => 262,
			'node' => 32,
			'term' => 72,
			'sterm' => 29,
			'ident' => 263,
			'param' => 261,
			'expr' => 260,
			'lterm' => 23
		}
	},
	{#State 267
		ACTIONS => {
			'perl' => 68,
			"\"" => 37,
			'THROW' => 38,
			'STOP' => 75,
			'VIEW' => 74,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'IDENT' => 70,
			'INCLUDE' => 33,
			'FOR' => 20,
			'NOT' => 22,
			'NEXT' => 66,
			'META' => 67,
			";" => -19,
			'REF' => 28,
			'FILTER' => 61,
			'USE' => 63,
			'CALL' => 62,
			'IF' => 27,
			"\$" => 26,
			'LITERAL' => 59,
			'GET' => 60,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'CLEAR' => 11,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'INSERT' => 17,
			'rawperl' => 18,
			'MACRO' => 55,
			'NUMBER' => 54,
			"{" => 53,
			'DEBUG' => 16,
			'UNLESS' => 43,
			'RAW' => 44,
			'BLOCK' => 42,
			'LAST' => 3,
			'WHILE' => 41,
			'SET' => 2,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'RETURN' => 45,
			'TRY' => 5
		},
		DEFAULT => -3,
		GOTOS => {
			'javascript' => 52,
			'view' => 31,
			'raw' => 30,
			'atomdir' => 14,
			'directive' => 69,
			'filter' => 12,
			'use' => 10,
			'defblock' => 50,
			'setlist' => 9,
			'capture' => 39,
			'anonblock' => 73,
			'term' => 72,
			'loop' => 35,
			'node' => 32,
			'try' => 15,
			'macro' => 24,
			'lterm' => 23,
			'wrapper' => 58,
			'expr' => 57,
			'condition' => 21,
			'chunks' => 40,
			'atomexpr' => 1,
			'ident' => 19,
			'chunk' => 56,
			'assign' => 7,
			'sterm' => 29,
			'switch' => 65,
			'block' => 297,
			'statement' => 64,
			'defblockname' => 4,
			'item' => 25
		}
	},
	{#State 268
		DEFAULT => -157,
		GOTOS => {
			'args' => 298
		}
	},
	{#State 269
		DEFAULT => -157,
		GOTOS => {
			'args' => 299
		}
	},
	{#State 270
		ACTIONS => {
			'perl' => 68,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			'STOP' => 75,
			'VIEW' => 74,
			'THROW' => 38,
			"\"" => 37,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'NOT' => 22,
			'FOR' => 20,
			'REF' => 28,
			";" => -19,
			'META' => 67,
			'NEXT' => 66,
			"\$" => 26,
			'GET' => 60,
			'LITERAL' => 59,
			'USE' => 63,
			'CALL' => 62,
			'IF' => 27,
			'FILTER' => 61,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'CLEAR' => 11,
			'MACRO' => 55,
			'rawperl' => 18,
			'INSERT' => 17,
			"{" => 53,
			'DEBUG' => 16,
			'NUMBER' => 54,
			'LAST' => 3,
			'SET' => 2,
			'WHILE' => 41,
			'BLOCK' => 42,
			'RAW' => 44,
			'UNLESS' => 43,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			'TRY' => 5,
			'RETURN' => 45
		},
		DEFAULT => -3,
		GOTOS => {
			'chunk' => 56,
			'ident' => 19,
			'chunks' => 40,
			'atomexpr' => 1,
			'condition' => 21,
			'expr' => 57,
			'lterm' => 23,
			'wrapper' => 58,
			'macro' => 24,
			'item' => 25,
			'defblockname' => 4,
			'statement' => 64,
			'block' => 300,
			'switch' => 65,
			'sterm' => 29,
			'assign' => 7,
			'setlist' => 9,
			'defblock' => 50,
			'use' => 10,
			'filter' => 12,
			'atomdir' => 14,
			'directive' => 69,
			'raw' => 30,
			'javascript' => 52,
			'view' => 31,
			'node' => 32,
			'try' => 15,
			'loop' => 35,
			'term' => 72,
			'capture' => 39,
			'anonblock' => 73
		}
	},
	{#State 271
		DEFAULT => -130
	},
	{#State 272
		ACTIONS => {
			'ELSIF' => 302,
			'ELSE' => 303
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 301
		}
	},
	{#State 273
		ACTIONS => {
			'FOR' => 20,
			'NOT' => 22,
			"\$" => 26,
			'LITERAL' => 59,
			'GET' => 60,
			'FILTER' => 61,
			'USE' => 63,
			'IF' => 27,
			'CALL' => 62,
			";" => -19,
			'REF' => 28,
			'NEXT' => 66,
			'META' => 67,
			'perl' => 68,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			"\"" => 37,
			'THROW' => 38,
			'STOP' => 75,
			'VIEW' => 74,
			'LAST' => 3,
			'BLOCK' => 42,
			'SET' => 2,
			'WHILE' => 41,
			'UNLESS' => 43,
			'RAW' => 44,
			'RETURN' => 45,
			'TRY' => 5,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'CLEAR' => 11,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'DEBUG' => 16,
			"{" => 53,
			'NUMBER' => 54,
			'MACRO' => 55,
			'INSERT' => 17,
			'rawperl' => 18
		},
		DEFAULT => -3,
		GOTOS => {
			'anonblock' => 73,
			'capture' => 39,
			'term' => 72,
			'loop' => 35,
			'node' => 32,
			'try' => 15,
			'view' => 31,
			'javascript' => 52,
			'raw' => 30,
			'filter' => 12,
			'atomdir' => 14,
			'directive' => 69,
			'use' => 10,
			'defblock' => 50,
			'setlist' => 9,
			'assign' => 7,
			'block' => 304,
			'sterm' => 29,
			'switch' => 65,
			'statement' => 64,
			'item' => 25,
			'defblockname' => 4,
			'macro' => 24,
			'wrapper' => 58,
			'lterm' => 23,
			'condition' => 21,
			'expr' => 57,
			'chunk' => 56,
			'chunks' => 40,
			'atomexpr' => 1,
			'ident' => 19
		}
	},
	{#State 274
		ACTIONS => {
			'END' => 305
		}
	},
	{#State 275
		ACTIONS => {
			'ELSIF' => 302,
			'ELSE' => 303
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 306
		}
	},
	{#State 276
		DEFAULT => -158
	},
	{#State 277
		ACTIONS => {
			'ASSIGN' => -161
		},
		DEFAULT => -168
	},
	{#State 278
		ACTIONS => {
			'END' => 307
		}
	},
	{#State 279
		ACTIONS => {
			'END' => 308
		}
	},
	{#State 280
		ACTIONS => {
			'BINOP' => 160,
			'MOD' => 164,
			'CAT' => 163,
			"+" => 158,
			"?" => 159,
			'DIV' => 161,
			'OR' => 162,
			"/" => 157,
			'AND' => 155,
			'CMPOP' => 156
		},
		DEFAULT => -125
	},
	{#State 281
		ACTIONS => {
			'OR' => 162,
			'DIV' => 161,
			"+" => 158,
			"?" => 159,
			'CAT' => 163,
			'MOD' => 164,
			'BINOP' => 160,
			'CMPOP' => 156,
			'AND' => 155,
			"/" => 157
		},
		DEFAULT => -124
	},
	{#State 282
		ACTIONS => {
			'IDENT' => 310,
			'COMMA' => 309,
			")" => 311
		}
	},
	{#State 283
		ACTIONS => {
			")" => -97,
			'COMMA' => -97,
			'IDENT' => -97
		},
		DEFAULT => -131
	},
	{#State 284
		ACTIONS => {
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			'IDENT' => 70,
			'NUMBER' => 54,
			"\$" => 26,
			'LITERAL' => 95,
			"{" => 53,
			'NOT' => 22
		},
		GOTOS => {
			'lterm' => 23,
			'sterm' => 29,
			'term' => 72,
			'expr' => 312,
			'node' => 32,
			'item' => 25,
			'ident' => 92
		}
	},
	{#State 285
		ACTIONS => {
			'END' => 313
		}
	},
	{#State 286
		ACTIONS => {
			'CASE' => 315
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 314
		}
	},
	{#State 287
		ACTIONS => {
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'TRY' => 5,
			'RETURN' => 45,
			'UNLESS' => 43,
			'RAW' => 44,
			'SET' => 2,
			'BLOCK' => 42,
			'WHILE' => 41,
			'LAST' => 3,
			'rawperl' => 18,
			'INSERT' => 17,
			'MACRO' => 55,
			'NUMBER' => 54,
			'DEBUG' => 16,
			"{" => 53,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'CLEAR' => 11,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'META' => 67,
			'NEXT' => 66,
			'REF' => 28,
			";" => -19,
			'USE' => 63,
			'CALL' => 62,
			'IF' => 27,
			'FILTER' => 61,
			'GET' => 60,
			'LITERAL' => 59,
			"\$" => 26,
			'NOT' => 22,
			'FOR' => 20,
			'STOP' => 75,
			'VIEW' => 74,
			'THROW' => 38,
			"\"" => 37,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'IDENT' => 70,
			'INCLUDE' => 33,
			'perl' => 68
		},
		DEFAULT => -3,
		GOTOS => {
			'sterm' => 29,
			'switch' => 65,
			'block' => 316,
			'assign' => 7,
			'defblockname' => 4,
			'item' => 25,
			'statement' => 64,
			'lterm' => 23,
			'wrapper' => 58,
			'macro' => 24,
			'ident' => 19,
			'chunks' => 40,
			'atomexpr' => 1,
			'chunk' => 56,
			'expr' => 57,
			'condition' => 21,
			'term' => 72,
			'capture' => 39,
			'anonblock' => 73,
			'try' => 15,
			'node' => 32,
			'loop' => 35,
			'atomdir' => 14,
			'directive' => 69,
			'filter' => 12,
			'raw' => 30,
			'javascript' => 52,
			'view' => 31,
			'setlist' => 9,
			'use' => 10,
			'defblock' => 50
		}
	},
	{#State 288
		DEFAULT => -83
	},
	{#State 289
		ACTIONS => {
			"\"" => 317
		}
	},
	{#State 290
		ACTIONS => {
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'CLEAR' => 11,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			"{" => 53,
			'DEBUG' => 16,
			'NUMBER' => 54,
			'MACRO' => 55,
			'rawperl' => 18,
			'INSERT' => 17,
			'SET' => 2,
			'LAST' => 3,
			'BLOCK' => 42,
			'WHILE' => 41,
			'UNLESS' => 43,
			'RAW' => 44,
			'TRY' => 5,
			'RETURN' => 45,
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			'perl' => 68,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'STOP' => 75,
			'VIEW' => 74,
			"\"" => 37,
			'THROW' => 38,
			'NOT' => 22,
			'FOR' => 20,
			"\$" => 26,
			'GET' => 60,
			'LITERAL' => 59,
			'USE' => 63,
			'IF' => 27,
			'CALL' => 62,
			'FILTER' => 61,
			'REF' => 28,
			";" => -19,
			'META' => 67,
			'NEXT' => 66
		},
		DEFAULT => -3,
		GOTOS => {
			'capture' => 39,
			'anonblock' => 73,
			'term' => 72,
			'loop' => 35,
			'node' => 32,
			'try' => 15,
			'raw' => 30,
			'view' => 31,
			'javascript' => 52,
			'directive' => 69,
			'atomdir' => 14,
			'filter' => 12,
			'defblock' => 50,
			'use' => 10,
			'setlist' => 9,
			'assign' => 7,
			'sterm' => 29,
			'switch' => 65,
			'block' => 318,
			'statement' => 64,
			'defblockname' => 4,
			'item' => 25,
			'macro' => 24,
			'lterm' => 23,
			'wrapper' => 58,
			'condition' => 21,
			'expr' => 57,
			'chunks' => 40,
			'atomexpr' => 1,
			'ident' => 19,
			'chunk' => 56
		}
	},
	{#State 291
		ACTIONS => {
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'CLEAR' => 11,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'DEBUG' => 16,
			"{" => 53,
			'NUMBER' => 54,
			'MACRO' => 55,
			'INSERT' => 17,
			'rawperl' => 18,
			'WHILE' => 41,
			'SET' => 2,
			'LAST' => 3,
			'BLOCK' => 42,
			'UNLESS' => 43,
			'RAW' => 44,
			'RETURN' => 45,
			'TRY' => 5,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			'perl' => 68,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'THROW' => 38,
			"\"" => 37,
			'VIEW' => 74,
			'STOP' => 75,
			'FOR' => 20,
			'NOT' => 22,
			'GET' => 60,
			'LITERAL' => 59,
			"\$" => 26,
			'FILTER' => 61,
			'USE' => 63,
			'CALL' => 62,
			'IF' => 27,
			";" => -19,
			'REF' => 28,
			'NEXT' => 66,
			'META' => 67
		},
		DEFAULT => -3,
		GOTOS => {
			'capture' => 39,
			'anonblock' => 73,
			'term' => 72,
			'loop' => 35,
			'try' => 15,
			'node' => 32,
			'raw' => 30,
			'javascript' => 52,
			'view' => 31,
			'filter' => 12,
			'atomdir' => 14,
			'directive' => 69,
			'defblock' => 50,
			'use' => 10,
			'setlist' => 9,
			'assign' => 7,
			'block' => 319,
			'sterm' => 29,
			'switch' => 65,
			'statement' => 64,
			'item' => 25,
			'defblockname' => 4,
			'macro' => 24,
			'lterm' => 23,
			'wrapper' => 58,
			'condition' => 21,
			'expr' => 57,
			'chunk' => 56,
			'chunks' => 40,
			'ident' => 19,
			'atomexpr' => 1
		}
	},
	{#State 292
		ACTIONS => {
			'DOT' => 194,
			";" => 320
		}
	},
	{#State 293
		ACTIONS => {
			";" => 321
		}
	},
	{#State 294
		DEFAULT => -69
	},
	{#State 295
		DEFAULT => -165
	},
	{#State 296
		ACTIONS => {
			'NOT' => 22,
			'REF' => 28,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			"\"" => 37,
			"\$" => 26,
			'LITERAL' => 95,
			"{" => 53,
			'IDENT' => 70,
			'NUMBER' => 54
		},
		GOTOS => {
			'lterm' => 23,
			'sterm' => 29,
			'term' => 72,
			'item' => 25,
			'node' => 32,
			'ident' => 92,
			'expr' => 322
		}
	},
	{#State 297
		ACTIONS => {
			'END' => 323
		}
	},
	{#State 298
		ACTIONS => {
			"\"" => 37,
			"(" => 48,
			"\${" => 47,
			"[" => 6,
			'REF' => 28,
			'NUMBER' => 54,
			'COMMA' => 259,
			'IDENT' => 70,
			"{" => 53,
			'LITERAL' => 258,
			"\$" => 26,
			'NOT' => 22
		},
		DEFAULT => -65,
		GOTOS => {
			'item' => 262,
			'node' => 32,
			'sterm' => 29,
			'term' => 72,
			'param' => 261,
			'ident' => 263,
			'expr' => 260,
			'lterm' => 23
		}
	},
	{#State 299
		ACTIONS => {
			'NOT' => 22,
			"(" => 48,
			"\"" => 37,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			'IDENT' => 70,
			'NUMBER' => 54,
			'COMMA' => 259,
			'LITERAL' => 258,
			"\$" => 26,
			"{" => 53
		},
		DEFAULT => -64,
		GOTOS => {
			'term' => 72,
			'sterm' => 29,
			'node' => 32,
			'item' => 262,
			'lterm' => 23,
			'expr' => 260,
			'param' => 261,
			'ident' => 263
		}
	},
	{#State 300
		ACTIONS => {
			'END' => 324
		}
	},
	{#State 301
		ACTIONS => {
			'END' => 325
		}
	},
	{#State 302
		ACTIONS => {
			'LITERAL' => 95,
			"\$" => 26,
			"{" => 53,
			'IDENT' => 70,
			'NUMBER' => 54,
			'REF' => 28,
			"\${" => 47,
			"[" => 6,
			"(" => 48,
			"\"" => 37,
			'NOT' => 22
		},
		GOTOS => {
			'sterm' => 29,
			'term' => 72,
			'lterm' => 23,
			'expr' => 326,
			'ident' => 92,
			'item' => 25,
			'node' => 32
		}
	},
	{#State 303
		ACTIONS => {
			";" => 327
		}
	},
	{#State 304
		ACTIONS => {
			'END' => 328
		}
	},
	{#State 305
		DEFAULT => -89
	},
	{#State 306
		ACTIONS => {
			'END' => 329
		}
	},
	{#State 307
		DEFAULT => -67
	},
	{#State 308
		DEFAULT => -80
	},
	{#State 309
		DEFAULT => -96
	},
	{#State 310
		DEFAULT => -95
	},
	{#State 311
		ACTIONS => {
			'NOT' => 22,
			'FOR' => 20,
			'NEXT' => 66,
			'REF' => 28,
			'CALL' => 62,
			'IF' => 27,
			'FILTER' => 61,
			"\$" => 26,
			'LITERAL' => 59,
			'GET' => 60,
			'perl' => 68,
			'STOP' => 75,
			'THROW' => 38,
			"\"" => 37,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			'IDENT' => 70,
			'INCLUDE' => 33,
			'UNLESS' => 43,
			'SET' => 2,
			'WHILE' => 41,
			'LAST' => 3,
			'BLOCK' => 200,
			"(" => 48,
			"\${" => 47,
			"[" => 6,
			'TRY' => 5,
			'RETURN' => 45,
			'JAVASCRIPT' => 51,
			'CLEAR' => 11,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'INSERT' => 17,
			'NUMBER' => 54,
			'DEBUG' => 16,
			"{" => 53
		},
		GOTOS => {
			'assign' => 7,
			'sterm' => 29,
			'switch' => 65,
			'item' => 25,
			'wrapper' => 58,
			'lterm' => 23,
			'condition' => 21,
			'expr' => 230,
			'ident' => 145,
			'atomexpr' => 1,
			'mdir' => 330,
			'term' => 72,
			'loop' => 35,
			'try' => 15,
			'node' => 32,
			'javascript' => 52,
			'filter' => 12,
			'atomdir' => 14,
			'directive' => 198,
			'setlist' => 9
		}
	},
	{#State 312
		ACTIONS => {
			"?" => 159,
			"+" => 158,
			'DIV' => 161,
			'OR' => 162,
			'BINOP' => 160,
			'MOD' => 164,
			'CAT' => 163,
			'AND' => 155,
			'CMPOP' => 156,
			"/" => 157
		},
		DEFAULT => -144
	},
	{#State 313
		DEFAULT => -81
	},
	{#State 314
		ACTIONS => {
			'END' => 331
		}
	},
	{#State 315
		ACTIONS => {
			'NUMBER' => 54,
			'IDENT' => 70,
			"{" => 53,
			'LITERAL' => 95,
			"\$" => 26,
			"\"" => 37,
			"\${" => 47,
			"[" => 6,
			";" => 332,
			'DEFAULT' => 333,
			'REF' => 28
		},
		GOTOS => {
			'sterm' => 29,
			'term' => 334,
			'lterm' => 23,
			'ident' => 92,
			'item' => 25,
			'node' => 32
		}
	},
	{#State 316
		ACTIONS => {
			'END' => 335
		}
	},
	{#State 317
		DEFAULT => -102
	},
	{#State 318
		DEFAULT => -73
	},
	{#State 319
		ACTIONS => {
			'FINAL' => 252,
			'CATCH' => 253
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 336
		}
	},
	{#State 320
		ACTIONS => {
			'IDENT' => 70,
			'INCLUDE' => 33,
			"\"" => 37,
			'THROW' => 38,
			'VIEW' => 74,
			'STOP' => 75,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			'perl' => 68,
			'FILTER' => 61,
			'USE' => 63,
			'IF' => 27,
			'CALL' => 62,
			"\$" => 26,
			'LITERAL' => 59,
			'GET' => 60,
			'NEXT' => 66,
			'META' => 67,
			";" => -19,
			'REF' => 28,
			'FOR' => 20,
			'NOT' => 22,
			'NUMBER' => 54,
			"{" => 53,
			'DEBUG' => 16,
			'INSERT' => 17,
			'rawperl' => 18,
			'MACRO' => 55,
			'CLEAR' => 11,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'RETURN' => 45,
			'TRY' => 5,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'RAW' => 44,
			'UNLESS' => 43,
			'LAST' => 3,
			'WHILE' => 41,
			'SET' => 2,
			'BLOCK' => 42
		},
		DEFAULT => -3,
		GOTOS => {
			'condition' => 21,
			'expr' => 57,
			'chunk' => 56,
			'chunks' => 40,
			'atomexpr' => 1,
			'ident' => 19,
			'macro' => 24,
			'lterm' => 23,
			'wrapper' => 58,
			'statement' => 64,
			'item' => 25,
			'defblockname' => 4,
			'assign' => 7,
			'block' => 337,
			'sterm' => 29,
			'switch' => 65,
			'defblock' => 50,
			'use' => 10,
			'setlist' => 9,
			'raw' => 30,
			'view' => 31,
			'javascript' => 52,
			'filter' => 12,
			'atomdir' => 14,
			'directive' => 69,
			'loop' => 35,
			'node' => 32,
			'try' => 15,
			'anonblock' => 73,
			'capture' => 39,
			'term' => 72
		}
	},
	{#State 321
		ACTIONS => {
			'CLEAR' => 11,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'NUMBER' => 54,
			"{" => 53,
			'DEBUG' => 16,
			'rawperl' => 18,
			'INSERT' => 17,
			'MACRO' => 55,
			'RAW' => 44,
			'UNLESS' => 43,
			'BLOCK' => 42,
			'WHILE' => 41,
			'LAST' => 3,
			'SET' => 2,
			'TRY' => 5,
			'RETURN' => 45,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'perl' => 68,
			'IDENT' => 70,
			'INCLUDE' => 33,
			'VIEW' => 74,
			'STOP' => 75,
			'THROW' => 38,
			"\"" => 37,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'NOT' => 22,
			'FOR' => 20,
			'IF' => 27,
			'CALL' => 62,
			'USE' => 63,
			'FILTER' => 61,
			'GET' => 60,
			"\$" => 26,
			'LITERAL' => 59,
			'META' => 67,
			'NEXT' => 66,
			'REF' => 28,
			";" => -19
		},
		DEFAULT => -3,
		GOTOS => {
			'node' => 32,
			'try' => 15,
			'loop' => 35,
			'term' => 72,
			'capture' => 39,
			'anonblock' => 73,
			'setlist' => 9,
			'use' => 10,
			'defblock' => 50,
			'filter' => 12,
			'directive' => 69,
			'atomdir' => 14,
			'view' => 31,
			'javascript' => 52,
			'raw' => 30,
			'item' => 25,
			'defblockname' => 4,
			'statement' => 64,
			'block' => 338,
			'sterm' => 29,
			'switch' => 65,
			'assign' => 7,
			'chunk' => 56,
			'ident' => 19,
			'chunks' => 40,
			'atomexpr' => 1,
			'condition' => 21,
			'expr' => 57,
			'wrapper' => 58,
			'lterm' => 23,
			'macro' => 24
		}
	},
	{#State 322
		ACTIONS => {
			'CAT' => 163,
			'MOD' => 164,
			'BINOP' => 160,
			"/" => 157,
			'CMPOP' => 156,
			'OR' => 162,
			'DIV' => 161,
			"+" => 158,
			"?" => 159,
			'AND' => 155
		},
		DEFAULT => -155
	},
	{#State 323
		DEFAULT => -94
	},
	{#State 324
		DEFAULT => -59
	},
	{#State 325
		DEFAULT => -46
	},
	{#State 326
		ACTIONS => {
			";" => 339,
			'MOD' => 164,
			'OR' => 162,
			'CMPOP' => 156,
			'CAT' => 163,
			'AND' => 155,
			"/" => 157,
			"?" => 159,
			"+" => 158,
			'DIV' => 161,
			'BINOP' => 160
		}
	},
	{#State 327
		ACTIONS => {
			'FOR' => 20,
			'NOT' => 22,
			'FILTER' => 61,
			'CALL' => 62,
			'USE' => 63,
			'IF' => 27,
			'GET' => 60,
			'LITERAL' => 59,
			"\$" => 26,
			'NEXT' => 66,
			'META' => 67,
			";" => -19,
			'REF' => 28,
			'perl' => 68,
			'IDENT' => 70,
			'INCLUDE' => 33,
			"\"" => 37,
			'THROW' => 38,
			'VIEW' => 74,
			'STOP' => 75,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			'UNLESS' => 43,
			'RAW' => 44,
			'WHILE' => 41,
			'BLOCK' => 42,
			'LAST' => 3,
			'SET' => 2,
			'RETURN' => 45,
			'TRY' => 5,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'CLEAR' => 11,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'NUMBER' => 54,
			"{" => 53,
			'DEBUG' => 16,
			'INSERT' => 17,
			'rawperl' => 18,
			'MACRO' => 55
		},
		DEFAULT => -3,
		GOTOS => {
			'macro' => 24,
			'wrapper' => 58,
			'lterm' => 23,
			'expr' => 57,
			'condition' => 21,
			'ident' => 19,
			'chunks' => 40,
			'atomexpr' => 1,
			'chunk' => 56,
			'assign' => 7,
			'sterm' => 29,
			'switch' => 65,
			'block' => 340,
			'statement' => 64,
			'defblockname' => 4,
			'item' => 25,
			'view' => 31,
			'javascript' => 52,
			'raw' => 30,
			'directive' => 69,
			'atomdir' => 14,
			'filter' => 12,
			'use' => 10,
			'defblock' => 50,
			'setlist' => 9,
			'anonblock' => 73,
			'capture' => 39,
			'term' => 72,
			'loop' => 35,
			'try' => 15,
			'node' => 32
		}
	},
	{#State 328
		DEFAULT => -62
	},
	{#State 329
		DEFAULT => -48
	},
	{#State 330
		DEFAULT => -91
	},
	{#State 331
		DEFAULT => -53
	},
	{#State 332
		ACTIONS => {
			'perl' => 68,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			"\"" => 37,
			'THROW' => 38,
			'STOP' => 75,
			'VIEW' => 74,
			'FOR' => 20,
			'NOT' => 22,
			"\$" => 26,
			'GET' => 60,
			'LITERAL' => 59,
			'FILTER' => 61,
			'IF' => 27,
			'USE' => 63,
			'CALL' => 62,
			";" => -19,
			'REF' => 28,
			'NEXT' => 66,
			'META' => 67,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'CLEAR' => 11,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			"{" => 53,
			'DEBUG' => 16,
			'NUMBER' => 54,
			'MACRO' => 55,
			'INSERT' => 17,
			'rawperl' => 18,
			'SET' => 2,
			'BLOCK' => 42,
			'LAST' => 3,
			'WHILE' => 41,
			'UNLESS' => 43,
			'RAW' => 44,
			'RETURN' => 45,
			'TRY' => 5,
			"[" => 6,
			"\${" => 47,
			"(" => 48
		},
		DEFAULT => -3,
		GOTOS => {
			'block' => 341,
			'sterm' => 29,
			'switch' => 65,
			'assign' => 7,
			'item' => 25,
			'defblockname' => 4,
			'statement' => 64,
			'lterm' => 23,
			'wrapper' => 58,
			'macro' => 24,
			'chunk' => 56,
			'ident' => 19,
			'chunks' => 40,
			'atomexpr' => 1,
			'expr' => 57,
			'condition' => 21,
			'term' => 72,
			'anonblock' => 73,
			'capture' => 39,
			'node' => 32,
			'try' => 15,
			'loop' => 35,
			'filter' => 12,
			'directive' => 69,
			'atomdir' => 14,
			'view' => 31,
			'javascript' => 52,
			'raw' => 30,
			'setlist' => 9,
			'defblock' => 50,
			'use' => 10
		}
	},
	{#State 333
		ACTIONS => {
			";" => 342
		}
	},
	{#State 334
		ACTIONS => {
			";" => 343
		}
	},
	{#State 335
		DEFAULT => -78
	},
	{#State 336
		DEFAULT => -72
	},
	{#State 337
		ACTIONS => {
			'CATCH' => 253,
			'FINAL' => 252
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 344
		}
	},
	{#State 338
		ACTIONS => {
			'CATCH' => 253,
			'FINAL' => 252
		},
		DEFAULT => -74,
		GOTOS => {
			'final' => 345
		}
	},
	{#State 339
		ACTIONS => {
			'perl' => 68,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'VIEW' => 74,
			'STOP' => 75,
			"\"" => 37,
			'THROW' => 38,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'NOT' => 22,
			'FOR' => 20,
			'REF' => 28,
			";" => -19,
			'META' => 67,
			'NEXT' => 66,
			'LITERAL' => 59,
			"\$" => 26,
			'GET' => 60,
			'IF' => 27,
			'USE' => 63,
			'CALL' => 62,
			'FILTER' => 61,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'WRAPPER' => 49,
			'PROCESS' => 8,
			'CLEAR' => 11,
			'MACRO' => 55,
			'rawperl' => 18,
			'INSERT' => 17,
			"{" => 53,
			'DEBUG' => 16,
			'NUMBER' => 54,
			'BLOCK' => 42,
			'LAST' => 3,
			'WHILE' => 41,
			'SET' => 2,
			'RAW' => 44,
			'UNLESS' => 43,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			'TRY' => 5,
			'RETURN' => 45
		},
		DEFAULT => -3,
		GOTOS => {
			'switch' => 65,
			'sterm' => 29,
			'block' => 346,
			'assign' => 7,
			'defblockname' => 4,
			'item' => 25,
			'statement' => 64,
			'wrapper' => 58,
			'lterm' => 23,
			'macro' => 24,
			'chunks' => 40,
			'ident' => 19,
			'atomexpr' => 1,
			'chunk' => 56,
			'expr' => 57,
			'condition' => 21,
			'term' => 72,
			'capture' => 39,
			'anonblock' => 73,
			'try' => 15,
			'node' => 32,
			'loop' => 35,
			'directive' => 69,
			'atomdir' => 14,
			'filter' => 12,
			'view' => 31,
			'raw' => 30,
			'javascript' => 52,
			'setlist' => 9,
			'use' => 10,
			'defblock' => 50
		}
	},
	{#State 340
		DEFAULT => -51
	},
	{#State 341
		DEFAULT => -56
	},
	{#State 342
		ACTIONS => {
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'CLEAR' => 11,
			'TEXT' => 13,
			'JAVASCRIPT' => 51,
			'DEBUG' => 16,
			"{" => 53,
			'NUMBER' => 54,
			'MACRO' => 55,
			'rawperl' => 18,
			'INSERT' => 17,
			'WHILE' => 41,
			'LAST' => 3,
			'SET' => 2,
			'BLOCK' => 42,
			'UNLESS' => 43,
			'RAW' => 44,
			'TRY' => 5,
			'RETURN' => 45,
			"[" => 6,
			"\${" => 47,
			"(" => 48,
			'perl' => 68,
			'INCLUDE' => 33,
			'IDENT' => 70,
			'DEFAULT' => 36,
			'SWITCH' => 71,
			'VIEW' => 74,
			'STOP' => 75,
			'THROW' => 38,
			"\"" => 37,
			'NOT' => 22,
			'FOR' => 20,
			'LITERAL' => 59,
			"\$" => 26,
			'GET' => 60,
			'USE' => 63,
			'IF' => 27,
			'CALL' => 62,
			'FILTER' => 61,
			'REF' => 28,
			";" => -19,
			'META' => 67,
			'NEXT' => 66
		},
		DEFAULT => -3,
		GOTOS => {
			'loop' => 35,
			'try' => 15,
			'node' => 32,
			'anonblock' => 73,
			'capture' => 39,
			'term' => 72,
			'use' => 10,
			'defblock' => 50,
			'setlist' => 9,
			'view' => 31,
			'raw' => 30,
			'javascript' => 52,
			'filter' => 12,
			'atomdir' => 14,
			'directive' => 69,
			'statement' => 64,
			'item' => 25,
			'defblockname' => 4,
			'assign' => 7,
			'block' => 347,
			'sterm' => 29,
			'switch' => 65,
			'expr' => 57,
			'condition' => 21,
			'chunk' => 56,
			'atomexpr' => 1,
			'ident' => 19,
			'chunks' => 40,
			'macro' => 24,
			'lterm' => 23,
			'wrapper' => 58
		}
	},
	{#State 343
		ACTIONS => {
			'CLEAR' => 11,
			'PROCESS' => 8,
			'WRAPPER' => 49,
			'JAVASCRIPT' => 51,
			'TEXT' => 13,
			'NUMBER' => 54,
			'DEBUG' => 16,
			"{" => 53,
			'rawperl' => 18,
			'INSERT' => 17,
			'MACRO' => 55,
			'RAW' => 44,
			'UNLESS' => 43,
			'LAST' => 3,
			'SET' => 2,
			'BLOCK' => 42,
			'WHILE' => 41,
			'TRY' => 5,
			'RETURN' => 45,
			"(" => 48,
			"[" => 6,
			"\${" => 47,
			'perl' => 68,
			'IDENT' => 70,
			'INCLUDE' => 33,
			'VIEW' => 74,
			'STOP' => 75,
			"\"" => 37,
			'THROW' => 38,
			'SWITCH' => 71,
			'DEFAULT' => 36,
			'NOT' => 22,
			'FOR' => 20,
			'USE' => 63,
			'CALL' => 62,
			'IF' => 27,
			'FILTER' => 61,
			'LITERAL' => 59,
			"\$" => 26,
			'GET' => 60,
			'META' => 67,
			'NEXT' => 66,
			'REF' => 28,
			";" => -19
		},
		DEFAULT => -3,
		GOTOS => {
			'node' => 32,
			'try' => 15,
			'loop' => 35,
			'term' => 72,
			'anonblock' => 73,
			'capture' => 39,
			'setlist' => 9,
			'use' => 10,
			'defblock' => 50,
			'atomdir' => 14,
			'directive' => 69,
			'filter' => 12,
			'javascript' => 52,
			'view' => 31,
			'raw' => 30,
			'defblockname' => 4,
			'item' => 25,
			'statement' => 64,
			'switch' => 65,
			'sterm' => 29,
			'block' => 348,
			'assign' => 7,
			'chunks' => 40,
			'ident' => 19,
			'atomexpr' => 1,
			'chunk' => 56,
			'expr' => 57,
			'condition' => 21,
			'lterm' => 23,
			'wrapper' => 58,
			'macro' => 24
		}
	},
	{#State 344
		DEFAULT => -70
	},
	{#State 345
		DEFAULT => -71
	},
	{#State 346
		ACTIONS => {
			'ELSIF' => 302,
			'ELSE' => 303
		},
		DEFAULT => -52,
		GOTOS => {
			'else' => 349
		}
	},
	{#State 347
		DEFAULT => -55
	},
	{#State 348
		ACTIONS => {
			'CASE' => 315
		},
		DEFAULT => -57,
		GOTOS => {
			'case' => 350
		}
	},
	{#State 349
		DEFAULT => -50
	},
	{#State 350
		DEFAULT => -54
	}
]; 


#========================================================================
# Rules
#========================================================================

$RULES = [
	[#Rule 0
		 '$start', 2, undef
	],
	[#Rule 1
		 'template', 1,
sub
#line 68 "Parser.yp"
{ $factory->template($_[1])           }
	],
	[#Rule 2
		 'block', 1,
sub
#line 71 "Parser.yp"
{ $factory->block($_[1])              }
	],
	[#Rule 3
		 'block', 0,
sub
#line 72 "Parser.yp"
{ $factory->block()                   }
	],
	[#Rule 4
		 'chunks', 2,
sub
#line 75 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
					if defined $_[2]; $_[1]           }
	],
	[#Rule 5
		 'chunks', 1,
sub
#line 77 "Parser.yp"
{ defined $_[1] ? [ $_[1] ] : [ ]     }
	],
	[#Rule 6
		 'chunk', 1,
sub
#line 80 "Parser.yp"
{ $factory->textblock($_[1])          }
	],
	[#Rule 7
		 'chunk', 2,
sub
#line 81 "Parser.yp"
{ return '' unless $_[1];
                           $_[0]->location() . $_[1];
                         }
	],
	[#Rule 8
		 'statement', 1, undef
	],
	[#Rule 9
		 'statement', 1, undef
	],
	[#Rule 10
		 'statement', 1, undef
	],
	[#Rule 11
		 'statement', 1, undef
	],
	[#Rule 12
		 'statement', 1, undef
	],
	[#Rule 13
		 'statement', 1, undef
	],
	[#Rule 14
		 'statement', 1, undef
	],
	[#Rule 15
		 'statement', 1, undef
	],
	[#Rule 16
		 'statement', 1, undef
	],
	[#Rule 17
		 'statement', 1,
sub
#line 95 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 18
		 'statement', 2,
sub
#line 96 "Parser.yp"
{ $_[0]->add_metadata($_[2]);         }
	],
	[#Rule 19
		 'statement', 0, undef
	],
	[#Rule 20
		 'directive', 1,
sub
#line 100 "Parser.yp"
{ $factory->set($_[1])                }
	],
	[#Rule 21
		 'directive', 1, undef
	],
	[#Rule 22
		 'directive', 1, undef
	],
	[#Rule 23
		 'directive', 1, undef
	],
	[#Rule 24
		 'directive', 1, undef
	],
	[#Rule 25
		 'directive', 1, undef
	],
	[#Rule 26
		 'directive', 1, undef
	],
	[#Rule 27
		 'directive', 1, undef
	],
	[#Rule 28
		 'atomexpr', 1,
sub
#line 115 "Parser.yp"
{ $factory->get($_[1])                }
	],
	[#Rule 29
		 'atomexpr', 1, undef
	],
	[#Rule 30
		 'atomdir', 2,
sub
#line 119 "Parser.yp"
{ $factory->get($_[2])                }
	],
	[#Rule 31
		 'atomdir', 2,
sub
#line 120 "Parser.yp"
{ $factory->call($_[2])               }
	],
	[#Rule 32
		 'atomdir', 2,
sub
#line 121 "Parser.yp"
{ $factory->set($_[2])                }
	],
	[#Rule 33
		 'atomdir', 2,
sub
#line 122 "Parser.yp"
{ $factory->default($_[2])            }
	],
	[#Rule 34
		 'atomdir', 2,
sub
#line 123 "Parser.yp"
{ $factory->insert($_[2])             }
	],
	[#Rule 35
		 'atomdir', 2,
sub
#line 124 "Parser.yp"
{ $factory->include($_[2])            }
	],
	[#Rule 36
		 'atomdir', 2,
sub
#line 125 "Parser.yp"
{ $factory->process($_[2])            }
	],
	[#Rule 37
		 'atomdir', 2,
sub
#line 126 "Parser.yp"
{ $factory->throw($_[2])              }
	],
	[#Rule 38
		 'atomdir', 1,
sub
#line 127 "Parser.yp"
{ $factory->return()                  }
	],
	[#Rule 39
		 'atomdir', 1,
sub
#line 128 "Parser.yp"
{ $factory->stop()                    }
	],
	[#Rule 40
		 'atomdir', 1,
sub
#line 129 "Parser.yp"
{ $factory->clear()                   }
	],
	[#Rule 41
		 'atomdir', 1,
sub
#line 130 "Parser.yp"
{ $factory->break()                   }
	],
	[#Rule 42
		 'atomdir', 1,
sub
#line 131 "Parser.yp"
{ $factory->next()                    }
	],
	[#Rule 43
		 'atomdir', 2,
sub
#line 132 "Parser.yp"
{ if ($_[2]->[0]->[0] =~ /^'(on|off)'$/) {
				          $_[0]->{ DEBUG_DIRS } = ($1 eq 'on');
					  $factory->debug($_[2]);
				      }
				      else {
					  $_[0]->{ DEBUG_DIRS } ? $factory->debug($_[2]) : '';
				      }
				    }
	],
	[#Rule 44
		 'atomdir', 1, undef
	],
	[#Rule 45
		 'atomdir', 1, undef
	],
	[#Rule 46
		 'condition', 6,
sub
#line 145 "Parser.yp"
{ $factory->if(@_[2, 4, 5])           }
	],
	[#Rule 47
		 'condition', 3,
sub
#line 146 "Parser.yp"
{ $factory->if(@_[3, 1])              }
	],
	[#Rule 48
		 'condition', 6,
sub
#line 148 "Parser.yp"
{ $factory->if("tt2_not($_[2])", @_[4, 5])  }
	],
	[#Rule 49
		 'condition', 3,
sub
#line 149 "Parser.yp"
{ $factory->if("tt2_not($_[3])", $_[1])     }
	],
	[#Rule 50
		 'else', 5,
sub
#line 153 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]);
				      $_[5];                              }
	],
	[#Rule 51
		 'else', 3,
sub
#line 155 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 52
		 'else', 0,
sub
#line 156 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 53
		 'switch', 6,
sub
#line 160 "Parser.yp"
{ $factory->switch(@_[2, 5])          }
	],
	[#Rule 54
		 'case', 5,
sub
#line 164 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2, 4] ]); 
				      $_[5];                              }
	],
	[#Rule 55
		 'case', 4,
sub
#line 166 "Parser.yp"
{ [ $_[4] ]                           }
	],
	[#Rule 56
		 'case', 3,
sub
#line 167 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 57
		 'case', 0,
sub
#line 168 "Parser.yp"
{ [ undef ]                           }
	],
	[#Rule 58
		 '@1-3', 0,
sub
#line 171 "Parser.yp"
{ $_[0]->{ INFOR }++                  }
	],
	[#Rule 59
		 'loop', 6,
sub
#line 172 "Parser.yp"
{ $_[0]->{ INFOR }--;
				      $factory->foreach(@{$_[2]}, $_[5])  }
	],
	[#Rule 60
		 'loop', 3,
sub
#line 176 "Parser.yp"
{ $factory->foreach(@{$_[3]}, $_[1])  }
	],
	[#Rule 61
		 '@2-3', 0,
sub
#line 177 "Parser.yp"
{ $_[0]->{ INWHILE }++                }
	],
	[#Rule 62
		 'loop', 6,
sub
#line 178 "Parser.yp"
{ $_[0]->{ INWHILE }--;
                                      $factory->while(@_[2, 5])           }
	],
	[#Rule 63
		 'loop', 3,
sub
#line 180 "Parser.yp"
{ $factory->while(@_[3, 1])           }
	],
	[#Rule 64
		 'loopvar', 4,
sub
#line 183 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 65
		 'loopvar', 4,
sub
#line 184 "Parser.yp"
{ [ @_[1, 3, 4] ]                     }
	],
	[#Rule 66
		 'loopvar', 2,
sub
#line 185 "Parser.yp"
{ [ 0, @_[1, 2] ]                     }
	],
	[#Rule 67
		 'wrapper', 5,
sub
#line 189 "Parser.yp"
{ $factory->wrapper(@_[2, 4])         }
	],
	[#Rule 68
		 'wrapper', 3,
sub
#line 191 "Parser.yp"
{ $factory->wrapper(@_[3, 1])         }
	],
	[#Rule 69
		 'try', 5,
sub
#line 195 "Parser.yp"
{ $factory->try(@_[3, 4])             }
	],
	[#Rule 70
		 'final', 5,
sub
#line 199 "Parser.yp"
{ unshift(@{$_[5]}, [ @_[2,4] ]);
				      $_[5];                              }
	],
	[#Rule 71
		 'final', 5,
sub
#line 202 "Parser.yp"
{ unshift(@{$_[5]}, [ undef, $_[4] ]);
				      $_[5];                              }
	],
	[#Rule 72
		 'final', 4,
sub
#line 205 "Parser.yp"
{ unshift(@{$_[4]}, [ undef, $_[3] ]);
				      $_[4];                              }
	],
	[#Rule 73
		 'final', 3,
sub
#line 207 "Parser.yp"
{ [ $_[3] ]                           }
	],
	[#Rule 74
		 'final', 0,
sub
#line 208 "Parser.yp"
{ [ 0 ] }
	],
	[#Rule 75
		 'use', 2,
sub
#line 211 "Parser.yp"
{ $factory->use($_[2])                }
	],
	[#Rule 76
		 'raw', 2,
sub
#line 214 "Parser.yp"
{ $factory->raw($_[2])                }
	],
	[#Rule 77
		 '@3-3', 0,
sub
#line 217 "Parser.yp"
{ $_[0]->push_defblock();		  }
	],
	[#Rule 78
		 'view', 6,
sub
#line 218 "Parser.yp"
{ $factory->view(@_[2,5], 
						     $_[0]->pop_defblock) }
	],
	[#Rule 79
		 '@4-2', 0,
sub
#line 222 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}++;             }
	],
	[#Rule 80
		 'javascript', 5,
sub
#line 223 "Parser.yp"
{ ${$_[0]->{ INJAVASCRIPT }}--;
				      $_[0]->{ EVAL_JAVASCRIPT } 
				      ? $factory->javascript($_[4])             
				      : $factory->no_javascript();              }
	],
	[#Rule 81
		 'filter', 5,
sub
#line 230 "Parser.yp"
{ $factory->filter(@_[2,4])           }
	],
	[#Rule 82
		 'filter', 3,
sub
#line 232 "Parser.yp"
{ $factory->filter(@_[3,1])           }
	],
	[#Rule 83
		 'defblock', 5,
sub
#line 237 "Parser.yp"
{ my $name = join('/', @{ $_[0]->{ DEFBLOCKS } });
				      pop(@{ $_[0]->{ DEFBLOCKS } });
				      $_[0]->define_block($name, $_[4]); 
				      undef
				    }
	],
	[#Rule 84
		 'defblockname', 2,
sub
#line 244 "Parser.yp"
{ push(@{ $_[0]->{ DEFBLOCKS } }, $_[2]);
				      $_[2];
				    }
	],
	[#Rule 85
		 'blockname', 1, undef
	],
	[#Rule 86
		 'blockname', 1,
sub
#line 250 "Parser.yp"
{ $_[1] =~ s/^'(.*)'$/$1/; $_[1]      }
	],
	[#Rule 87
		 'blockargs', 1, undef
	],
	[#Rule 88
		 'blockargs', 0, undef
	],
	[#Rule 89
		 'anonblock', 5,
sub
#line 258 "Parser.yp"
{ local $" = ', ';
				      print STDERR "experimental block args: [@{ $_[2] }]\n"
					  if $_[2];
				      $factory->anon_block($_[4])         }
	],
	[#Rule 90
		 'capture', 3,
sub
#line 264 "Parser.yp"
{ $factory->capture(@_[1, 3])         }
	],
	[#Rule 91
		 'macro', 6,
sub
#line 268 "Parser.yp"
{ $factory->macro(@_[2, 6, 4])        }
	],
	[#Rule 92
		 'macro', 3,
sub
#line 269 "Parser.yp"
{ $factory->macro(@_[2, 3])           }
	],
	[#Rule 93
		 'mdir', 1, undef
	],
	[#Rule 94
		 'mdir', 4,
sub
#line 273 "Parser.yp"
{ $_[3]                               }
	],
	[#Rule 95
		 'margs', 2,
sub
#line 276 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 96
		 'margs', 2,
sub
#line 277 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 97
		 'margs', 1,
sub
#line 278 "Parser.yp"
{ [ $_[1] ]                           }
	],
	[#Rule 98
		 'metadata', 2,
sub
#line 281 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 99
		 'metadata', 2, undef
	],
	[#Rule 100
		 'metadata', 1, undef
	],
	[#Rule 101
		 'meta', 3,
sub
#line 286 "Parser.yp"
{ for ($_[3]) { s/^'//; s/'$//; 
						       s/\\'/'/g  }; 
					 [ @_[1,3] ] }
	],
	[#Rule 102
		 'meta', 5,
sub
#line 289 "Parser.yp"
{ [ @_[1,4] ] }
	],
	[#Rule 103
		 'meta', 3,
sub
#line 290 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 104
		 'term', 1, undef
	],
	[#Rule 105
		 'term', 1, undef
	],
	[#Rule 106
		 'lterm', 3,
sub
#line 302 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 107
		 'lterm', 3,
sub
#line 303 "Parser.yp"
{ "{ $_[2] }"                         }
	],
	[#Rule 108
		 'lterm', 2,
sub
#line 304 "Parser.yp"
{ "{ }"                               }
	],
	[#Rule 109
		 'lterm', 3,
sub
#line 305 "Parser.yp"
{ "{ $_[2]  }"                        }
	],
	[#Rule 110
		 'sterm', 1,
sub
#line 308 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 111
		 'sterm', 2,
sub
#line 309 "Parser.yp"
{ $factory->identref($_[2])           }
	],
	[#Rule 112
		 'sterm', 3,
sub
#line 310 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 113
		 'sterm', 1, undef
	],
	[#Rule 114
		 'sterm', 1, undef
	],
	[#Rule 115
		 'list', 2,
sub
#line 315 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 116
		 'list', 2, undef
	],
	[#Rule 117
		 'list', 1, undef
	],
	[#Rule 118
		 'range', 3,
sub
#line 320 "Parser.yp"
{ $_[1] . '..' . $_[3]                }
	],
	[#Rule 119
		 'hash', 1, undef
	],
	[#Rule 120
		 'hash', 0,
sub
#line 325 "Parser.yp"
{ "" }
	],
	[#Rule 121
		 'params', 2,
sub
#line 328 "Parser.yp"
{ "$_[1], $_[2]"                      }
	],
	[#Rule 122
		 'params', 2, undef
	],
	[#Rule 123
		 'params', 1, undef
	],
	[#Rule 124
		 'param', 3,
sub
#line 333 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 125
		 'param', 3,
sub
#line 334 "Parser.yp"
{ "[$_[1]] = $_[3]"                    }
	],
	[#Rule 126
		 'ident', 3,
sub
#line 337 "Parser.yp"
{ push(@{$_[1]}, @{$_[3]}); $_[1]     }
	],
	[#Rule 127
		 'ident', 3,
sub
#line 338 "Parser.yp"
{ push(@{$_[1]}, 
					   map {($_, 0)} split(/\./, $_[3]));
				      $_[1];			          }
	],
	[#Rule 128
		 'ident', 1, undef
	],
	[#Rule 129
		 'node', 1,
sub
#line 344 "Parser.yp"
{ [ $_[1], 0 ]                        }
	],
	[#Rule 130
		 'node', 4,
sub
#line 345 "Parser.yp"
{ [ $_[1], $factory->args($_[3]) ]    }
	],
	[#Rule 131
		 'item', 1,
sub
#line 348 "Parser.yp"
{ "'$_[1]'"                           }
	],
	[#Rule 132
		 'item', 3,
sub
#line 349 "Parser.yp"
{ $_[2]                               }
	],
	[#Rule 133
		 'item', 2,
sub
#line 350 "Parser.yp"
{ $_[0]->{ V1DOLLAR }
				       ? "'$_[2]'" 
				       : $factory->ident(["'$_[2]'", 0])  }
	],
	[#Rule 134
		 'expr', 3,
sub
#line 355 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 135
		 'expr', 3,
sub
#line 356 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 136
		 'expr', 3,
sub
#line 357 "Parser.yp"
{ "$_[1] $_[2] $_[3]"                 }
	],
	[#Rule 137
		 'expr', 3,
sub
#line 358 "Parser.yp"
{ "math_floor($_[1] / $_[3])"         }
	],
	[#Rule 138
		 'expr', 3,
sub
#line 359 "Parser.yp"
{ "$_[1] % $_[3]"                     }
	],
	[#Rule 139
		 'expr', 3,
sub
#line 360 "Parser.yp"
{ "$_[1] $CMPOP{ $_[2] } $_[3]"       }
	],
	[#Rule 140
		 'expr', 3,
sub
#line 361 "Parser.yp"
{ "$_[1] .. $_[3]"                    }
	],
	[#Rule 141
		 'expr', 3,
sub
#line 362 "Parser.yp"
{ "tt2_true($_[1]) and tt2_true($_[3])"                   }
	],
	[#Rule 142
		 'expr', 3,
sub
#line 363 "Parser.yp"
{ "tt2_true($_[1]) or tt2_true($_[3])"                    }
	],
	[#Rule 143
		 'expr', 2,
sub
#line 364 "Parser.yp"
{ "tt2_not($_[2])"                         }
	],
	[#Rule 144
		 'expr', 5,
sub
#line 365 "Parser.yp"
{ "tt2_true($_[1]) and $_[3] or $_[5]"          }
	],
	[#Rule 145
		 'expr', 3,
sub
#line 366 "Parser.yp"
{ $factory->assign(@{$_[2]})          }
	],
	[#Rule 146
		 'expr', 3,
sub
#line 367 "Parser.yp"
{ "($_[2])"                           }
	],
	[#Rule 147
		 'expr', 1, undef
	],
	[#Rule 148
		 'setlist', 2,
sub
#line 371 "Parser.yp"
{ push(@{$_[1]}, @{$_[2]}); $_[1]     }
	],
	[#Rule 149
		 'setlist', 2, undef
	],
	[#Rule 150
		 'setlist', 1, undef
	],
	[#Rule 151
		 'assign', 3,
sub
#line 377 "Parser.yp"
{ [ $_[1], $_[3] ]                    }
	],
	[#Rule 152
		 'assign', 3,
sub
#line 378 "Parser.yp"
{ [ @_[1,3] ]                         }
	],
	[#Rule 153
		 'args', 2,
sub
#line 385 "Parser.yp"
{ push(@{$_[1]}, $_[2]); $_[1]        }
	],
	[#Rule 154
		 'args', 2,
sub
#line 386 "Parser.yp"
{ push(@{$_[1]->[0]}, $_[2]); $_[1]   }
	],
	[#Rule 155
		 'args', 4,
sub
#line 387 "Parser.yp"
{ push(@{$_[1]->[0]}, "'', " . 
				      $factory->assign(@_[2,4])); $_[1]  }
	],
	[#Rule 156
		 'args', 2,
sub
#line 389 "Parser.yp"
{ $_[1]                               }
	],
	[#Rule 157
		 'args', 0,
sub
#line 390 "Parser.yp"
{ [ [ ] ]                             }
	],
	[#Rule 158
		 'lnameargs', 3,
sub
#line 400 "Parser.yp"
{ push(@{$_[3]}, $_[1]); $_[3]        }
	],
	[#Rule 159
		 'lnameargs', 1, undef
	],
	[#Rule 160
		 'lvalue', 1, undef
	],
	[#Rule 161
		 'lvalue', 3,
sub
#line 405 "Parser.yp"
{ $factory->quoted($_[2])             }
	],
	[#Rule 162
		 'lvalue', 1, undef
	],
	[#Rule 163
		 'nameargs', 3,
sub
#line 409 "Parser.yp"
{ [ [$factory->ident($_[2])], $_[3] ]   }
	],
	[#Rule 164
		 'nameargs', 2,
sub
#line 410 "Parser.yp"
{ [ @_[1,2] ] }
	],
	[#Rule 165
		 'nameargs', 4,
sub
#line 411 "Parser.yp"
{ [ @_[1,3] ] }
	],
	[#Rule 166
		 'names', 3,
sub
#line 414 "Parser.yp"
{ push(@{$_[1]}, $_[3]); $_[1] }
	],
	[#Rule 167
		 'names', 1,
sub
#line 415 "Parser.yp"
{ [ $_[1] ]                    }
	],
	[#Rule 168
		 'name', 3,
sub
#line 418 "Parser.yp"
{ $factory->quoted($_[2])  }
	],
	[#Rule 169
		 'name', 1,
sub
#line 419 "Parser.yp"
{ "'$_[1]'" }
	],
	[#Rule 170
		 'name', 1, undef
	],
	[#Rule 171
		 'filename', 3,
sub
#line 431 "Parser.yp"
{ "$_[1].$_[3]" }
	],
	[#Rule 172
		 'filename', 1, undef
	],
	[#Rule 173
		 'filepart', 1, undef
	],
	[#Rule 174
		 'filepart', 1, undef
	],
	[#Rule 175
		 'filepart', 1, undef
	],
	[#Rule 176
		 'quoted', 2,
sub
#line 445 "Parser.yp"
{ push(@{$_[1]}, $_[2]) 
				          if defined $_[2]; $_[1]         }
	],
	[#Rule 177
		 'quoted', 0,
sub
#line 447 "Parser.yp"
{ [ ]                                 }
	],
	[#Rule 178
		 'quotable', 1,
sub
#line 450 "Parser.yp"
{ $factory->ident($_[1])              }
	],
	[#Rule 179
		 'quotable', 1,
sub
#line 451 "Parser.yp"
{ $factory->text($_[1])               }
	],
	[#Rule 180
		 'quotable', 1,
sub
#line 452 "Parser.yp"
{ undef                               }
	]
];

1;
