package Business::EDI::CodeList::BankOperationCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.02;
sub list_number {4383;}
my $usage       = 'B';

# 4383  Bank operation code                                     [B]
# Desc: Code specifying a bank operation.
# Repr: an..3

my %code_hash = (
'AAA' => [ 'Transfer according to bilaterally agreed standards',
    'The transfer is to be executed according to bilaterally agreed standards.' ],
'AAB' => [ 'Incoming international payment',
    'International payment that is incoming.' ],
'AAC' => [ 'Outgoing international payment',
    'International payment that is outgoing.' ],
'AAD' => [ 'Tax payment',
    'Payment of tax.' ],
'AAE' => [ 'Incoming OCR (Optical Character Recognition) payment',
    'OCR (Optical Character Recognition) payment that is incoming.' ],
'AAF' => [ 'Incoming retail direct debit',
    'Retail direct debit that is incoming.' ],
'AAG' => [ 'Incoming corporate direct debit',
    'Corporate direct debit that is incoming.' ],
'AAH' => [ 'Incoming paper-based payment',
    'Paper-based payment that is incoming.' ],
'AAI' => [ 'Zero-balancing transaction',
    'Transaction that is zero-balancing.' ],
'AAJ' => [ 'Safe deposit box',
    'To identify a bank operation as relating to a safe deposit box.' ],
'AAK' => [ 'Domestic money market',
    'To identify a bank operation as being a money market transaction effected on a domestic exchange.' ],
'AAL' => [ 'Foreign money market',
    'To identify a bank operation as being a money market transaction effected on a foreign exchange.' ],
'AAM' => [ 'Domestic bond market',
    'To identify a bank operation as being a bond transaction effected in a domestic market.' ],
'AAN' => [ 'International bond market',
    'To identify a bank operation as being a bond transaction effected in a international market.' ],
'AAO' => [ 'Funds',
    'To identify a bank operation as being for funds.' ],
'AAP' => [ 'Safe custody',
    'To identify a bank operation relating to safe custody.' ],
'AAQ' => [ 'Guarantee',
    'To identify a bank operation related to a guarantee.' ],
'AAR' => [ 'Short foreign credits',
    "To identify a bank operation as being for short credits granted to parties outside the bank's country." ],
'AAS' => [ 'Long foreign credits',
    "To identify a bank operation as being for long credits granted to parties outside the bank's country." ],
'AAT' => [ 'Promissory note loan',
    'Promissory note type of loan.' ],
'AAU' => [ 'Mortgage loan',
    'Mortgage type of loan.' ],
'AAV' => [ 'Salary',
    'To identify a bank operation as being for salary payments.' ],
'AAW' => [ 'Incoming bankgiro',
    'Bankgiro that is incoming.' ],
'ABX' => [ 'Automated bills of exchange',
    'The payment has been done by automated bills of exchange.' ],
'ABY' => [ 'Returned direct debit',
    "To identify a bank operation as being for returning a direct debit. This is the refusal for technical reasons by a collecting bank to execute one or more transactions in a direct debit transfer request received from a creditor's bank." ],
'ABZ' => [ 'Truncated paper based payment',
    'Truncated paper based payment is the financial operation of extracting data from a paper based payment.' ],
'BEX' => [ 'Bills of exchange',
    'The payment has been done by bills of exchange.' ],
'BGI' => [ 'Bankgiro',
    'The payment was originally made by bankgiro.' ],
'BKD' => [ 'Bank draft',
    'Original payment was made by bank draft.' ],
'BKI' => [ 'Bank initiated',
    'The fund transfer is initiated by a bank.' ],
'CAL' => [ 'Cash letter',
    'The payment has been done by a cash letter.' ],
'CHG' => [ 'Charges',
    'The fund transfer represents charges.' ],
'CHI' => [ 'Cheque international',
    'The financial operation has been done by international cheque.' ],
'CHN' => [ 'Cheque national',
    'The financial operation has been done by national cheque.' ],
'CLR' => [ 'Clearing',
    'The financial operation has been done by a clearing system.' ],
'COL' => [ 'Collection',
    'The financial operation is collection.' ],
'COM' => [ 'Commission',
    'The fund transfer represents commission.' ],
'CON' => [ 'Cash concentration',
    'An aggregation of funds from different accounts into a single account.' ],
'CPP' => [ 'Cash payment by post',
    'The financial operation has been done by cash payment by post.' ],
'CUX' => [ 'Currencies',
    'Buying or selling of foreign notes.' ],
'DDT' => [ 'Direct debit',
    'The financial operation is direct debit.' ],
'DEP' => [ 'Deposit cash operation',
    'The financial operation is by deposit cash.' ],
'FEX' => [ 'Foreign exchange',
    'The financial operation is by foreign exchange.' ],
'FGI' => [ 'Free format giro',
    'System of credit transfer between banks, Post Offices, etc.' ],
'INT' => [ 'Interest',
    'The fund transfer represents usury.' ],
'LOC' => [ 'Letter of credit',
    'The financial operation is a letter of credit.' ],
'LOK' => [ 'Lockbox',
    "Type of cash management system offered by financial institutions to provide for collection of customers 'receivables'." ],
'MSC' => [ 'Miscellaneous',
    'The fund transfer is miscellaneous.' ],
'PAC' => [ 'Payment card',
    'Relating to credit, debit, guarantee or charge card.' ],
'PGI' => [ 'Postgiro',
    'The financial operation has been done by postgiro.' ],
'POS' => [ 'Point of sale',
    'The financial operation is point of sale.' ],
'REC' => [ 'Returned cheques',
    'The fund transfer represents returned cheques.' ],
'RET' => [ 'Returned items',
    'The fund transfer represents returned items.' ],
'RGI' => [ 'Reference giro',
    'Payments was done by a special service, for low priority payments. Finnish national bank service.' ],
'RTR' => [ 'Returned transfers',
    'The financial operation has been done by returned transfers.' ],
'SEC' => [ 'Securities',
    'The fund transfer represents securities.' ],
'STO' => [ 'Standing order',
    'The financial operation is done by a standing order.' ],
'TCK' => [ "Traveller's cheque",
    "The financial operation is done by traveller's cheque." ],
'TRF' => [ 'Transfer',
    'The financial operation is done by transfer.' ],
'UGI' => [ 'Urgent giro',
    'Payment was made by special bank service, for high priority payments. Finnish national bank service.' ],
'VDA' => [ 'Value date adjustment',
    'The financial operation has adjusted value date.' ],
'WDL' => [ 'Withdrawal cash operation',
    'The financial operation is a withdrawal cash operation.' ],
'ZZZ' => [ 'Mutually defined',
    'A temporary code which may be used between trading partners to describe a fund transfer whilst approval for a formal code value is being sought.' ],
);
sub get_codes { return \%code_hash; }

1;
