# Generated by default/object.tt
package Paws::AuditManager::AssessmentReport;
  use Moose;
  has AssessmentId => (is => 'ro', isa => 'Str', request_name => 'assessmentId', traits => ['NameInRequest']);
  has AssessmentName => (is => 'ro', isa => 'Str', request_name => 'assessmentName', traits => ['NameInRequest']);
  has Author => (is => 'ro', isa => 'Str', request_name => 'author', traits => ['NameInRequest']);
  has AwsAccountId => (is => 'ro', isa => 'Str', request_name => 'awsAccountId', traits => ['NameInRequest']);
  has CreationTime => (is => 'ro', isa => 'Str', request_name => 'creationTime', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has Id => (is => 'ro', isa => 'Str', request_name => 'id', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AuditManager::AssessmentReport

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AuditManager::AssessmentReport object:

  $service_obj->Method(Att1 => { AssessmentId => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AuditManager::AssessmentReport object:

  $result = $service_obj->Method(...);
  $result->Att1->AssessmentId

=head1 DESCRIPTION

A finalized document generated from an AWS Audit Manager assessment.
These reports summarize the relevant evidence collected for your audit,
and link to the relevant evidence folders which are named and organized
according to the controls specified in your assessment.

=head1 ATTRIBUTES


=head2 AssessmentId => Str

The identifier for the specified assessment.


=head2 AssessmentName => Str

The name of the associated assessment.


=head2 Author => Str

The name of the user who created the assessment report.


=head2 AwsAccountId => Str

The identifier for the specified AWS account.


=head2 CreationTime => Str

Specifies when the assessment report was created.


=head2 Description => Str

The description of the specified assessment report.


=head2 Id => Str

The unique identifier for the specified assessment report.


=head2 Name => Str

The name given to the assessment report.


=head2 Status => Str

The current status of the specified assessment report.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AuditManager>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

